/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.obj.OBJLoader;
import com.pixelmonmod.pixelmon.client.models.smd.GabeNewellException;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModelLoader;
import net.minecraft.client.model.Model;
import net.minecraft.resources.ResourceLocation;

public enum CustomModel {
    PILLAR_PLATFORM("blocks/pillar/pillar_platform.obj"),
    PILLAR_COLUMN("blocks/pillar/pillar_column.obj"),
    PILLAR_COLUMN_FRACTURED_BOTTOM("blocks/pillar/pillar_column_fractured_bottom.obj"),
    PILLAR_COLUMN_FRACTURED_TOP("blocks/pillar/pillar_column_fractured_top.obj"),
    POKE_BALL("pokeballs/base.pqc"),
    CHERISH_BALL("pokeballs/cherishball.pqc"),
    GREAT_BALL("pokeballs/greatball.pqc"),
    HEAVY_BALL("pokeballs/heavyball.pqc"),
    MASTER_BALL("pokeballs/masterball.pqc"),
    NET_BALL("pokeballs/netball.pqc"),
    TIMER_BALL("pokeballs/timerball.pqc"),
    BEAST_BALL("pokeballs/beastball.pqc"),
    MEGA_BRACELET_ORAS("playeritems/megaitems/megabraceletoras.pqc"),
    MEGA_BRACELET_ORAS_STONE("playeritems/megaitems/megabraceletorasstone.pqc"),
    MEGA_GLASSES("playeritems/megaitems/mega_glasses.pqc"),
    MEGA_ANCHOR("playeritems/megaitems/mega_anchor.pqc"),
    MEGA_BOOST_NECKLACE("playeritems/megaitems/boost_necklace.pqc"),
    DYNAMAX_BAND("playeritems/megaitems/dynamax_band.pqc"),
    MACH_BIKE("bikes/mbike.pqc"),
    ACRO_BIKE("bikes/abike.pqc"),
    DYNAMAX_CLOUDS("fluff/clouds.pqc"),
    SPHERE_SIMPLE("sphere.pqc"),
    OVAL_CHARM("playeritems/oval_charm.pqc"),
    SHINY_CHARM("playeritems/shiny_charm.pqc"),
    EXP_CHARM("playeritems/exp_charm.pqc"),
    CATCHING_CHARM("playeritems/catching_charm.pqc"),
    MARK_CHARM("playeritems/mark_charm.pqc"),
    SPHERE("fluff/sphere.pqc");

    private final String fileName;
    private Model model;
    private boolean initialised = false;

    private CustomModel(String fileName) {
        this.fileName = fileName;
    }

    public Model getModel() {
        if (!this.initialised) {
            ResourceLocation rl = ResourceLocationHelper.of("pixelmon:models/" + this.fileName);
            if (ValveStudioModelLoader.INSTANCE.accepts(rl)) {
                try {
                    this.model = ValveStudioModelLoader.INSTANCE.loadModel(null, rl);
                }
                catch (GabeNewellException e) {
                    Pixelmon.LOGGER.error("Failed to load custom model: " + this.fileName, (Throwable)e);
                }
            } else if (OBJLoader.accepts(rl)) {
                this.model = OBJLoader.loadModel(rl);
            }
            this.initialised = true;
        }
        return this.model;
    }
}

