/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.init.registry.PixelmonWoodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.registries.ForgeRegistries;

public enum BerryType {
    CHERI(2, 5, 5, 10, 0, 0, 0, 0, DyeColor.RED, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/cheri_tree"))),
    CHESTO(2, 5, 5, 0, 10, 0, 0, 0, DyeColor.PURPLE, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/chesto_tree"))),
    PECHA(2, 5, 5, 0, 0, 10, 0, 0, DyeColor.PINK, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/pecha_tree"))),
    RAWST(2, 5, 5, 0, 0, 0, 10, 0, DyeColor.GREEN, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/rawst_tree"))),
    ASPEAR(2, 5, 5, 0, 0, 0, 0, 10, DyeColor.YELLOW, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/aspear_tree"))),
    LEPPA(2, 5, 5, 10, 0, 10, 10, 10, DyeColor.RED, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/leppa_tree"))),
    ORAN(2, 3, 5, 10, 10, 0, 10, 10, DyeColor.BLUE, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/oran_tree"))),
    PERSIM(2, 5, 5, 10, 10, 10, 0, 10, DyeColor.PINK, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/persim_tree"))),
    LUM(2, 5, 5, 10, 10, 10, 10, 0, DyeColor.GREEN, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/lum_tree"))),
    SITRUS(2, 5, 5, 0, 10, 10, 10, 10, DyeColor.YELLOW, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/sitrus_tree"))),
    FIGY(1, 5, 5, 15, 0, 0, 0, 0, DyeColor.RED, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/figy_tree"))),
    WIKI(1, 5, 5, 0, 15, 0, 0, 0, DyeColor.PURPLE, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/wiki_tree"))),
    MAGO(1, 5, 5, 0, 0, 15, 0, 0, DyeColor.PINK, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/mago_tree"))),
    AGUAV(1, 5, 5, 0, 0, 0, 15, 0, DyeColor.GREEN, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/aguav_tree"))),
    IAPAPA(1, 5, 5, 0, 0, 0, 0, 15, DyeColor.YELLOW, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/iapapa_tree"))),
    RAZZ(3, 6, 5, 10, 10, 0, 0, 0, DyeColor.RED, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/razz_tree"))),
    BLUK(3, 6, 5, 0, 10, 10, 0, 0, DyeColor.PURPLE, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/bluk_tree"))),
    NANAB(3, 6, 5, 0, 0, 10, 10, 0, DyeColor.PINK, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/nanab_tree"))),
    WEPEAR(3, 6, 5, 0, 0, 0, 10, 10, DyeColor.GREEN, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/wepear_tree"))),
    PINAP(2, 10, 5, 10, 0, 0, 0, 10, DyeColor.YELLOW, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/pinap_tree"))),
    POMEG(1, 5, 5, 10, 0, 10, 10, 0, DyeColor.RED, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/pomeg_tree"))),
    KELPSY(1, 5, 5, 0, 10, 0, 10, 10, DyeColor.BLUE, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/kelpsy_tree"))),
    QUALOT(1, 5, 5, 10, 0, 10, 0, 10, DyeColor.YELLOW, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/qualot_tree"))),
    HONDEW(1, 5, 5, 10, 10, 0, 10, 0, DyeColor.GREEN, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/hondew_tree"))),
    GREPA(1, 5, 5, 0, 10, 10, 0, 10, DyeColor.YELLOW, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/grepa_tree"))),
    TAMATO(1, 5, 5, 20, 10, 0, 0, 0, DyeColor.RED, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/tamato_tree"))),
    CORNN(2, 10, 5, 0, 20, 10, 0, 0, DyeColor.PURPLE, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/cornn_tree"))),
    MAGOST(2, 10, 5, 0, 0, 20, 10, 0, DyeColor.PINK, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/magost_tree"))),
    RABUTA(2, 10, 5, 0, 0, 0, 20, 10, DyeColor.GREEN, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/rabuta_tree"))),
    NOMEL(2, 10, 5, 10, 0, 0, 0, 20, DyeColor.YELLOW, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/nomel_tree"))),
    SPELON(2, 15, 6, 30, 10, 0, 0, 0, DyeColor.RED, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/spelon_tree"))),
    PAMTRE(3, 15, 6, 0, 30, 10, 0, 0, DyeColor.PURPLE, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/pamtre_tree"))),
    WATMEL(2, 15, 6, 0, 0, 30, 10, 0, DyeColor.PINK, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/watmel_tree"))),
    DURIN(3, 15, 6, 0, 0, 0, 30, 10, DyeColor.GREEN, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/durin_tree"))),
    BELUE(2, 15, 6, 10, 0, 0, 0, 30, DyeColor.PURPLE, 1, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/belue_tree"))),
    OCCA(1, 5, 7, 15, 0, 10, 0, 0, DyeColor.RED, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/occa_tree"))),
    PASSHO(1, 5, 7, 0, 15, 0, 10, 0, DyeColor.BLUE, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/passho_tree"))),
    WACAN(1, 5, 7, 0, 0, 15, 0, 10, DyeColor.YELLOW, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/wacan_tree"))),
    RINDO(1, 5, 7, 10, 0, 0, 15, 0, DyeColor.GREEN, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/rindo_tree"))),
    YACHE(1, 5, 7, 0, 10, 0, 0, 15, DyeColor.BLUE, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/yache_tree"))),
    CHOPLE(1, 5, 7, 15, 0, 0, 10, 0, DyeColor.RED, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/chople_tree"))),
    KEBIA(1, 5, 7, 0, 15, 0, 0, 10, DyeColor.GREEN, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/kebia_tree"))),
    SHUCA(1, 5, 7, 10, 0, 15, 0, 0, DyeColor.YELLOW, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/shuca_tree"))),
    COBA(1, 5, 7, 0, 10, 0, 15, 0, DyeColor.BLUE, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/coba_tree"))),
    PAYAPA(1, 5, 7, 0, 0, 10, 0, 15, DyeColor.PURPLE, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/payapa_tree"))),
    TANGA(1, 5, 7, 20, 0, 0, 0, 10, DyeColor.GREEN, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/tanga_tree"))),
    CHARTI(1, 5, 7, 10, 20, 0, 0, 0, DyeColor.YELLOW, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/charti_tree"))),
    KASIB(1, 5, 7, 0, 10, 20, 0, 0, DyeColor.PURPLE, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/kasib_tree"))),
    HABAN(1, 5, 7, 0, 0, 10, 20, 0, DyeColor.RED, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/haban_tree"))),
    COLBUR(1, 5, 7, 0, 0, 0, 10, 20, DyeColor.PURPLE, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/colbur_tree"))),
    BABIRI(1, 5, 7, 25, 10, 0, 0, 0, DyeColor.GREEN, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/babiri_tree"))),
    CHILAN(1, 5, 7, 0, 25, 10, 0, 0, DyeColor.YELLOW, 2, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/chilan_tree"))),
    ROSELI(1, 5, 7, 0, 0, 25, 10, 0, DyeColor.PINK, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/roseli_tree"))),
    LIECHI(1, 5, 10, 30, 10, 30, 0, 0, DyeColor.RED, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/liechi_tree"))),
    GANLON(1, 5, 10, 0, 30, 10, 30, 0, DyeColor.PURPLE, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/ganlon_tree"))),
    SALAC(1, 5, 10, 0, 0, 30, 10, 30, DyeColor.GREEN, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/salac_tree"))),
    PETAYA(1, 2, 10, 30, 0, 0, 30, 10, DyeColor.PINK, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/petaya_tree"))),
    APICOT(1, 5, 10, 10, 30, 0, 0, 30, DyeColor.BLUE, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/apicot_tree"))),
    LANSAT(1, 5, 10, 30, 10, 30, 10, 30, DyeColor.RED, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/lansat_tree"))),
    STARF(1, 2, 10, 30, 10, 30, 10, 30, DyeColor.GREEN, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/starf_tree"))),
    PUMKIN(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.YELLOW, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/pumkin_tree"))),
    DRASH(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.PINK, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/drash_tree"))),
    EGGANT(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.PURPLE, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/eggant_tree"))),
    STRIB(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.GREEN, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/strib_tree"))),
    NUTPEA(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.YELLOW, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/nutpea_tree"))),
    GINEMA(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.YELLOW, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/ginema_tree"))),
    KUO(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.GREEN, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/kuo_tree"))),
    YAGO(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.GREEN, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/yago_tree"))),
    TOUGA(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.RED, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/touga_tree"))),
    NINIKU(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.BLUE, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/niniku_tree"))),
    TOPO(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.PINK, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/topo_tree"))),
    ENIGMA(1, 5, 10, 40, 10, 0, 0, 0, DyeColor.PURPLE, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/enigma_tree"))),
    MICLE(1, 5, 10, 0, 40, 10, 0, 0, DyeColor.GREEN, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/micle_tree"))),
    CUSTAP(1, 5, 10, 0, 0, 40, 10, 0, DyeColor.RED, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/custap_tree"))),
    JABOCA(1, 5, 10, 0, 0, 0, 40, 10, DyeColor.YELLOW, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/jaboca_tree"))),
    ROWAP(1, 5, 10, 10, 0, 0, 0, 40, DyeColor.BLUE, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/rowap_tree"))),
    KEE(1, 5, 10, 30, 30, 10, 10, 10, DyeColor.YELLOW, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/kee_tree"))),
    MARANGA(1, 5, 10, 10, 10, 30, 30, 10, DyeColor.BLUE, 3, () -> ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "trees/berry/maranga_tree")));

    private static final List<BerryType> IMPLEMENTED;
    public final byte minYield;
    public final byte maxYield;
    public final byte growthTime;
    public final boolean isImplemented;
    public final byte spicy;
    public final byte dry;
    public final byte sweet;
    public final byte bitter;
    public final byte sour;
    public final DyeColor color;
    public final byte juiceGroup;
    private final Supplier<ResourceKey<ConfiguredFeature<?, ?>>> feature;
    private final ResourceLocation berryLocation = ResourceLocationHelper.of("pixelmon:" + this.name().toLowerCase(Locale.ROOT) + "_berry");
    private final ResourceLocation logBlockLocation = ResourceLocationHelper.of("pixelmon:berry_log");
    private final ResourceLocation leavesBlockLocation = ResourceLocationHelper.of("pixelmon:berry_leaves_" + this.name().toLowerCase(Locale.ROOT));
    private final ResourceLocation saplingBlockLocation = ResourceLocationHelper.of("pixelmon:berry_plant_" + this.name().toLowerCase(Locale.ROOT));

    private BerryType(int minYield, int maxYield, int growthTime, int spicy, int dry, int sweet, int bitter, int sour, DyeColor color, int juiceGroup, boolean isImplemented, Supplier<ResourceKey<ConfiguredFeature<?, ?>>> feature) {
        this.minYield = (byte)minYield;
        this.maxYield = (byte)maxYield;
        this.growthTime = (byte)growthTime;
        this.isImplemented = isImplemented;
        this.spicy = (byte)spicy;
        this.dry = (byte)dry;
        this.sweet = (byte)sweet;
        this.bitter = (byte)bitter;
        this.sour = (byte)sour;
        this.color = color;
        this.juiceGroup = (byte)juiceGroup;
        this.feature = feature;
    }

    private BerryType(int minYield, int maxYield, int growthTime, int spicy, int dry, int sweet, int bitter, int sour, DyeColor color, int juiceGroup, Supplier<ResourceKey<ConfiguredFeature<?, ?>>> feature) {
        this(minYield, maxYield, growthTime, spicy, dry, sweet, bitter, sour, color, juiceGroup, true, feature);
    }

    public byte getMinYield() {
        return this.minYield;
    }

    public byte getMaxYield() {
        return this.maxYield;
    }

    public byte getGrowthTime() {
        return this.growthTime;
    }

    public boolean isImplemented() {
        return this.isImplemented;
    }

    public byte getSpicy() {
        return this.spicy;
    }

    public byte getDry() {
        return this.dry;
    }

    public byte getSweet() {
        return this.sweet;
    }

    public byte getBitter() {
        return this.bitter;
    }

    public byte getSour() {
        return this.sour;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public byte getJuiceGroup() {
        return this.juiceGroup;
    }

    public ResourceKey<ConfiguredFeature<?, ?>> getFeature() {
        return this.feature.get();
    }

    public Item getBerryItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.berryLocation);
    }

    public Block getLogBlock() {
        return (Block)ForgeRegistries.BLOCKS.getValue(this.logBlockLocation);
    }

    public Block getLeavesBlock() {
        return (Block)ForgeRegistries.BLOCKS.getValue(this.leavesBlockLocation);
    }

    public Block getSaplingBlock() {
        return (Block)ForgeRegistries.BLOCKS.getValue(this.saplingBlockLocation);
    }

    public WoodType getWoodType() {
        switch (this.color) {
            case BLUE: {
                return PixelmonWoodType.BLUE_BERRY_WOOD;
            }
            case GREEN: {
                return PixelmonWoodType.GREEN_BERRY_WOOD;
            }
            case PINK: {
                return PixelmonWoodType.PINK_BERRY_WOOD;
            }
            case PURPLE: {
                return PixelmonWoodType.PURPLE_BERRY_WOOD;
            }
            case RED: {
                return PixelmonWoodType.RED_BERRY_WOOD;
            }
            case YELLOW: {
                return PixelmonWoodType.YELLOW_BERRY_WOOD;
            }
        }
        return null;
    }

    public Block getSignBlock() {
        switch (this.color) {
            case BLUE: {
                return PixelmonBlocks.blue_berry_wood_sign;
            }
            case GREEN: {
                return PixelmonBlocks.green_berry_wood_sign;
            }
            case PINK: {
                return PixelmonBlocks.pink_berry_wood_sign;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_berry_wood_sign;
            }
            case RED: {
                return PixelmonBlocks.red_berry_wood_sign;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_berry_wood_sign;
            }
        }
        return null;
    }

    public Block getWallSignBlock() {
        switch (this.color) {
            case BLUE: {
                return PixelmonBlocks.blue_berry_wood_wall_sign;
            }
            case GREEN: {
                return PixelmonBlocks.green_berry_wood_wall_sign;
            }
            case PINK: {
                return PixelmonBlocks.pink_berry_wood_wall_sign;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_berry_wood_wall_sign;
            }
            case RED: {
                return PixelmonBlocks.red_berry_wood_wall_sign;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_berry_wood_wall_sign;
            }
        }
        return null;
    }

    @Nonnull
    public static BerryType getImplementedBerry() {
        return RandomHelper.getRandomElementFromCollection(IMPLEMENTED);
    }

    static {
        IMPLEMENTED = new ArrayList<BerryType>();
        for (BerryType berry : BerryType.values()) {
            if (!berry.isImplemented) continue;
            IMPLEMENTED.add(berry);
        }
    }
}

