/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.projectiles;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.events.FishingEvent;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.items.SpawnActionItem;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TriggerSpawner;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.conditions.TriggerLocation;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumRodType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.init.registry.PixelmonBlockTags;
import com.pixelmonmod.pixelmon.items.FishingRodItem;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.eventbus.api.Event;

public class HookEntity
extends FishingHook
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Integer> DATA_HOOK_STATE = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private EnumRodType rodType;
    private SpawnAction<? extends Entity> caught = null;
    private int ticksTillCatch = 0;
    private int ticksTillEscape = 0;
    private float chanceOfNothing = 0.0f;
    private HookState state = HookState.FLYING;
    private int dotsShowing = 0;
    private int momentsShowingDots = 0;
    private int rodQuality = 0;

    @OnlyIn(value=Dist.CLIENT)
    public HookEntity(Level world, Player player, double x, double y, double z) {
        super(player, world, 0, 0);
        this.init(player);
        this.m_146884_(new Vec3(x, y, z));
    }

    public HookEntity(Level world, Player player, EnumRodType rodType, int rodQuality) {
        super(player, world, rodType.rarityThreshold, rodQuality);
        this.rodType = rodType;
        this.rodQuality = rodQuality;
        this.init(player);
    }

    public EntityType<?> m_6095_() {
        return (EntityType)EntityRegistration.HOOK.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_HOOK_STATE, (Object)-1);
    }

    public void init(Player player) {
        this.f_19811_ = true;
        if (player != null) {
            this.setAngler((Entity)player);
            player.f_36083_ = this;
        }
    }

    public void m_6686_(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        if (this.m_19749_() != null) {
            super.m_6686_(p_70186_1_, p_70186_3_, p_70186_5_, p_70186_7_, p_70186_8_);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        UUID uuid = this.m_19749_() != null ? this.m_19749_().m_20148_() : new UUID(0L, 0L);
        buffer.m_130077_(uuid);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }

    public void setAngler(Entity entity) {
        if (entity instanceof Player) {
            this.m_5602_(entity);
            ((Player)entity).f_36083_ = this;
        }
    }

    public void m_8119_() {
        Entity shooter = this.m_19749_();
        if (!(shooter instanceof Player) || ((Player)shooter).f_36083_ != this) {
            this.m_6089_();
            return;
        }
        if (this.f_19853_.f_46443_) {
            ++this.momentsShowingDots;
            if (this.momentsShowingDots > 40) {
                this.momentsShowingDots = 0;
                this.dotsShowing = (this.dotsShowing + 1) % 3;
            }
        }
        --this.ticksTillCatch;
        --this.ticksTillEscape;
        if (this.ticksTillEscape == 0 && this.caught != null) {
            this.caught = null;
            if (shooter != null) {
                ChatHandler.sendFormattedChat((CommandSource)shooter, ChatFormatting.GRAY, "pixelmon.projectiles.gotaway", new Object[0]);
                if (!this.f_19853_.f_46443_) {
                    this.m_6089_();
                }
            }
        }
        this.m_6075_();
        if (this.f_19853_.f_46443_ || !this.shouldStopFishing()) {
            if (this.f_19861_) {
                ++this.f_37103_;
                if (this.f_37103_ >= 1200) {
                    this.m_6089_();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Vec3i)this.m_20183_());
            BlockState blockState = this.f_19853_.m_8055_(blockpos);
            if (blockState.m_204336_(PixelmonBlockTags.LOCATION_TYPE_WATER_BLOCKS) || blockState.m_204336_(PixelmonBlockTags.LOCATION_TYPE_LAVA_BLOCKS)) {
                FluidState fluidState = this.f_19853_.m_6425_(blockpos);
                f = fluidState.m_76155_((BlockGetter)this.f_19853_, blockpos);
            }
            if (this.state == HookState.FLYING) {
                if (this.f_37094_ != null) {
                    this.m_20256_(Vec3.f_82478_);
                    this.state = HookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
                    this.state = HookState.BOBBING;
                    if (!this.f_19853_.f_46443_) {
                        this.setNewTimeToCatch();
                    }
                    return;
                }
                if (!this.f_19853_.f_46443_) {
                    this.m_37171_();
                }
                if (!this.f_19861_ && !this.f_19862_) {
                    ++this.f_37089_;
                } else {
                    this.f_37089_ = 0;
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                if (this.state == HookState.HOOKED_IN_ENTITY) {
                    if (this.f_37094_ != null) {
                        if (!this.f_37094_.m_6084_()) {
                            this.f_37094_ = null;
                            this.state = HookState.FLYING;
                        } else {
                            this.m_6034_(this.f_37094_.m_20185_(), this.f_37094_.m_20191_().f_82289_ + (double)this.f_37094_.m_20206_() * 0.8, this.f_37094_.m_20189_());
                        }
                    }
                    return;
                }
                if (this.state == HookState.BOBBING) {
                    this.m_20256_(this.m_20184_().m_82542_(0.9, 1.0, 0.9));
                    double d0 = this.m_20186_() + this.m_20184_().f_82480_ - (double)blockpos.m_123342_() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    if (!this.f_19853_.f_46443_ && this.ticksTillCatch == 0 && this.m_19749_() != null && this.m_19749_().m_20194_() != null) {
                        if (f > 0.0f && this.f_37094_ == null) {
                            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - (double)Math.abs(this.f_19796_.m_188501_()) * 0.2, this.m_20184_().f_82481_);
                            if (PixelmonSpawning.fishingSpawner == null) {
                                return;
                            }
                            SpawnLocation spawnLocation = this.createSpawnLocation();
                            SpawnAction<? extends Entity> caught = PixelmonSpawning.fishingSpawner.getAction(spawnLocation, 1.0f - this.chanceOfNothing);
                            if (spawnLocation.diameter == 0) {
                                caught = null;
                            }
                            int displayedMarks = 1;
                            if (caught != null) {
                                this.caught = caught;
                                int ticksTillEscape = 30;
                                float nominalRarity = caught.spawnInfo.calculateNominalRarity();
                                displayedMarks = nominalRarity < 5.0f ? 3 : (nominalRarity < 50.0f ? 2 : 1);
                                FishingEvent.Catch catchEvent = new FishingEvent.Catch((ServerPlayer)shooter, this, caught, ticksTillEscape, displayedMarks);
                                if (Pixelmon.EVENT_BUS.post((Event)catchEvent)) {
                                    caught = null;
                                } else {
                                    this.m_20088_().m_135381_(DATA_HOOK_STATE, (Object)catchEvent.getDisplayedMarks());
                                    this.ticksTillEscape = catchEvent.getTicksTillEscape();
                                }
                            }
                            if (caught == null) {
                                ChatHandler.sendFormattedChat((CommandSource)shooter, ChatFormatting.GRAY, "pixelmon.projectiles.nibble", new Object[0]);
                                this.m_6089_();
                            }
                        }
                    } else {
                        this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() - d0 * (double)this.f_19796_.m_188501_() * 0.2, this.m_20184_().m_7094_());
                    }
                }
            }
            if (!blockState.m_60713_(Blocks.f_49990_) && !blockState.m_60713_(Blocks.f_49991_)) {
                this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() - 0.03, this.m_20184_().m_7094_());
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_37283_();
            this.m_20256_(this.m_20184_().m_82542_(0.92, 0.92, 0.92));
            this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    public SpawnLocation createSpawnLocation() {
        BlockPos pos = new BlockPos((Vec3i)this.m_20183_());
        BlockState state = this.f_19853_.m_8055_(pos);
        TriggerLocation loc = state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_WATER_BLOCKS) ? this.rodType.locationInWater : (state.m_204336_(PixelmonBlockTags.LOCATION_TYPE_LAVA_BLOCKS) ? this.rodType.locationInLava : null);
        TriggerLocation qualityLoc = null;
        switch (this.rodQuality) {
            case 0: {
                qualityLoc = LocationType.OK_ROD_QUALITY;
                break;
            }
            case 1: {
                qualityLoc = LocationType.SO_SO_ROD_QUALITY;
                break;
            }
            case 2: {
                qualityLoc = LocationType.GOOD_ROD_QUALITY;
                break;
            }
            case 3: {
                qualityLoc = LocationType.GREAT_ROD_QUALITY;
                break;
            }
            case 4: {
                qualityLoc = LocationType.RARE_ROD_QUALITY;
                break;
            }
            case 5: {
                qualityLoc = LocationType.PRO_ROD_QUALITY;
                break;
            }
            case 6: {
                qualityLoc = LocationType.SUPREME_ROD_QUALITY;
            }
        }
        if (this.rodType == EnumRodType.OasRod) {
            qualityLoc = LocationType.SUPREME_ROD_QUALITY;
        }
        SpatialData data = TriggerSpawner.calculateSpatialData(this.f_19853_, this.m_20183_(), 10, true, block -> block.m_204336_(PixelmonBlockTags.LOCATION_TYPE_WATER_BLOCKS) || block.m_204336_(PixelmonBlockTags.LOCATION_TYPE_LAVA_BLOCKS) || block.m_204336_(PixelmonBlockTags.LOCATION_TYPE_AIR_BLOCKS));
        boolean canSeeSky = true;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int y = pos.m_123342_() + 1; y < 256; ++y) {
            if (BetterSpawnerConfig.doesBlockSeeSky(this.f_19853_.m_8055_((BlockPos)mutablePos.m_122178_(pos.m_123341_(), y, pos.m_123343_())))) continue;
            canSeeSky = false;
            break;
        }
        HashSet sets = Sets.newHashSet((Object[])new LocationType[]{loc});
        if (qualityLoc != null) {
            sets.add(qualityLoc);
        }
        return new SpawnLocation(this.m_19749_(), new MutableLocation(this.f_19853_, pos), sets, data.baseBlock, data.uniqueSurroundingBlocks, (Holder<Biome>)this.f_19853_.m_204166_(pos), canSeeSky, data.radius, this.f_19853_.m_46803_(pos.m_7494_()));
    }

    public void setNewTimeToCatch() {
        this.caught = null;
        this.ticksTillCatch = 20 * RandomHelper.getRandomNumberBetween(5, 15);
        FishingEvent.Cast castEvent = new FishingEvent.Cast((ServerPlayer)this.m_19749_(), this, this.ticksTillCatch, this.chanceOfNothing);
        Pixelmon.EVENT_BUS.post((Event)castEvent);
        this.ticksTillCatch = castEvent.getTicksUntilCatch();
        this.chanceOfNothing = castEvent.getChanceOfNothing();
        this.m_20088_().m_135381_(DATA_HOOK_STATE, (Object)0);
    }

    public boolean shouldStopFishing() {
        boolean flag1;
        ItemStack itemstack = ((Player)this.m_19749_()).m_21205_();
        ItemStack itemstack1 = ((Player)this.m_19749_()).m_21206_();
        boolean flag = itemstack.m_41720_() instanceof FishingRodItem && ((FishingRodItem)itemstack.m_41720_()).getRodType() == this.rodType;
        boolean bl = flag1 = itemstack1.m_41720_() instanceof FishingRodItem && ((FishingRodItem)itemstack1.m_41720_()).getRodType() == this.rodType;
        if (this.m_19749_().m_6084_() && this.m_19749_().m_6084_() && (flag || flag1) && this.m_20280_(this.m_19749_()) <= 1024.0) {
            return false;
        }
        this.m_6089_();
        return true;
    }

    public void m_37283_() {
        float f = Mth.m_14116_((float)((float)(this.m_20184_().m_7096_() * this.m_20184_().m_7098_() + this.m_20184_().m_7094_() * this.m_20184_().m_7094_())));
        this.f_19857_ = (float)(Mth.m_14136_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7094_()) * 57.29577951308232);
        this.f_19858_ = (float)(Mth.m_14136_((double)this.m_20184_().m_7098_(), (double)f) * 57.29577951308232);
        while (this.f_19858_ - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.f_19858_ - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.f_19857_ - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.f_19857_ - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.f_19858_ = this.f_19860_ + (this.f_19858_ - this.f_19860_) * 0.2f;
        this.f_19857_ = this.f_19859_ + (this.f_19857_ - this.f_19859_) * 0.2f;
    }

    private void m_37171_() {
        Vec3 vec3d = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 vec3d1 = new Vec3(this.m_20185_() + this.m_20184_().m_7096_(), this.m_20186_() + this.m_20184_().m_7098_(), this.m_20189_() + this.m_20184_().m_7094_());
        BlockHitResult hitResult = this.f_19853_.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this));
        vec3d = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        vec3d1 = new Vec3(this.m_20185_() + this.m_20184_().m_7096_(), this.m_20186_() + this.m_20184_().m_7098_(), this.m_20189_() + this.m_20184_().m_7094_());
        if (hitResult != null) {
            vec3d1 = new Vec3(hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_);
        }
        Entity entity = null;
        List list = this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82363_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_(), this.m_20184_().m_7094_()).m_82400_(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AABB axisalignedbb;
            Vec3 HitResult1;
            if (!this.m_5603_(entity1) || entity1 == this.m_19749_() && this.f_19797_ < 5 || (HitResult1 = (Vec3)(axisalignedbb = entity1.m_20191_().m_82400_((double)0.3f)).m_82371_(vec3d, vec3d1).orElse(null)) == null || !((d1 = vec3d.m_82557_(HitResult1)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            hitResult = new EntityHitResult(entity);
        }
        if (hitResult != null && hitResult.m_6662_() != HitResult.Type.MISS) {
            if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                this.f_37094_ = ((EntityHitResult)hitResult).m_82443_();
                this.m_20088_().m_135381_(f_37101_, (Object)(this.f_37094_.m_19879_() + 1));
            } else {
                this.f_19861_ = true;
                this.f_37089_ = 0;
                this.ticksTillEscape = 0;
                this.caught = null;
                this.state = HookState.FLYING;
                this.m_20088_().m_135381_(DATA_HOOK_STATE, (Object)-1);
            }
        }
    }

    public int m_37156_(ItemStack p_146034_1_) {
        if (this.f_19853_.f_46443_) {
            return 0;
        }
        int b0 = 0;
        if (this.f_37094_ != null) {
            this.f_19853_.m_7605_((Entity)this, (byte)31);
            b0 = 3;
            this.m_6089_();
            return b0;
        }
        Entity entity = this.caught == null ? null : this.caught.doSpawn(PixelmonSpawning.fishingSpawner);
        FishingEvent.Reel reelEvent = new FishingEvent.Reel((ServerPlayer)this.m_19749_(), this, entity);
        Pixelmon.EVENT_BUS.post((Event)reelEvent);
        if (this.caught != null) {
            if (entity == null) {
                return b0;
            }
            if (this.caught instanceof SpawnActionPokemon) {
                PixelmonEntity pokemon = (PixelmonEntity)((Object)((SpawnActionPokemon)this.caught).getOrCreateEntity());
                pokemon.setSpawnLocation(SpawnLocationType.WATER);
                pokemon.resetAI();
                PlayerPartyStorage storage = StorageProxy.getPartyNow((ServerPlayer)this.m_19749_());
                if (storage.countAblePokemon() > 0) {
                    WildPixelmonParticipant wpp = new WildPixelmonParticipant(pokemon);
                    PlayerParticipant pp = new PlayerParticipant((ServerPlayer)this.m_19749_(), storage.getAndSendOutFirstAblePokemon(this.m_19749_()));
                    BattleRegistry.startBattle(pp, wpp);
                }
            } else if (this.caught instanceof SpawnActionItem) {
                ItemEntity caughtItem = (ItemEntity)entity;
                ItemStack stack = caughtItem.m_32055_();
                caughtItem.m_142687_(Entity.RemovalReason.DISCARDED);
                ChatHandler.sendFormattedChat((CommandSource)this.m_19749_(), ChatFormatting.GREEN, "pixelmon.projectiles.fisheditem", stack.m_41613_(), Component.m_237115_((String)stack.m_41720_().m_5671_(stack)));
                DropItemHelper.giveItemStack((ServerPlayer)this.m_19749_(), stack, false);
            }
        }
        if (this.f_19861_) {
            b0 = 2;
        }
        this.m_6089_();
        this.f_37094_ = null;
        return b0;
    }

    public EnumRodType getRodType() {
        return this.rodType;
    }

    public int getDotsShowing() {
        return this.dotsShowing;
    }

    public static enum HookState {
        BOBBING,
        FLYING,
        HOOKED_IN_ENTITY;

    }
}

