/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokeBallImpactEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonSendOutEvent;
import com.pixelmonmod.pixelmon.api.events.SpawnPixelmonEntityForBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public class OccupiedPokeBallEntity
extends PokeBallEntity {
    private static final UUID CREATOR_UUID = UUID.fromString("2f723150-24de-44ff-aeee-87c75f7c7a9e");
    private static final int MAX_LIFETIME = 400;
    String pokeName = null;

    public OccupiedPokeBallEntity(EntityType<OccupiedPokeBallEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public void spawnRedBeam() {
    }

    public OccupiedPokeBallEntity(Level world) {
        this((EntityType<OccupiedPokeBallEntity>)((EntityType)EntityRegistration.OCCUPIED_POKEBALL.get()), world);
        SYNC_MODE.set((Entity)this, (Object)PokeBallMode.FULL);
    }

    public String getPokeNameUnlocalized() {
        PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)this.thrower);
        if (this.getPokeUUID() != null && party.find(this.getPokeUUID()) != null) {
            return party.find(this.getPokeUUID()).getSpecies().getLocalizedName();
        }
        return "";
    }

    public Optional<Species> getPokemon() {
        if (this.thrower == null) {
            return Optional.empty();
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)this.thrower);
        if (this.getPokeUUID() != null && party.find(this.getPokeUUID()) != null) {
            return Optional.of(party.find(this.getPokeUUID()).getSpecies());
        }
        return Optional.empty();
    }

    public OccupiedPokeBallEntity(Level world, LivingEntity entityliving, int slot, PokeBall type) {
        super((EntityType<? extends PokeBallEntity>)((EntityType)EntityRegistration.OCCUPIED_POKEBALL.get()), type, world, entityliving, PokeBallMode.FULL);
        this.thrower = entityliving;
        this.setOwnerId(this.thrower.m_20148_());
        this.endRotationYaw = entityliving.f_20885_;
        SYNC_SLOT.set((Entity)this, (Object)((byte)slot));
        this.setPokeUUID(StorageProxy.getPartyNow((ServerPlayer)entityliving).get(slot).getUUID());
        this.m_7678_(entityliving.m_20185_(), entityliving.m_20186_() + (double)entityliving.m_20192_(), entityliving.m_20189_(), entityliving.m_146908_(), entityliving.m_146909_());
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_37251_((Entity)entityliving, entityliving.m_146909_(), entityliving.m_146908_(), 0.0f, 0.90000004f, 1.0f);
        this.setInitialYaw(this.thrower.m_146908_());
        this.setInitialPitch(this.thrower.m_146909_());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && (this.f_19797_ > 400 || this.m_20186_() < (double)this.m_9236_().m_6042_().f_156647_())) {
            this.m_6089_();
        }
    }

    @Override
    public Component m_7755_() {
        PlayerPartyStorage party;
        Pokemon pokemon;
        if (this.pokeName == null && this.thrower instanceof ServerPlayer && (pokemon = (party = StorageProxy.getPartyNow((ServerPlayer)this.thrower)).find(this.getPokeUUID())) != null) {
            this.pokeName = pokemon.getSpecies().getLocalizedName();
        }
        return Component.m_237113_((String)(this.pokeName + " ")).m_7220_(super.m_7755_());
    }

    @Override
    public void m_6532_(HitResult traceResult) {
        VoxelShape bounds;
        BlockPos pos;
        BlockState state;
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (traceResult.m_6662_() == HitResult.Type.BLOCK && !(state = this.f_19853_.m_8055_(pos = ((BlockHitResult)traceResult).m_82425_())).m_280296_() && !state.m_60783_((BlockGetter)this.f_19853_, pos, ((BlockHitResult)traceResult).m_82434_()) && (bounds = state.m_60816_((BlockGetter)this.f_19853_, pos)).m_83281_()) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeBallImpactEvent(this, traceResult))) {
            return;
        }
        if (traceResult.m_6662_() != HitResult.Type.BLOCK) {
            PixelmonEntity pokemonHit = null;
            if (traceResult instanceof EntityHitResult && ((EntityHitResult)traceResult).m_82443_() != null && ((EntityHitResult)traceResult).m_82443_() instanceof PixelmonEntity) {
                pokemonHit = (PixelmonEntity)((EntityHitResult)traceResult).m_82443_();
            }
            if (pokemonHit != null && pokemonHit.m_269323_() == this.m_19749_() && pokemonHit.m_20160_()) {
                return;
            }
            if (((EntityHitResult)traceResult).m_82443_() == this.m_19749_() || this.m_19749_() == null) {
                return;
            }
            UUID throwerUUID = this.getOwnerId();
            if (throwerUUID == null || ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(throwerUUID) == null) {
                this.m_6089_();
                return;
            }
            PlayerPartyStorage storage = StorageProxy.getPartyNow((ServerPlayer)this.thrower);
            Pokemon pokemon = storage.get(this.slot);
            if (pokemon == null) {
                this.m_6089_();
                return;
            }
            if (pokemon.getSpecies().is(PixelmonSpecies.WOBBUFFET) && CREATOR_UUID.equals(pokemon.getOwnerPlayerUUID())) {
                pokemon.setForm("online");
            }
            if (pokemonHit != null && !Objects.equals(pokemonHit.m_21805_(), throwerUUID)) {
                PixelmonEntity target = pokemonHit;
                if (target.battleController != null) {
                    if (target.battleController.checkValid()) {
                        ChatHandler.sendChat(this.m_19749_(), "pixelmon.entitypokemon.inbattle", new Object[0]);
                        this.m_6089_();
                        return;
                    }
                    if (target.getTrainer() != null) {
                        target.m_6089_();
                        this.m_6089_();
                        return;
                    }
                }
                if (target.hitByPokeball != null) {
                    this.m_6089_();
                    return;
                }
                if (target.hasOwner()) {
                    PlayerPartyStorage targetStorage = StorageProxy.getPartyNow(target.m_21805_());
                    if (target.m_269323_() == null) {
                        this.m_6089_();
                        return;
                    }
                    if (!targetStorage.battleEnabled) {
                        this.m_6089_();
                        return;
                    }
                    if (targetStorage.guiOpened) {
                        ChatHandler.sendChat(this.m_19749_(), "pixelmon.general.playerbusy", new Object[0]);
                        this.m_6089_();
                        return;
                    }
                    if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(pokemon))) {
                        new BattleQuery((ServerPlayer)this.m_19749_(), this.pixelmon, (ServerPlayer)target.m_269323_(), target);
                        this.m_6089_();
                        return;
                    }
                    PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19857_, 0.0f);
                    Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(pokemon, pixelmon));
                    if (pixelmon != null) {
                        pixelmon.setPixelmonToFlyForBattle();
                        Pixelmon.EVENT_BUS.post((Event)new PokemonSendOutEvent.Post((ServerPlayer)this.m_19749_(), pokemon, pixelmon));
                        pixelmon.onSendout();
                        new BattleQuery((ServerPlayer)this.m_19749_(), pixelmon, (ServerPlayer)target.m_269323_(), target);
                    }
                } else {
                    if (BattleRegistry.getBattle((Player)this.m_19749_()) != null) {
                        this.m_6089_();
                        return;
                    }
                    WildPixelmonParticipant part = new WildPixelmonParticipant(target);
                    if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(pokemon))) {
                        BattleRegistry.startBattle(new BattleParticipant[]{new PlayerParticipant((ServerPlayer)this.m_19749_(), pokemon)}, new BattleParticipant[]{part}, new BattleRules(BattleType.SINGLE));
                        this.m_6089_();
                        return;
                    }
                    PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19857_, 0.0f);
                    Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(pokemon, pixelmon));
                    if (pixelmon != null) {
                        pixelmon.setPixelmonToFlyForBattle();
                        pixelmon.onSendout();
                        Pixelmon.EVENT_BUS.post((Event)new PokemonSendOutEvent.Post((ServerPlayer)this.m_19749_(), pokemon, pixelmon));
                        pixelmon.startBattle(new PlayerParticipant((ServerPlayer)this.m_19749_(), pixelmon), part);
                    }
                    this.m_6089_();
                }
            } else {
                if (traceResult instanceof EntityHitResult && ((EntityHitResult)traceResult).m_82443_() instanceof NPCTrainer) {
                    ServerPlayer throwerPlayer;
                    NPCTrainer trainerEntity = (NPCTrainer)((EntityHitResult)traceResult).m_82443_();
                    BattleController bc = trainerEntity.getBattleController();
                    if (bc != null) {
                        if (bc.battleEnded) {
                            bc.endBattle(BattleEndCause.FORCE);
                        } else {
                            ChatHandler.sendChat(this.m_19749_(), "pixelmon.entitytrainer.inbattle", new Object[0]);
                            this.m_6089_();
                            return;
                        }
                    }
                    if (!trainerEntity.canStartBattle((Player)(throwerPlayer = (ServerPlayer)this.m_19749_()), true)) {
                        return;
                    }
                    BattleType battleType = trainerEntity.getBattleType();
                    if (trainerEntity.battleRules.isDefault()) {
                        if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(pokemon))) {
                            PlayerParticipant playerPart;
                            TrainerParticipant trainer = new TrainerParticipant(trainerEntity, (Player)this.thrower, battleType.getNumPokemon());
                            if (battleType == BattleType.SINGLE) {
                                playerPart = new PlayerParticipant(throwerPlayer, pokemon);
                            } else {
                                ArrayList<Pokemon> list = new ArrayList<Pokemon>();
                                list.add(pokemon);
                                list.addAll(storage.getTeam().stream().filter(p -> p.getHealth() > 0 && p != pokemon).collect(Collectors.toList()));
                                playerPart = new PlayerParticipant(throwerPlayer, list, 2);
                            }
                            BattleRegistry.startBattle(new BattleParticipant[]{playerPart}, new BattleParticipant[]{trainer}, trainerEntity.battleRules);
                            this.m_6089_();
                            return;
                        }
                        PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19857_, 0.0f);
                        Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(pokemon, pixelmon));
                        if (pixelmon != null) {
                            PlayerParticipant playerPart;
                            Pixelmon.EVENT_BUS.post((Event)new PokemonSendOutEvent.Post((ServerPlayer)this.m_19749_(), pokemon, pixelmon));
                            pixelmon.setPixelmonToFlyForBattle();
                            pixelmon.onSendout();
                            TrainerParticipant trainer = new TrainerParticipant(trainerEntity, (Player)this.thrower, battleType.getNumPokemon());
                            if (battleType == BattleType.SINGLE) {
                                playerPart = new PlayerParticipant(throwerPlayer, pixelmon);
                            } else {
                                ArrayList<Pokemon> list = new ArrayList<Pokemon>();
                                list.add(pokemon);
                                list.addAll(storage.getTeam().stream().filter(p -> p.getHealth() > 0 && p != pokemon).collect(Collectors.toList()));
                                playerPart = new PlayerParticipant(throwerPlayer, list, 2);
                            }
                            pixelmon.startBattle((BattleParticipant)playerPart, (BattleParticipant)trainer, trainerEntity.battleRules);
                        }
                    } else {
                        TeamSelectionRegistry.builder().members(new Entity[]{trainerEntity, throwerPlayer}).showRules().showOpponentTeam().closeable().battleRules(trainerEntity.battleRules).start();
                    }
                    this.m_6089_();
                    return;
                }
                if (PixelmonConfigProxy.getGeneral().isEngagePlayerByPokeBall() && traceResult instanceof EntityHitResult && ((EntityHitResult)traceResult).m_82443_() instanceof ServerPlayer && ((EntityHitResult)traceResult).m_82443_() != this.m_19749_()) {
                    ServerPlayer thrower = (ServerPlayer)this.m_19749_();
                    ServerPlayer enemy = (ServerPlayer)((EntityHitResult)traceResult).m_82443_();
                    PlayerPartyStorage enemyParty = StorageProxy.getPartyNow(enemy);
                    if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(pokemon))) {
                        Pokemon player1FirstPokemon = storage.getFirstBattleReadyPokemon();
                        Pokemon player2FirstPokemon = enemyParty.getFirstBattleReadyPokemon();
                        if (player2FirstPokemon == null) {
                            ChatHandler.sendChat((Entity)thrower, "pixelmon.command.battle.nopokemon", enemy.m_5446_());
                        } else if (player1FirstPokemon != null) {
                            new BattleQuery(thrower, player1FirstPokemon, enemy, player2FirstPokemon);
                        }
                        this.m_6089_();
                        return;
                    }
                    PixelmonEntity player1FirstPixelmonEntity = storage.getAndSendOutFirstAblePokemon((Entity)thrower);
                    Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(pokemon, player1FirstPixelmonEntity));
                    if (enemyParty.guiOpened) {
                        ChatHandler.sendChat((Entity)thrower, "pixelmon.general.playerbusy", new Object[0]);
                        return;
                    }
                    PixelmonEntity player2FirstPixelmonEntity = enemyParty.getAndSendOutFirstAblePokemon((Entity)enemy);
                    if (player2FirstPixelmonEntity == null) {
                        ChatHandler.sendChat((Entity)thrower, "pixelmon.command.battle.nopokemon", enemy.m_5446_());
                    } else {
                        new BattleQuery(thrower, player1FirstPixelmonEntity, enemy, player2FirstPixelmonEntity);
                    }
                }
            }
        }
        if (this.getIsWaiting()) {
            this.m_20256_(Vec3.f_82478_);
            this.m_6089_();
            this.m_6074_();
            this.setIsOnGround(true);
        } else {
            BlockHitResult blockHitResult;
            if (traceResult instanceof BlockHitResult && (blockHitResult = (BlockHitResult)traceResult).m_82434_() != Direction.UP) {
                this.m_6074_();
                return;
            }
            this.setAnimation(AnimationType.BOUNCEOPEN);
            this.setIsWaiting(true);
            this.m_20256_(Vec3.f_82478_);
            this.f_19858_ = 0.0f;
        }
    }

    protected Item m_7881_() {
        return null;
    }
}

