/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.events.PokeBallImpactEvent;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BonusStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.Experience;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.particles.Beam;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;

public class EmptyPokeBallEntity
extends PokeBallEntity {
    private int waitTime;
    private int criticalTime = 0;
    private BattleController battleController;
    private boolean isBattleThrown = false;
    private int totalTime;
    private boolean captureFinished;
    private double pokemonPosX;
    private double pokemonPosY;
    private double pokemonPosZ;
    boolean capturedPokemon = false;

    public EmptyPokeBallEntity(EntityType<EmptyPokeBallEntity> type, Level world) {
        super(type, world);
    }

    public EmptyPokeBallEntity(Level world) {
        this((EntityType<EmptyPokeBallEntity>)((EntityType)EntityRegistration.EMPTY_POKEBALL.get()), world);
    }

    public EmptyPokeBallEntity(Level world, LivingEntity entityliving, PokeBall type, boolean dropItem) {
        super((EntityType<? extends PokeBallEntity>)((EntityType)EntityRegistration.EMPTY_POKEBALL.get()), type, world, entityliving, PokeBallMode.EMPTY);
        this.thrower = entityliving;
        this.dropItem = dropItem;
        this.setInitialYaw(this.thrower.f_19857_);
        this.setInitialPitch(this.thrower.m_146909_());
        this.m_37251_((Entity)entityliving, entityliving.m_146909_(), entityliving.f_19857_, 0.0f, (float)type.getVelocityModifier(), 0.5f);
    }

    public EmptyPokeBallEntity(Level world, LivingEntity thrower, PixelmonEntity target, PokeBall type, BattleController battleController) {
        super((EntityType<? extends PokeBallEntity>)((EntityType)EntityRegistration.EMPTY_POKEBALL.get()), type, world, thrower, PokeBallMode.BATTLE);
        this.thrower = thrower;
        this.dropItem = false;
        this.endRotationYaw = thrower.f_20885_;
        this.pixelmon = target;
        this.isBattleThrown = true;
        this.battleController = battleController;
        this.f_19853_ = thrower.f_19853_;
        battleController.pauseBattle();
        this.m_7678_(thrower.m_20185_(), thrower.m_20186_() + (double)thrower.m_20192_(), thrower.m_20189_(), thrower.f_19857_, thrower.m_146909_());
        this.m_6034_(this.m_20185_() - (double)(Mth.m_14089_((float)(this.f_19857_ / 180.0f * (float)Math.PI)) * 0.16f), this.m_20186_() - (double)0.1f, this.m_20189_() - (double)(Mth.m_14031_((float)(this.f_19857_ / 180.0f * (float)Math.PI)) * 0.16f));
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20334_((double)(-Mth.m_14031_((float)(this.f_19857_ / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI))) * 0.8, (double)(Mth.m_14089_((float)(this.f_19857_ / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI))) * 0.8, (double)(-Mth.m_14031_((float)0.0f)) * 0.8);
    }

    @Override
    public void m_6532_(HitResult movingobjectposition) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeBallImpactEvent(this, movingobjectposition)) && !this.isBattleThrown) {
            return;
        }
        if (this.dropItem && this.getBallType().getBreakChance() > 0.0 && RandomHelper.getRandomChance(this.getBallType().getBreakChance()) && !this.getIsWaiting() && movingobjectposition.m_6662_() == HitResult.Type.BLOCK) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 0.8f, 0.8f + RandomHelper.getRandom().nextFloat() * 0.4f);
            for (ItemStack item : this.getComponentItems()) {
                this.m_5552_(item, 0.0f);
            }
            this.m_6089_();
            return;
        }
        if (this.isBattleThrown && !this.f_19853_.f_46443_) {
            if (!this.getIsWaiting()) {
                this.startBattleCapture();
            } else {
                this.startShake();
            }
        } else {
            if (movingobjectposition.m_6662_() == HitResult.Type.BLOCK) {
                BlockState state = this.f_19853_.m_8055_(((BlockHitResult)movingobjectposition).m_82425_());
                if (state.m_60713_(Blocks.f_50359_) || state.m_204336_(BlockTags.f_13040_)) {
                    return;
                }
                if (!this.getIsWaiting() && state.m_280296_()) {
                    if (this.dropItem) {
                        this.m_5552_(this.getBallType().getBallItem(), 0.0f);
                    }
                    this.m_6089_();
                    this.m_6074_();
                    return;
                }
                if (this.getIsWaiting()) {
                    EntityHelper.setPosition((Entity)this, EnumRotation.y, ((BlockHitResult)movingobjectposition).m_82425_().m_123342_() + 1);
                    EntityHelper.setMotion((Entity)this, EnumRotation.y, 0.0);
                    this.setIsOnGround(true);
                    this.m_6853_(true);
                }
                return;
            }
            if (movingobjectposition instanceof EntityHitResult && ((EntityHitResult)movingobjectposition).m_82443_() instanceof PixelmonEntity) {
                if (this.getIsWaiting()) {
                    return;
                }
                this.pixelmon = (PixelmonEntity)((EntityHitResult)movingobjectposition).m_82443_();
                this.setPairedEntity((Entity)this.pixelmon);
                this.pokemonPosX = this.pixelmon.m_20185_();
                this.pokemonPosY = this.pixelmon.m_20186_();
                this.pokemonPosZ = this.pixelmon.m_20189_();
                if (!this.pixelmon.hasOwner() && this.pixelmon.getTrainer() == null) {
                    this.dropItem = false;
                }
                if (this.pixelmon.battleController != null) {
                    boolean inBattle = false;
                    if (this.pixelmon.battleController.checkValid()) {
                        inBattle = true;
                    } else if (this.pixelmon.getTrainer() != null) {
                        this.pixelmon.m_6089_();
                        inBattle = true;
                    }
                    if (inBattle) {
                        ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.pokeinbattle", new Object[0]);
                        if (this.dropItem) {
                            this.m_5552_(this.getBallType().getBallItem(), 0.0f);
                        }
                        this.m_6089_();
                        return;
                    }
                }
                if (this.pixelmon.getBossTier().isBoss()) {
                    ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.boss", new Object[0]);
                    if (this.dropItem) {
                        this.m_5552_(this.getBallType().getBallItem(), 0.0f);
                    }
                    this.m_6089_();
                    return;
                }
                if (this.pixelmon.getPokemon().isUncatchable()) {
                    ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.aura", new Object[0]);
                    if (this.dropItem) {
                        this.m_5552_(this.getBallType().getBallItem(), 0.0f);
                    }
                    this.m_6089_();
                    return;
                }
                if (this.pixelmon.hasOwner() || this.pixelmon.getTrainer() != null) {
                    if (this.pixelmon.m_269323_() == this.thrower) {
                        ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.alreadyown", new Object[0]);
                    } else {
                        ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.otherspokemon", new Object[0]);
                    }
                    if (this.dropItem) {
                        this.m_5552_(this.getBallType().getBallItem(), 0.0f);
                    }
                    this.m_6089_();
                    return;
                }
                PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)this.thrower);
                if (party.transientData.highestLevel < this.pixelmon.getPokemon().getPokemonLevel() && !((ServerPlayer)this.thrower).m_7500_()) {
                    if (RandomHelper.getRandomChance(this.getBallType().getBreakChance())) {
                        for (ItemStack componentItem : this.getComponentItems()) {
                            this.m_19983_(componentItem);
                        }
                    } else {
                        this.m_19983_(this.getBallType().getBallItem());
                    }
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    this.pixelmon.setAggression(Aggression.AGGRESSIVE);
                    this.pixelmon.m_6710_(this.thrower);
                    this.pixelmon.resetAI();
                    return;
                }
                if (this.pixelmon.hitByPokeball != null) {
                    return;
                }
                this.pixelmon.hitByPokeball = this;
                if (!this.getIsWaiting()) {
                    this.startCapture();
                }
            } else if (this.getIsWaiting()) {
                this.startShake();
            } else {
                if (this.dropItem) {
                    this.m_5552_(this.getBallType().getBallItem(), 0.0f);
                }
                this.m_6089_();
                return;
            }
        }
        super.m_6532_(movingobjectposition);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnRedBeam() {
        PixelmonEntity entity = (PixelmonEntity)this.f_19853_.m_6815_(this.getPairedEntity());
        if (entity == null) {
            return;
        }
        if (!Minecraft.m_91087_().m_91104_() && RandomHelper.getRandom().nextInt(2) == 0) {
            double w = entity.getForm().getDimensions().getWidth() / 2.0;
            double h = entity.getForm().getDimensions().getHeight() / 2.0;
            double dx = RandomHelper.getRandom().nextDouble() * w - w / 2.0;
            double dy = RandomHelper.getRandom().nextDouble() * h;
            double dz = RandomHelper.getRandom().nextDouble() * w - w / 2.0;
            ParticleArcanery parent = new ParticleArcanery(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, new Beam((Entity)this, (Entity)entity, new Vec3(RandomHelper.getRandom().nextDouble() * 0.05, RandomHelper.getRandom().nextDouble() * 0.05 + 0.05, RandomHelper.getRandom().nextDouble() * 0.05), new Vec3(dx, dy, dz), 0.05, 15, 0.05f, 0.15f, 0.15f, 3.0f, -6, 2.0f, 1.0f, 0.0f, 0.0f));
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)parent);
        }
    }

    private void startCapture() {
        this.doCaptureCalc(this.pixelmon);
        this.pixelmon.m_20256_(Vec3.f_82478_);
        this.initialScale = this.pixelmon.getPixelmonScale();
        this.setIsWaiting(true);
        this.setPokeballID(this.canCatch ? this.numShakes : -1 * this.numShakes);
        this.pixelmon.m_20256_(Vec3.f_82478_);
        this.m_146926_(0.0f);
        this.m_20256_(Vec3.f_82478_);
        int i = -2;
        while (!this.f_19853_.m_46859_(new BlockPos((int)this.m_20185_(), (int)Math.ceil(this.m_20186_()) + i, (int)this.m_20189_()))) {
            ++i;
        }
        EntityHelper.setPosition((Entity)this, EnumRotation.y, Math.ceil(this.m_20186_()) + (double)i + (double)0.1f);
    }

    private void startBattleCapture() {
        this.pokemonPosX = this.pixelmon.m_20185_();
        this.pokemonPosY = this.pixelmon.m_20186_();
        this.pokemonPosZ = this.pixelmon.m_20189_();
        this.pixelmon.hitByPokeball = this;
        this.startCapture();
        this.m_6034_((int)this.m_20185_(), this.m_20186_(), (int)this.m_20189_());
    }

    private void forceBattleCapture() {
        this.startBattleCapture();
        this.pixelmon.unloadEntity();
        this.setIsOnGround(true);
    }

    private void startShake() {
        this.m_20256_(Vec3.f_82478_);
        this.setIsOnGround(true);
    }

    @Override
    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            super.m_8119_();
            return;
        }
        EntityHelper.setMotion((Entity)this, EnumRotation.y, EntityHelper.getMotion((Entity)this, EnumRotation.y) * this.getBallType().getGravityModifier());
        ++this.totalTime;
        ++this.criticalTime;
        if (this.criticalTime == 43 && this.getCritical()) {
            ServerLevel world = (ServerLevel)this.f_19853_;
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 0.6f, 1.2f);
            for (int i = 0; i < 15; ++i) {
                world.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.75);
            }
        }
        if (this.getIsOnGround()) {
            if (this.waitTime < 0) {
                this.waitTime = 0;
            }
            ++this.waitTime;
        }
        if (this.capturedPokemon) {
            if (this.waitTime > 20) {
                this.storeCapture();
                this.m_6089_();
            }
        } else {
            Objects.requireNonNull(this);
            if (this.waitTime > this.numShakes * 25) {
                this.catchPokemon();
                this.waitTime = 0;
            } else if (this.totalTime > 100 && this.isBattleThrown && !this.getIsWaiting() && !this.captureFinished) {
                this.forceBattleCapture();
            }
        }
        super.m_8119_();
    }

    private void storeCapture() {
        this.pixelmon.retrieve("PokemonCaught");
        Pokemon pokemon = this.pixelmon.getPokemon();
        if (pokemon.getOwnerPlayer() != null) {
            this.setIsWaiting(false);
            return;
        }
        pokemon.setOriginalTrainer((Player)((ServerPlayer)this.thrower));
        pokemon.setBall(this.getBallType());
        pokemon.setFriendship(pokemon.getForm().getSpawn().getBaseFriendship());
        this.getBallType().getLogic().doAfterEffect(this.getBallType(), this, this.pixelmon);
        if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent((ServerPlayer)this.thrower, pokemon, "PokeBall"))) {
            return;
        }
        PokedexEvent.Pre preEvent = new PokedexEvent.Pre(this.thrower.m_20148_(), pokemon, PokedexRegistrationStatus.CAUGHT, "capture");
        if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            PlayerPokedex.set(this.thrower.m_20148_(), pokemon, PokedexRegistrationStatus.CAUGHT);
            Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(this.thrower.m_20148_(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
        }
        StorageProxy.getPartyNow((ServerPlayer)this.thrower).add(pokemon);
        if (this.getMode() == PokeBallMode.BATTLE) {
            PlayerParticipant p = (PlayerParticipant)this.battleController.getParticipantForEntity(this.thrower);
            Experience.awardExp(this.battleController.participants, p, this.pixelmon.getPixelmonWrapper());
            this.battleController.endBattle(BattleEndCause.FORCE);
        }
        this.setIsWaiting(false);
        StorageProxy.getPartyNow((ServerPlayer)((ServerPlayer)this.thrower)).stats.addCaughtTypes(pokemon.getForm().getTypes());
        StorageProxy.getPartyNow((ServerPlayer)((ServerPlayer)this.thrower)).transientData.captureCombo.onCapture((ServerPlayer)this.thrower, pokemon.getSpecies());
        PixelmonAdvancements.throwCaptureTriggers((ServerPlayer)this.thrower, this.getBallType(), pokemon);
    }

    protected void catchPokemon() {
        if (!this.isBattleThrown && this.pixelmon.battleController != null) {
            boolean inBattle = false;
            if (this.pixelmon.battleController.checkValid()) {
                inBattle = true;
            } else if (this.pixelmon.getTrainer() != null) {
                inBattle = true;
            }
            if (inBattle) {
                ChatHandler.sendChat((Entity)this.thrower, "pixelmon.pokeballs.pokeinbattle", new Object[0]);
                if (this.dropItem) {
                    this.m_5552_(this.getBallType().getBallItem(), 0.0f);
                }
                this.m_6089_();
                return;
            }
        }
        this.captureFinished = true;
        if (this.canCatch) {
            boolean transformedToDitto;
            CaptureEvent.SuccessfulCapture capEvent = new CaptureEvent.SuccessfulCapture((ServerPlayer)this.thrower, this.pixelmon, this);
            if (Pixelmon.EVENT_BUS.post((Event)capEvent)) {
                this.failCapture();
                return;
            }
            this.pixelmon = capEvent.getPokemon();
            this.pixelmon.getPokemon().setOriginalTrainer((Player)((ServerPlayer)this.thrower));
            if (!this.pixelmon.getPokemon().getBonusStats().isPersistentAfterCapture()) {
                this.pixelmon.getPokemon().setBonusStats(new BonusStats());
            }
            MutableComponent message = ChatHandler.getMessage((transformedToDitto = this.checkReallyADitto()) ? "pixelmon.pokeballs.capturetransform" : "pixelmon.pokeballs.capture", this.pixelmon.getLocalizedName());
            if (this.pixelmon.battleController == null) {
                ChatHandler.sendChat((CommandSource)this.thrower, (Component)message);
            } else {
                PixelmonWrapper pw = this.pixelmon.getPixelmonWrapper();
                if (pw != null) {
                    pw.resetOnSwitch();
                    HeldItem currentHeldItem = pw.getHeldItem();
                    if (currentHeldItem != PixelmonItems.no_item && currentHeldItem != pw.initialCopyOfPokemon.getHeldItemAsItemHeld()) {
                        pw.enableReturnHeldItem();
                    }
                }
                this.pixelmon.battleController.sendToAll((Component)message);
                Experience.awardExp(this.pixelmon.battleController.participants, this.pixelmon.getParticipant(), pw);
            }
            this.tryApplyRibbons();
            this.capturedPokemon = true;
            this.waitTime = 0;
        } else {
            this.failCapture();
        }
    }

    private boolean checkReallyADitto() {
        boolean transformToDitto;
        boolean isMeltan = this.pixelmon.getSpecies().is(PixelmonSpecies.MELTAN);
        boolean bl = transformToDitto = RandomHelper.getRandom().nextDouble() <= PixelmonConfigProxy.getSpawning().getTransformToDittoOnCatch();
        if (PixelmonSpecies.getLegendaries().contains(this.pixelmon.getSpecies().getDex()) || !PixelmonConfigProxy.getSpawning().getCanTransformToDittoOnCatch().contains(this.pixelmon.getPokemonName())) {
            transformToDitto = false;
        }
        if (transformToDitto || isMeltan && RandomHelper.getRandom().nextDouble() <= PixelmonConfigProxy.getSpawning().getMeltanTransformChance()) {
            transformToDitto = true;
            int level = this.pixelmon.getPokemon().getPokemonLevel();
            boolean isShiny = this.pixelmon.getPokemon().isShiny();
            this.pixelmon.getPokemon().setSpecies(PixelmonSpecies.DITTO, true);
            this.pixelmon.getPokemon().initialize(InitializeCategory.INTRINSIC_FORCEFUL, InitializeCategory.SPECIES);
            this.pixelmon.getPokemon().setLevel(level);
            this.pixelmon.getPokemon().setShiny(isShiny);
        }
        return transformToDitto;
    }

    private void tryApplyRibbons() {
        ServerPlayer player;
        int rolls = 1;
        if (this.m_19749_() instanceof ServerPlayer && StorageProxy.getPartyNow(player = (ServerPlayer)this.m_19749_()).getMarkCharm().isActive()) {
            rolls = PixelmonConfigProxy.getGeneral().getMarkCharmRolls();
        }
        for (int i = 0; i < rolls; ++i) {
            if (this.pixelmon.getPokemon().getRibbons().size() != 0) continue;
            if (Math.random() <= 0.001) {
                this.pixelmon.getPokemon().addRibbon(RibbonRegistry.RARE.getValueUnsafe());
                continue;
            }
            if (Math.random() <= 0.01) {
                this.pixelmon.getPokemon().addRibbon(RandomHelper.getRandomElementFromArray(RibbonRegistry.GROUP_28).getValueUnsafe());
                continue;
            }
            if (Math.random() <= 0.02) {
                this.pixelmon.getPokemon().addRibbon(RibbonRegistry.UNCOMMON.getValueUnsafe());
                continue;
            }
            if (Math.random() <= 0.02) {
                Biome biome;
                WeatherType weatherType;
                if (this.pixelmon.battleController != null) {
                    if (this.pixelmon.battleController.globalStatusController.hasStatus(StatusType.MistyTerrain)) {
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.MISTY.getValueUnsafe());
                        continue;
                    }
                    if (this.pixelmon.battleController.globalStatusController.hasStatus(StatusType.Sandstorm)) {
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.SANDSTORM.getValueUnsafe());
                        continue;
                    }
                    if (this.pixelmon.battleController.globalStatusController.hasStatus(StatusType.Sunny)) {
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.DRY.getValueUnsafe());
                        continue;
                    }
                    weatherType = WeatherType.get(this.f_19853_);
                    biome = (Biome)this.f_19853_.m_204166_(this.pixelmon.m_20183_()).get();
                    if (weatherType == WeatherType.RAIN) {
                        if (biome.m_264600_(this.m_20183_()) == Biome.Precipitation.SNOW) {
                            this.pixelmon.getPokemon().addRibbon(RibbonRegistry.SNOWY.getValueUnsafe());
                            continue;
                        }
                        if (biome.m_264600_(this.m_20183_()) == Biome.Precipitation.NONE) continue;
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.RAINY.getValueUnsafe());
                        continue;
                    }
                    if (weatherType == WeatherType.STORM) {
                        if (biome.m_264600_(this.m_20183_()) == Biome.Precipitation.SNOW) {
                            this.pixelmon.getPokemon().addRibbon(RibbonRegistry.BLIZZARD.getValueUnsafe());
                            continue;
                        }
                        if (biome.m_264600_(this.m_20183_()) == Biome.Precipitation.NONE) continue;
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.STORMY.getValueUnsafe());
                        continue;
                    }
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.CLOUDY.getValueUnsafe());
                    continue;
                }
                weatherType = WeatherType.get(this.f_19853_);
                biome = (Biome)this.f_19853_.m_204166_(this.pixelmon.m_20183_()).get();
                if (weatherType == WeatherType.RAIN) {
                    if (biome.m_264600_(this.m_20183_()) == Biome.Precipitation.SNOW) {
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.SNOWY.getValueUnsafe());
                        continue;
                    }
                    if (biome.m_264600_(this.m_20183_()) != Biome.Precipitation.RAIN) continue;
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.RAINY.getValueUnsafe());
                    continue;
                }
                if (weatherType == WeatherType.STORM) {
                    if (biome.m_264600_(this.m_20183_()) == Biome.Precipitation.SNOW) {
                        this.pixelmon.getPokemon().addRibbon(RibbonRegistry.BLIZZARD.getValueUnsafe());
                        continue;
                    }
                    if (biome.m_264600_(this.m_20183_()) != Biome.Precipitation.RAIN) continue;
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.STORMY.getValueUnsafe());
                    continue;
                }
                this.pixelmon.getPokemon().addRibbon(RibbonRegistry.CLOUDY.getValueUnsafe());
                continue;
            }
            if (Math.random() <= 0.02) {
                List<WorldTime> current = WorldTime.getCurrent(this.f_19853_);
                if (current.contains(WorldTime.AFTERNOON)) {
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.LUNCHTIME.getValueUnsafe());
                    continue;
                }
                if (current.contains(WorldTime.DUSK)) {
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.DUSK.getValueUnsafe());
                    continue;
                }
                if (current.contains(WorldTime.NIGHT) || current.contains(WorldTime.DAWN)) {
                    this.pixelmon.getPokemon().addRibbon(RibbonRegistry.SLEEPY_TIME.getValueUnsafe());
                    continue;
                }
                this.pixelmon.getPokemon().addRibbon(RibbonRegistry.DAWN.getValueUnsafe());
                continue;
            }
            if (!(Math.random() <= 0.04) || this.battleController == null || !this.battleController.wasFishing) continue;
            this.pixelmon.getPokemon().addRibbon(RibbonRegistry.FISHING.getValueUnsafe());
        }
    }

    private void failCapture() {
        Pixelmon.EVENT_BUS.post((Event)new CaptureEvent.FailedCapture((ServerPlayer)this.thrower, this.pixelmon, this));
        this.openAngle = -1.5707964f;
        this.waitTime = 0;
        this.setIsWaiting(false);
        this.pixelmon.m_6034_(this.pokemonPosX, this.pokemonPosY, this.pokemonPosZ);
        this.pixelmon.hitByPokeball = null;
        if (this.f_19853_.m_6815_(this.pixelmon.m_19879_()) != null) {
            this.pixelmon.unloadEntity();
        }
        this.pixelmon.revive();
        this.f_19853_.m_7967_((Entity)this.pixelmon);
        this.pixelmon.getPokemon().updateDimensionAndEntityID((ResourceKey<Level>)this.f_19853_.m_46472_(), this.pixelmon.m_19879_());
        this.pixelmon.m_6034_(this.pokemonPosX, this.pokemonPosY, this.pokemonPosZ);
        this.pixelmon.resetAlterations(this.initialScale);
        this.pixelmon.revive();
        this.getBallType().getLogic().doFailEffect(this.getBallType(), this, this.pixelmon);
        MutableComponent message = ChatHandler.getMessage("pixelmon.pokeballs.brokefree", this.pixelmon.getLocalizedName());
        if (this.getMode() == PokeBallMode.BATTLE && !this.battleController.battleEnded) {
            this.pixelmon.battleController = this.battleController;
            if (this.pixelmon.transformed != null) {
                this.pixelmon.updateTransformed();
            }
            PlayerParticipant playerParticipant = (PlayerParticipant)this.battleController.getParticipantForEntity(this.thrower);
            playerParticipant.lastFailedCapture = this.getBallType();
            this.battleController.sendToAll((Component)message);
            this.battleController.endPause();
        } else {
            ChatHandler.sendChat((CommandSource)this.thrower, (Component)message);
        }
        this.m_6089_();
    }

    public void m_6089_() {
        if (this.isBattleThrown && !this.captureFinished) {
            if (!this.getIsWaiting()) {
                this.forceBattleCapture();
            }
            this.catchPokemon();
            return;
        }
        if (this.capturedPokemon && this.getIsWaiting()) {
            this.storeCapture();
        }
        if (this.pixelmon != null && this.pixelmon.hitByPokeball == this) {
            this.pixelmon.hitByPokeball = null;
        }
        super.m_6089_();
    }

    protected Item m_7881_() {
        return null;
    }
}

