/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers;

import com.google.common.collect.Maps;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.CastformTickHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.ShearableTickHandler;
import java.util.Map;
import net.minecraft.world.level.Level;

public abstract class TickHandlerBase {
    protected AbstractBaseEntity pixelmon;
    private int refreshRate;
    private int ticks = 0;
    private static final Map<RegistryValue<Species>, Class<? extends TickHandlerBase>> TICK_HANDLERS = Maps.newHashMap();

    public TickHandlerBase(AbstractBaseEntity pixelmon, int refreshRate) {
        this.pixelmon = pixelmon;
        this.refreshRate = refreshRate;
    }

    public TickHandlerBase(AbstractBaseEntity pixelmon) {
        this(pixelmon, 0);
    }

    protected abstract void onTick(Level var1);

    public void tick(Level world) {
        if (++this.ticks > this.refreshRate) {
            this.ticks = 0;
            this.onTick(world);
        }
    }

    public static TickHandlerBase getTickHandler(PixelmonEntity pixelmon) {
        if (!TICK_HANDLERS.containsKey(pixelmon.getSpecies())) {
            return null;
        }
        Class<? extends TickHandlerBase> c = TICK_HANDLERS.get(pixelmon.getSpecies());
        try {
            return c.getConstructor(AbstractBaseEntity.class).newInstance(new Object[]{pixelmon});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        TICK_HANDLERS.put(PixelmonSpecies.CASTFORM, CastformTickHandler.class);
        TICK_HANDLERS.put(PixelmonSpecies.MAREEP, ShearableTickHandler.class);
        TICK_HANDLERS.put(PixelmonSpecies.WOOLOO, ShearableTickHandler.class);
        TICK_HANDLERS.put(PixelmonSpecies.DUBWOOL, ShearableTickHandler.class);
    }
}

