/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.movement;

import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.ControlledMovementLogic;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import com.pixelmonmod.pixelmon.enums.EnumKeybinds;
import java.util.List;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

public abstract class PixelmonMovementBase {
    protected AbstractMovesEntity pixelmon;

    public PixelmonMovementBase(AbstractMovesEntity dragon) {
        this.pixelmon = dragon;
    }

    public abstract void handleMovement(List<EnumKeybinds> var1);

    public abstract void onLivingUpdate();

    public abstract void updatePassenger(Entity var1, Vector3f var2);

    protected Matrix3f createRotationMatrix(Vector3f lookVec) {
        Matrix3f matOut = new Matrix3f();
        matOut.m00 = 1.0f;
        matOut.m01 = 0.0f;
        matOut.m02 = 0.0f;
        matOut.m10 = 0.0f;
        matOut.m11 = 1.0f;
        matOut.m12 = 0.0f;
        matOut.m20 = 0.0f;
        matOut.m21 = 0.0f;
        matOut.m22 = 1.0f;
        Matrix3f matW = new Matrix3f();
        matW.m01 = -lookVec.z;
        matW.m02 = lookVec.y;
        matW.m10 = lookVec.z;
        matW.m12 = -lookVec.x;
        matW.m20 = -lookVec.y;
        matW.m21 = lookVec.x;
        Matrix3f matW2 = new Matrix3f((Matrix3fc)matW);
        double angle = -this.pixelmon.rotationRoll * (float)Math.PI / 180.0f;
        this.mul(matW, (float)Math.sin(angle));
        this.mul(matW2, (float)(2.0 * Math.sin(angle / 2.0) * Math.sin(angle / 2.0)));
        matW2.mul((Matrix3fc)matW2);
        this.add(matW, matOut);
        this.add(matW2, matOut);
        return matOut;
    }

    public void add(Matrix3f src, Matrix3f dest) {
        dest.m00 += src.m00;
        dest.m01 += src.m01;
        dest.m02 += src.m02;
        dest.m10 += src.m10;
        dest.m11 += src.m11;
        dest.m12 += src.m12;
        dest.m20 += src.m20;
        dest.m21 += src.m21;
        dest.m22 += src.m22;
    }

    public void mul(Matrix3f src, float f) {
        src.m00 *= f;
        src.m01 *= f;
        src.m02 *= f;
        src.m10 *= f;
        src.m11 *= f;
        src.m12 *= f;
        src.m20 *= f;
        src.m21 *= f;
        src.m22 *= f;
    }

    public void scale(Vector3f src, float scale) {
        src.x = src.x() * scale;
        src.y = src.y() * scale;
        src.z = src.z() * scale;
    }

    private void calculateRoll(AbstractMovesEntity pixelmon, float strafe) {
        ControlledMovementLogic mountedFlyingParameters = pixelmon.getForm().getMovement().getMountedFlyingParameters();
        if (mountedFlyingParameters != null) {
            mountedFlyingParameters.calculateRoll(pixelmon, strafe);
        }
    }
}

