/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;

public class WeatherChanger {
    public static boolean allowMultiplayerWeather = false;

    public static MoveSkill createRainMoveSkill() {
        return WeatherChanger.createBaseMoveSkill("rain_dance", true).setName("pixelmon.moveskill.rain_dance").describe("pixelmon.moveskill.rain_dance.description1", "pixelmon.moveskill.rain_dance.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/raindance.png")).setAnyMoves("Rain Dance").setUsePP(true).setIntrinsicSpecs(Lists.newArrayList((Object[])new PokemonSpecification[]{PokemonSpecificationProxy.create("Kyogre").get()}));
    }

    public static MoveSkill createSunMoveSkill() {
        return WeatherChanger.createBaseMoveSkill("sunny_day", false).setName("pixelmon.moveskill.sunny_day").describe("pixelmon.moveskill.sunny_day.description1", "pixelmon.moveskill.sunny_day.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/sunnyday.png")).setAnyMoves("Sunny Day").setUsePP(true).setIntrinsicSpecs(Lists.newArrayList((Object[])new PokemonSpecification[]{PokemonSpecificationProxy.create("Groudon").get()}));
    }

    private static MoveSkill createBaseMoveSkill(String id, boolean rain) {
        MoveSkill moveSkill = new MoveSkill(id);
        moveSkill.setDefaultCooldownTicks(6000);
        moveSkill.setBehaviourNoTarget(pixelmon -> {
            if (!allowMultiplayerWeather && pixelmon.f_19853_.m_7654_().m_6846_().m_11309_() > 1 && pixelmon.f_19853_.m_7654_() instanceof DedicatedServer) {
                ChatHandler.sendFormattedChat((CommandSource)pixelmon.m_269323_(), ChatFormatting.RED, "pixelmon.moveskill.weather.nomultiplayer", new Object[0]);
                return -1;
            }
            if (rain) {
                if (!pixelmon.f_19853_.m_45527_(pixelmon.m_20183_())) {
                    ChatHandler.sendFormattedChat((CommandSource)pixelmon.m_269323_(), ChatFormatting.RED, "pixelmon.moveskill.weather.underground", pixelmon.m_5446_());
                    return -1;
                }
                if (pixelmon.f_19853_.m_46471_()) {
                    ChatHandler.sendFormattedChat((CommandSource)pixelmon.m_269323_(), ChatFormatting.RED, "pixelmon.moveskill.rain_dance.alreadyraining", new Object[0]);
                    return -1;
                }
            } else {
                if (!pixelmon.f_19853_.m_45527_(pixelmon.m_20183_())) {
                    ChatHandler.sendFormattedChat((CommandSource)pixelmon.m_269323_(), ChatFormatting.RED, "pixelmon.moveskill.weather.underground", pixelmon.m_5446_());
                    return -1;
                }
                if (!pixelmon.f_19853_.m_46471_()) {
                    ChatHandler.sendFormattedChat((CommandSource)pixelmon.m_269323_(), ChatFormatting.RED, "pixelmon.moveskill.sunny_day.alreadysunny", new Object[0]);
                    return -1;
                }
            }
            pixelmon.f_19853_.m_6106_().m_5565_(rain);
            if (pixelmon.getPokemon().getSpecies().is(PixelmonSpecies.KYOGRE) && rain) {
                ServerLevel ServerLevel2 = (ServerLevel)pixelmon.f_19853_;
                ServerLevel2.m_8606_(0, 6000, true, true);
                ChatHandler.sendFormattedChat((CommandSource)pixelmon.m_269323_(), ChatFormatting.WHITE, "pixelmon.moveskill.rain_dance.kyogreused", pixelmon.m_5446_());
            } else if (rain) {
                ChatHandler.sendFormattedChat((CommandSource)pixelmon.m_269323_(), ChatFormatting.WHITE, "pixelmon.moveskill.rain_dance.used", new Object[0]);
            } else {
                ChatHandler.sendFormattedChat((CommandSource)pixelmon.m_269323_(), ChatFormatting.WHITE, "pixelmon.moveskill.sunny_day.used", new Object[0]);
            }
            return moveSkill.cooldownTicks;
        });
        return moveSkill;
    }
}

