/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.attackAnimations.VariableParticleEffect;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class Smelt {
    public static boolean instaCookForMedHighStrength = true;
    public static List<RegistryValue<ImmutableAttack>> highStrength = Lists.newArrayList((Object[])new RegistryValue[]{AttackRegistry.INFERNO, AttackRegistry.BURN_UP, AttackRegistry.BLUE_FLARE});
    public static List<RegistryValue<ImmutableAttack>> midStrength = Lists.newArrayList((Object[])new RegistryValue[]{AttackRegistry.INCINERATE});

    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("smelt").setName("pixelmon.moveskill.smelt").describe("pixelmon.moveskill.smelt.description1", "pixelmon.moveskill.smelt.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/smelt.png")).setDefaultCooldownTicks(2400).setUsePP(true).setRange(8).setAnyMoves("Incinerate", "Inferno", "Ember", "Burn Up", "Blue Flare");
        return moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            BlockPos pos = (BlockPos)tup.m_14418_();
            BlockState state = pixelmon.f_19853_.m_8055_(pos);
            if (!(state.m_60734_() instanceof AbstractFurnaceBlock)) {
                return -1;
            }
            BlockEntity te = pixelmon.f_19853_.m_7702_(pos);
            if (!(te instanceof AbstractFurnaceBlockEntity)) {
                return -1;
            }
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)te;
            RecipeType checkType = furnace instanceof SmokerBlockEntity ? RecipeType.f_44110_ : (furnace instanceof BlastFurnaceBlockEntity ? RecipeType.f_44109_ : RecipeType.f_44108_);
            int strength = 0;
            for (RegistryValue<ImmutableAttack> highAttack : highStrength) {
                if (!highAttack.isInitialized() || !pixelmon.getPokemon().getMoveset().hasAttack(highAttack.get())) continue;
                strength = 32;
                break;
            }
            for (RegistryValue<ImmutableAttack> midAttack : midStrength) {
                if (!midAttack.isInitialized() || !pixelmon.getPokemon().getMoveset().hasAttack(midAttack.get())) continue;
                strength = 16;
                break;
            }
            int cooked = 0;
            while (strength > cooked++ && instaCookForMedHighStrength) {
            }
            furnace.f_58311_.m_8050_(0, (32 + strength) * 20);
            pixelmon.f_19853_.m_6263_(null, (double)pos.m_123341_(), (double)((float)pos.m_123342_() + 0.5f), (double)pos.m_123343_(), SoundEvents.f_11705_, SoundSource.BLOCKS, 0.2f, 1.0f);
            ChatHandler.sendFormattedChat((CommandSource)pixelmon.m_269323_(), ChatFormatting.GRAY, "pixelmon.moveskill.smelt.use", pixelmon.getLocalizedName());
            new VariableParticleEffect(pixelmon.f_19853_, AttackAnimationData.beam().setScale(0.25f).setPower(30)).setAttackBase(AttackRegistry.FLAMETHROWER.get()).setStartPosition((LivingEntity)pixelmon).setEndPosition(new Vec3((double)furnace.m_58899_().m_123341_() + 0.5, (double)furnace.m_58899_().m_123342_() + 0.5, (double)furnace.m_58899_().m_123343_() + 0.5)).showAllWithin(20);
            pixelmon.f_19853_.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
            return moveSkill.cooldownTicks / (strength == 0 ? 2 : 1);
        });
    }
}

