/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.pixelmonmod.pixelmon.api.battles.BattleStartTypes;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.PixelBlockSnapshot;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.FossilBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawningHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.PixelmonBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RockSmash {
    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("rock_smash").setName("pixelmon.moveskill.rock_smash").describe("pixelmon.moveskill.rock_smash.description1", "pixelmon.moveskill.rock_smash.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/rocksmash.png")).setDefaultCooldownTicks(800).setUsePP(true).setAnyMoves("Rock Smash");
        moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            if (!PixelmonConfigProxy.getExternalMoves().isAllowDestructiveExternalMoves()) {
                return -1;
            }
            Level world = pixelmon.f_19853_;
            BlockPos pos = (BlockPos)tup.m_14418_();
            BlockState state = world.m_8055_(pos);
            if (!state.m_204336_(PixelmonBlockTags.ROCK_SMASHABLE_BLOCKS)) {
                return -1;
            }
            if (state.m_60734_() instanceof MultiBlock || state.m_60734_() instanceof FossilBlock) {
                return -1;
            }
            ServerPlayer owner = (ServerPlayer)pixelmon.m_269323_();
            if (owner.f_8941_.m_9290_() == GameType.ADVENTURE) {
                PixelBlockSnapshot snapshot = new PixelBlockSnapshot(world, pos, state);
                world.m_7471_(pos, false);
            } else {
                ItemStack hand = owner.m_6844_(EquipmentSlot.MAINHAND);
                try {
                    owner.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    if (owner.f_8941_.m_9280_(pos) && !state.m_60734_().canHarvestBlock(state, (BlockGetter)world, pos, (Player)owner)) {
                        world.m_46961_(pos, true);
                    }
                }
                finally {
                    owner.m_8061_(EquipmentSlot.MAINHAND, hand);
                }
            }
            BlockSpawningHandler.getInstance().performBattleStartCheck(world, pos, (Entity)pixelmon.m_269323_(), (PixelmonEntity)((Object)pixelmon), BattleStartTypes.ROCKSMASH, state, new Object[0]);
            return moveSkill.cooldownTicks - pixelmon.getPokemon().getStat(BattleStatsType.SPEED);
        });
        return moveSkill;
    }
}

