/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.config.GeneralConfig;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.IlluminatePositionsPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class OreSense {
    public static int durationTicks = 300;
    public static int maxSearchRadius = 10;

    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("ore_sense").setName("pixelmon.moveskill.ore_sense").describe("pixelmon.moveskill.ore_sense.description1", "pixelmon.moveskill.ore_sense.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/oresense.png")).setAnyMoves("Magnet Rise", "Metal Sound", "Steel Beam").setIntrinsicSpecs(Lists.newArrayList((Object[])new PokemonSpecification[]{PokemonSpecificationProxy.create("ab:MagnetPull").get()})).setDefaultCooldownTicks(2400).setUsePP(true);
        return moveSkill.setBehaviourNoTarget(pixelmon -> {
            final Level world = pixelmon.f_19853_;
            final BlockPos middle = pixelmon.m_20183_();
            new Timer(true).schedule(new TimerTask((PixelmonEntity)((Object)pixelmon)){
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
                final /* synthetic */ PixelmonEntity val$pixelmon;
                {
                    this.val$pixelmon = pixelmonEntity;
                }

                @Override
                public void run() {
                    ArrayList<BlockPos> oreLocations = new ArrayList<BlockPos>();
                    for (int x = middle.m_123341_() - maxSearchRadius; x <= middle.m_123341_() + maxSearchRadius; ++x) {
                        for (int y = middle.m_123342_() - maxSearchRadius; y <= middle.m_123342_() + maxSearchRadius; ++y) {
                            for (int z = middle.m_123343_() - maxSearchRadius; z <= middle.m_123343_() + maxSearchRadius; ++z) {
                                BlockState state = world.m_8055_((BlockPos)this.pos.m_122178_(x, y, z));
                                if (!OreSense.isAnOre(state.m_60734_())) continue;
                                oreLocations.add(new BlockPos((Vec3i)this.pos));
                            }
                        }
                    }
                    world.m_7654_().execute(() -> {
                        ServerPlayer player = (ServerPlayer)this.val$pixelmon.m_269323_();
                        if (player == null) {
                            return;
                        }
                        HashMap<BlockPos, GeneralConfig.OreColor> locationColors = new HashMap<BlockPos, GeneralConfig.OreColor>();
                        for (BlockPos pos : oreLocations) {
                            GeneralConfig.OreColor entry;
                            int color;
                            Block block = world.m_8055_(pos).m_60734_();
                            if (ForgeRegistries.BLOCKS.getKey((Object)block) == null || (color = (entry = PixelmonConfigProxy.getGeneral().getEntryForBlock(ForgeRegistries.BLOCKS.getKey((Object)block).toString())).getColor()) == -1) continue;
                            locationColors.put(pos, entry);
                        }
                        if (locationColors.isEmpty()) {
                            ChatHandler.sendFormattedChat((CommandSource)this.val$pixelmon.m_269323_(), ChatFormatting.RED, "pixelmon.moveskill.ore_sense.none", new Object[0]);
                        } else {
                            ChatHandler.sendFormattedChat((CommandSource)this.val$pixelmon.m_269323_(), ChatFormatting.WHITE, "pixelmon.moveskill.ore_sense.some", this.val$pixelmon.m_5446_());
                            NetworkHelper.sendPacket(new IlluminatePositionsPacket(world, durationTicks, locationColors), player);
                        }
                    });
                }
            }, 1L);
            return moveSkill.cooldownTicks;
        });
    }

    private static boolean isAnOre(Block block) {
        if (ForgeRegistries.BLOCKS.getKey((Object)block) != null) {
            String blockName = ForgeRegistries.BLOCKS.getKey((Object)block).toString();
            return PixelmonConfigProxy.getGeneral().getEntryForBlock(blockName) != null;
        }
        return false;
    }
}

