/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class Lightning {
    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("lightning_bolt").setName("pixelmon.moveskill.lightning_bolt").describe("pixelmon.moveskill.lightning_bolt.description").setDefaultCooldownTicks(500).setRange(7).setUsePP(true).setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/lightning.png")).setAnyMoves("Thunderbolt", "Bolt Strike", "Thunder", "Spark", "Discharge", "Fusion Bolt", "Thunder Shock");
        return moveSkill.setBehaviourMultiTarget((pixelmon, data) -> {
            ServerPlayer player = (ServerPlayer)pixelmon.m_269323_();
            if (!PixelmonConfigProxy.getExternalMoves().isAllowDestructiveExternalMoves()) {
                return -1;
            }
            ServerLevel world = (ServerLevel)pixelmon.f_19853_;
            BlockPos pos = data instanceof LivingEntity ? ((LivingEntity)data).m_20183_() : (BlockPos)((Tuple)data).m_14418_();
            if (Lightning.canLightningStrike((Level)world, pos) && !world.m_7654_().m_7762_(world, pos, (Player)player)) {
                LightningBolt entity = new LightningBolt(EntityType.f_20465_, (Level)world);
                entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                world.m_7967_((Entity)entity);
                return moveSkill.cooldownTicks - pixelmon.getPokemon().getStat(BattleStatsType.SPEED);
            }
            return -1;
        }, MoveSkill.EnumTargetType.BLOCK, MoveSkill.EnumTargetType.MISC_ENTITY);
    }

    private static boolean canLightningStrike(Level world, BlockPos strikePosition) {
        Biome biome = (Biome)world.m_204166_(strikePosition).get();
        return biome.m_264600_(strikePosition) == Biome.Precipitation.RAIN;
    }
}

