/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.pixelmonmod.pixelmon.api.attackAnimations.VariableParticleEffect;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.Scheduling;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Ignite {
    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("ignite").setName("pixelmon.moveskill.ignite").describe("pixelmon.moveskill.ignite.description1", "pixelmon.moveskill.ignite.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/fire.png")).setUsePP(true).setAnyMoves("Ember", "Fire Blast", "Flamethrower", "Incinerate", "Blast Burn", "Fire Spin", "Flame Burst", "Flame Wheel", "Heat Wave", "Inferno", "Sacred Fire", "Will-O-Wisp").setDefaultCooldownTicks(800).setRange(10);
        return moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            if (!PixelmonConfigProxy.getExternalMoves().isAllowDestructiveExternalMoves()) {
                return -1;
            }
            if (((ServerPlayer)pixelmon.m_269323_()).f_8941_.m_9290_() == GameType.ADVENTURE) {
                return moveSkill.cooldownTicks;
            }
            ServerPlayer player = (ServerPlayer)pixelmon.m_269323_();
            Pokemon pokemon = pixelmon.getPokemon();
            int width = 1;
            int length = 1;
            boolean cross = false;
            if (pokemon.getMoveset().hasAttack(AttackRegistry.FIRE_BLAST)) {
                cross = true;
                width = 3;
                length = 3;
            } else if (pokemon.getMoveset().hasAttack(AttackRegistry.INFERNO, AttackRegistry.SACRED_FIRE, AttackRegistry.INCINERATE)) {
                width = 3;
                length = 3;
            } else {
                length = 3;
            }
            BlockPos pos = (BlockPos)tup.m_14418_();
            int initPosX = pos.m_123341_();
            int initPosY = pos.m_123342_();
            int initPosZ = pos.m_123343_();
            ArrayList<Vec3> targets = new ArrayList<Vec3>();
            if (!cross) {
                for (x = 0; x < width; ++x) {
                    posX = x + initPosX;
                    for (z = 0; z < length; ++z) {
                        posZ = z + initPosZ;
                        lit = Ignite.placeFire(pixelmon.f_19853_, posX, initPosY, posZ, player);
                        if (lit == null) continue;
                        targets.add(new Vec3((double)((float)lit.m_123341_() + 0.5f), (double)lit.m_123342_(), (double)((float)lit.m_123343_() + 0.5f)));
                    }
                }
            } else {
                for (x = -1; x < 2; ++x) {
                    posX = x + initPosX;
                    for (z = -1; z < 2; ++z) {
                        posZ = z + initPosZ;
                        if (x != z && x != -z || (lit = Ignite.placeFire(pixelmon.f_19853_, posX, initPosY, posZ, player)) == null) continue;
                        targets.add(new Vec3((double)((float)lit.m_123341_() + 0.5f), (double)lit.m_123342_(), (double)((float)lit.m_123343_() + 0.5f)));
                    }
                }
            }
            pixelmon.m_21563_().m_24950_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 360.0f, 360.0f);
            VariableParticleEffect effect = new VariableParticleEffect(pixelmon.f_19853_, AttackAnimationData.beam().setScale(0.25f).setPower(30)).setAttackBase(AttackRegistry.getAttackBaseFromEnglishName("Flamethrower").get()).setStartPosition((LivingEntity)pixelmon);
            for (Vec3 target : targets) {
                effect.setEndPosition(target).showAllWithin(20);
            }
            return moveSkill.cooldownTicks;
        });
    }

    private static BlockPos placeFire(Level world, int x, int y, int z, ServerPlayer player) {
        int origy = y;
        while (world.m_8055_(new BlockPos(x, y, z)).m_60734_() != Blocks.f_50016_ && y < origy + 3) {
            ++y;
        }
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block == Blocks.f_50016_ && block.canHarvestBlock(state, (BlockGetter)world, pos, (Player)player)) {
            Scheduling.schedule(10, () -> {
                if (!world.m_7654_().m_7762_((ServerLevel)world, pos, (Player)player)) {
                    world.m_46597_(pos, Blocks.f_50083_.m_49966_());
                }
            }, false);
            return pos;
        }
        return null;
    }
}

