/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.PixelmonBlockTags;
import com.pixelmonmod.pixelmon.tools.LineCalc;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;

public class Dig {
    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("dig").setName("pixelmon.moveskill.dig").describe("pixelmon.moveskill.dig.description1", "pixelmon.moveskill.dig.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/dig.png")).setAnyMoves("Dig").setUsePP(true);
        moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            if (!PixelmonConfigProxy.getExternalMoves().isAllowDestructiveExternalMoves()) {
                return -1;
            }
            Direction sideHit = (Direction)tup.m_14419_();
            BlockPos pos = (BlockPos)tup.m_14418_();
            int depth = 74 - (int)(((float)pixelmon.getPokemon().getStat(BattleStatsType.ATTACK) - 20.0f) / 180.0f * 74.0f);
            if (depth < -62) {
                depth = -62;
            }
            int maxOff = 1;
            if (pixelmon.getPokemon().getStat(BattleStatsType.ATTACK) > 150) {
                maxOff = 2;
            }
            if (pixelmon.getPokemon().getStat(BattleStatsType.ATTACK) > 300) {
                maxOff = 3;
            }
            if (pos.m_123342_() < depth) {
                pixelmon.f_19853_.m_5594_(null, pos, SoundEvents.f_11668_, SoundSource.NEUTRAL, 0.3f, 0.1f);
            } else {
                if (sideHit == Direction.UP) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.m_7918_(xOff, 0, zOff));
                        }
                    }
                } else if (sideHit == Direction.DOWN) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.m_7918_(xOff, 0, zOff));
                        }
                    }
                } else if (sideHit == Direction.SOUTH) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                            Dig.doHarvest(pixelmon, pos.m_7918_(xOff, yOff, 0));
                        }
                    }
                } else if (sideHit == Direction.NORTH) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                            Dig.doHarvest(pixelmon, pos.m_7918_(xOff, yOff, 0));
                        }
                    }
                } else if (sideHit == Direction.EAST) {
                    for (yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.m_7918_(0, yOff, zOff));
                        }
                    }
                } else if (sideHit == Direction.WEST) {
                    for (yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.m_7918_(0, yOff, zOff));
                        }
                    }
                }
                pixelmon.f_19853_.m_5594_(null, pos, SoundEvents.f_11988_, SoundSource.NEUTRAL, 1.0f, 0.1f);
            }
            float speed = pixelmon.getPokemon().getStat(BattleStatsType.SPEED);
            return (int)(300.0f * (1.0f - LineCalc.lerp(speed, 1.0f, 200.0f, 0.0f, 0.5f)));
        });
        return moveSkill;
    }

    private static void doHarvest(PixelmonEntity user, BlockPos pos) {
        BlockState state = user.f_19853_.m_8055_(pos);
        if (state.m_204336_(PixelmonBlockTags.DIGGABLE_BLOCKS)) {
            ServerPlayer player = (ServerPlayer)user.m_269323_();
            if (player == null) {
                return;
            }
            user.f_19853_.m_46953_(pos, true, (Entity)user);
        }
    }
}

