/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.Scheduling;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.tools.LineCalc;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class Cut {
    public static int maximumLogs = 100;
    public static int ticksBetweenChops = 2;
    public static ArrayList<Direction[]> checkDirections = Lists.newArrayList((Object[])new Direction[][]{{Direction.NORTH}, {Direction.SOUTH}, {Direction.EAST}, {Direction.WEST}, {Direction.UP}, {Direction.UP, Direction.NORTH}, {Direction.UP, Direction.SOUTH}, {Direction.UP, Direction.EAST}, {Direction.UP, Direction.WEST}});

    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("cut").setName("pixelmon.moveskill.cut").describe("pixelmon.moveskill.cut.description1", "pixelmon.moveskill.cut.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/cut.png")).setAnyMoves("Cut").setUsePP(true).setRange(8);
        moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            if (!PixelmonConfigProxy.getExternalMoves().isAllowDestructiveExternalMoves()) {
                return -1;
            }
            Level world = pixelmon.f_19853_;
            BlockPos pos = (BlockPos)tup.m_14418_();
            if (!world.m_8055_(pos).m_204336_(BlockTags.f_13106_)) {
                return -1;
            }
            ArrayList<BlockPos> logs = Cut.findTreeLogs(world, pos);
            int logCount = logs.size();
            if (logs.size() > maximumLogs) {
                ChatHandler.sendChat((Entity)pixelmon.m_269323_(), "pixelmon.moveskill.cut.toomany", new Object[0]);
                return -1;
            }
            float maxLogs = LineCalc.lerp(pixelmon.getPokemon().getStat(BattleStatsType.ATTACK), 1.0f, 300.0f, 1.0f, maximumLogs);
            if (maxLogs <= (float)logs.size()) {
                ChatHandler.sendChat((Entity)pixelmon.m_269323_(), "pixelmon.moveskill.cut.fail", pixelmon.getPokemon().getDisplayName());
                return -1;
            }
            Scheduling.schedule(ticksBetweenChops, task -> {
                if (!logs.isEmpty()) {
                    ServerPlayer player = (ServerPlayer)pixelmon.m_269323_();
                    if (player == null) {
                        return;
                    }
                    BlockPos log = (BlockPos)logs.remove(0);
                    BlockState state = world.m_8055_(log);
                    ItemStack hand = player.m_6844_(EquipmentSlot.MAINHAND);
                    try {
                        player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                        ((ServerPlayer)pixelmon.m_269323_()).f_8941_.m_9280_(log);
                    }
                    finally {
                        player.m_8061_(EquipmentSlot.MAINHAND, hand);
                    }
                }
                if (logs.isEmpty()) {
                    task.repeats = false;
                }
            }, true);
            float speed = pixelmon.getPokemon().getStat(BattleStatsType.SPEED);
            return (int)(200.0f + (float)(logCount * 20) * (1.5f - LineCalc.ratio(speed, 1.0f, 200.0f)));
        });
        return moveSkill;
    }

    private static ArrayList<BlockPos> findTreeLogs(Level world, BlockPos pos) {
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> newLogs = new ArrayList<BlockPos>();
        newLogs.add(pos);
        while (!newLogs.isEmpty()) {
            Cut.addAdjacentLogs(world, (BlockPos)newLogs.get(0), newLogs, logs);
            logs.add(newLogs.get(0));
            newLogs.remove(0);
        }
        return logs;
    }

    private static void addAdjacentLogs(Level world, BlockPos pos, ArrayList<BlockPos> newLogs, ArrayList<BlockPos> logs) {
        for (Direction[] facings : checkDirections) {
            BlockPos loc = pos;
            for (Direction f : facings) {
                loc = loc.m_121945_(f);
            }
            if (!world.m_8055_(loc).m_204336_(BlockTags.f_13106_) || Cut.hasLog(logs, loc) || Cut.hasLog(newLogs, loc)) continue;
            newLogs.add(loc);
        }
    }

    private static boolean hasLog(ArrayList<BlockPos> logs, BlockPos loc) {
        for (BlockPos log : logs) {
            if (!log.equals((Object)loc)) continue;
            return true;
        }
        return false;
    }
}

