/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.pokemon.ItemFormChangeEvent;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayParticleSystemPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges.IFormChange;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;

public class NecrozmaFormChange
implements IFormChange {
    @Override
    public boolean isValidItem(ItemStack stack) {
        Item item = stack.m_41720_();
        return item == PixelmonItems.n_lunarizer || item == PixelmonItems.n_solarizer;
    }

    @Override
    public boolean isValidPokemon(PixelmonEntity pixelmon) {
        return pixelmon.isPokemon(PixelmonSpecies.NECROZMA) && !pixelmon.isEvolving();
    }

    @Override
    public boolean execute(PixelmonEntity pixelmon, ItemStack stack, ServerPlayer player) {
        Pokemon toFuse;
        Item item = stack.m_41720_();
        Pokemon pokemon = pixelmon.getPokemon();
        Species partner = item == PixelmonItems.n_lunarizer ? PixelmonSpecies.LUNALA.getValueUnsafe() : PixelmonSpecies.SOLGALEO.getValueUnsafe();
        Stats toForm = partner.is(PixelmonSpecies.LUNALA) ? pokemon.getSpecies().getForm("dawn") : pokemon.getSpecies().getForm("dusk");
        PlayerPartyStorage storage = StorageProxy.getPartyNow(player.m_20148_());
        if (pokemon.getForm().is(toForm)) {
            ItemFormChangeEvent event;
            CompoundTag fusedPokemonNBT = pokemon.getPersistentData().m_128469_("FusedPokemon");
            Pokemon fused = null;
            if (!fusedPokemonNBT.m_128456_()) {
                try {
                    fused = PokemonFactory.create(fusedPokemonNBT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (fused == null) {
                    Pixelmon.LOGGER.error("Couldn't get fused Pok\u00e9mon from NBT for player: " + player.m_7755_());
                }
            }
            if (Pixelmon.EVENT_BUS.post((Event)(event = new ItemFormChangeEvent(player, stack, pixelmon, fused)))) {
                return false;
            }
            pixelmon.m_20193_().m_6263_(null, pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 0.1f);
            NetworkHelper.sendToDimension(new PlayParticleSystemPacket(ParticleSystems.DISCHARGE, pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), pixelmon.f_19853_, pixelmon.getPixelmonScale(), pixelmon.getPokemon().isShiny(), partner.is(PixelmonSpecies.SOLGALEO) ? 1.0 : 0.5, 0.5, partner != PixelmonSpecies.SOLGALEO.getValueUnsafe() ? 1.0 : 0.5, 0.0), player.f_19853_);
            pokemon.setForm(PixelmonForms.NONE);
            if ((pokemon.getMoveset().removeAttack(AttackRegistry.SUNSTEEL_STRIKE.orElse(null)) || pokemon.getMoveset().removeAttack(AttackRegistry.MOONGEIST_BEAM.orElse(null))) && pokemon.getMoveset().size() == 0) {
                pokemon.getMoveset().add(new Attack(AttackRegistry.CONFUSION));
            }
            if (fused != null) {
                storage.add(event.fusion);
            }
            pixelmon.getPersistentData().m_128473_("FusedPokemon");
        } else if (pokemon.getForm().isForm(PixelmonForms.NONE) && (toFuse = storage.findOne(pk -> pk.getSpecies().is(partner))) != null) {
            Attack specialMove;
            ItemFormChangeEvent event = new ItemFormChangeEvent(player, stack, pixelmon, toFuse);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            toFuse.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("FormChange"));
            pixelmon.m_20193_().m_6263_(null, pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), SoundEvents.f_12558_, SoundSource.NEUTRAL, 0.3f, 0.2f);
            NetworkHelper.sendToDimension(new PlayParticleSystemPacket(ParticleSystems.RADIALTHUNDER, pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), pixelmon.f_19853_, pixelmon.getPixelmonScale(), pixelmon.getPokemon().isShiny(), partner.is(PixelmonSpecies.SOLGALEO) ? 1.0 : 0.5, 0.5, partner != PixelmonSpecies.SOLGALEO.getValueUnsafe() ? 1.0 : 0.5), pixelmon.f_19853_);
            storage.set(toFuse.getPosition(), null);
            pokemon.getPersistentData().m_128365_("FusedPokemon", (Tag)toFuse.writeToNBT(new CompoundTag()));
            pokemon.setForm(toForm);
            Attack attack = specialMove = partner.is(PixelmonSpecies.SOLGALEO) ? new Attack(AttackRegistry.SUNSTEEL_STRIKE) : new Attack(AttackRegistry.MOONGEIST_BEAM);
            if (!pokemon.getMoveset().add(specialMove)) {
                LearnMoveController.sendLearnMove(player, pokemon.getUUID(), specialMove.getActualMove());
            }
        }
        return true;
    }
}

