/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.pokemon.ItemFormChangeEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayParticleSystemPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges.IFormChange;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;

public class KyuremFormChange
implements IFormChange {
    @Override
    public boolean isValidItem(ItemStack stack) {
        Item item = stack.m_41720_();
        return item == PixelmonItems.dna_splicers;
    }

    @Override
    public boolean isValidPokemon(PixelmonEntity pixelmon) {
        return pixelmon.isPokemon(PixelmonSpecies.KYUREM) && !pixelmon.isEvolving();
    }

    @Override
    public boolean execute(PixelmonEntity pixelmon, ItemStack stack, ServerPlayer player) {
        PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
        if (!pixelmon.getForm().isForm(PixelmonForms.NONE)) {
            ItemFormChangeEvent event;
            CompoundTag fusedPokemonNBT = pixelmon.getPokemon().getPersistentData().m_128469_("FusedPokemon");
            Pokemon fused = null;
            if (!fusedPokemonNBT.m_128456_()) {
                try {
                    fused = PokemonFactory.create(fusedPokemonNBT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (fused == null) {
                    Pixelmon.LOGGER.error("Couldn't get fused Pok\u00e9mon from NBT for player: " + player.m_7755_());
                }
            }
            if (Pixelmon.EVENT_BUS.post((Event)(event = new ItemFormChangeEvent(player, stack, pixelmon, fused)))) {
                return false;
            }
            if (fused != null) {
                storage.add(event.fusion);
            }
            pixelmon.getPersistentData().m_128473_("FusedPokemon");
            pixelmon.m_20193_().m_6263_(null, pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 0.1f);
            NetworkHelper.sendToDimension(new PlayParticleSystemPacket(ParticleSystems.DISCHARGE, pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), pixelmon.f_19853_, pixelmon.getPixelmonScale(), pixelmon.getPokemon().isPalette("shiny"), PixelmonSpecies.ZEKROM.getValueUnsafe().getName().equals(fusedPokemonNBT.m_128461_("Name")) ? 0.5 : 1.0, 0.5, PixelmonSpecies.ZEKROM.getValueUnsafe().getName().equals(fusedPokemonNBT.m_128461_("Name")) ? 1.0 : 0.5, 0.0), pixelmon.f_19853_);
            pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.FUSION_BOLT, new Attack(AttackRegistry.SCARY_FACE));
            pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.FUSION_FLARE, new Attack(AttackRegistry.SCARY_FACE));
            pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.FREEZE_SHOCK, new Attack(AttackRegistry.GLACIATE));
            pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.ICE_BURN, new Attack(AttackRegistry.GLACIATE));
            pixelmon.getPokemon().setForm(PixelmonForms.NONE);
        } else {
            Pokemon pokemon = storage.findOne(p -> !p.isEgg() && p.isPokemonOptional(PixelmonSpecies.RESHIRAM, PixelmonSpecies.ZEKROM));
            if (pokemon == null) {
                ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.RED, "pixelmon.interaction.kyurem.notfound", pixelmon.m_5446_());
                return true;
            }
            ItemFormChangeEvent event = new ItemFormChangeEvent(player, stack, pixelmon, pokemon);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            pixelmon.m_20193_().m_6263_(null, pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), SoundEvents.f_12558_, SoundSource.NEUTRAL, 0.3f, 0.2f);
            NetworkHelper.sendToDimension(new PlayParticleSystemPacket(ParticleSystems.RADIALTHUNDER, pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), pixelmon.f_19853_, pixelmon.getPixelmonScale(), pixelmon.getPokemon().isPalette("shiny"), pokemon.isPokemonOptional(PixelmonSpecies.ZEKROM) ? 0.5 : 1.0, 0.5, pokemon.isPokemonOptional(PixelmonSpecies.ZEKROM) ? 1.0 : 0.5), pixelmon.f_19853_);
            pokemon.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("FormChange"));
            storage.set((StoragePosition)pokemon.getStorageAndPosition().m_14419_(), null);
            CompoundTag pokenbt = new CompoundTag();
            pokemon.writeToNBT(pokenbt);
            pixelmon.getPokemon().getPersistentData().m_128365_("FusedPokemon", (Tag)pokenbt);
            if (pokemon.isPokemonOptional(PixelmonSpecies.ZEKROM)) {
                pixelmon.setForm("black");
                pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.SCARY_FACE, new Attack(AttackRegistry.FUSION_BOLT));
                pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.GLACIATE, new Attack(AttackRegistry.FREEZE_SHOCK));
            } else {
                pixelmon.setForm("white");
                pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.SCARY_FACE, new Attack(AttackRegistry.FUSION_FLARE));
                pixelmon.getPokemon().getMoveset().replaceMove(AttackRegistry.GLACIATE, new Attack(AttackRegistry.ICE_BURN));
            }
        }
        return true;
    }
}

