/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.pokemon.ItemFormChangeEvent;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges.IFormChange;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;

public class CalyrexFormChange
implements IFormChange {
    private static final String[] RIDER_MOVES = new String[]{"Glacial Lance", "Astral Barrage", "Tackle", "Tail Whip", "Double Kick", "Avalanche", "Hex", "Stomp", "Torment", "Confuse Ray", "Mist", "Haze", "Icicle Crash", "Shadow Ball", "Take Down", "Iron Defense", "Agility", "Thrash", "Taunt", "Disable", "Double-Edge", "Swords Dance", "Nasty Plot"};

    @Override
    public boolean isValidItem(ItemStack stack) {
        Item item = stack.m_41720_();
        return item == PixelmonItems.reins_of_unity;
    }

    @Override
    public boolean isValidPokemon(PixelmonEntity pixelmon) {
        return pixelmon.isPokemon(PixelmonSpecies.CALYREX.getValueUnsafe()) && !pixelmon.isEvolving();
    }

    @Override
    public boolean execute(PixelmonEntity pixelmon, ItemStack stack, ServerPlayer player) {
        PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
        if (!pixelmon.getForm().isForm(PixelmonForms.NONE)) {
            ItemFormChangeEvent event;
            CompoundTag fusedPokemonNBT = pixelmon.getPokemon().getPersistentData().m_128469_("FusedPokemon");
            Pokemon fused = null;
            if (!fusedPokemonNBT.m_128456_()) {
                try {
                    fused = PokemonFactory.create(fusedPokemonNBT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (fused == null) {
                    Pixelmon.LOGGER.error("Couldn't get fused Pok\u00e9mon from NBT for player: " + player.m_7755_());
                }
            }
            if (Pixelmon.EVENT_BUS.post((Event)(event = new ItemFormChangeEvent(player, stack, pixelmon, fused)))) {
                return false;
            }
            if (fused != null) {
                storage.add(event.fusion);
            }
            pixelmon.getPersistentData().m_128473_("FusedPokemon");
            pixelmon.m_20193_().m_6263_(null, pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), SoundEvents.f_12034_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            Moveset moveset = pixelmon.getPokemon().getMoveset();
            moveset.removeAttack(AttackRegistry.GLACIAL_LANCE, AttackRegistry.ASTRAL_BARRAGE, AttackRegistry.TACKLE, AttackRegistry.TAIL_WHIP, AttackRegistry.DOUBLE_KICK, AttackRegistry.AVALANCHE, AttackRegistry.HEX, AttackRegistry.STOMP, AttackRegistry.TORMENT, AttackRegistry.CONFUSE_RAY, AttackRegistry.MIST, AttackRegistry.HAZE, AttackRegistry.ICICLE_CRASH, AttackRegistry.SHADOW_BALL, AttackRegistry.TAKE_DOWN, AttackRegistry.IRON_DEFENSE, AttackRegistry.AGILITY, AttackRegistry.THRASH, AttackRegistry.TAUNT, AttackRegistry.DISABLE, AttackRegistry.DOUBLE_EDGE, AttackRegistry.SWORDS_DANCE, AttackRegistry.NASTY_PLOT);
            if (moveset.isEmpty()) {
                moveset.add(new Attack(AttackRegistry.CONFUSION));
            }
            pixelmon.getPokemon().setForm(PixelmonForms.NONE);
        } else {
            Attack specialMove;
            Pokemon pokemon = storage.findOne(p -> !p.isEgg() && p.isPokemonOptional(PixelmonSpecies.GLASTRIER, PixelmonSpecies.SPECTRIER));
            if (pokemon == null) {
                ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.RED, "pixelmon.interaction.calyrex.notfound", pixelmon.m_5446_());
                return true;
            }
            ItemFormChangeEvent event = new ItemFormChangeEvent(player, stack, pixelmon, pokemon);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            pixelmon.m_20193_().m_6263_(null, pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), SoundEvents.f_11972_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            pokemon.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("FormChange"));
            storage.set((StoragePosition)pokemon.getStorageAndPosition().m_14419_(), null);
            CompoundTag pokenbt = new CompoundTag();
            pokemon.writeToNBT(pokenbt);
            pixelmon.getPokemon().getPersistentData().m_128365_("FusedPokemon", (Tag)pokenbt);
            pixelmon.setForm(pokemon.getSpecies().is(PixelmonSpecies.GLASTRIER) ? "icerider" : "shadowrider");
            Attack attack = specialMove = pokemon.getSpecies().is(PixelmonSpecies.GLASTRIER) ? new Attack(AttackRegistry.GLACIAL_LANCE) : new Attack(AttackRegistry.ASTRAL_BARRAGE);
            if (!pixelmon.getPokemon().getMoveset().add(specialMove)) {
                LearnMoveController.sendLearnMove(player, pixelmon.getPokemon().getUUID(), specialMove.getActualMove());
            }
        }
        return true;
    }
}

