/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions;

import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.NuggetCondition;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class InteractionMeltanNuggets
implements IInteraction {
    @Override
    public boolean processInteract(PixelmonEntity pixelmon, Player player, InteractionHand hand, ItemStack itemstack) {
        if (!(player instanceof ServerPlayer) || pixelmon.m_269323_() != player || !pixelmon.isPokemon(PixelmonSpecies.MELTAN)) {
            return false;
        }
        Item item = itemstack.m_41720_();
        if (item != Items.f_42749_ && item != Items.f_42416_ && item != Items.f_41913_) {
            return false;
        }
        int required = pixelmon.getForm().getFirstEvolutionConditionOfType(NuggetCondition.class).map(nuggets -> nuggets.nuggets).orElse(-1);
        if (required > 0) {
            pixelmon.getPokemon().getExtraStats(MeltanStats.class).ifPresent(stats -> {
                boolean done = required <= stats.nuggetsFed;
                int result = 0;
                if (!done) {
                    result = stats.feed(itemstack, required);
                    if (!player.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                    pixelmon.f_19853_.m_5594_(null, pixelmon.m_20183_(), (SoundEvent)SoundRegistration.MELTAN_EAT.get(), SoundSource.NEUTRAL, 1.0f, RandomHelper.getRandom().nextFloat() + 1.0f);
                    pixelmon.getPokemon().markDirty(EnumUpdateType.Meltan_Stats);
                }
                if (result <= 0) {
                    player.m_213846_((Component)Component.m_237115_((String)"pixelmon.meltan.sated"));
                    while (result < 0) {
                        boolean ingot = result <= -9;
                        ItemStack stack = new ItemStack((ItemLike)(ingot ? Items.f_42416_ : Items.f_42749_));
                        if (!player.m_36356_(stack)) {
                            player.m_36176_(stack, true);
                        }
                        int refund = ingot ? 9 : 1;
                        result += refund;
                        stats.nuggetsFed -= refund;
                    }
                    pixelmon.getPokemon().markDirty(EnumUpdateType.Meltan_Stats);
                }
            });
            return true;
        }
        return false;
    }
}

