/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.pokemon.BottleCapEvent;
import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.items.EnumBottleCap;
import com.pixelmonmod.pixelmon.items.BottlecapItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;

public class InteractionBottleCap
implements IInteraction {
    @Override
    public boolean processInteract(PixelmonEntity pixelmon, Player player, InteractionHand hand, ItemStack itemstack) {
        boolean isHt;
        if (player.f_19853_.f_46443_ || hand == InteractionHand.OFF_HAND || !(itemstack.m_41720_() instanceof BottlecapItem)) {
            return false;
        }
        Pokemon data = pixelmon.getPokemon();
        if (data.getOwnerPlayer() != player) {
            return false;
        }
        if (data.getPokemonLevel() < PixelmonConfigProxy.getItems().getBottleCapLevel()) {
            ChatHandler.sendChat((Entity)player, "pixelmon.interaction.bottlecap.level", pixelmon.getNickname(), PixelmonConfigProxy.getItems().getBottleCapLevel());
            return true;
        }
        IVStore ivs = data.getIVs();
        boolean isMax = ivs.getStat(BattleStatsType.HP) + ivs.getStat(BattleStatsType.ATTACK) + ivs.getStat(BattleStatsType.DEFENSE) + ivs.getStat(BattleStatsType.SPECIAL_ATTACK) + ivs.getStat(BattleStatsType.SPECIAL_DEFENSE) + ivs.getStat(BattleStatsType.SPEED) == 186;
        boolean bl = isHt = ivs.isHyperTrained(BattleStatsType.HP) && ivs.isHyperTrained(BattleStatsType.ATTACK) && ivs.isHyperTrained(BattleStatsType.DEFENSE) && ivs.isHyperTrained(BattleStatsType.SPECIAL_ATTACK) && ivs.isHyperTrained(BattleStatsType.SPECIAL_DEFENSE) && ivs.isHyperTrained(BattleStatsType.SPEED);
        if (isMax || isHt) {
            ChatHandler.sendChat((Entity)player, "pixelmon.interaction.bottlecap.full", pixelmon.getNickname());
            return true;
        }
        BottlecapItem bottleCap = (BottlecapItem)itemstack.m_41720_();
        if (Pixelmon.EVENT_BUS.post((Event)new BottleCapEvent(pixelmon, player, bottleCap.type, itemstack))) {
            return false;
        }
        if (bottleCap.type == EnumBottleCap.GOLD) {
            ivs.setHyperTrained(null, true);
            data.getStats().setLevelStats(data.getNature(), data.getForm(), data.getPokemonLevel());
            data.markDirty(EnumUpdateType.HP, EnumUpdateType.Stats);
            ChatHandler.sendChat((Entity)player, "pixelmon.interaction.bottlecap.goldcap", pixelmon.getNickname());
            itemstack.m_41774_(1);
        } else {
            BattleStatsType[] types = BattleStatsType.getEVIVStatValues();
            int[] screenData = new int[types.length + 1];
            for (int i = 0; i < types.length; ++i) {
                screenData[i] = ivs.isHyperTrained(types[i]) || ivs.getStat(types[i]) == 31 ? 0 : InteractionBottleCap.getHTValue(types[i], data);
            }
            screenData[6] = pixelmon.m_19879_();
            OpenScreenPacket.open(player, EnumGuiScreen.BottleCap, screenData);
        }
        return true;
    }

    private static int getHTValue(BattleStatsType type, Pokemon pokemon) {
        IVStore store = pokemon.getIVs();
        boolean isHT = store.isHyperTrained(type);
        store.setHyperTrained(type, true);
        int stat = pokemon.getStats().calculateStat(type, pokemon.getNature(), pokemon.getForm(), pokemon.getPokemonLevel());
        store.setHyperTrained(type, isHT);
        return stat;
    }
}

