/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.helpers;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolvePokemonPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class EvolutionQueryList {
    public static final List<EvolutionQuery> queryList = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void declineQuery(ServerPlayer player, UUID pokemonUUID) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery query = queryList.get(i);
                if (!query.pokemonUUID.equals(pokemonUUID)) continue;
                if (query.player == player) {
                    query.decline();
                    queryList.remove(i);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acceptQuery(ServerPlayer player, UUID pokemonUUID) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery query = queryList.get(i);
                if (!query.pokemonUUID.equals(pokemonUUID)) continue;
                if (query.player == player) {
                    query.accept();
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EvolutionQuery get(Player player) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery q = queryList.get(i);
                if (q.player != player) continue;
                return q;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(Level world) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery q = queryList.get(i);
                q.tick(world);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spawnPokemon(ServerPlayer player, UUID pokemonUUID) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery query = queryList.get(i);
                if (!query.pokemonUUID.equals(pokemonUUID)) continue;
                PlayerPartyStorage party = StorageProxy.getPartyNow(player);
                PixelmonEntity pixelmon = party.find(pokemonUUID).getOrSpawnPixelmon((Entity)player);
                if (pixelmon == null || party.find(pokemonUUID).getPixelmonEntity() == null) {
                    return;
                }
                NetworkHelper.sendNearbyPacket(new EvolvePokemonPacket(pokemonUUID, EvolutionStage.Choice), new PacketDistributor.TargetPoint(pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_(), 60.0, pixelmon.m_9236_().m_46472_()));
                return;
            }
        }
    }
}

