/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.helpers;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.EvolveEvent;
import com.pixelmonmod.pixelmon.api.events.MegaEvolutionEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MirrorArmor;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Pressure;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.util.AirSaver;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolvePokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.OpenEvolutionGUIPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.items.heldItems.MegaStoneItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public class EvolutionQuery {
    Pokemon pokemon;
    Evolution evolution = null;
    PokemonSpecification newPokemon;
    public UUID pokemonUUID;
    boolean fromLevelUp;
    int level;
    public boolean battleEvolutionConcluded;
    Stats newForm;
    ServerPlayer player;
    boolean normalEvolution = true;
    EvolutionStage stage;
    private AirSaver airSaver;
    private String cause;
    int ticks = 0;

    public EvolutionQuery(Pokemon pokemon, Evolution evolution, String cause) {
        this.pokemon = pokemon;
        this.cause = cause;
        this.newPokemon = evolution.to.clone();
        this.pokemonUUID = pokemon.getUUID();
        this.evolution = evolution;
        this.level = pokemon.getPokemonLevel();
        this.fromLevelUp = evolution instanceof LevelingEvolution;
        if (pokemon.getOwnerPlayer() != null) {
            this.airSaver = new AirSaver(pokemon.getOwnerPlayer());
        }
        this.sendQuery();
        pokemon.getPixelmonEntity().ifPresent(pixelmonEntity -> pixelmonEntity.f_21345_.f_25345_.clear());
    }

    public EvolutionQuery(PixelmonEntity pixelmon, Evolution evolution, String cause) {
        this.pokemon = pixelmon.getPokemon();
        this.cause = cause;
        this.newPokemon = evolution.to.clone();
        this.pokemonUUID = pixelmon.getPokemon().getUUID();
        this.evolution = evolution;
        this.level = pixelmon.getLvl().getPokemonLevel();
        this.fromLevelUp = evolution instanceof LevelingEvolution;
        if (pixelmon.m_269323_() != null) {
            this.player = (ServerPlayer)pixelmon.m_269323_();
            this.airSaver = new AirSaver(this.player);
        }
        this.setStage(EvolutionStage.PreChoice);
        this.sendQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvolutionQuery(Pokemon pokemon, Stats form) {
        this.normalEvolution = false;
        this.pokemon = pokemon;
        this.pokemonUUID = pokemon.getUUID();
        this.fromLevelUp = false;
        this.newForm = form;
        if (pokemon.getOwnerPlayer() != null) {
            this.airSaver = new AirSaver(pokemon.getOwnerPlayer());
        }
        this.level = pokemon.getPokemonLevel();
        pokemon.getPixelmonEntity().ifPresent(pixelmonEntity -> pixelmonEntity.f_21345_.f_25345_.clear());
        this.setStage(EvolutionStage.PreAnimation);
        this.updateAllAround(this.stage);
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            EvolutionQueryList.queryList.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvolutionQuery(PixelmonEntity pixelmon, Stats form) {
        this.normalEvolution = false;
        this.pokemon = pixelmon.getPokemon();
        this.pokemonUUID = pixelmon.getPokemon().getUUID();
        this.fromLevelUp = false;
        this.newForm = form;
        if (pixelmon.m_269323_() != null) {
            this.player = (ServerPlayer)pixelmon.m_269323_();
            this.airSaver = new AirSaver(this.player);
        }
        this.level = pixelmon.getLvl().getPokemonLevel();
        pixelmon.f_21345_.f_25345_.clear();
        this.setStage(EvolutionStage.PreAnimation);
        this.updateAllAround(this.stage);
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            EvolutionQueryList.queryList.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tick(Level world) {
        if (this.pokemon == null) {
            return;
        }
        PixelmonEntity pixelmon = this.pokemon.getPixelmonEntity().orElse(null);
        if (this.airSaver != null) {
            this.airSaver.tick();
        }
        if (this.stage == EvolutionStage.Choice) {
            return;
        }
        ++this.ticks;
        if (this.stage == EvolutionStage.PreChoice) {
            if (this.ticks >= this.stage.ticks) {
                this.ticks = 0;
                this.setStage(EvolutionStage.Choice);
            }
        } else if (this.stage == EvolutionStage.PreAnimation) {
            if (this.ticks >= this.stage.ticks) {
                this.ticks = 0;
                this.setStage(EvolutionStage.PostAnimation);
                this.updateAllAround(this.stage);
                this.doEvoSwitch();
            }
        } else if (this.stage == EvolutionStage.PostAnimation && this.ticks >= this.stage.ticks) {
            this.ticks = 0;
            this.setStage(EvolutionStage.End);
            if (this.evolution != null) {
                this.evolution.finishedEvolving(this.pokemon);
            }
            if (pixelmon != null) {
                pixelmon.resetAI();
            }
            this.updateAllAround(this.stage);
            List<EvolutionQuery> list = EvolutionQueryList.queryList;
            synchronized (list) {
                EvolutionQueryList.queryList.remove(this);
            }
        }
    }

    private void setStage(EvolutionStage stage) {
        this.stage = stage;
        this.pokemon.getPixelmonEntity().ifPresent(pixelmonEntity -> pixelmonEntity.setEvoStage(stage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery() {
        if (this.pokemon.getOwnerPlayer() != null) {
            NetworkHelper.sendPacket(new OpenEvolutionGUIPacket(this.pokemonUUID, ((Species)((RegistryValue)this.newPokemon.getValue(SpeciesRequirement.class).get()).getValueUnsafe()).getName()), this.player);
            this.updateAllAround(this.stage);
            this.removeExisting();
            List<EvolutionQuery> list = EvolutionQueryList.queryList;
            synchronized (list) {
                EvolutionQueryList.queryList.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExisting() {
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            for (int i = 0; i < EvolutionQueryList.queryList.size(); ++i) {
                EvolutionQuery query = EvolutionQueryList.queryList.get(i);
                if (!query.pokemonUUID.equals(this.pokemonUUID)) continue;
                EvolutionQueryList.queryList.remove(i);
                break;
            }
        }
    }

    void accept() {
        this.setStage(EvolutionStage.PreAnimation);
        this.ticks = 0;
        this.updateAllAround(this.stage);
    }

    void doEvoSwitch() {
        if (this.normalEvolution) {
            if (!this.newPokemon.getValue(SpeciesRequirement.class).isPresent()) {
                return;
            }
            if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(this.player, this.pokemon, "Evolution"))) {
                return;
            }
            this.checkMagbyJump();
            this.pokemon.evolve(this.newPokemon);
            this.checkShedinja();
            this.checkForLearnMoves();
            this.checkForEvolutionMoves();
            this.checkCorvisquire();
            this.evolution.finishedEvolving(this.pokemon);
            Pixelmon.EVENT_BUS.post((Event)new EvolveEvent.Post(this.player, this.pokemon.getPixelmonEntity().orElse(null), this.evolution, this.cause));
        } else {
            boolean isUltraburst;
            boolean bl = isUltraburst = PixelmonWrapper.canUltraBurst(this.pokemon.getSpecies(), this.pokemon.getHeldItemAsItemHeld(), this.pokemon.getForm()) && this.newForm.isForm("ultra");
            if (!this.battleEvolutionConcluded) {
                MegaStoneItem megaStone;
                MegaStoneItem megaStoneItem = megaStone = this.pokemon.getHeldItemAsItemHeld() instanceof MegaStoneItem ? (MegaStoneItem)this.pokemon.getHeldItemAsItemHeld() : null;
                if (!isUltraburst && this.newForm == null && megaStone != null) {
                    this.newForm = this.pokemon.getSpecies().getForm(megaStone.getMegaForm());
                }
                if (this.pokemon.getForm() != this.newForm) {
                    this.pokemon.setForm(this.newForm);
                }
                this.pokemon.getPixelmonEntity().ifPresent(pixelmon -> {
                    pixelmon.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
                    if (pixelmon.battleController == null) {
                        pixelmon.resetAI();
                        pixelmon.setBlockTarget((int)pixelmon.m_20185_(), (int)pixelmon.m_20186_(), (int)pixelmon.m_20189_(), Direction.SOUTH, null);
                    }
                });
            }
            Pixelmon.EVENT_BUS.post((Event)new MegaEvolutionEvent.Post(this.player, this.pokemon, this.pokemon.getHeldItem(), isUltraburst));
        }
    }

    private void removeEntity() {
        this.pokemon.getPixelmonEntity().ifPresent(PixelmonEntity::unloadEntity);
    }

    void decline() {
        this.removeEntity();
    }

    private void checkCorvisquire() {
        if (this.pokemon.getSpecies().is(PixelmonSpecies.CORVISQUIRE)) {
            if (this.pokemon.hasHiddenAbility()) {
                this.pokemon.setAbility(new MirrorArmor());
            } else {
                this.pokemon.setAbility(new Pressure());
            }
        }
    }

    private void checkMagbyJump() {
        PokemonStorage party;
        if (this.pokemon.isPokemonOptional(PixelmonSpecies.MAGBY) && (party = this.pokemon.getStorage()) != null) {
            for (Pokemon poke : party.getAll()) {
                if (poke == null || !poke.getSpecies().is(PixelmonSpecies.SLUGMA) || poke.getForm().getName().isEmpty()) continue;
                this.pokemon.setForm(poke.getForm().getName());
                break;
            }
        }
    }

    private void checkShedinja() {
        PokemonStorage party;
        if (this.pokemon.getSpecies().is(PixelmonSpecies.NINJASK) && (party = (PokemonStorage)Objects.requireNonNull(this.pokemon.getStorageAndPosition()).m_14418_()).hasSpace()) {
            int slotMatchingUnusedItem;
            ServerPlayer player;
            ServerPlayer serverPlayer = player = party instanceof PlayerPartyStorage ? ((PlayerPartyStorage)party).getPlayer() : null;
            if (player != null && (slotMatchingUnusedItem = player.m_150109_().m_36043_(PokeBallRegistry.POKE_BALL.getValueUnsafe().getBallItem())) != -1 && !player.m_150109_().m_7407_(slotMatchingUnusedItem, 1).m_41619_()) {
                Pokemon shedinja = PokemonSpecificationProxy.create(PixelmonSpecies.SHEDINJA.getValueUnsafe().getName(), "lvl:" + this.pokemon.getPokemonLevel()).get().create();
                shedinja.getMoveset().clear();
                shedinja.getMoveset().addAll(this.pokemon.getMoveset());
                shedinja.setStatus((StatusPersist)this.pokemon.getStatus().copy());
                shedinja.setPalette(this.pokemon.getPalette());
                shedinja.setGrowth(this.pokemon.getGrowth());
                shedinja.setFriendship(this.pokemon.getFriendship());
                shedinja.setNature(this.pokemon.getNature());
                shedinja.setExperience(this.pokemon.getExperience());
                shedinja.getEVs().fillFromArray(this.pokemon.getEVs().getArray());
                shedinja.getIVs().copyIVs(this.pokemon.getIVs());
                shedinja.setOriginalTrainer(this.pokemon.getOriginalTrainerUUID(), this.pokemon.getOriginalTrainer());
                party.add(shedinja);
            }
        }
    }

    private void checkForLearnMoves() {
        int level = this.pokemon.getPokemonLevel();
        if (level == 1) {
            level = 0;
        }
        if (!this.pokemon.getForm().getMoves().getMovesAtLevel(level).isEmpty()) {
            List<ImmutableAttack> newAttacks = this.pokemon.getForm().getMoves().getMovesAtLevel(level);
            Moveset moveset = this.pokemon.getMoveset();
            newAttacks.stream().filter(a -> !moveset.hasAttack((ImmutableAttack)a)).forEach(a -> {
                if (moveset.size() >= 4) {
                    LearnMoveController.sendLearnMove(this.player, this.pokemon.getUUID(), a);
                } else {
                    moveset.add(a.ofMutable());
                    this.pokemon.getPixelmonEntity().ifPresent(pixelmonEntity -> pixelmonEntity.update(EnumUpdateType.Moveset));
                    if (BattleRegistry.getBattle((Player)this.pokemon.getOwnerPlayer()) != null) {
                        ChatHandler.sendBattleMessage((Entity)this.pokemon.getOwnerPlayer(), "pixelmon.stats.learnedmove", this.pokemon.getNickname(), a.getTranslatedName());
                    } else {
                        ChatHandler.sendChat((Entity)this.pokemon.getOwnerPlayer(), "pixelmon.stats.learnedmove", this.pokemon.getNickname(), a.getTranslatedName());
                    }
                }
            });
        }
    }

    public void checkForEvolutionMoves() {
        if (this.evolution.moves == null || this.evolution.moves.isEmpty()) {
            return;
        }
        ArrayList<ImmutableAttack> evoMoves = new ArrayList<ImmutableAttack>();
        for (String moveName : this.evolution.moves) {
            ImmutableAttack ab = AttackRegistry.getAttackBase(moveName).orElse(null);
            if (ab == null) {
                String name = this.evolution.to.getValue(SpeciesRequirement.class).isPresent() ? ((Species)((RegistryValue)this.evolution.to.getValue(SpeciesRequirement.class).get()).getValueUnsafe()).getName() : this.evolution.to.toString();
                Pixelmon.LOGGER.error("Unknown move in evolution. To: " + name + ". Move: " + moveName);
                continue;
            }
            evoMoves.add(ab);
            this.pokemon.getPixelmonEntity().ifPresent(pixelmon -> {
                if (!pixelmon.relearnableEvolutionMoves.contains(ab.getAttackName())) {
                    pixelmon.relearnableEvolutionMoves.add(ab.getAttackName());
                }
            });
        }
        this.pokemon.getPixelmonEntity().ifPresent(pixelmon -> pixelmon.update(EnumUpdateType.Moveset));
        for (ImmutableAttack ab : evoMoves) {
            Attack a = new Attack(ab);
            Moveset moveset = this.pokemon.getMoveset();
            if (moveset.hasAttack(a)) continue;
            if (moveset.size() >= 4) {
                LearnMoveController.sendLearnMove(this.player, this.pokemon.getUUID(), a.getActualMove());
                continue;
            }
            moveset.add(a);
            this.pokemon.getPixelmonEntity().ifPresent(pixelmonEntity -> pixelmonEntity.update(EnumUpdateType.Moveset));
            if (BattleRegistry.getBattle((Player)this.pokemon.getOwnerPlayer()) != null) {
                ChatHandler.sendBattleMessage((Entity)this.pokemon.getOwnerPlayer(), "pixelmon.stats.learnedmove", this.pokemon.getNickname(), a.getMove().getTranslatedName());
                continue;
            }
            ChatHandler.sendChat((Entity)this.pokemon.getOwnerPlayer(), "pixelmon.stats.learnedmove", this.pokemon.getNickname(), a.getMove().getTranslatedName());
        }
    }

    public boolean isEnded() {
        return this.stage == EvolutionStage.End;
    }

    private void updateAllAround(EvolutionStage currentStage) {
        Object owner = this.pokemon.getOwnerPlayer();
        if (owner == null) {
            owner = this.pokemon.getOrCreatePixelmon();
        }
        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 20.0, owner.m_20193_().m_46472_());
        NetworkHelper.sendNearbyPacket(new EvolvePokemonPacket(this.pokemonUUID, currentStage), point);
    }
}

