/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.drops;

import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.boss.DropSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class DroppedItem {
    public ItemStack item;
    public DropSet.Drop drop = null;
    public BossTier rarity = BossTierRegistry.NOT_BOSS;
    public int id;

    public DroppedItem(ItemStack item, int id) {
        this.item = item;
        this.id = id;
    }

    public DroppedItem(ItemStack item, int id, BossTier rarity) {
        this(item, id);
        this.rarity = rarity;
    }

    public DroppedItem(DropSet.Drop drop, int id) {
        this.drop = drop;
        this.id = id;
    }

    public DroppedItem(DropSet.Drop drop, int id, BossTier rarity) {
        this(drop, id);
        this.rarity = rarity;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.drop == null ? this.item : this.drop.getDisplayItem());
        buffer.m_130070_(this.rarity.getID());
        buffer.writeInt(this.id);
    }

    public static DroppedItem fromBytes(FriendlyByteBuf buffer) {
        ItemStack itemStack = buffer.m_130267_();
        BossTier rarity = BossTierRegistry.getBossTierOrNotBoss(buffer.m_130277_());
        int id = buffer.readInt();
        return new DroppedItem(itemStack, id, rarity);
    }
}

