/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelData;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelLocator;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimationSequence;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.UpdateClientEditingStatuePacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.AnimationVariables;
import com.pixelmonmod.pixelmon.enums.EnumBoundingBoxMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StatueEntity
extends AbstractClientEntity {
    public static final int parameterId = Pokemon.SYNC_POKEMON_BASE.getParameterId();
    public static final int parameterId2 = Pokemon.SYNC_GROWTH.getParameterId();
    public static final DataSync<StatueEntity, EnumBoundingBoxMode> SYNC_BOUND_MODE = new DataSync<StatueEntity, EnumBoundingBoxMode>(StatueEntity.class, PixelmonDataSerializers.BOUNDING_BOX_MODE, (statueEntity, enumBoundingBoxMode) -> {
        statueEntity.boundingMode = enumBoundingBoxMode;
        statueEntity.m_20011_(statueEntity.getForm().getDimensions().createBoundingBox((Entity)statueEntity, statueEntity.m_6134_()));
    });
    public static final DataSync<StatueEntity, String> SYNC_LABEL = new DataSync<StatueEntity, String>(StatueEntity.class, EntityDataSerializers.f_135030_, (statueEntity, s) -> {
        statueEntity.label = s;
    });
    public static final DataSync<StatueEntity, EnumStatueTextureType> SYNC_TEXTURES = new DataSync<StatueEntity, EnumStatueTextureType>(StatueEntity.class, PixelmonDataSerializers.STATUE_TEXTURE_TYPE, (statueEntity, s) -> {
        statueEntity.textureMode = s;
    });
    public static final DataSync<StatueEntity, AnimationType> SYNC_ANIMATION = new DataSync<StatueEntity, AnimationType>(StatueEntity.class, PixelmonDataSerializers.ANIMATION_TYPE, (statueEntity, s) -> {
        statueEntity.animation = s;
    });
    public static final DataSync<StatueEntity, Integer> SYNC_ANIMATION_FRAME = new DataSync<StatueEntity, Integer>(StatueEntity.class, EntityDataSerializers.f_135028_, (statueEntity, s) -> {
        statueEntity.animationFrame = s;
    });
    public static final DataSync<StatueEntity, Boolean> SYNC_IS_FLYING = new DataSync<StatueEntity, Boolean>(StatueEntity.class, EntityDataSerializers.f_135035_, (statueEntity, s) -> {
        statueEntity.isFlying = s;
    });
    public static final DataSync<StatueEntity, Boolean> SYNC_CAN_MOVE = new DataSync<StatueEntity, Boolean>(StatueEntity.class, EntityDataSerializers.f_135035_, (statueEntity, s) -> {
        statueEntity.canMove = s;
    });
    private EnumBoundingBoxMode boundingMode = EnumBoundingBoxMode.Solid;
    private String label = "";
    private EnumStatueTextureType textureMode = EnumStatueTextureType.OriginalTexture;
    private AnimationType animation = AnimationType.IDLE;
    private int animationFrame = 0;
    private boolean isFlying = false;
    private boolean canMove = false;
    private AnimationType lastAnimation = null;
    private int lastFrame = -1;
    private AnimationVariables animationVariables;
    private ResourceLocation lastTexture;
    private final boolean exists = true;

    public StatueEntity(EntityType<StatueEntity> type, Level world) {
        super((EntityType<? extends AbstractClientEntity>)type, world);
    }

    public StatueEntity(Level world) {
        this((EntityType<StatueEntity>)((EntityType)EntityRegistration.STATUE.get()), world);
        this.m_20242_(true);
    }

    @Override
    protected void m_8097_() {
        this.define(SYNC_LABEL, "");
        this.define(SYNC_TEXTURES, EnumStatueTextureType.OriginalTexture);
        this.define(SYNC_ANIMATION, AnimationType.IDLE);
        this.define(SYNC_ANIMATION_FRAME, 0);
        this.define(SYNC_IS_FLYING, false);
        this.define(SYNC_CAN_MOVE, false);
        super.m_8097_();
        this.define(SYNC_BOUND_MODE, EnumBoundingBoxMode.Solid);
    }

    public void m_8107_() {
    }

    public boolean m_21691_() {
        return false;
    }

    public boolean m_21525_() {
        return true;
    }

    protected void m_8024_() {
    }

    public boolean m_21515_() {
        return false;
    }

    @Override
    public void setPokemon(Pokemon pokemon) {
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)pokemon);
    }

    public void setPalette(String palette) {
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)new PokemonBase(this.getSpecies(), this.getForm(), this.getGenderProperties().getPalette(palette), this.getGender()));
    }

    protected void setPokemon(PokemonBase pokemon) {
        this.pokemon = pokemon.toPokemon();
        this.initAnimation();
    }

    public void setBoundingMode(EnumBoundingBoxMode boundingMode) {
        SYNC_BOUND_MODE.set((Entity)this, (Object)boundingMode);
    }

    public EnumBoundingBoxMode getBoundingMode() {
        return this.boundingMode;
    }

    public void setCanMove(boolean canMove) {
        SYNC_CAN_MOVE.set((Entity)this, (Object)canMove);
    }

    public boolean canMove() {
        return this.canMove;
    }

    public PokemonBase getPokemonBase() {
        return this.pokemon;
    }

    public void setSpecies(Species species) {
        this.setPokemon(new PokemonBase(species));
    }

    public void setSpecies(RegistryValue<Species> species) {
        species.ifInitialized(s -> this.setPokemon(new PokemonBase((Species)s)));
    }

    @Override
    public void resetDataWatchers() {
        super.resetDataWatchers();
        SYNC_BOUND_MODE.set((Entity)this, (Object)EnumBoundingBoxMode.Solid);
        SYNC_LABEL.set((Entity)this, (Object)"");
        SYNC_TEXTURES.set((Entity)this, (Object)EnumStatueTextureType.OriginalTexture);
        SYNC_ANIMATION.set((Entity)this, (Object)AnimationType.IDLE);
        SYNC_ANIMATION_FRAME.set((Entity)this, (Object)0);
        SYNC_IS_FLYING.set((Entity)this, (Object)false);
        SYNC_CAN_MOVE.set((Entity)this, (Object)false);
    }

    @Override
    public Species getSpecies() {
        return this.pokemon.getSpecies();
    }

    public void setForm(Stats form) {
        PaletteProperties palette;
        GenderProperties genderProperties = form.getGenderProperties(this.pokemon.getGender());
        if (genderProperties == null) {
            genderProperties = form.getDefaultGenderProperties();
        }
        if ((palette = genderProperties.getPalette(this.getPalette().getName())) == null) {
            palette = genderProperties.getDefaultPalette();
        }
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)new PokemonBase(this.pokemon.getSpecies(), form, palette, this.pokemon.getGender()));
    }

    @Override
    public Stats getForm() {
        if (this.pokemon.getForm() == null) {
            PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)new PokemonBase(this.getSpecies(), this.getSpecies().getDefaultForm(), this.getPalette(), this.getGender()));
        }
        return this.pokemon.getForm();
    }

    public void setGender(Gender gender) {
        PaletteProperties palette;
        GenderProperties genderProperties = this.getForm().getGenderProperties(gender);
        if (genderProperties == null) {
            genderProperties = this.getForm().getDefaultGenderProperties();
        }
        if ((palette = genderProperties.getPalette(this.getPalette().getName())) == null) {
            palette = genderProperties.getDefaultPalette();
        }
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)new PokemonBase(this.pokemon.getSpecies(), this.pokemon.getForm(), palette, gender));
    }

    public Gender getGender() {
        return this.pokemon.getGender();
    }

    public Stats getStats() {
        return null;
    }

    public void setGrowth(EnumGrowth growth) {
        Pokemon.SYNC_GROWTH.set((Entity)this, (Object)growth);
    }

    public EnumGrowth getGrowth() {
        return this.pokemon.getGrowth();
    }

    @Override
    public void setPixelmonScale(float scale) {
        AbstractBaseEntity.SYNC_SCALE.set((Entity)this, (Object)Float.valueOf(scale));
    }

    @Override
    public float getPixelmonScale() {
        return this.scale;
    }

    public void setLabel(String label) {
        SYNC_LABEL.set((Entity)this, (Object)label);
    }

    public String getLabel() {
        return this.label;
    }

    public void setTextureType(EnumStatueTextureType type) {
        SYNC_TEXTURES.set((Entity)this, (Object)type);
    }

    public EnumStatueTextureType getTextureType() {
        return this.textureMode;
    }

    @Override
    public void setAnimation(AnimationType animationType) {
        SYNC_ANIMATION.set((Entity)this, (Object)animationType);
    }

    public AnimationType getAnimation() {
        AnimationType animationType = this.animation;
        if (animationType == null) {
            animationType = AnimationType.IDLE;
            this.setAnimation(animationType);
        }
        return animationType;
    }

    public void setAnimationFrame(int animationFrame) {
        if (animationFrame < 0) {
            animationFrame = 0;
        }
        SYNC_ANIMATION_FRAME.set((Entity)this, (Object)animationFrame);
    }

    public int getAnimationFrame() {
        return this.animationFrame;
    }

    public Stats getBaseStats() {
        return this.pokemon.getForm();
    }

    @Override
    public Color getColor() {
        return this.textureMode.color;
    }

    @Override
    public float[] getRenderColor() {
        if (this.getColor() == null) {
            return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        }
        return new float[]{(float)this.getColor().getRed() / 255.0f, (float)this.getColor().getGreen() / 255.0f, (float)this.getColor().getBlue() / 255.0f, 1.0f};
    }

    @Override
    public void m_8119_() {
        this.m_20256_(Vec3.f_82478_);
        super.m_8119_();
        if (this.f_19797_ % 64 == 1) {
            this.m_6210_();
            this.updateSize();
        }
        if (this.pokemon == null) {
            return;
        }
        if (this.f_19853_.f_46443_ && (this.lastAnimation == null || this.lastFrame == -1 || this.lastFrame != this.getAnimationFrame() || !this.lastAnimation.equals((Object)this.getAnimation()))) {
            SmdAnimation theAnim;
            this.lastAnimation = this.getAnimation();
            this.lastFrame = this.getAnimationFrame();
            ValveStudioModel model = this.getModel()[0].getModel();
            if (model == null) {
                Pixelmon.LOGGER.error("Missing model for Statue Entity at " + this.m_20182_().toString() + " data: " + this.pokemon.toString());
                return;
            }
            model.setAnimation(this.getAnimation());
            SmdAnimation smdAnimation = theAnim = model.currentSequence == null ? null : model.currentSequence.current();
            if (theAnim == null || theAnim.totalFrames == 0) {
                return;
            }
            if (this.getAnimationFrame() >= theAnim.totalFrames) {
                this.setAnimationFrame(theAnim.totalFrames - 1);
            }
            theAnim.setCurrentFrame(this.getAnimationFrame());
            model.animate();
            this.updateSize();
        }
    }

    @Override
    public void m_6075_() {
        if (this.getPalette() == null) {
            return;
        }
        ModelLocator[] modelLocators = this.getPalette().getModelLocators();
        if (this.f_20903_ > 0 && !this.m_6109_()) {
            double d0 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
            double d1 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
            double d2 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
            double d3 = Mth.m_14175_((double)(this.f_20907_ - (double)this.f_19857_));
            this.f_19857_ = (float)((double)this.f_19857_ + d3 / (double)this.f_20903_);
            this.f_19858_ = (float)((double)this.f_19858_ + (this.f_20908_ - (double)this.f_19858_) / (double)this.f_20903_);
            --this.f_20903_;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.f_19857_, this.f_19858_);
        } else if (!this.m_21515_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.98, 0.98, 0.98));
        }
        if (this.canMove()) {
            if (Math.abs(this.m_20184_().m_7096_()) < 0.003) {
                this.m_20334_(0.0, this.m_20184_().m_7098_(), this.m_20184_().m_7094_());
            }
            if (Math.abs(this.m_20184_().m_7096_()) < 0.003) {
                this.m_20334_(this.m_20184_().m_7096_(), 0.0, this.m_20184_().m_7094_());
            }
            if (Math.abs(this.m_20184_().m_7094_()) < 0.003) {
                this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_(), 0.0);
            }
            this.f_19853_.m_46473_().m_6180_("travel");
            this.f_20900_ *= 0.98f;
            this.f_20902_ *= 0.98f;
            this.m_7023_(new Vec3((double)this.f_20900_, (double)this.f_20901_, (double)this.f_20902_));
            this.f_19853_.m_46473_().m_7238_();
        }
        if (this.boundingMode == EnumBoundingBoxMode.Pushout) {
            this.f_19853_.m_46473_().m_6180_("push");
            this.m_6138_();
            this.f_19853_.m_46473_().m_7238_();
        }
        this.f_20895_ = this.f_20894_;
        this.f_20884_ = this.f_20883_;
        this.f_20886_ = this.f_20885_;
        this.f_19859_ = this.f_19857_;
        this.f_19860_ = this.f_19858_;
        this.flyingDelayCounter = 0;
        for (int i = 0; i < modelLocators.length; ++i) {
            ModelLocator modelLocator = modelLocators[i];
            if (!modelLocator.getPredicate().shouldUseModel(this)) continue;
            if (this.getModelSlot() == i) break;
            this.setModelSlot(i);
            break;
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player instanceof ServerPlayer && !stack.m_41619_() && stack.m_41720_() == PixelmonItems.chisel) {
            NetworkHelper.sendPacket(new UpdateClientEditingStatuePacket(this.m_20148_()), (ServerPlayer)player);
            OpenScreenPacket.open(player, EnumGuiScreen.StatueEditor, this.m_19879_());
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.pokemon.writeToNBT(nbt);
        nbt.m_128359_("Variant", this.pokemon.getForm().getName());
        if (this.getGrowth() != null) {
            nbt.m_128344_("Growth", (byte)this.getGrowth().index);
        }
        nbt.m_128344_("BoundingBoxMode", (byte)this.boundingMode.ordinal());
        nbt.m_128359_("statueLabel", this.getLabel());
        nbt.m_128344_("statueTexture", (byte)this.getTextureType().ordinal());
        nbt.m_128359_("statueAnimation", this.getAnimation().toString().toLowerCase(Locale.ROOT));
        nbt.m_128405_("statueFrame", this.getAnimationFrame());
        nbt.m_128379_("Animate", this.isAnimated());
        nbt.m_128379_("statueModelType", !this.getIsFlying());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        Pokemon pokemon = PokemonFactory.create(nbt);
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)pokemon);
        if (nbt.m_128441_("Growth")) {
            this.setGrowth(EnumGrowth.getFromNBT(nbt));
        } else {
            this.setGrowth(null);
        }
        if (nbt.m_128441_("BoundingBoxMode")) {
            SYNC_BOUND_MODE.set((Entity)this, (Object)EnumBoundingBoxMode.values()[nbt.m_128445_("BoundingBoxMode")]);
        }
        if (nbt.m_128441_("statueLabel")) {
            this.setLabel(nbt.m_128461_("statueLabel"));
        }
        if (nbt.m_128441_("statueTexture")) {
            this.setTextureType(EnumStatueTextureType.getFromOrdinal(nbt.m_128445_("statueTexture")));
        }
        if (nbt.m_128441_("statueAnimation")) {
            this.setAnimation(AnimationType.getTypeFor(nbt.m_128461_("statueAnimation")));
            this.setAnimationFrame(nbt.m_128451_("statueFrame"));
            this.setIsFlying(!nbt.m_128471_("statueModelType"));
            this.setAnimated(nbt.m_128471_("Animate"));
        }
    }

    public Component m_5446_() {
        return Component.m_237113_((String)this.getSpecies().getLocalizedName());
    }

    @Override
    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    @Override
    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_5829_() {
        return this.boundingMode == EnumBoundingBoxMode.Solid;
    }

    @Override
    public boolean m_6094_() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source == this.m_269291_().m_269341_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PixelmonItems.chisel);
    }

    @Override
    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        this.updateSize();
    }

    @Override
    public float m_20236_(Pose p_213307_1_) {
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        float scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
        Dimensions data = this.getBaseStats().getDimensions();
        return data.getEyeHeight() * scale;
    }

    @Override
    public void updateSize() {
        if (this.pokemon == null || this.getBaseStats() == null) {
            return;
        }
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        float scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
        Dimensions data = this.getBaseStats().getDimensions();
        this.setDimensions(new EntityDimensions((float)(data.getHeight() * (double)scale), (float)(data.getWidth() * (double)scale), false));
        this.m_20011_(data.createBoundingBox((Entity)this, scale));
        this.f_19816_ = this.getGrowth() != null ? data.getEyeHeight() * this.getGrowth().scaleValue : data.getEyeHeight();
    }

    @Override
    public float getScaleFactor() {
        if (this.getGrowth() == null) {
            return 1.0f;
        }
        return (float)Math.pow(this.getGrowth().scaleValue, PixelmonConfigProxy.getGeneral().getGrowthScaleModifier());
    }

    @Override
    public AnimationType getCurrentAnimation() {
        return this.getAnimation();
    }

    @Override
    public void initAnimation() {
        if (this.f_19853_.f_46443_) {
            for (ModelData modelData : this.getModel()) {
                modelData.getModel().animate();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFrameCount() {
        ModelData model = this.getModel()[0];
        model.getModel().setAnimation(this.getAnimation());
        SmdAnimationSequence sequence = model.getModel().currentSequence;
        return sequence == null || sequence.current() == null ? 0 : sequence.current().totalFrames;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AnimationType nextAnimation() {
        AnimationType animation = this.getAnimation();
        Iterator<Map.Entry<AnimationType, SmdAnimationSequence>> it = this.getModel()[0].getModel().anims.entrySet().iterator();
        AnimationType first = null;
        boolean takeNext = false;
        while (it.hasNext()) {
            Map.Entry<AnimationType, SmdAnimationSequence> entry = it.next();
            AnimationType key = entry.getKey();
            if (first == null) {
                first = key;
            }
            if (takeNext) {
                return key;
            }
            if (!key.equals((Object)animation)) continue;
            takeNext = true;
        }
        return first;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<AnimationType> getAllAnimations() {
        ArrayList animationTypes = Lists.newArrayList();
        for (ModelData modelData : this.getModel()) {
            animationTypes.addAll(modelData.getModel().anims.keySet());
        }
        return animationTypes;
    }

    @Override
    public AnimationVariables getAnimationVariables() {
        if (this.animationVariables == null) {
            this.animationVariables = new AnimationVariables();
        }
        return this.animationVariables;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ModelData[] getModel() {
        if (this.getPalette() == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getModel(this);
        }
        if (this.getPalette().getModel(this) == null || this.getPalette().getModel(this) == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getModel(this);
        }
        return this.getPalette().getModel(this);
    }

    public void setIsFlying(boolean isFlying) {
        SYNC_IS_FLYING.set((Entity)this, (Object)isFlying);
    }

    public boolean getIsFlying() {
        return this.isFlying;
    }
}

