/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.entity.ticking.EntityTicker;
import com.pixelmonmod.pixelmon.api.entity.ticking.TickingEntityFactory;
import com.pixelmonmod.pixelmon.api.events.PixelmonUpdateEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonRetrievedEvent;
import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.ControlledMovementLogic;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.InteractEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.TickingEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.TradeEvolution;
import com.pixelmonmod.pixelmon.api.registries.PixelmonEggGroups;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.blocks.tileentity.PixelmonSpawnerTileEntity;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.shader.ShaderParameters;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LensInfoPacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHoldsItemsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;

public class PixelmonEntity
extends AbstractHoldsItemsEntity {
    public int legendaryTicks = -1;
    public int despawnCounter = -1;
    public static int TICKSPERSECOND = 20;
    public static int intMinTicksToDespawn = 15 * TICKSPERSECOND;
    public static int intMaxTicksToDespawn = 180 * TICKSPERSECOND;
    private LensInfoPacket info = null;
    public boolean grounded = false;
    private float flyPower = 0.0f;
    private int flyingCharges = -100;
    private int hoverTicks = 0;
    private int movementTick = 0;
    private int lastJump = -1;
    private MobCategory spawnReplaceClassification = null;
    private Stats priorForm;
    public static ArrayList<IInteraction> interactionList = new ArrayList();
    int despawnTick = 0;
    public boolean canMove = true;
    public boolean stopRender = false;
    public PixelmonSpawnerTileEntity spawner = null;
    public ArrayList<UUID> cameraCapturedPlayers = new ArrayList();

    public PixelmonEntity(EntityType<PixelmonEntity> type, Level world) {
        super((EntityType<? extends AbstractHoldsItemsEntity>)type, world);
    }

    public PixelmonEntity(Level world, Pokemon pokemon) {
        this((EntityType<PixelmonEntity>)((EntityType)EntityRegistration.PIXELMON.get()), world);
        this.setPokemon(pokemon);
        if (world != null && world.f_46443_) {
            PixelmonEntity.m_20103_((double)PixelmonConfigProxy.getGraphics().getRenderDistanceWeight());
        }
        this.m_21573_().m_7008_(false);
        if (world != null) {
            pokemon.updateDimensionAndEntityID((ResourceKey<Level>)world.m_46472_(), this.m_19879_());
        }
    }

    public int getMovementTick() {
        return this.movementTick;
    }

    public MobCategory getSpawnReplaceClassification() {
        return this.spawnReplaceClassification;
    }

    public void setSpawnReplaceClassification(MobCategory type) {
        this.spawnReplaceClassification = type;
    }

    public Vec3 m_20994_(double p_233626_1_, boolean p_233626_3_, Vec3 p_233626_4_) {
        return Vec3.f_82478_;
    }

    public boolean m_6072_() {
        return false;
    }

    public PixelmonEntity(Level world, CompoundTag nbt) {
        this(world, PokemonFactory.create(nbt));
        this.getPokemon().updateDimensionAndEntityID((ResourceKey<Level>)world.m_46472_(), this.m_19879_());
        this.deserializeNBT(nbt);
    }

    public void m_7888_(int power) {
        if (this.pokemon.getForm().getMovement().canFly()) {
            ControlledMovementLogic mountedFlyingParameters = this.getPokemon().getForm().getMovement().getMountedFlyingParameters();
            if (mountedFlyingParameters != null) {
                mountedFlyingParameters.handleRiderJump(this, (Player)this.m_6688_(), power);
            }
        } else {
            super.m_7888_(power);
        }
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        if (this.spawnReplaceClassification != null) {
            return this.spawnReplaceClassification;
        }
        if (this.getSpawnLocation() == SpawnLocationType.WATER) {
            return MobCategory.WATER_CREATURE;
        }
        return MobCategory.CREATURE;
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        for (EntityTicker ticker : TickingEntityFactory.getTickers()) {
            if (!ticker.applies(this)) continue;
            ticker.tick(this);
        }
        if (this.m_6688_() != null) {
            if (this.isFlying() && !this.m_6688_().m_6047_()) {
                ++this.movementTick;
                this.m_20242_(true);
                ControlledMovementLogic mountedFlyingParameters = this.getPokemon().getForm().getMovement().getMountedFlyingParameters();
                if (mountedFlyingParameters != null) {
                    mountedFlyingParameters.handleMovementLogic(this, (Player)this.m_6688_());
                }
            }
            if (this.m_20069_()) {
                if (!this.canSurf() && !this.m_9236_().f_46443_) {
                    this.m_6688_().m_6038_();
                } else if (!this.m_6688_().m_6047_()) {
                    LivingEntity controllingPassenger = this.m_6688_();
                    Vec3 lookAngle = controllingPassenger.m_20154_();
                    controllingPassenger.m_20301_(300);
                    if (this.m_5842_() || lookAngle.f_82480_ < -0.3) {
                        this.m_20256_(this.m_20184_().m_82549_(new Vec3(0.0, lookAngle.m_7098_(), 0.0)));
                    }
                }
            }
        }
    }

    @Override
    public void onLanding() {
        super.onLanding();
        this.hoverTicks = 0;
        this.resetAI();
        this.setAnimation(AnimationType.IDLE);
        this.setFlying(false);
        this.m_20242_(false);
    }

    public boolean m_275843_() {
        return this.canSurf();
    }

    @Override
    public void m_6667_(DamageSource cause) {
        if (!this.m_9236_().f_46443_) {
            super.m_6667_(cause);
            if (this.m_269323_() != null) {
                this.m_21153_(0.0f);
                this.retrieve("Fainted");
            } else {
                if (cause.m_7639_() instanceof ServerPlayer && PixelmonConfigProxy.getGeneral().isCanPokemonBeHit()) {
                    List<ItemStack> items = DropItemRegistry.getDropsForPokemon(this);
                    for (ItemStack stack : items) {
                        DropItemHelper.dropItemOnGround(this.m_20182_(), (ServerPlayer)cause.m_7639_(), stack, false, false);
                    }
                }
                this.m_6089_();
            }
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer && hand == InteractionHand.MAIN_HAND) {
            ItemStack itemstack = player.m_21120_(hand);
            for (IInteraction i : interactionList) {
                if (!itemstack.m_41619_() && player.m_36335_().m_41519_(itemstack.m_41720_())) {
                    return InteractionResult.SUCCESS;
                }
                if (!i.processOnEmptyHand(this, player, hand, itemstack) && itemstack.m_41619_() || !i.processInteract(this, player, hand, itemstack)) continue;
                if (!itemstack.m_41619_()) {
                    player.m_36335_().m_41524_(itemstack.m_41720_(), 20);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void retrieve(String pokemonRetrievedEventReason) {
        if (this.battleController == null) {
            if (this.priorForm != null) {
                this.setForm(this.priorForm);
                this.priorForm = null;
            } else if (this.getForm().isTemporary()) {
                if (this.getForm().hasTag("galarian")) {
                    this.setForm(this.getPokemon().getSpecies().getForm("galarian"));
                } else if (this.getPokemon().getPersistentData().m_128441_("SrcForm")) {
                    this.setForm(this.getPokemon().getPersistentData().m_128461_("SrcForm"));
                } else {
                    this.setForm(this.getPokemon().getSpecies().getDefaultForm());
                }
            }
        }
        Pixelmon.EVENT_BUS.post((Event)new PokemonRetrievedEvent.Pre(this.m_269323_(), this.getPokemon(), pokemonRetrievedEventReason));
        this.unloadEntity();
        Pixelmon.EVENT_BUS.post((Event)new PokemonRetrievedEvent.Post(this.m_269323_(), this.getPokemon(), pokemonRetrievedEventReason));
    }

    public void releaseFromPokeball() {
        if (this.hasOwner()) {
            this.aggression = Aggression.PASSIVE;
        }
        this.m_6089_();
        try {
            this.f_19853_.m_7967_((Entity)this);
            if (this.pokemon != null) {
                this.pokemon.updateDimensionAndEntityID((ResourceKey<Level>)this.m_20193_().m_46472_(), this.m_19879_());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void clearAttackTarget() {
        this.m_6703_(null);
        this.m_6710_(null);
    }

    public void setPriorForm(Stats form) {
        this.priorForm = form;
    }

    public boolean m_5545_(LevelAccessor p_213380_1_, MobSpawnType p_213380_2_) {
        AABB aabb = this.m_20191_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int x = (int)Math.floor(aabb.f_82288_);
        while ((double)x < Math.ceil(aabb.f_82291_)) {
            int y = (int)Math.floor(aabb.f_82289_);
            while ((double)y < Math.ceil(aabb.f_82292_)) {
                int z = (int)Math.floor(aabb.f_82290_);
                while ((double)z < Math.ceil(aabb.f_82293_)) {
                    if (this.f_19853_.m_8055_((BlockPos)pos.m_122178_(x, y, z)).m_280296_()) {
                        return false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (this.getSpawnLocation() == SpawnLocationType.WATER) {
            int wDepth = WorldHelper.getWaterDepth(this.m_20183_(), this.f_19853_);
            if (wDepth > this.getSwimmingParameters().getDepthRangeStart() && wDepth < this.getSwimmingParameters().getDepthRangeEnd()) {
                return true;
            }
            double prevPosY = this.m_20186_();
            EntityHelper.setPosition((Entity)this, EnumRotation.y, this.m_20186_() - (double)(this.getSwimmingParameters().getDepthRangeStart() + this.f_19796_.m_188503_(this.getSwimmingParameters().getDepthRangeEnd() - this.getSwimmingParameters().getDepthRangeStart())));
            wDepth = WorldHelper.getWaterDepth(this.m_20183_(), this.f_19853_);
            if (wDepth > this.getSwimmingParameters().getDepthRangeStart() && wDepth < this.getSwimmingParameters().getDepthRangeEnd()) {
                EntityHelper.setPosition((Entity)this, EnumRotation.y, prevPosY);
                return false;
            }
            return true;
        }
        return true;
    }

    public void m_6119_() {
    }

    @Override
    public boolean m_6785_(double p_213397_1_) {
        return this.legendaryTicks <= 0 && super.m_6785_(p_213397_1_);
    }

    @Override
    public LivingEntity m_269323_() {
        if (!this.hasOwner()) {
            return null;
        }
        UUID trainerUUID = this.pokemon.getOwnerTrainerUUID();
        if (trainerUUID != null) {
            if (this.m_9236_() instanceof ServerLevel) {
                return (LivingEntity)CollectionHelper.find(((ServerLevel)this.m_9236_()).m_142646_().m_142273_(), e -> e.m_20148_().equals(trainerUUID));
            }
            if (this.m_9236_() instanceof ClientLevel) {
                return (LivingEntity)CollectionHelper.find(Lists.newArrayList((Iterable)((ClientLevel)this.m_9236_()).m_104735_()), e -> e.m_20148_().equals(trainerUUID));
            }
        }
        return super.m_269323_();
    }

    @Override
    public void m_8119_() {
        if (this.pokemon == null) {
            return;
        }
        this.m_9236_().m_46473_().m_6180_("pixelmon");
        if (!this.m_9236_().f_46443_ && this.pokemon == null) {
            this.m_6089_();
            return;
        }
        if (Pixelmon.freeze) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PixelmonUpdateEvent(this, TickEvent.Phase.START))) {
            return;
        }
        if (this.m_20186_() < (double)this.m_9236_().m_6042_().f_156647_() && !this.m_9236_().f_46443_) {
            if (this.battleController == null) {
                this.m_6089_();
            } else {
                EntityHelper.setPosition((Entity)this, EnumRotation.y, 0.0);
                this.m_20256_(Vec3.f_82478_);
            }
        }
        if (this.pokemon.getStorage() instanceof TrainerPartyStorage && this.pokemon.getOwnerTrainer() != null && this.pokemon.getOwnerTrainer().battleController == null && (this.battleController == null || this.battleController.battleEnded)) {
            this.m_6089_();
        }
        if ((this.pokemon.getStorage() != null || this.pokemon.getOriginalTrainerUUID() != null) && this.pokemon.getEntityID() == -1) {
            this.m_6089_();
        }
        if (this.canDespawn && !this.f_19853_.f_46443_) {
            this.updateDespawn();
        }
        if (this.pokemon.getOwnerPlayerUUID() != null && (this.pokemon.getOwnerPlayer() == null || this.pokemon.getOwnerPlayer().m_9236_().m_46472_() != this.m_20193_().m_46472_()) || this.pokemon.getOwnerTrainerUUID() != null && this.pokemon.getOwnerTrainer() == null) {
            this.retrieve("Forced");
        }
        this.animateDynamax();
        super.m_8119_();
        this.floatEntity();
        if (!this.f_19853_.f_46443_ && this.f_19797_ % 100 == 1 && !this.isEvolving() && this.m_269323_() instanceof Player) {
            this.testTickingEvolution();
        }
        Pixelmon.EVENT_BUS.post((Event)new PixelmonUpdateEvent(this, TickEvent.Phase.END));
        this.f_19853_.m_46473_().m_7238_();
        this.f_20895_ = this.f_20894_;
        this.f_20884_ = this.f_20883_;
        this.f_20886_ = this.f_20885_;
        this.f_19859_ = this.f_19857_;
        this.f_19860_ = this.m_146909_();
    }

    public void updateDespawn() {
        this.despawnTick = (this.despawnTick + 1) % 60;
        if (this.despawnTick == 0) {
            if (this.legendaryTicks > 0 || this.battleController != null && this.battleController.containsParticipantType(PlayerParticipant.class) || this.m_269323_() != null) {
                return;
            }
            if (!this.playersNearby() || this.despawnCounter == 0) {
                if (this.battleController != null) {
                    if (this.battleController.playerNumber != 0) {
                        return;
                    }
                    this.battleController.endBattle(BattleEndCause.FORCE);
                }
                this.m_6089_();
            } else {
                this.despawnCounter = (int)(Math.random() * (double)(intMaxTicksToDespawn - intMinTicksToDespawn) + (double)intMinTicksToDespawn);
            }
        }
        this.checkForRarityDespawn();
        if (this.legendaryTicks >= 0 && this.battleController == null) {
            --this.legendaryTicks;
            if (this.legendaryTicks == 0 && this.canDespawn) {
                this.m_6089_();
            }
        }
    }

    @Override
    public void m_6089_() {
        if (this.battleController == null) {
            if (this.priorForm != null) {
                this.setForm(this.priorForm);
                this.priorForm = null;
            } else if (this.getForm() != null && this.getForm().isTemporary()) {
                this.setForm(this.getSpecies().getDefaultForm());
            }
        }
        super.m_6089_();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_286979_)) {
            this.m_21153_(0.0f);
            return true;
        }
        if (!source.m_269533_(TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)ResourceLocationHelper.of("pixelmon", "battle"))) && !source.m_19385_().equals(this.m_269291_().m_269341_().m_19385_())) {
            if (source.m_7640_() == null || source.m_7640_() == source.m_7639_()) {
                if (source.m_7639_() instanceof ServerPlayer) {
                    this.onAttackedByPlayer((ServerPlayer)source.m_7639_());
                }
            } else if (source.m_19385_().equalsIgnoreCase("thrown") && source.m_7639_() instanceof ServerPlayer) {
                this.m_6710_((LivingEntity)((ServerPlayer)source.m_7639_()));
            }
            Stats baseStats = this.getForm();
            boolean waterSpawn = false;
            for (SpawnLocationType slt : baseStats.getSpawn().getSpawnLocations()) {
                if (slt != SpawnLocationType.WATER) continue;
                waterSpawn = true;
                break;
            }
            if (this.getPokemon().isPokemonOptional(PixelmonSpecies.UXIE, PixelmonSpecies.MESPRIT, PixelmonSpecies.AZELF)) {
                waterSpawn = true;
            }
            if (this.getPokemon().isPalette("drowned")) {
                waterSpawn = true;
            }
            List<Element> typeList = baseStats.getTypes();
            if (this.m_5825_() && source.m_269533_(DamageTypeTags.f_268745_)) {
                return false;
            }
            if (typeList.contains(Element.FIRE) && source.m_269533_(DamageTypeTags.f_268745_)) {
                return false;
            }
            if (typeList.contains(Element.GHOST) && source != this.m_269291_().m_269425_()) {
                return false;
            }
            if ((typeList.contains(Element.ICE) || typeList.contains(Element.GHOST)) && source.m_269533_(DamageTypeTags.f_268419_)) {
                return false;
            }
            if (typeList.contains(Element.ELECTRIC) && source.m_19385_().equals(this.m_269291_().m_269548_().m_19385_())) {
                this.m_5634_(amount);
                return false;
            }
            if ((typeList.contains(Element.WATER) || baseStats.getEggGroups().contains(PixelmonEggGroups.WATER_ONE) || baseStats.getEggGroups().contains(PixelmonEggGroups.WATER_TWO) || baseStats.getEggGroups().contains(PixelmonEggGroups.WATER_THREE) || waterSpawn || baseStats.getMovement().getSwimmingParameters() != null && baseStats.getMovement().getSwimmingParameters().getDepthRangeEnd() > 2) && source == this.m_269291_().m_269063_()) {
                return false;
            }
            if ((typeList.contains(Element.STEEL) || baseStats.getEggGroups().contains(PixelmonEggGroups.MINERAL)) && source == this.m_269291_().m_269425_()) {
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    private void onAttackedByPlayer(ServerPlayer player) {
        int knockback;
        if (this.battleController == null && !this.hasOwner() && player.m_21205_().m_41720_() == Items.f_42398_ && (knockback = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)player.m_21205_())) > 0) {
            if (!player.m_7500_() && RandomHelper.getRandomChance(40)) {
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 0.8f, 0.8f + RandomHelper.getRandom().nextFloat() * 0.4f);
                player.m_21205_().m_41774_(1);
            } else {
                this.m_20334_(player.m_20154_().f_82479_ * (double)knockback, 0.3 * (double)knockback, player.m_20154_().f_82481_ * (double)knockback);
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12314_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.m_6703_((LivingEntity)player);
            }
        }
    }

    private void checkForRarityDespawn() {
        if (this.legendaryTicks > 0 || this.battleController != null && this.battleController.containsParticipantType(PlayerParticipant.class) || this.m_269323_() != null) {
            return;
        }
        if (this.despawnCounter > 0) {
            --this.despawnCounter;
        } else if (this.despawnCounter == 0) {
            if (!this.playersNearby()) {
                if (this.battleController != null) {
                    this.battleController.endBattle(BattleEndCause.FORCE);
                }
                this.m_6089_();
            }
        } else {
            this.despawnCounter = (int)(Math.random() * (double)(intMaxTicksToDespawn - intMinTicksToDespawn) + (double)intMinTicksToDespawn);
        }
    }

    private boolean playersNearby() {
        for (int i = 0; i < this.f_19853_.m_6907_().size(); ++i) {
            double distancez;
            double distancey;
            Player player = (Player)this.f_19853_.m_6907_().get(i);
            double distancex = player.m_20185_() - this.m_20185_();
            double distancesquared = distancex * distancex + (distancey = player.m_20186_() - this.m_20186_()) * distancey + (distancez = player.m_20189_() - this.m_20189_()) * distancez;
            if (!(distancesquared < (double)(PixelmonConfigProxy.getSpawning().getDespawnRadius() * PixelmonConfigProxy.getSpawning().getDespawnRadius()))) continue;
            return true;
        }
        return false;
    }

    private boolean shouldSave() {
        return this.m_6084_() && this.pokemon != null && !this.isRaidPokemon() && this.pokemon.getStorage() == null && (super.m_21532_() || PixelmonConfigProxy.getStorage().isWriteEntitiesToWorld());
    }

    public boolean m_20223_(CompoundTag p_70039_1_) {
        return this.shouldSave() && super.m_20223_(p_70039_1_);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.getSpawnLocation() == null) {
            this.setSpawnLocation(SpawnLocationType.LAND);
        }
        nbt.m_128344_("pixelmonType", (byte)this.getSpawnLocation().ordinal());
        if (this.legendaryTicks > 0) {
            nbt.m_128405_("legendaryTicks", this.legendaryTicks);
            nbt.m_128356_("legendaryTime", this.f_19853_.m_46467_());
        }
        nbt.m_128359_("BossTier", this.getBossTier().getID());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        float h = this.m_21223_();
        this.m_21153_(h);
        if (nbt.m_128441_("pixelmonType")) {
            this.setSpawnLocation(SpawnLocationType.getFromIndex(nbt.m_128445_("pixelmonType")));
        } else if (this.getForm().getSpawn().getSpawnLocations()[0] == SpawnLocationType.LAND) {
            this.setSpawnLocation(SpawnLocationType.LAND);
        } else {
            this.setSpawnLocation(SpawnLocationType.WATER);
        }
        this.resetAI();
        if (nbt.m_128441_("legendaryTicks")) {
            this.legendaryTicks = nbt.m_128451_("legendaryTicks");
            long lastTime = nbt.m_128454_("legendaryTime");
            this.legendaryTicks -= (int)(this.f_19853_.m_46467_() - lastTime);
            if (this.legendaryTicks <= 0) {
                this.m_6089_();
            }
        }
        if (nbt.m_128441_("BossTier")) {
            this.setBossTier(BossTierRegistry.getBossTierOrNotBoss(nbt.m_128461_("BossTier")));
        }
    }

    @Override
    public void unloadEntity() {
        super.unloadEntity();
        this.m_142687_(Entity.RemovalReason.UNLOADED_TO_CHUNK);
        this.clearAttackTarget();
        if (this.pokemon != null) {
            this.pokemon.updateDimensionAndEntityID((ResourceKey<Level>)Level.f_46428_, -1);
        }
    }

    public void startEvolution(Evolution evolution, String cause) {
        if (this.m_21223_() < 1.0f) {
            return;
        }
        this.setShaderParameters(ShaderParameters.builder().id(ResourceLocationHelper.of("pixelmon", "rendertype_entity_smooth_cutout_fresnel")).noTexture().onlyShader().withParameter("FresnelBias", Codec.FLOAT, Float.valueOf(0.35f)).withParameter("FresnelScale", Codec.FLOAT, Float.valueOf(20.0f)).withParameter("FresnelPower", Codec.FLOAT, Float.valueOf(0.85f)).withParameter("FresnelColor", Codec.FLOAT.listOf(), List.of(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f))).renderColor(new Color(1.0f, 1.0f, 1.0f, 1.0f)).build());
        StorageProxy.getPartyNow((ServerPlayer)((ServerPlayer)this.m_269323_())).guiOpened = true;
        new EvolutionQuery(this, evolution, cause);
    }

    public boolean isLoaded() {
        return this.isLoaded(false);
    }

    public boolean isLoaded(boolean checkChunk) {
        boolean isLoaded = true;
        if (checkChunk) {
            isLoaded = this.f_19853_.isAreaLoaded(this.m_20183_(), 1);
        }
        if (isLoaded) {
            isLoaded = this.f_19853_.m_6815_(this.m_19879_()) != null;
        }
        return isLoaded;
    }

    public boolean isRaidPokemon() {
        return this.getPixelmonWrapper() != null && this.getPixelmonWrapper().isRaidPokemon();
    }

    public boolean testTradeEvolution(Species with) {
        if (this.getPokemon().getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.everStone) {
            return false;
        }
        ArrayList<TradeEvolution> tradeEvolutions = this.getPokemon().getEvolutions(TradeEvolution.class);
        for (TradeEvolution evo : tradeEvolutions) {
            if (!evo.canEvolve(this, with)) continue;
            return evo.doEvolution(this, "TradeMachine");
        }
        return false;
    }

    public boolean testLevelEvolution(int level) {
        if (this.getPokemon().getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.everStone) {
            return false;
        }
        ArrayList<LevelingEvolution> levelingEvolutions = this.getPokemon().getEvolutions(LevelingEvolution.class);
        for (LevelingEvolution evo : levelingEvolutions) {
            if (!evo.canEvolve(this, level)) continue;
            return evo.doEvolution(this, "Levelling");
        }
        return false;
    }

    public boolean testInteractEvolution(ItemStack stack) {
        if (this.getPokemon().getHeldItemAsItemHeld() != null && this.getPokemon().getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.everStone) {
            return false;
        }
        ArrayList<InteractEvolution> interactingEvolutions = this.getPokemon().getEvolutions(InteractEvolution.class);
        for (InteractEvolution evo : interactingEvolutions) {
            if (!evo.canEvolve(this, stack)) continue;
            return evo.doEvolution(this, "Interaction") && evo.emptyHand == false;
        }
        return false;
    }

    public boolean testTickingEvolution() {
        if (this.getPokemon().getHeldItemAsItemHeld() != null && this.getPokemon().getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.everStone) {
            return false;
        }
        ArrayList<TickingEvolution> tickingEvolutions = this.getPokemon().getEvolutions(TickingEvolution.class);
        for (TickingEvolution evo : tickingEvolutions) {
            if (!evo.canEvolve(this)) continue;
            return evo.doEvolution(this, "TICKING");
        }
        return false;
    }

    public void setSpawnerParent(PixelmonSpawnerTileEntity spawner) {
        this.spawner = spawner;
    }

    @Override
    public boolean m_6000_(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        if (!this.f_19861_ && this.m_20186_() > 64.0) {
            double d3 = this.m_20185_() - p_145770_1_;
            double d5 = this.m_20189_() - p_145770_5_;
            double d6 = d3 * d3 + d5 * d5;
            return this.m_6783_(d6);
        }
        double d3 = this.m_20185_() - p_145770_1_;
        double d4 = this.m_20186_() - p_145770_3_;
        double d5 = this.m_20189_() - p_145770_5_;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.m_6783_(d6);
    }

    public double getYCentre() {
        return this.m_20186_() + (this.m_20191_().f_82292_ - this.m_20191_().f_82289_) / 2.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientOnlyInfo(LensInfoPacket info) {
        this.info = info;
    }

    @OnlyIn(value=Dist.CLIENT)
    public LensInfoPacket getClientOnlyInfo() {
        return this.info;
    }

    public boolean isUncatchable() {
        return this.pokemon.isUncatchable();
    }

    public boolean isUnbattleable() {
        return this.pokemon.isUnbattleable();
    }

    public void exposeInfo(ServerPlayer player) {
        NetworkHelper.sendPacket(new LensInfoPacket(this), player);
    }

    public void hideInfo(ServerPlayer player) {
        NetworkHelper.sendPacket(new LensInfoPacket(this, true), player);
    }

    public static boolean displacePokemonIfShouldered(ServerPlayer player, UUID uuid) {
        CompoundTag nbt;
        if (player.m_36331_() != null && !(nbt = player.m_36331_()).m_128456_() && nbt.m_128342_("UUID").equals(uuid)) {
            player.m_36362_(new CompoundTag());
            return true;
        }
        if (player.m_36332_() != null && !(nbt = player.m_36332_()).m_128456_() && nbt.m_128342_("UUID").equals(uuid)) {
            player.m_36364_(new CompoundTag());
            return true;
        }
        return false;
    }

    public boolean m_203441_(FluidState fluidState) {
        return this.getForm().hasTag("walksonwater") && fluidState.m_205070_(FluidTags.f_13131_) || this.getForm().hasTag("walksonlava") && fluidState.m_205070_(FluidTags.f_13132_);
    }

    private void floatEntity() {
        CollisionContext iselectioncontext;
        if (this.m_20069_() && this.getForm().hasTag("walksonwater")) {
            iselectioncontext = CollisionContext.m_82750_((Entity)this);
            if (iselectioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13131_)) {
                this.f_19861_ = true;
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
        if (this.m_20077_() && this.getForm().hasTag("walksonlava")) {
            iselectioncontext = CollisionContext.m_82750_((Entity)this);
            if (iselectioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.f_19861_ = true;
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    public int getFlyingCharges() {
        return this.flyingCharges;
    }

    public void setFlyingCharges(Integer flyingCharges) {
        this.flyingCharges = flyingCharges;
    }

    public float getFlyPower() {
        return this.flyPower;
    }

    public void setFlyPower(float flyPower) {
        this.flyPower = flyPower;
    }

    public void setLastJump(int lastJump) {
        this.lastJump = lastJump;
    }

    public int getLastJump() {
        return this.lastJump;
    }

    public int getHoverTicks() {
        return this.hoverTicks;
    }

    public void setHoverTicks(int hoverTicks) {
        this.hoverTicks = hoverTicks;
    }

    /*
     * Unable to fully structure code
     */
    public void m_8107_() {
        if (this.f_20954_ > 0) {
            --this.f_20954_;
        }
        if (this.m_6109_()) {
            this.f_20903_ = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.f_20903_ > 0) {
            d0 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
            d2 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
            d4 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
            d6 = Mth.m_14175_((double)(this.f_20907_ - (double)this.f_19857_));
            this.f_19857_ = (float)((double)this.f_19857_ + d6 / (double)this.f_20903_);
            this.f_19858_ = (float)((double)this.f_19858_ + (this.f_20908_ - (double)this.f_19858_) / (double)this.f_20903_);
            --this.f_20903_;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.f_19857_, this.f_19858_);
        } else if (!this.m_21515_()) {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
        if (this.f_20934_ > 0) {
            this.f_20885_ = (float)((double)this.f_20885_ + Mth.m_14175_((double)((double)this.f_20885_ - (double)this.f_20885_)) / (double)this.f_20934_);
            --this.f_20934_;
        }
        Vec3 = this.m_20184_();
        d1 = Vec3.f_82479_;
        d3 = Vec3.f_82480_;
        d5 = Vec3.f_82481_;
        if (Math.abs(Vec3.f_82479_) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(Vec3.f_82480_) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(Vec3.f_82481_) < 0.003) {
            d5 = 0.0;
        }
        this.m_20334_(d1, d3, d5);
        this.f_19853_.m_46473_().m_6180_("ai");
        if (this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        } else if (this.m_21515_()) {
            this.m_9236_().m_46473_().m_6180_("newAi");
            this.m_6140_();
            this.m_9236_().m_46473_().m_7238_();
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("jump");
        if (this.f_20899_ && this.m_6129_()) {
            d7 = this.m_20077_() != false ? this.m_204036_(FluidTags.f_13132_) : this.m_204036_(FluidTags.f_13131_);
            flag = this.m_20069_() != false && d7 > 0.0;
            d8 = this.m_20204_();
            if (!flag || this.f_19861_ && !(d7 > d8)) {
                if (!this.m_20077_() || this.f_19861_ && !(d7 > d8)) {
                    if ((this.f_19861_ || flag && d7 <= d8) && this.f_20954_ == 0) {
                        this.m_6135_();
                        this.f_20954_ = 10;
                    }
                } else {
                    this.m_203347_((TagKey<Fluid>)FluidTags.f_13132_);
                }
            } else {
                this.m_203347_((TagKey<Fluid>)FluidTags.f_13131_);
            }
        } else {
            this.f_20954_ = 0;
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("travel");
        this.f_20900_ *= 0.98f;
        this.f_20902_ *= 0.98f;
        this.m_21323_();
        aabb = this.m_20191_();
        vec3 = new Vec3((double)this.f_20900_, (double)this.f_20901_, (double)this.f_20902_);
        if (this.m_21023_(MobEffects.f_19591_) || this.m_21023_(MobEffects.f_19620_)) {
            this.m_183634_();
        }
        if (!((livingentity = this.m_6688_()) instanceof Player)) ** GOTO lbl-1000
        player = (Player)livingentity;
        if (this.m_6084_()) {
            this.m_274466_(player, vec3);
        } else lbl-1000:
        // 2 sources

        {
            this.m_7023_(vec3);
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("freezing");
        if (!this.m_9236_().f_46443_ && !this.m_21224_()) {
            i = this.m_146888_();
            if (this.f_146808_ && this.m_142079_()) {
                this.m_146917_(Math.min(this.m_146891_(), i + 1));
            } else {
                this.m_146917_(Math.max(0, i - 2));
            }
        }
        this.m_147225_();
        this.m_147226_();
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 40 == 0 && this.m_146890_() && this.m_142079_()) {
            this.m_6469_(this.m_269291_().m_269109_(), 1.0f);
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("push");
        if (this.f_20938_ > 0) {
            --this.f_20938_;
            this.m_21071_(aabb, this.m_20191_());
        }
        this.m_6138_();
        this.m_9236_().m_46473_().m_7238_();
        if (!this.m_9236_().f_46443_ && this.m_6126_() && this.m_20071_()) {
            this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
        }
    }

    protected void m_8022_() {
    }
}

