/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.ai.BattleHoverGoal;
import com.pixelmonmod.pixelmon.ai.PixelmonMovementController;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.ControlledMovementLogic;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.comm.packetHandlers.UpdatePixelmonMovementPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBattleEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementFlying;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementGround;
import com.pixelmonmod.pixelmon.enums.EnumKeybinds;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import org.joml.Vector3f;

public abstract class AbstractMovesEntity
extends AbstractBattleEntity {
    public static final float MAX_MOVE_MULTIPLIER = 1.4f;
    public static final float MIN_MOVE_MULTIPLIER = 0.3f;
    private static final String NBT_FLY_HEIGHT = "flyheight";
    private static final String NBT_IS_FLYING = "isFly";
    private static final String NBT_CAN_FLY = "canfly";
    public static final DataSync<AbstractMovesEntity, Boolean> SYNC_FLYING = new DataSync<AbstractMovesEntity, Boolean>(AbstractMovesEntity.class, EntityDataSerializers.f_135035_, (abstractMovesEntity, flying) -> {
        abstractMovesEntity.isFlying = flying;
    });
    public static final DataSync<AbstractMovesEntity, Boolean> SYNC_HOVERING = new DataSync<AbstractMovesEntity, Boolean>(AbstractMovesEntity.class, EntityDataSerializers.f_135035_, (abstractMovesEntity, hovering) -> {
        abstractMovesEntity.hovering = hovering;
    });
    private int baseFlyHeight = 30;
    private int baseSwimDepth = 5;
    private int flyHeight = -1;
    private int swimDepth = -1;
    private float fallRate = 0.04f;
    private float strafeUpDown = 0.0f;
    private float hoverRotationPitch = 20.0f;
    private float moveMultiplier = 0.3f;
    private float thermalPower = 0.0f;
    private boolean canFly = true;
    private boolean canFlyOverride = true;
    public float rotationRoll = 0.0f;
    public float prevRotationRoll = 0.0f;
    public float lastSpeed = -1.0f;
    public float lastStrafe = -1.0f;
    public float lastStrafeUp = -1.0f;
    private PixelmonMovementFlying movementFlying = new PixelmonMovementFlying(this);
    private PixelmonMovementGround movementGround = new PixelmonMovementGround(this);
    private boolean hovering = false;
    public int takeOffTicks = 0;
    public boolean lastFlyingState = false;
    Vec3 targetPosition;

    public AbstractMovesEntity(EntityType<? extends AbstractMovesEntity> type, Level worldIn) {
        super((EntityType<? extends AbstractBattleEntity>)type, worldIn);
        this.f_21342_ = new PixelmonMovementController((Mob)this);
    }

    @Override
    protected void m_8097_() {
        this.define(SYNC_FLYING, false);
        this.define(SYNC_HOVERING, false);
        super.m_8097_();
    }

    public PixelmonMovementBase getMovement() {
        if (this.isFlying()) {
            return this.movementFlying;
        }
        return this.movementGround;
    }

    public void setFlying(boolean isFlying) {
        SYNC_FLYING.set((Entity)this, (Object)isFlying);
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public boolean isHovering() {
        return this.hovering;
    }

    public void toggleHover() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        boolean hovering = this.isHovering();
        if (this.isFlying() || hovering) {
            SYNC_HOVERING.set((Entity)this, (Object)(!hovering ? 1 : 0));
            this.calcMoveSpeed();
            NetworkHelper.sendToAllTracking(new UpdatePixelmonMovementPacket(this), (Entity)this);
        }
    }

    public void handleMovement(List<EnumKeybinds> movements) {
        this.getMovement().handleMovement(movements);
        if (!this.m_9236_().f_46443_) {
            NetworkHelper.sendToAllTracking(new UpdatePixelmonMovementPacket(this), (Entity)this);
        }
    }

    public void doJump() {
        this.m_6135_();
    }

    protected float m_6118_() {
        return (float)Math.max(0.42, (double)(super.m_6118_() * this.m_20206_() / 2.0f));
    }

    protected float m_20098_() {
        return 1.0f;
    }

    public void takeOff() {
        if (this.isHovering()) {
            this.toggleHover();
        }
        this.m_146926_(20.0f);
        this.lastSpeed = -1.0f;
        this.lastStrafe = -1.0f;
        this.lastStrafeUp = -1.0f;
        this.strafeUpDown = 0.0f;
        this.takeOffTicks = 20;
        if (!this.m_9236_().f_46443_) {
            this.moveMultiplier = 0.2f;
            EntityHelper.setPosition((Entity)this, EnumRotation.y, this.m_20186_() + 0.3);
            NetworkHelper.sendToAllTracking(new UpdatePixelmonMovementPacket(this), (Entity)this);
            this.setFlying(true);
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        double moveForward;
        double speed;
        LivingFallEvent event = ForgeEventFactory.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (event.isCanceled()) {
            return false;
        }
        distance = event.getDistance();
        damageMultiplier = event.getDamageMultiplier();
        double moveDown = Math.abs(this.m_20184_().f_82480_) - 0.8;
        double d = speed = moveDown > (moveForward = (double)Math.abs(this.f_20902_) - 0.8) ? moveDown : moveForward;
        if (speed > 0.0) {
            this.m_5496_(this.m_5896_((int)speed * 6), 1.0f, 1.0f);
            this.m_6469_(source, (float)speed * 6.0f);
            int j = Mth.m_14107_((double)this.m_20185_());
            int k = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f));
            int l = Mth.m_14107_((double)this.m_20189_());
            BlockState iblockstate = this.m_9236_().m_8055_(new BlockPos(j, k, l));
            if (!iblockstate.m_60795_()) {
                SoundType soundtype = iblockstate.m_60734_().getSoundType(iblockstate, (LevelReader)this.m_9236_(), new BlockPos(j, k, l), (Entity)this);
                this.m_5496_(soundtype.m_56779_(), soundtype.m_56773_() * 0.5f, soundtype.m_56774_() * 0.75f);
            }
        }
        return true;
    }

    public void calcMoveSpeed() {
        ControlledMovementLogic mountedFlyingParameters = this.getPokemon().getForm().getMovement().getMountedFlyingParameters();
        if (mountedFlyingParameters != null) {
            mountedFlyingParameters.calcMoveSpeed(this);
        }
    }

    public void setMovementTarget(Vec3 targetPosition) {
        this.targetPosition = targetPosition;
    }

    public Vec3 getTargetPosition() {
        return this.targetPosition;
    }

    @Override
    public void m_6075_() {
        if (!this.isFlying() && this.hasOwner()) {
            this.m_146926_(0.0f);
            this.rotationRoll = 0.0f;
            this.m_20242_(false);
        }
        if (!(this.m_9236_().f_46443_ || !PixelmonConfigProxy.getGeneral().isDisabledNonPlayerMovement() || this.pokemon.getStorageAndPosition() != null && this.pokemon.getStorage() != null && this.pokemon.getStorage() instanceof PlayerPartyStorage)) {
            return;
        }
        super.m_6075_();
    }

    public void onLanding() {
    }

    public float getFlyingDirection() {
        return this.m_6688_().m_146908_();
    }

    private float getRideSpeed() {
        return 0.07f + 0.05f * (float)this.pokemon.getStat(BattleStatsType.SPEED) / 500.0f;
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        this.resetAI();
        this.lastSpeed = -1.0f;
        this.setFlying(false);
        this.m_146926_(0.0f);
        this.rotationRoll = 0.0f;
    }

    public int getFlyHeight() {
        if (this.flyHeight == -1) {
            this.flyHeight = RandomHelper.getRandomNumberBetween(this.getFlyingParameters().getFlyHeightMin(), this.getFlyingParameters().getFlyHeightMax());
        }
        return this.flyHeight;
    }

    public void setFlyHeight(int flyHeight) {
        this.flyHeight = flyHeight;
    }

    public int getSwimDepth() {
        if (this.swimDepth == -1) {
            this.swimDepth = this.m_9236_().m_46472_() == DrownedWorld.WORLD ? RandomHelper.getRandomNumberBetween(10, 235) : (this.getSwimmingParameters() == null ? (this.m_6040_() ? RandomHelper.getRandomNumberBetween(1, 10) : (int)(this.f_19815_.f_20378_ / 2.0f)) : RandomHelper.getRandomNumberBetween(this.getSwimmingParameters().getDepthRangeStart(), this.getSwimmingParameters().getDepthRangeEnd()));
        }
        return this.swimDepth;
    }

    public void setSwimDepth(int swimDepth) {
        this.swimDepth = swimDepth;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128405_(NBT_FLY_HEIGHT, this.getFlyHeight());
        compound.m_128379_(NBT_CAN_FLY, this.canFly);
        compound.m_128379_(NBT_IS_FLYING, this.isFlying());
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.flyHeight = nbt.m_128451_(NBT_FLY_HEIGHT);
        this.canFly = nbt.m_128471_(NBT_CAN_FLY);
        this.setFlying(nbt.m_128471_(NBT_IS_FLYING));
        super.deserializeNBT(nbt);
    }

    public boolean m_6000_(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        if (this.isFlying()) {
            double d3 = this.m_20185_() - p_145770_1_;
            double d5 = this.m_20189_() - p_145770_5_;
            double d6 = d3 * d3 + d5 * d5;
            return this.m_6783_(d6);
        }
        double d3 = this.m_20185_() - p_145770_1_;
        double d4 = this.m_20186_() - p_145770_3_;
        double d5 = this.m_20189_() - p_145770_5_;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.m_6783_(d6);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 1200.0 * 1.0) * d0;
    }

    public void setCanFly(boolean canFly) {
        this.canFly = canFly;
    }

    public boolean getCanFly() {
        return this.getForm().getMovement().getMountedFlyingParameters() != null;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction p_19958_) {
        super.m_19956_(passenger, p_19958_);
        if (this.getForm() == null || this.getForm().getMovement() == null || this.getForm().getMovement().getRidingOffsets() == null) {
            return;
        }
        Vector3f offsets = this.getForm().getMovement().getRidingOffsets().standing != null ? this.getForm().getMovement().getRidingOffsets().standing : new Vector3f(0.0f, 0.0f, 0.0f);
        if (this.getForm().getMovement().getRidingOffsets().moving != null && (this.flyingDelayCounter >= flyingDelayLimit || this.getUsingRidingSpecialConditions())) {
            offsets = this.getForm().getMovement().getRidingOffsets().moving;
        }
        if (this.m_20363_(passenger) && this.isFlying()) {
            this.getMovement().updatePassenger(passenger, offsets);
        } else {
            Vec3 vec = new Vec3((double)(offsets.x() * this.getPixelmonScale() * this.getScaleFactor()), (double)((offsets.y() + this.m_20206_()) * this.getPixelmonScale() * this.getScaleFactor()), (double)(offsets.z() * this.getPixelmonScale() * this.getScaleFactor()));
            vec = vec.m_82524_(-1.0f * this.f_20883_ * (float)Math.PI / 180.0f);
            passenger.m_6034_(this.m_20185_() + vec.f_82479_, this.m_20186_() + vec.f_82480_, this.m_20189_() + vec.f_82481_);
        }
    }

    public boolean getStaysHorizontalInRender() {
        ControlledMovementLogic mountedFlyingParameters = this.getPokemon().getForm().getMovement().getMountedFlyingParameters();
        if (mountedFlyingParameters == null) {
            return false;
        }
        return mountedFlyingParameters.getStaysHorizontalInRender(this);
    }

    public float getMoveMultiplier() {
        return this.moveMultiplier;
    }

    public void setMoveMultiplier(float moveMultiplier) {
        this.moveMultiplier = moveMultiplier;
    }

    public float getStrafeUpDown() {
        return this.strafeUpDown;
    }

    public void setStrafeUpDown(float strafeUpDown) {
        this.strafeUpDown = strafeUpDown;
    }

    public void setThermalPower(float thermalPower) {
        this.thermalPower = thermalPower;
    }

    public float getThermalPower() {
        return this.thermalPower;
    }

    public float getHoverRotationPitch() {
        return this.hoverRotationPitch;
    }

    public void setHoverRotationPitch(float hoverRotationPitch) {
        this.hoverRotationPitch = hoverRotationPitch;
    }

    public float getFallRate() {
        return this.fallRate;
    }

    public void setPixelmonToFlyForBattle() {
        AbstractMovesEntity abstractMovesEntity;
        Vec3 pos = this.m_20182_().m_82520_(0.0, -4.0, 0.0);
        if (this.canFly() && this.m_9236_().m_8055_(new BlockPos((int)pos.m_7096_(), (int)pos.m_7098_(), (int)pos.m_7094_())).m_60795_() && (abstractMovesEntity = this) instanceof PixelmonEntity) {
            PixelmonEntity pixelmon = (PixelmonEntity)abstractMovesEntity;
            this.f_21345_.m_25352_(0, (Goal)new BattleHoverGoal(pixelmon));
        }
    }
}

