/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.ai.naivgator.ProxyPathNavigation;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.events.RidePokemonEvent;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.AIHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHasStatsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.PixelmonInteraction;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;

public abstract class AbstractInteractionsEntity
extends AbstractHasStatsEntity {
    public static final DataSync<AbstractInteractionsEntity, Byte> SYNC_INTERACTIONS = new DataSync<AbstractInteractionsEntity, Byte>(AbstractInteractionsEntity.class, EntityDataSerializers.f_135027_, (abstractInteractionsEntity, interactions) -> {
        abstractInteractionsEntity.numInteractions = interactions.byteValue();
    });
    protected int ridingPlayerVertical;
    protected boolean isFlying = false;
    protected int initAir = 0;
    protected boolean ridingInitialised = false;
    protected AIHelper aiHelper;
    protected int aggressionTimer = 0;
    protected PixelmonInteraction interaction;
    protected int numInteractions = 0;
    public float mountBoost = 1.0f;
    protected int jumpTicks = 0;
    public String skillId;
    public int targetX;
    public int targetY;
    public int targetZ;
    public Direction targetSide;

    public AbstractInteractionsEntity(EntityType<? extends AbstractInteractionsEntity> type, Level par1World) {
        super((EntityType<? extends AbstractHasStatsEntity>)type, par1World);
    }

    @Override
    protected void m_8097_() {
        this.define(SYNC_INTERACTIONS, (byte)0);
        super.m_8097_();
    }

    public AIHelper getAIHelper() {
        if (this.aiHelper == null) {
            this.resetAI();
        }
        return this.aiHelper;
    }

    public void resetAI() {
        if (!(this.f_21344_ instanceof ProxyPathNavigation)) {
            return;
        }
        this.aiHelper = new AIHelper();
        ((ProxyPathNavigation)this.f_21344_).setProxiedNavigator(this.aiHelper.createNavigator(this));
        this.aiHelper.populateTasks(this, this.f_21345_);
    }

    protected void m_8099_() {
        this.aiHelper.populateTasks(this, this.f_21345_);
    }

    protected void m_7509_() {
    }

    protected PathNavigation m_6037_(Level world) {
        this.aiHelper = new AIHelper();
        return new ProxyPathNavigation((Mob)this, world, this.aiHelper.createNavigator(this));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_9236_().f_46443_) {
            return super.m_6071_(player, hand);
        }
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        if (this.interaction != null && this.getNumInteractions() > 0 && this.interaction.processInteract(this, player, hand, player.m_21120_(hand))) {
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(InteractionHand.MAIN_HAND) != null) {
            InteractionResult InteractionResult2 = player.m_21120_(InteractionHand.MAIN_HAND).m_41647_(player, (LivingEntity)this, InteractionHand.MAIN_HAND);
            if (InteractionResult2 != InteractionResult.PASS) {
                return InteractionResult2;
            }
        }
        if (hand == InteractionHand.MAIN_HAND) {
            boolean allowMount;
            if (player.m_20159_() || !PixelmonConfigProxy.getGeneral().getRiding().isAllowRiding() || !this.getForm().getMovement().isRideable() || !this.belongsTo(player)) {
                return InteractionResult.PASS;
            }
            if (!(PixelmonConfigProxy.getGeneral().getRiding().isLandMount() || this.canFly() || this.canSurf())) {
                return InteractionResult.PASS;
            }
            boolean bl = allowMount = !Pixelmon.EVENT_BUS.post((Event)new RidePokemonEvent((ServerPlayer)player, (PixelmonEntity)this));
            if (!allowMount) {
                return InteractionResult.PASS;
            }
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean m_30614_() {
        return super.m_30614_();
    }

    public boolean canFly() {
        if (PixelmonConfigProxy.getGeneral().getRiding().isRequireHM()) {
            Moveset moves = this.getPokemon().getMoveset();
            return this.getForm().getMovement().canFly() && moves.hasAttack(AttackRegistry.FLY);
        }
        return this.getForm().getMovement().canFly();
    }

    public boolean canSurf() {
        if (PixelmonConfigProxy.getGeneral().getRiding().isRequireHM()) {
            Moveset moves = this.getPokemon().getMoveset();
            return this.getForm().getMovement().canSurf() && moves.hasAttack(AttackRegistry.SURF);
        }
        return this.getForm().getMovement().canSurf();
    }

    public void onSendout() {
        if (!this.m_9236_().f_46443_ && this.interaction == null) {
            this.interaction = PixelmonInteraction.getInteraction(this.getSpecies());
            if (this.interaction != null) {
                this.setNumInteractions(this.pokemon.getPersistentData().m_128445_("NumInteractions"));
                this.interaction.counter = this.pokemon.getPersistentData().m_128448_("InteractionCount");
                if (this.interaction.counter == -1 && this.interaction.maxInteractions != this.getNumInteractions()) {
                    this.interaction.resetCounter(this);
                }
            }
        }
    }

    protected float m_293694_(EntityDimensions p_299002_, float p_297393_) {
        return (float)((double)this.m_20206_() * 0.9);
    }

    private boolean isFlying() {
        return this instanceof AbstractMovesEntity && ((AbstractMovesEntity)this).isFlying();
    }

    protected boolean m_245259_() {
        return false;
    }

    protected void updateEntityActionStateAlt() {
        ++this.f_20891_;
        this.m_6043_();
        if (Double.isNaN(this.m_20185_()) || Double.isNaN(this.m_20186_()) || Double.isNaN(this.m_20189_())) {
            return;
        }
        this.m_21574_().m_26789_();
        this.f_21344_.m_26569_();
        this.m_8024_();
        if (this.m_20159_() && this.m_20202_() instanceof Mob) {
            Mob entityliving = (Mob)this.m_20202_();
            entityliving.m_21573_().m_26536_(this.m_21573_().m_26570_(), 1.5);
        }
        this.f_21342_.m_8126_();
        if (!this.isFlying()) {
            this.m_21563_().m_8128_();
            this.f_21343_.m_8124_();
        }
    }

    public void m_6089_() {
        if (this.interaction != null && !this.m_9236_().f_46443_) {
            this.pokemon.getPersistentData().m_128344_("NumInteractions", (byte)this.numInteractions);
            this.pokemon.getPersistentData().m_128376_("InteractionCount", (short)this.interaction.counter);
        }
        super.m_6089_();
    }

    public void m_6710_(LivingEntity entity) {
        this.skillId = null;
        super.m_6710_(entity);
    }

    public void setAttackTarget(LivingEntity entity, String skillId) {
        this.m_6710_(entity);
        this.skillId = skillId;
    }

    public void setBlockTarget(int x, int y, int z, Direction side, String skillId) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.targetSide = side;
        this.skillId = skillId;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.interaction != null) {
            if (this.interaction.counter > 0) {
                --this.interaction.counter;
            }
            if (this.interaction.counter == 0) {
                this.setNumInteractions(Math.min(this.interaction.maxInteractions, this.getNumInteractions() + 1));
                if (this.interaction.maxInteractions > this.getNumInteractions()) {
                    this.interaction.resetCounter(this);
                } else {
                    --this.interaction.counter;
                }
            }
        }
        if (this.m_6688_() != null && !this.ridingInitialised) {
            this.initAir = this.m_6688_().m_20146_();
            this.ridingInitialised = true;
        } else if (this.m_6688_() == null && this.ridingInitialised) {
            this.ridingInitialised = false;
            this.resetAI();
        }
        if (!this.m_9236_().f_46443_ && this.aiHelper == null && this.getForm() != null) {
            this.resetAI();
        }
        if (this.aggressionTimer > 0) {
            --this.aggressionTimer;
        }
    }

    public int getNumInteractions() {
        return this.numInteractions;
    }

    public void setNumInteractions(int newValue) {
        SYNC_INTERACTIONS.set((Entity)this, (Object)((byte)Math.max(0, newValue)));
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.interaction != null && !this.m_9236_().f_46443_) {
            this.pokemon.getPersistentData().m_128344_("NumInteractions", (byte)this.numInteractions);
            this.pokemon.getPersistentData().m_128376_("InteractionCount", (short)this.interaction.counter);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (!this.m_9236_().f_46443_ && this.interaction != null) {
            this.setNumInteractions(this.pokemon.getPersistentData().m_128445_("NumInteractions"));
            this.interaction.counter = this.pokemon.getPersistentData().m_128448_("InteractionCount");
        }
    }

    protected boolean getUsingRidingSpecialConditions() {
        if (Math.abs(this.m_20184_().m_7096_()) > 0.01 || Math.abs(this.m_20184_().m_7094_()) > 0.01) {
            if (this.getSpecies().is(PixelmonSpecies.GYARADOS)) {
                return this.m_20069_();
            }
            return this.getSpecies().is(PixelmonSpecies.ONIX);
        }
        return false;
    }

    public void unloadEntity() {
        if (this.m_6688_() != null) {
            this.m_6688_().m_6038_();
            this.resetAI();
        }
        if (this.m_20202_() != null) {
            this.m_6038_();
        }
    }

    public int getAggressionTimer() {
        return this.aggressionTimer;
    }

    public void setAggressionTimer(int aggressionTimer) {
        this.aggressionTimer = aggressionTimer;
    }

    public int getJumpTicks() {
        return this.jumpTicks;
    }

    public void setJumpTicks(int jumpTicks) {
        this.jumpTicks = jumpTicks;
    }

    public int getRidingPlayerVertical() {
        return this.ridingPlayerVertical;
    }

    public void setRidingPlayerVertical(int ridingPlayerVertical) {
        this.ridingPlayerVertical = ridingPlayerVertical;
    }
}

