/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.boss.DropSet;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractHoldsItemsEntity
extends AbstractMovesEntity {
    boolean dropped = false;

    public AbstractHoldsItemsEntity(EntityType<? extends AbstractHoldsItemsEntity> type, Level par1World) {
        super((EntityType<? extends AbstractMovesEntity>)type, par1World);
    }

    public void m_6667_(DamageSource cause) {
        PixelmonEntity pix;
        if (cause.m_7640_() instanceof PixelmonEntity && this.getBossTier().isBoss() && !this.m_9236_().f_46443_) {
            pix = (PixelmonEntity)cause.m_7640_();
            if (pix.m_269323_() != null && !this.dropped) {
                this.dropBossItems((ServerPlayer)pix.m_269323_());
                this.dropped = true;
            } else if (pix.battleController != null && !this.dropped) {
                pix.battleController.participants.stream().filter(p -> p instanceof PlayerParticipant).forEach(p -> {
                    this.dropBossItems(((PlayerParticipant)p).player);
                    this.dropped = true;
                });
            }
        }
        if (cause.m_7640_() instanceof PixelmonEntity && this.getBossTier().isNotBoss() && !this.m_9236_().f_46443_) {
            pix = (PixelmonEntity)cause.m_7640_();
            if (pix.m_269323_() != null && !this.dropped) {
                this.dropNormalItems((ServerPlayer)pix.m_269323_());
                this.dropped = true;
            } else if (pix.battleController != null && !this.dropped) {
                pix.battleController.participants.stream().filter(p -> p instanceof PlayerParticipant && p.team != this.getPixelmonWrapper().getParticipant().team).forEach(p -> {
                    this.dropNormalItems(((PlayerParticipant)p).player);
                    this.dropped = true;
                });
            }
        }
        super.m_6667_(cause);
    }

    public void dropNormalItems(ServerPlayer player) {
        if (!PixelmonConfigProxy.getGeneral().getDrops().isPokemonDropsEnabled() || this.isBossPokemon() || this.hasOwner() || this.getTrainer() != null) {
            return;
        }
        if (this.pokemon.hasNoDrops()) {
            return;
        }
        List<ItemStack> items = DropItemRegistry.getDropsForPokemon(this);
        int id = 0;
        ArrayList<DroppedItem> givenDrops = new ArrayList<DroppedItem>();
        for (ItemStack item : items) {
            if (item == null) continue;
            givenDrops.add(new DroppedItem(item, id++));
        }
        if (givenDrops.size() > 0) {
            DropItemQueryList.register(this, givenDrops, player);
        }
    }

    public void dropBossItems(ServerPlayer player) {
        List<ItemStack> items = DropItemRegistry.getDropsForPokemon(this);
        if (this.pokemon.hasNoDrops()) {
            return;
        }
        int id = 0;
        ArrayList<DroppedItem> givenDrops = new ArrayList<DroppedItem>();
        for (ItemStack item : items) {
            if (item == null) continue;
            givenDrops.add(new DroppedItem(item, id++));
        }
        Set<DropSet.Drop> bossDrops = this.getBossTier().getDrops(player, this);
        for (DropSet.Drop drop : bossDrops) {
            givenDrops.add(new DroppedItem(drop, id++));
        }
        if (givenDrops.size() > 0) {
            DropItemQueryList.register(this, givenDrops, player);
        }
    }
}

