/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.flying.FlyingParameters;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.swimming.SwimmingParameters;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.ExtraStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PokemonLevel;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.ShearableStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.render.shader.ShaderParameters;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.CastformTickHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.ShearableTickHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.TickHandlerBase;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasStorage;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public abstract class AbstractHasStatsEntity
extends AbstractClientEntity {
    private TickHandlerBase tickHandler;
    int friendshipTicker = 0;

    public AbstractHasStatsEntity(EntityType<? extends AbstractHasStatsEntity> type, Level par1World) {
        super((EntityType<? extends AbstractClientEntity>)type, par1World);
        this.setAnimated(true);
        this.updateSize();
    }

    public PokemonLevel getLvl() {
        return this.getPokemon().getPokemonLevelContainer();
    }

    float getMoveSpeed() {
        return 0.3f + (1.0f - (200.0f - (float)this.pokemon.getStat(BattleStatsType.SPEED)) / 200.0f) * 0.3f;
    }

    @Override
    public void setBossTier(BossTier tier) {
        if (tier == null) {
            tier = BossTierRegistry.NOT_BOSS;
        }
        if (tier == null) {
            return;
        }
        super.setBossTier(tier);
        if (this.getBossTier().isBoss()) {
            if (this.getBossTier().isMega()) {
                Stats form;
                if (this.getForm().hasMegaForm() && !Objects.equals(this.getSpecies(), PixelmonSpecies.NECROZMA.getValueUnsafe())) {
                    this.setForm(this.getForm().getRandomMegaForm());
                }
                if ((form = this.getSpecies().getForm("primal")) != null) {
                    this.setForm(form);
                }
            }
            if (!tier.getAlwaysPalette().isEmpty()) {
                this.getPokemon().setPalette(tier.getAlwaysPalette());
            } else {
                this.getPokemon().setPalette("none");
            }
            this.setShaderParameters(ShaderParameters.builder().id(ResourceLocationHelper.of("pixelmon", "rendertype_entity_smooth_cutout_fresnel")).noTexture().modelAndShader().withParameter("FresnelBias", Codec.FLOAT, Float.valueOf(0.35f)).withParameter("FresnelScale", Codec.FLOAT, Float.valueOf(20.0f)).withParameter("FresnelPower", Codec.FLOAT, Float.valueOf(0.85f)).withParameter("FresnelColor", Codec.FLOAT.listOf(), List.of(Float.valueOf((float)this.bossTier.getColor().getRed() / 255.0f), Float.valueOf((float)this.bossTier.getColor().getGreen() / 255.0f), Float.valueOf((float)this.bossTier.getColor().getBlue() / 255.0f), Float.valueOf((float)this.bossTier.getColor().getAlpha() / 255.0f))).renderColor(new Color(1.0f, 1.0f, 1.0f, 0.1f)).build());
        }
    }

    public void m_21153_(float par1) {
        super.m_21153_(par1);
        this.updateHealth();
    }

    public void updateHealth() {
        if (this.m_21223_() > this.m_21233_()) {
            super.m_21153_(this.m_21233_());
        }
        if (this.m_21223_() < 0.0f) {
            super.m_21153_(0.0f);
        }
        if (this.pokemon != null && this.m_269323_() != null && !this.m_9236_().f_46443_) {
            this.update(EnumUpdateType.HP, EnumUpdateType.Stats);
        }
    }

    public void updateStats() {
        this.pokemon.getStats().setLevelStats(this.pokemon.getNature(), this.pokemon.getForm(), this.pokemon.getPokemonLevel());
        AbstractBaseEntity.SYNC_MAX_HP.set((Entity)this, (Object)this.pokemon.getMaxHealth());
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.pokemon.getMaxHealth());
        this.updateHealth();
    }

    public Optional<Pokerus> getPokerus() {
        return Optional.ofNullable(this.pokemon.getPokerus());
    }

    @Override
    public Stats getForm() {
        return this.pokemon == null ? PixelmonSpecies.BULBASAUR.getValueUnsafe().getDefaultForm() : this.pokemon.getForm();
    }

    public void setForm(String form) {
        this.getPokemon().setForm(form);
    }

    public void setForm(Stats form) {
        this.getPokemon().setForm(form);
    }

    public int getNumForms() {
        return this.getSpecies().getForms().size();
    }

    public String getFormIncludeTransformed() {
        if (this.transformed != null) {
            return this.transformed.getForm().getName();
        }
        return this.pokemon.getForm().getName();
    }

    public int getPartyPosition() {
        PokemonStorage storage = this.getStorage();
        if (!(storage instanceof PartyStorage)) {
            return -1;
        }
        return storage.getPosition((Pokemon)this.pokemon).order;
    }

    public SpawnLocationType getDefaultSpawnLocation() {
        if (this.getForm() != null && this.getForm().getSpawn().getSpawnLocations() != null && this.getForm().getSpawn().getSpawnLocations().length > 0) {
            return this.getForm().getSpawn().getSpawnLocations()[0];
        }
        return SpawnLocationType.LAND;
    }

    public FlyingParameters getFlyingParameters() {
        return this.getForm().getMovement().getFlyingParameters();
    }

    public SwimmingParameters getSwimmingParameters() {
        return this.getForm().getMovement().getSwimmingParameters();
    }

    public boolean m_6040_() {
        return this.getSpawnLocation() == SpawnLocationType.WATER || this.getForm().getTypes().contains(Element.WATER);
    }

    @Override
    public void m_8119_() {
        if (this.m_269323_() != null && !this.m_9236_().f_46443_ && ++this.friendshipTicker % 800 == 0) {
            this.friendshipTicker = 0;
            int amount = this.pokemon.getFriendship() < 200 ? 2 : 1;
            this.pokemon.increaseFriendship(amount);
            PixelExtrasStorage.getData(this.m_21805_()).checkPokemon(this.pokemon);
        }
        if (this.hasOwner() && this.m_269323_() == null && !this.m_9236_().f_46443_) {
            this.m_6089_();
        }
        if (this.getSpecies().is(PixelmonSpecies.CASTFORM) && !(this.tickHandler instanceof CastformTickHandler)) {
            this.tickHandler = new CastformTickHandler(this);
        } else if (ExtraStats.getExtraStats(this.getSpecies()) instanceof ShearableStats && !(this.tickHandler instanceof ShearableTickHandler)) {
            this.tickHandler = new ShearableTickHandler(this);
        } else if (!(this.tickHandler instanceof ShearableTickHandler) && !(this.tickHandler instanceof CastformTickHandler) || this.getSpecies().is(PixelmonSpecies.FLAAFFY)) {
            this.tickHandler = null;
        }
        if (this.tickHandler != null) {
            this.tickHandler.tick(this.m_9236_());
        }
        super.m_8119_();
    }
}

