/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.ModelAttachment;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelData;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelLocator;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.client.render.shader.ShaderParameters;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.AnimationVariables;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.PaletteParticles;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.ParticleEffects;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public abstract class AbstractClientEntity
extends AbstractBaseEntity {
    public static final int parameterId = Pokemon.SYNC_POKEMON_BASE.getParameterId();
    public static final int parameterId2 = Pokemon.SYNC_GROWTH.getParameterId();
    public static final DataSync<AbstractClientEntity, Integer> SYNC_TRANSFORMATION = new DataSync<AbstractClientEntity, Integer>(AbstractClientEntity.class, EntityDataSerializers.f_135028_, (abstractClientEntity, integer) -> {
        abstractClientEntity.transformations = integer;
    });
    public static final DataSync<AbstractClientEntity, Boolean> SYNC_DYNAMAXED = new DataSync<AbstractClientEntity, Boolean>(AbstractClientEntity.class, EntityDataSerializers.f_135035_, (abstractClientEntity, f) -> {
        abstractClientEntity.dynamaxed = f;
    });
    public static final DataSync<AbstractClientEntity, ResourceLocation> SYNC_OVERRIDE_TEXTURE = new DataSync<AbstractClientEntity, ResourceLocation>(AbstractClientEntity.class, PixelmonDataSerializers.RESOURCE_LOCATION, (abstractClientEntity, f) -> {
        abstractClientEntity.overrideTexture = f;
    });
    public static final DataSync<AbstractClientEntity, Boolean> SYNC_WIREFRAME = new DataSync<AbstractClientEntity, Boolean>(AbstractClientEntity.class, EntityDataSerializers.f_135035_, (abstractMovesEntity, wireFrame) -> {
        abstractMovesEntity.wireFrame = wireFrame;
    });
    public static final DataSync<AbstractClientEntity, Boolean> SYNC_ANIMATED = new DataSync<AbstractClientEntity, Boolean>(AbstractClientEntity.class, EntityDataSerializers.f_135035_, (abstractMovesEntity, animated) -> {
        abstractMovesEntity.animated = animated;
    });
    public static final DataSync<AbstractClientEntity, Integer> SYNC_MODEL_SLOT = new DataSync<AbstractClientEntity, Integer>(AbstractClientEntity.class, EntityDataSerializers.f_135028_, (abstractMovesEntity, modelSlot) -> {
        abstractMovesEntity.modelSlot = modelSlot;
    });
    public static final DataSync<AbstractClientEntity, Boolean> SYNC_SPRITE_MODEL = new DataSync<AbstractClientEntity, Boolean>(AbstractClientEntity.class, EntityDataSerializers.f_135035_, (abstractMovesEntity, spriteModel) -> {
        abstractMovesEntity.spriteModel = spriteModel;
    });
    public static final DataSync<AbstractClientEntity, EvolutionStage> SYNC_EVO_STAGE = new DataSync<AbstractClientEntity, EvolutionStage>(AbstractClientEntity.class, PixelmonDataSerializers.EVO_STAGE, (abstractMovesEntity, evoStage) -> {
        abstractMovesEntity.evoStage = evoStage;
    });
    public static final DataSync<AbstractClientEntity, Optional<ShaderParameters>> SYNC_SHADER_PARAMETERS = new DataSync<AbstractClientEntity, Optional>(AbstractClientEntity.class, ShaderParameters.OPTIONAL_SHADER_DATA_SERIALIZER, (abstractMovesEntity, shaderParameters) -> {
        abstractMovesEntity.shaderParameters = shaderParameters.orElse(null);
    });
    public static final String IGNORED_TEXTURE = "notexture.png";
    private static final int animationFlyingDelayLimit = 10;
    private static final int animationDelayLimit = 3;
    static int flyingDelayLimit = 10;
    public PokemonBase transformed = null;
    public ResourceLocation transformedTexture = null;
    public PaletteParticles transformedParticles = null;
    boolean animationFlyingCounting = false;
    boolean animationFlyingSwap = false;
    boolean animationCounting = false;
    boolean animationSwap = false;
    int animationFlyingDelayCounter = 0;
    int animationDelayCounter = 0;
    int flyingDelayCounter = 0;
    protected AnimationType animationType;
    protected AnimationVariables particleVariables = new AnimationVariables();
    protected Map<ModelData, AnimationVariables> animationVariables = Maps.newHashMap();
    protected ResourceLocation overrideTexture;
    protected EvolutionStage evoStage = null;
    protected ShaderParameters shaderParameters = null;
    public int dynamaxAnimationTicks = 0;
    public static final int dynamaxAnimationTicksUp = 50;
    public static final float dynamaxAnimationTicksUpAmount = 0.02f;
    public static final int dynamaxAnimationTicksDown = 50;
    public static final float dynamaxAnimationTicksDownAmount = 0.02f;
    private int transformations = -1;
    private boolean dynamaxed = false;
    protected boolean wireFrame = false;
    protected boolean animated = false;
    protected boolean spriteModel = false;
    protected int modelSlot = 0;
    public int evolvingVal = 0;
    public int evoAnimTicks = 0;
    public int fadeCount = 0;
    private boolean fadeDirection = true;
    public float heightDiff;
    public float widthDiff;
    public float lengthDiff;
    private final float[] renderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public AbstractClientEntity(EntityType<? extends AbstractClientEntity> type, Level par1World) {
        super(type, par1World);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(SYNC_TRANSFORMATION, 0);
        this.define(SYNC_DYNAMAXED, false);
        this.define(SYNC_OVERRIDE_TEXTURE, ResourceLocationHelper.of("pixelmon:notexture.png"));
        this.define(SYNC_WIREFRAME, false);
        this.define(SYNC_ANIMATED, false);
        this.define(SYNC_MODEL_SLOT, 0);
        this.define(SYNC_SPRITE_MODEL, false);
        this.define(SYNC_EVO_STAGE, EvolutionStage.None);
        this.define(SYNC_SHADER_PARAMETERS, Optional.empty());
    }

    public boolean isWireFrame() {
        return this.wireFrame;
    }

    public void setWireFrame(boolean wireFrame) {
        SYNC_WIREFRAME.set((Entity)this, (Object)wireFrame);
    }

    public boolean isAnimated() {
        return this.animated && PixelmonConfigProxy.getGraphics().isGlobalAnimationToggle();
    }

    public void setAnimated(boolean animated) {
        SYNC_ANIMATED.set((Entity)this, (Object)animated);
    }

    public void setOverrideTexture(ResourceLocation overrideTexture) {
        SYNC_OVERRIDE_TEXTURE.set((Entity)this, (Object)overrideTexture);
    }

    @Override
    public Pokemon getPokemon() {
        Pokemon pokemon = super.getPokemon();
        if (pokemon == null) {
            this.pokemon = PokemonFactory.create(PixelmonSpecies.BULBASAUR.getValueUnsafe());
            return this.pokemon;
        }
        return pokemon;
    }

    public ResourceLocation getSprite() {
        return this.getPokemon().getPalette().getSprite();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelData[] getModel() {
        if (this.getPalette() == null) {
            ModelData[] modelData = PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getModel(this);
            if (modelData == null) {
                return null;
            }
            return modelData;
        }
        ModelData[] model = this.getPalette().getModel(this);
        if (model == null) {
            Pixelmon.LOGGER.error("Null model in species " + this.getSpecies().getName() + ", form " + this.getForm().getName() + ", palette " + this.getPalette().getName() + ", gender " + this.getGenderProperties().getGender().name());
            return null;
        }
        return model;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void transform(Species transformedModel, String transformedForm, String transformedTexture, String transformedParticles) {
        this.transformed = new PokemonBase(transformedModel, transformedModel.getForm(transformedForm), Gender.MALE);
        this.transformedTexture = ResourceLocationHelper.of(transformedTexture);
        this.transformedParticles = new PaletteParticles(ParticleSystems.get(ResourceLocationHelper.of(transformedParticles)));
    }

    public void cancelTransform() {
        this.transformed = null;
        this.transformedTexture = null;
        this.transformedParticles = null;
        this.updateTransformed();
    }

    public void updateTransformed() {
    }

    public void transformServer(Species transformedModel, String form, String texture, String particles) {
        this.transformed = new PokemonBase(transformedModel, transformedModel.getForm(form), Gender.MALE);
        this.transformedTexture = ResourceLocationHelper.of(texture);
        this.transformedParticles = new PaletteParticles(ParticleSystems.get(ResourceLocationHelper.of(particles)));
        this.updateTransformed();
    }

    public int getTransformed() {
        return this.transformations;
    }

    public float getScaleFactor() {
        if (this.getPokemon() == null || this.getPokemon().getGrowth() == null || this.getBossTier() == null) {
            return 1.0f;
        }
        return (float)Math.pow(this.getPokemon().getGrowth().scaleValue, PixelmonConfigProxy.getGeneral().getGrowthScaleModifier()) * this.getBossTier().getModelScaleFactor();
    }

    public boolean isDynamaxed() {
        return this.dynamaxed;
    }

    public void setDynamaxed(boolean dynamaxed) {
        SYNC_DYNAMAXED.set((Entity)this, (Object)dynamaxed);
        if (dynamaxed) {
            this.setShaderParameters(ShaderParameters.builder().id(ResourceLocationHelper.of("pixelmon", "rendertype_entity_smooth_cutout_fresnel")).noTexture().modelAndShader().withParameter("FresnelBias", Codec.FLOAT, Float.valueOf(0.35f)).withParameter("FresnelScale", Codec.FLOAT, Float.valueOf(20.0f)).withParameter("FresnelPower", Codec.FLOAT, Float.valueOf(0.85f)).withParameter("FresnelColor", Codec.FLOAT.listOf(), this.getSpecies().is(PixelmonSpecies.CALYREX) ? List.of(Float.valueOf(0.0f), Float.valueOf(0.25f), Float.valueOf(1.0f), Float.valueOf(0.15f)) : List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.25f), Float.valueOf(0.15f))).renderColor(new Color(1.0f, 1.0f, 1.0f, 0.1f)).build());
        } else {
            this.setShaderParameters(null);
        }
    }

    public AnimationVariables getAnimationVariables() {
        return this.getAnimationVariables(null);
    }

    public AnimationVariables getAnimationVariables(ModelData modelData) {
        if (modelData == null) {
            return this.particleVariables;
        }
        return this.animationVariables.computeIfAbsent(modelData, k -> new AnimationVariables());
    }

    public void initAnimation() {
        if (this.m_9236_().f_46443_) {
            ModelData[] base;
            for (ModelData modelData : base = this.getModel()) {
                for (ModelAttachment attachment : modelData.attachments()) {
                    attachment.model().getModel().animate();
                }
                modelData.getModel().animate();
            }
        }
    }

    protected void m_203347_(TagKey<Fluid> p_180466_1_) {
        if (!this.getPokemon().getForm().hasType(Element.WATER) && this.getPokemon().getForm().getMovement().getSwimmingParameters() == null && this.m_9236_().m_46472_() != DrownedWorld.WORLD) {
            super.m_203347_(p_180466_1_);
        }
    }

    public void checkAnimation() {
        if (this.getModel() == null) {
            return;
        }
        for (ModelData modelData : this.getModel()) {
            IncrementingVariable inc;
            AbstractClientEntity pixelmon = this;
            float f1 = pixelmon.f_267362_.f_267406_ + (pixelmon.f_267362_.m_267731_() - pixelmon.f_267362_.f_267406_) * 1.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            if ((inc = this.getAnimationVariables(modelData).getCounter(-1)) == null) {
                this.getAnimationVariables(modelData).setCounter(-1, 2.1474836E9f, modelData.animationIncrement());
            } else {
                inc.increment = modelData.animationIncrement();
            }
            for (ModelAttachment attachment : modelData.attachments()) {
                ModelData attachmentModel = attachment.model();
                IncrementingVariable attachmentInc = this.getAnimationVariables(attachmentModel).getCounter(-1);
                if (attachmentInc == null) {
                    this.getAnimationVariables(attachmentModel).setCounter(-1, 2.1474836E9f, modelData.animationIncrement());
                    continue;
                }
                attachmentInc.increment = attachmentModel.animationIncrement();
            }
            if (pixelmon instanceof StatueEntity) continue;
            if (!pixelmon.animationCounting) {
                this.setAnimation(AnimationType.IDLE);
                pixelmon.animationCounting = true;
            }
            if (pixelmon.m_20069_() && !pixelmon.m_20096_()) {
                if (f1 > modelData.movementThreshold()) {
                    if (pixelmon.animationSwap) {
                        this.setAnimation(AnimationType.SWIM);
                    }
                } else if (pixelmon.animationSwap) {
                    this.setAnimation(AnimationType.IDLE_SWIM);
                }
            } else if (!pixelmon.m_20096_()) {
                if (!pixelmon.animationFlyingSwap) {
                    pixelmon.animationFlyingCounting = true;
                }
                if (pixelmon.animationFlyingSwap) {
                    this.setAnimation(AnimationType.FLY);
                }
            } else if (f1 > modelData.movementThreshold()) {
                if (pixelmon.animationSwap) {
                    this.setAnimation(AnimationType.WALK);
                }
            } else if (pixelmon.animationSwap) {
                this.setAnimation(AnimationType.IDLE);
            }
            if (modelData.getModel() == null || modelData.getModel().currentSequence != null) continue;
            this.setAnimation(AnimationType.IDLE);
        }
    }

    public void setAnimation(AnimationType animation) {
        this.animationType = animation;
    }

    public AnimationType getCurrentAnimation() {
        if (this.animationType == null) {
            return AnimationType.IDLE;
        }
        return this.animationType;
    }

    public void m_6075_() {
        if (this.getPalette() == null) {
            return;
        }
        ModelLocator[] modelLocators = this.getPalette().getModelLocators();
        for (int i = 0; i < modelLocators.length; ++i) {
            ModelLocator modelLocator = modelLocators[i];
            if (!modelLocator.getPredicate().shouldUseModel(this)) continue;
            if (this.getModelSlot() == i) break;
            this.setModelSlot(i);
            break;
        }
        super.m_6075_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (!this.m_20145_() && !(this instanceof StatueEntity)) {
                for (ParticleEffects particleEffect : ParticleEffects.getParticleEffects(this)) {
                    particleEffect.onUpdate(this);
                }
                if (this.getPalette().getParticle() != null && this.getPalette().getParticle().m_220527_(this.f_19796_)) {
                    this.f_19853_.m_7106_(this.getPalette().getParticle().m_47419_(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
            }
            this.tickEvolveAnimation();
            if (this.isAnimated() && this.getModel() != null) {
                for (ModelData modelData : this.getModel()) {
                    for (ModelAttachment attachment : modelData.attachments()) {
                        this.getAnimationVariables(attachment.model()).tick();
                    }
                    this.getAnimationVariables(modelData).tick();
                }
            }
            if (this.animationFlyingCounting) {
                if (this.animationFlyingDelayCounter < 10) {
                    ++this.animationFlyingDelayCounter;
                    this.animationFlyingSwap = false;
                }
                if (this.animationFlyingDelayCounter >= 10) {
                    this.animationFlyingSwap = true;
                    this.animationFlyingDelayCounter = 0;
                }
            } else {
                this.animationFlyingDelayCounter = 0;
                this.animationFlyingSwap = false;
            }
            if (!this.m_20096_() && !this.m_20069_()) {
                if (this.flyingDelayCounter < flyingDelayLimit) {
                    ++this.flyingDelayCounter;
                }
            } else {
                this.flyingDelayCounter = 0;
            }
            if (this.animationCounting) {
                if (this.animationDelayCounter < 3) {
                    ++this.animationDelayCounter;
                    this.animationSwap = false;
                }
                if (this.animationDelayCounter >= 3) {
                    this.animationSwap = true;
                    this.animationDelayCounter = 0;
                }
            } else {
                this.animationDelayCounter = 0;
                this.animationSwap = false;
            }
            this.checkAnimation();
        }
    }

    public void setEvoStage(EvolutionStage evoStage) {
        SYNC_EVO_STAGE.set((Entity)this, (Object)evoStage);
        if (evoStage == EvolutionStage.End) {
            this.setShaderParameters(null);
        }
    }

    public EvolutionStage getEvoStage() {
        return this.evoStage;
    }

    public boolean isEvolving() {
        return this.getEvoStage() != null && this.getEvoStage() != EvolutionStage.End;
    }

    public void setEvolutionAnimationStage(EvolutionStage stage) {
        if (stage == EvolutionStage.End) {
            this.setEvoStage(null);
            this.updateSize();
        } else {
            this.setEvoStage(stage);
            this.evoAnimTicks = 0;
            if (stage == EvolutionStage.PreChoice) {
                this.fadeCount = 20;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickEvolveAnimation() {
        ++this.evoAnimTicks;
        if (this.evoStage == null) {
            return;
        }
        ++this.evoAnimTicks;
        Dimensions dimensions = this.getForm().getDimensions();
        if (this.evoStage == EvolutionStage.Choice) {
            if (this.fadeDirection) {
                ++this.fadeCount;
                if (this.fadeCount >= 20) {
                    this.fadeDirection = false;
                }
            } else {
                --this.fadeCount;
                if (this.fadeCount <= 0) {
                    this.fadeDirection = true;
                }
            }
        } else if (this.evoStage == EvolutionStage.PreAnimation) {
            if (this.fadeDirection) {
                if (this.fadeCount < 20) {
                    ++this.fadeCount;
                }
            } else if (this.fadeCount > 0 && this.fadeCount <= 0) {
                this.fadeDirection = true;
            }
        }
        if (this.evoStage == EvolutionStage.Choice || this.evoStage == EvolutionStage.PreAnimation) {
            Random random = RandomHelper.getRandom();
            int numEffects = random.nextInt(10);
            for (int i = 0; i < numEffects; ++i) {
                Color color = RandomHelper.getRandomHighSaturationColor();
                this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue()), 1.0f), this.m_20185_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getWidth(), this.m_20186_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getHeight(), this.m_20189_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getWidth(), 0.0, 0.0, 0.0);
            }
        }
        if (this.evoStage == EvolutionStage.PreAnimation || this.evoStage == EvolutionStage.PostAnimation) {
            if (this.evoStage == EvolutionStage.PreAnimation) {
                if (this.evoAnimTicks > EvolutionStage.PreAnimation.ticks) {
                    --this.evoAnimTicks;
                }
            } else {
                if (this.evoAnimTicks > EvolutionStage.PostAnimation.ticks) {
                    --this.evoAnimTicks;
                }
                if (this.evoAnimTicks > EvolutionStage.PostAnimation.ticks - 21 && this.fadeCount > 0) {
                    --this.fadeCount;
                }
            }
            int ticks = this.evoAnimTicks;
            if (this.evoStage == EvolutionStage.PostAnimation) {
                ticks += EvolutionStage.PreAnimation.ticks;
            }
            Random random = RandomHelper.getRandom();
            int numEffects = random.nextInt(50);
            for (int i = 0; i < numEffects; ++i) {
                Color color = RandomHelper.getRandomHighSaturationColor();
                this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue()), 1.0f), this.m_20185_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getWidth(), this.m_20186_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getHeight(), this.m_20189_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getWidth(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_6034_(double x, double y, double z) {
        this.m_20343_(x, y, z);
        if (this.f_19804_ == null) {
            return;
        }
        this.updateSize();
    }

    public float m_20236_(Pose pose) {
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        float scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
        Dimensions dimensions = this.getForm().getDimensions();
        return Math.max(0.2f, dimensions.getEyeHeight() * scale);
    }

    @Override
    public void initBaseEntity() {
        super.initBaseEntity();
        this.updateSize();
    }

    public void updateSize() {
        if (this.f_19804_ == null) {
            return;
        }
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        float scale = 1.0f;
        if (this.getForm() != null) {
            scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
            Dimensions dimensions = this.getForm().getDimensions();
            this.m_20011_(dimensions.createBoundingBox((Entity)this, scale));
            if (this.getPokemon().getGrowth() != null) {
                this.f_19816_ = dimensions.getEyeHeight() * this.getPokemon().getGrowth().scaleValue;
            }
        } else {
            float halfWidth = this.m_20205_() * scale / 2.0f;
            this.m_20011_(new AABB(this.m_20185_() - (double)halfWidth, this.m_20186_(), this.m_20189_() - (double)halfWidth, this.m_20185_() + (double)halfWidth, this.m_20186_() - (double)this.m_6049_((Entity)this) + (double)this.m_20206_() * (double)scale, this.m_20189_() + (double)halfWidth));
        }
    }

    protected SoundEvent m_7515_() {
        return this.getPokemon().getPalette().getSound();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.overrideTexture != null && !this.overrideTexture.m_135815_().contains(IGNORED_TEXTURE)) {
            nbt.m_128359_("PokeOverrideTexture", this.overrideTexture.toString());
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("PokeOverrideTexture")) {
            this.overrideTexture = ResourceLocationHelper.of(nbt.m_128461_("PokeOverrideTexture"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderColor(float ... renderColor) {
        System.arraycopy(renderColor, 0, this.renderColor, 0, 4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getRenderColor() {
        return this.renderColor;
    }

    public int getModelSlot() {
        return this.modelSlot;
    }

    public void setModelSlot(int modelSlot) {
        SYNC_MODEL_SLOT.set((Entity)this, (Object)modelSlot);
    }

    public boolean isSpriteModel() {
        return this.spriteModel;
    }

    public void setSpriteModel(boolean spriteModel) {
        SYNC_SPRITE_MODEL.set((Entity)this, (Object)spriteModel);
    }

    public ShaderParameters getShaderParameters() {
        return this.shaderParameters;
    }

    public void setShaderParameters(ShaderParameters shaderParameters) {
        SYNC_SHADER_PARAMETERS.set((Entity)this, Optional.ofNullable(shaderParameters));
    }

    @Override
    public void resetDataWatchers() {
        super.resetDataWatchers();
        SYNC_DYNAMAXED.set((Entity)this, (Object)false);
        SYNC_TRANSFORMATION.set((Entity)this, (Object)0);
        SYNC_SHADER_PARAMETERS.set((Entity)this, Optional.empty());
    }

    public int getFlyingDelayCounter() {
        return this.flyingDelayCounter;
    }

    public void animateDynamax() {
        if (!this.isDynamaxed()) {
            return;
        }
        if (this.dynamaxAnimationTicks > 0) {
            this.setPixelmonScale(this.getPixelmonScale() + 0.02f);
            --this.dynamaxAnimationTicks;
        } else if (this.dynamaxAnimationTicks < 0) {
            this.setPixelmonScale(this.getPixelmonScale() - 0.02f);
            ++this.dynamaxAnimationTicks;
            if (this.dynamaxAnimationTicks == 0) {
                if (this.isDynamaxed()) {
                    this.setDynamaxed(false);
                }
                this.setPixelmonScale(1.0f);
            }
        }
    }
}

