/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.SpeciesHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TerrainExamine;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractInteractionsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public abstract class AbstractBattleEntity
extends AbstractInteractionsEntity {
    public static final DataSync<AbstractBattleEntity, Integer> SYNC_GROUP_ID = new DataSync<AbstractBattleEntity, Integer>(AbstractBattleEntity.class, EntityDataSerializers.f_135028_, (abstractBattleEntity, integer) -> {
        abstractBattleEntity.groupId = integer;
    });
    public BattleController battleController;
    private PixelmonWrapper pixelmonWrapper;
    public List<String> relearnableEvolutionMoves = new ArrayList<String>();
    protected int groupId;

    public AbstractBattleEntity(EntityType<? extends AbstractBattleEntity> type, Level par1World) {
        super((EntityType<? extends AbstractInteractionsEntity>)type, par1World);
    }

    @Override
    protected void m_8097_() {
        this.define(SYNC_GROUP_ID, -1);
        super.m_8097_();
    }

    @Override
    public boolean m_6785_(double p_213397_1_) {
        if (this.battleController != null) {
            return false;
        }
        return super.m_6785_(p_213397_1_);
    }

    public boolean inGroup() {
        return this.groupId != -1;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        SYNC_GROUP_ID.set((Entity)this, (Object)groupId);
    }

    public void startBattle(BattleParticipant p1, BattleParticipant p2) {
        if (this.inSameFlock(p1, p2)) {
            return;
        }
        this.startBattle(p1, p2, BattleType.SINGLE);
    }

    private boolean inSameFlock(BattleParticipant p1, BattleParticipant p2) {
        if (!(p1 instanceof WildPixelmonParticipant) || !(p2 instanceof WildPixelmonParticipant)) {
            return false;
        }
        AbstractBattleEntity battleEntity1 = (AbstractBattleEntity)((WildPixelmonParticipant)p1).getEntity();
        AbstractBattleEntity battleEntity2 = (AbstractBattleEntity)((WildPixelmonParticipant)p2).getEntity();
        return battleEntity1.inGroup() && battleEntity2.inGroup() && battleEntity1.groupId == battleEntity2.groupId;
    }

    public void startBattle(BattleParticipant p1, BattleParticipant p2, BattleType battleType) {
        this.startBattle(p1, p2, new BattleRules(battleType));
    }

    public void startBattle(BattleParticipant p1, BattleParticipant p2, BattleRules rules) {
        if (this.getPokemon().getMoveset().isEmpty()) {
            this.getPokemon().getMoveset().addImmutable(this.getForm().getMoves().getMovesAtLevel(this.getPokemon().getPokemonLevel()));
        }
        for (BattleParticipant p : new BattleParticipant[]{p1, p2}) {
            if (p.countAblePokemon() > 0) continue;
            return;
        }
        try {
            p1.startedBattle = true;
            this.battleController = BattleRegistry.startBattle(new BattleParticipant[]{p1}, new BattleParticipant[]{p2}, rules);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEndBattle() {
        if (this.getPokemon().getSpecies().is(PixelmonSpecies.BURMY) && this.pixelmonWrapper != null) {
            this.updateBurmyForm();
        }
        this.battleController = null;
        this.pixelmonWrapper = null;
        this.f_21345_.m_25374_(Goal.Flag.MOVE);
        this.f_21345_.m_25374_(Goal.Flag.JUMP);
        this.f_21345_.m_25374_(Goal.Flag.TARGET);
        this.f_21345_.m_25374_(Goal.Flag.LOOK);
    }

    private void updateBurmyForm() {
        for (PixelmonWrapper pw : this.pixelmonWrapper.getOpponentPokemon()) {
            TerrainExamine.TerrainType type = TerrainExamine.getTerrain(pw);
            if (type == TerrainExamine.TerrainType.Default) continue;
            this.setForm(SpeciesHelper.getBurmyForm(type));
            return;
        }
        this.setForm(SpeciesHelper.getBurmyForm(TerrainExamine.TerrainType.Default));
    }

    @Nullable
    public NPCTrainer getTrainer() {
        LivingEntity owner = this.m_269323_();
        return owner instanceof NPCTrainer ? (NPCTrainer)owner : null;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_) {
            if ((this.getBossTier().isBoss() || this.getPokemon().isUncatchable()) && source.m_19385_().equals("mob") && !(source.m_7640_() instanceof PixelmonEntity)) {
                return false;
            }
            if (source.m_19385_().equals("player") || source.m_19385_().equals("arrow") || source.m_19385_().equals("trident")) {
                if (!PixelmonConfigProxy.getGeneral().isCanPokemonBeHit() || this.battleController != null || this.isEvolving()) {
                    return false;
                }
                amount *= 3.0f;
            }
            if (!(this.battleController == null && !this.isEvolving() || source != this.m_269291_().m_269325_() && source != this.m_269291_().m_269063_() && source != this.m_269291_().m_268989_() && source != this.m_269291_().m_269387_() && source != this.m_269291_().m_269318_() && source != this.m_269291_().m_269233_() && source != this.m_269291_().m_269549_() && source != this.m_269291_().m_269425_())) {
                return false;
            }
            boolean flag = super.m_6469_(source, amount);
            if (this.battleController == null) {
                this.updateHealth();
            }
            Entity entity = source.m_7640_();
            if (this.battleController == null && this.m_269323_() != null) {
                this.update(EnumUpdateType.HP);
            }
            if (this.isValidTarget(entity)) {
                this.m_6710_((LivingEntity)((Mob)entity));
            }
            return flag;
        }
        return false;
    }

    public List<ImmutableAttack> getAttacksAtLevel(int level) {
        return this.getForm().getMoves().getMovesAtLevel(level);
    }

    public boolean learnsAttackAtLevel(int level) {
        return !this.getForm().getMoves().getMovesAtLevel(level).isEmpty();
    }

    protected boolean isValidTarget(Entity entity) {
        return entity instanceof PixelmonEntity;
    }

    @Override
    public void m_21153_(float par1) {
        super.m_21153_(par1);
        if (this.battleController != null) {
            this.battleController.updatePokemonHealth();
        }
    }

    public BattleParticipant getParticipant() {
        if (this.battleController == null) {
            return null;
        }
        for (BattleParticipant p : this.battleController.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw.entity != this) continue;
                return p;
            }
        }
        return null;
    }

    public PixelmonWrapper getPixelmonWrapper() {
        if (this.battleController == null) {
            return null;
        }
        if (this.pixelmonWrapper != null && this.pixelmonWrapper.bc != null) {
            return this.pixelmonWrapper;
        }
        for (BattleParticipant bp : this.battleController.participants) {
            if (bp.controlledPokemon == null) continue;
            for (PixelmonWrapper pw : bp.controlledPokemon) {
                if (pw.entity != this) continue;
                this.pixelmonWrapper = pw;
                return pw;
            }
        }
        return null;
    }

    public void setPixelmonWrapper(PixelmonWrapper newWrapper) {
        this.pixelmonWrapper = newWrapper;
    }

    @Override
    public int getPartyPosition() {
        PixelmonWrapper pw;
        int partyPosition = super.getPartyPosition();
        if (partyPosition == -1 && (pw = this.getPixelmonWrapper()) != null) {
            partyPosition = pw.getPartyPosition();
        }
        return partyPosition;
    }
}

