/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.registries.PixelmonEggGroups;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBaseEntity
extends AbstractHorse {
    private static final List<Vec3i> SURROUNDING_POSITIONS = Lists.newArrayList((Object[])new Vec3i[]{new Vec3i(1, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 1, 0), new Vec3i(0, -1, 0), new Vec3i(0, 0, 1), new Vec3i(0, 0, -1)});
    public static final DataSync<? extends AbstractBaseEntity, BossTier> SYNC_BOSS_MODE = new DataSync<AbstractBaseEntity, BossTier>(AbstractBaseEntity.class, PixelmonDataSerializers.BOSS_MODE, (abstractBaseEntity, boss) -> {
        abstractBaseEntity.bossTier = boss;
    });
    public static final DataSync<? extends AbstractBaseEntity, Integer> SYNC_MAX_HP = new DataSync<AbstractBaseEntity, Integer>(AbstractBaseEntity.class, EntityDataSerializers.f_135028_, (abstractBaseEntity, maxHp) -> {});
    public static final DataSync<? extends AbstractBaseEntity, SpawnLocationType> SYNC_SPAWN_LOCATION = new DataSync<AbstractBaseEntity, SpawnLocationType>(AbstractBaseEntity.class, PixelmonDataSerializers.SPAWN_LOCATION_TYPE, (abstractBaseEntity, spawnLocation) -> {
        abstractBaseEntity.spawnLocation = spawnLocation;
    });
    public static final DataSync<? extends AbstractBaseEntity, Float> SYNC_SCALE = new DataSync<AbstractBaseEntity, Float>(AbstractBaseEntity.class, EntityDataSerializers.f_135029_, (abstractBaseEntity, scale) -> {
        abstractBaseEntity.scale = scale.floatValue();
    });
    public static final DataSync<? extends AbstractBaseEntity, Optional<UUID>> SYNC_OWNER_UUID = new DataSync<AbstractBaseEntity, Optional>(AbstractBaseEntity.class, EntityDataSerializers.f_135041_, (abstractBaseEntity, uuid) -> {
        abstractBaseEntity.ownerUUID = uuid.orElse(null);
    });
    public static final DataSync<? extends AbstractBaseEntity, Boolean> SYNC_NAMETAG_DISABLE = new DataSync<AbstractBaseEntity, Boolean>(AbstractBaseEntity.class, EntityDataSerializers.f_135035_, (abstractBaseEntity, disableNametag) -> {
        abstractBaseEntity.disableNametag = disableNametag;
    });
    public static final DataSync<? extends AbstractBaseEntity, Boolean> SYNC_SHADOW_DISABLE = new DataSync<AbstractBaseEntity, Boolean>(AbstractBaseEntity.class, EntityDataSerializers.f_135035_, (abstractBaseEntity, disableShadow) -> {
        abstractBaseEntity.disableShadow = disableShadow;
    });
    public static final DataSync<? extends AbstractBaseEntity, Boolean> SYNC_OVERLAY = new DataSync<AbstractBaseEntity, Boolean>(AbstractBaseEntity.class, EntityDataSerializers.f_135035_, (abstractBaseEntity, overlay) -> {
        abstractBaseEntity.overlay = overlay;
    });
    public static final DataSync<? extends AbstractBaseEntity, Optional<Color>> SYNC_COLOR = new DataSync<AbstractBaseEntity, Optional>(AbstractBaseEntity.class, PixelmonDataSerializers.OPTIONAL_COLOR, (abstractBaseEntity, color) -> {
        abstractBaseEntity.color = color.orElse(null);
    });
    public static final DataSync<? extends AbstractBaseEntity, Boolean> SYNC_TEXTURE_DISABLE = new DataSync<AbstractBaseEntity, Boolean>(AbstractBaseEntity.class, EntityDataSerializers.f_135035_, (abstractBaseEntity, disableTexture) -> {
        abstractBaseEntity.disableTexture = disableTexture;
    });
    public static final DataSync<? extends AbstractBaseEntity, Boolean> SYNC_FULLBRIGHT = new DataSync<AbstractBaseEntity, Boolean>(AbstractBaseEntity.class, EntityDataSerializers.f_135035_, (abstractBaseEntity, fullbright) -> {
        abstractBaseEntity.fullbright = fullbright;
    });
    protected Pokemon pokemon;
    public PokeBallEntity hitByPokeball = null;
    public boolean canDespawn = true;
    private boolean isImmuneToFire = false;
    private UUID ownerUUID;
    private boolean disableNametag;
    private boolean disableShadow;
    private boolean overlay;
    private Color color;
    private boolean disableTexture;
    private boolean fullbright;
    public Aggression aggression;
    protected SpawnLocationType spawnLocation = SpawnLocationType.LAND;
    protected BossTier bossTier = BossTierRegistry.NOT_BOSS;
    private List<EntityDataAccessor<?>> delay = Lists.newArrayList();
    protected float scale = 1.0f;
    protected EntityDataSyncManager dataSyncManager;

    public AbstractBaseEntity(EntityType<? extends AbstractBaseEntity> type, Level par1World) {
        super(type, par1World);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(PokemonBase.SYNC_POKEMON_BASE, new PokemonBase(PixelmonSpecies.BULBASAUR.getValueUnsafe()));
        this.define(Pokemon.SYNC_GROWTH, EnumGrowth.Ordinary);
        this.define(SYNC_BOSS_MODE, BossTierRegistry.NOT_BOSS);
        this.define(Pokemon.SYNC_LEVEL, -1);
        this.define(SYNC_MAX_HP, 10);
        this.define(Pokemon.SYNC_EXP, 0);
        this.define(Pokemon.SYNC_NICK_NAME, Component.m_237119_());
        this.define(SYNC_SPAWN_LOCATION, SpawnLocationType.LAND);
        this.define(Pokemon.SYNC_ENTITY_UUID, Optional.of(this.m_20148_()));
        this.define(Pokemon.SYNC_RIBBON, Ribbon.builder().type(RibbonRegistry.ISI.getValueUnsafe()).build());
        this.define(Pokemon.SYNC_FLAGS, new String[0]);
        this.define(SYNC_SCALE, Float.valueOf(1.0f));
        this.define(SYNC_OWNER_UUID, Optional.empty());
        this.define(SYNC_NAMETAG_DISABLE, false);
        this.define(SYNC_SHADOW_DISABLE, false);
        this.define(SYNC_OVERLAY, false);
        this.define(SYNC_COLOR, Optional.empty());
        this.define(SYNC_TEXTURE_DISABLE, false);
        this.define(SYNC_FULLBRIGHT, false);
        this.dataSyncManager.addRegisteredSync(Pokemon.SYNC_HEALTH);
    }

    protected <A> void define(DataSync<?, A> sync, A value) {
        if (this.dataSyncManager == null) {
            this.dataSyncManager = new EntityDataSyncManager();
        }
        this.dataSyncManager.define((Entity)this, sync, value);
    }

    public boolean m_30614_() {
        return this.m_21805_() != null && this.getForm().getMovement().isRideable();
    }

    public boolean m_21523_() {
        return this.m_30614_();
    }

    protected boolean m_7341_(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        return this.isOwnedBy((LivingEntity)entity);
    }

    public boolean m_6741_() {
        return false;
    }

    public boolean m_6254_() {
        return this.m_30614_();
    }

    public void m_213583_(Player p_218808_) {
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return this.m_7515_();
    }

    @javax.annotation.Nullable
    protected SoundEvent m_5592_() {
        return this.m_7515_();
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return this.m_7515_();
    }

    protected void m_7486_() {
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7871_() {
        return this.m_7515_();
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
    }

    protected void m_5877_(SoundType p_190680_1_) {
    }

    public void resetDataWatchers() {
        SYNC_OWNER_UUID.set((Entity)this, Optional.ofNullable(this.pokemon.getOwnerPlayerUUID()));
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)this.pokemon);
        Pokemon.SYNC_GROWTH.set((Entity)this, (Object)this.pokemon.getGrowth());
        SYNC_BOSS_MODE.set((Entity)this, (Object)(this.bossTier == null ? BossTierRegistry.NOT_BOSS : this.bossTier));
        Pokemon.SYNC_LEVEL.set((Entity)this, (Object)this.pokemon.getPokemonLevel());
        SYNC_MAX_HP.set((Entity)this, (Object)this.pokemon.getMaxHealth());
        Pokemon.SYNC_EXP.set((Entity)this, (Object)this.pokemon.getExperience());
        SYNC_SCALE.set((Entity)this, (Object)Float.valueOf(1.0f));
        Pokemon.SYNC_NICK_NAME.set((Entity)this, this.pokemon.getFormattedNickname() == null ? Component.m_237119_() : this.pokemon.getFormattedNickname());
        SYNC_SPAWN_LOCATION.set((Entity)this, (Object)this.spawnLocation);
        Pokemon.SYNC_ENTITY_UUID.set((Entity)this, Optional.of(this.pokemon.getUUID()));
        Pokemon.SYNC_RIBBON.set((Entity)this, (Object)this.pokemon.getDisplayedRibbon());
        Pokemon.SYNC_FLAGS.set((Entity)this, (Object)this.pokemon.getFlags().toArray(new String[0]));
    }

    public void setPokemon(Pokemon pokemon) {
        this.pokemon = pokemon;
        this.m_20084_(this.pokemon.getUUID());
        this.resetDataWatchers();
        this.initBaseEntity();
        this.m_21153_(pokemon.getHealth());
        if (RandomHelper.getRandomChance(this.getForm().getAggression().getPassive())) {
            this.setAggression(Aggression.PASSIVE);
        } else if (RandomHelper.getRandomChance(this.getForm().getAggression().getTimid())) {
            this.setAggression(Aggression.TIMID);
        } else if (RandomHelper.getRandomChance(this.getForm().getAggression().getAggressive())) {
            this.setAggression(Aggression.AGGRESSIVE);
        }
        if (!this.m_9236_().f_46443_ && pokemon.getPokerus() == null && PixelmonConfigProxy.getGeneral().getPokerus().isEnabled() && PixelmonConfigProxy.getGeneral().getPokerus().getSpawnRate() > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getGeneral().getPokerus().getSpawnRate())) {
            pokemon.setPokerus(new Pokerus(PokerusStrain.getRandomType()));
        }
    }

    public void m_20084_(UUID uuid) {
        super.m_20084_(uuid);
        if (this.getPokemon() == null) {
            return;
        }
        Pokemon.SYNC_ENTITY_UUID.set((Entity)this, Optional.of(uuid));
    }

    public void initBaseEntity() {
        List<Element> types = this.getForm().getTypes();
        if (this.getForm().getMovement().getSwimmingParameters() != null) {
            this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_((double)this.getForm().getMovement().getSwimmingParameters().getSwimSpeed());
        } else {
            this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(5.0);
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(0.2 + (double)this.pokemon.getStats().getSpeed() / 200.0 * 0.3);
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.pokemon.getMaxHealth());
        this.m_21051_(Attributes.f_22288_).m_22100_((double)this.m_6118_());
        this.setDimensions(new EntityDimensions((float)this.getForm().getDimensions().getWidth(), (float)this.getForm().getDimensions().getHeight() + this.getForm().getHoverHeight(), false));
        this.isImmuneToFire = types.contains(Element.FIRE) || types.contains(Element.WATER) || this.getForm().getEggGroups().contains(PixelmonEggGroups.MINERAL);
    }

    public boolean m_5825_() {
        return this.isImmuneToFire;
    }

    public void setDimensions(EntityDimensions dimensions) {
        this.f_19815_ = dimensions;
    }

    public EntityDimensions m_6972_(Pose p_213305_1_) {
        return this.f_19815_;
    }

    public boolean hasPalette() {
        return !this.getPokemon().getPalette().getName().equalsIgnoreCase("none");
    }

    public PaletteProperties getPalette() {
        return this.pokemon.getPalette();
    }

    public GenderProperties getGenderProperties() {
        return this.pokemon.getGenderProperties();
    }

    public boolean isPalette(String paletteName) {
        if (this.getPokemon() == null || this.getPalette() == null) {
            return false;
        }
        return this.getPalette().getName().equalsIgnoreCase(paletteName);
    }

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public Stats getForm() {
        if (this.getPokemon() == null) {
            return this.getSpecies().getDefaultForm();
        }
        return this.getPokemon().getForm();
    }

    public Species getSpecies() {
        if (this.pokemon == null || this.pokemon.getSpecies() == null) {
            this.m_6089_();
            return PixelmonSpecies.BULBASAUR.getValueUnsafe();
        }
        return this.pokemon.getSpecies();
    }

    public boolean isPokemon(Species ... species) {
        return this.pokemon.isPokemon(species);
    }

    @SafeVarargs
    public final boolean isPokemon(Optional<Species> ... species) {
        return this.pokemon.isPokemonOptional(species);
    }

    @SafeVarargs
    public final boolean isPokemon(RegistryValue<Species> ... species) {
        return this.pokemon.isPokemonOptional(species);
    }

    public BossTier getBossTier() {
        if (this.bossTier == null) {
            this.setBossTier(BossTierRegistry.NOT_BOSS);
        }
        return this.bossTier;
    }

    public void setBossTier(BossTier tier) {
        if (tier == null) {
            tier = BossTierRegistry.NOT_BOSS;
        }
        SYNC_BOSS_MODE.set((Entity)this, (Object)tier);
    }

    public boolean isBossPokemon() {
        return this.getBossTier().isBoss();
    }

    public boolean isLegendary() {
        return this.getPokemon() != null && this.getPokemon().isLegendary();
    }

    public Aggression getAggression() {
        if (this.aggression == null) {
            return Aggression.PASSIVE;
        }
        return this.aggression;
    }

    public void setAggression(Aggression aggression) {
        if (aggression == null) {
            aggression = Aggression.PASSIVE;
        }
        this.aggression = aggression;
    }

    public SpawnLocationType getSpawnLocation() {
        return this.spawnLocation;
    }

    public void setSpawnLocation(SpawnLocationType spawnLocation) {
        if (spawnLocation == null) {
            spawnLocation = SpawnLocationType.LAND;
        }
        SYNC_SPAWN_LOCATION.set((Entity)this, (Object)spawnLocation);
    }

    public boolean hasOwner() {
        return this.m_21805_() != null;
    }

    @javax.annotation.Nullable
    public UUID m_21805_() {
        if (this.m_9236_().f_46443_) {
            return this.ownerUUID;
        }
        return this.pokemon == null ? null : this.pokemon.getOwnerPlayerUUID();
    }

    public void m_30586_(@javax.annotation.Nullable UUID uuid) {
        SYNC_OWNER_UUID.set((Entity)this, Optional.ofNullable(uuid));
    }

    @javax.annotation.Nullable
    public LivingEntity m_269323_() {
        UUID uuid = this.m_21805_();
        return uuid == null ? null : this.m_9236_().m_46003_(uuid);
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity == this.m_269323_();
    }

    public boolean belongsTo(Player player) {
        return Objects.equals(player.m_20148_(), this.pokemon.getOwnerPlayerUUID());
    }

    public void update(EnumUpdateType ... types) {
        this.pokemon.markDirty(types);
    }

    @javax.annotation.Nullable
    public PokemonStorage getStorage() {
        return (PokemonStorage)this.pokemon.getStorageAndPosition().m_14418_();
    }

    @javax.annotation.Nullable
    public PlayerPartyStorage getPlayerParty() {
        PokemonStorage storage = this.getStorage();
        if (storage != null && storage instanceof PlayerPartyStorage) {
            return (PlayerPartyStorage)storage;
        }
        return null;
    }

    public Optional<PlayerPartyStorage> getPlayerStorage() {
        if (this.pokemon.getStorageAndPosition() != null && this.pokemon.getStorageAndPosition().m_14418_() instanceof PlayerPartyStorage) {
            return Optional.of((PlayerPartyStorage)this.pokemon.getStorageAndPosition().m_14418_());
        }
        return Optional.empty();
    }

    public Component m_7755_() {
        return Component.m_237113_((String)this.getPokemonName());
    }

    public boolean m_8077_() {
        return false;
    }

    public String getPokemonName() {
        return this.getSpecies().getName();
    }

    public String getLocalizedName() {
        return this.pokemon.getLocalizedName();
    }

    public String getNickname() {
        return this.pokemon.getDisplayName();
    }

    public float getPixelmonScale() {
        if (this.f_19804_ == null) {
            return 1.0f;
        }
        return this.scale;
    }

    public void setPixelmonScale(float scale) {
        SYNC_SCALE.set((Entity)this, (Object)Float.valueOf(scale));
    }

    public void resetAlterations(float scale) {
        this.setPixelmonScale(scale);
        this.setOverlay(false);
        this.setColor(null);
        this.setDisableTexture(false);
        this.setDisableNametag(false);
        this.setDisableShadow(false);
        this.setFullbright(false);
    }

    public String getEscapedNickname() {
        return Matcher.quoteReplacement(this.getNickname());
    }

    public boolean m_5830_() {
        if (super.m_5830_()) {
            for (Vec3i position : SURROUNDING_POSITIONS) {
                BlockHelper.getPropertyValue(this.m_9236_().m_8055_(this.m_20183_().m_121955_(position)), BlockStateProperties.f_61442_).ifPresent(t -> this.m_6034_(this.m_20185_() + (double)position.m_123341_(), this.m_20186_() + (double)position.m_123342_(), this.m_20189_() + (double)position.m_123343_()));
            }
            return super.m_5830_();
        }
        return false;
    }

    public ItemStack m_21205_() {
        return this.pokemon.getHeldItem();
    }

    public boolean m_6094_() {
        return true;
    }

    public int m_146764_() {
        return 0;
    }

    public boolean m_6785_(double p_213397_1_) {
        return true;
    }

    @javax.annotation.Nullable
    public Entity m_5489_(ServerLevel p_241206_1_) {
        return null;
    }

    @javax.annotation.Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public boolean m_6573_(Player player) {
        return this.m_269323_() == player;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() == this.m_269323_()) {
            this.pokemon.decreaseFriendship(20);
        }
        return super.m_6469_(source, amount);
    }

    public void m_8038_(ServerLevel world, LightningBolt bolt) {
        if (PixelmonSpecies.MAGIKARP.isInitialized() && Objects.equals(this.getSpecies(), PixelmonSpecies.MAGIKARP.getValueUnsafe())) {
            this.getPokemon().setPalette("roasted");
        } else {
            super.m_8038_(world, bolt);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (this.getSpawnLocation() == SpawnLocationType.WATER) {
            return false;
        }
        return super.m_142535_(distance, damageMultiplier, source);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.pokemon.writeToNBT(nbt);
        if (this.m_21805_() != null) {
            nbt.m_128362_("Owner", this.m_21805_());
        } else {
            nbt.m_128473_("Owner");
        }
        if (this.aggression != null && this.aggression != Aggression.PASSIVE) {
            nbt.m_128344_("Aggression", (byte)this.aggression.ordinal());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128403_("Owner")) {
            this.m_30586_(nbt.m_128342_("Owner"));
        }
        if (this.pokemon == null) {
            this.pokemon = PokemonFactory.create(UUID.randomUUID());
            this.m_20084_(this.pokemon.getUUID());
        }
        this.pokemon.readFromNBT(nbt);
        this.resetDataWatchers();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.pokemon.getMaxHealth());
        this.m_21051_(Attributes.f_22279_).m_22100_(0.55);
        this.aggression = nbt.m_128441_("Aggression") ? Aggression.getAggression(nbt.m_128445_("Aggression")) : Aggression.PASSIVE;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        DataSync<?, ?> dataSync;
        if (this.getPokemon() == null && this.dataSyncManager.isRegistered(key)) {
            if (key.m_135015_() == PokemonBase.SYNC_POKEMON_BASE.getParameterId()) {
                PokemonBase base = (PokemonBase)this.f_19804_.m_135370_(PokemonBase.SYNC_POKEMON_BASE.getEntityDataAccessor());
                this.pokemon = base.toPokemon();
                for (EntityDataAccessor<?> dataParameter : this.delay) {
                    this.dataSyncManager.getSync(dataParameter).onSyncedDataUpdated(dataParameter, (Entity)this);
                }
            } else {
                if (this.delay == null) {
                    this.delay = Lists.newArrayList();
                }
                this.delay.add(key);
                return;
            }
        }
        if ((dataSync = this.dataSyncManager.getSync(key)) != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }

    public boolean isDisableNametag() {
        return this.disableNametag;
    }

    public void setDisableNametag(boolean disableNametag) {
        SYNC_NAMETAG_DISABLE.set((Entity)this, (Object)disableNametag);
    }

    public boolean isDisableShadow() {
        return this.disableShadow;
    }

    public void setDisableShadow(boolean disableShadow) {
        SYNC_SHADOW_DISABLE.set((Entity)this, (Object)disableShadow);
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setOverlay(boolean overlay) {
        SYNC_OVERLAY.set((Entity)this, (Object)overlay);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        SYNC_COLOR.set((Entity)this, Optional.ofNullable(color));
    }

    public boolean isDisableTexture() {
        return this.disableTexture;
    }

    public void setDisableTexture(boolean disableTexture) {
        SYNC_TEXTURE_DISABLE.set((Entity)this, (Object)disableTexture);
    }

    public boolean isFullbright() {
        return this.fullbright;
    }

    public void setFullbright(boolean fullbright) {
        SYNC_FULLBRIGHT.set((Entity)this, (Object)fullbright);
    }
}

