/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class ShopItemWithVariation {
    private float variation;
    private ShopItem shopItem;

    public ShopItemWithVariation(ShopItem shopItem, float variation) {
        this.shopItem = shopItem;
        this.variation = variation;
    }

    public ShopItemWithVariation(ShopItem item) {
        this(item, item.canPriceVary() ? ShopItemWithVariation.getVariation() : 1.0f);
    }

    private static float getVariation() {
        float rand = RandomHelper.getRandomNumberBetween(0.0f, 1.0f);
        float variation = 1.0f;
        if ((double)rand > 0.75) {
            variation = 1.1f;
        } else if ((double)rand < 0.25) {
            variation = 0.9f;
        }
        return variation;
    }

    public void writeToNBT(ListTag list) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("ItemName", this.shopItem.getBaseItem().id);
        tag.m_128350_("ItemVar", this.variation);
        list.add((Object)tag);
    }

    public static ShopItemWithVariation getFromNBT(String npcIndex, CompoundTag tag) {
        ShopItem item = ServerNPCRegistry.shopkeepers.getItem(npcIndex, tag.m_128461_("ItemName"));
        if (item == null) {
            return null;
        }
        return new ShopItemWithVariation(item, tag.m_128457_("ItemVar"));
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.shopItem.getBaseItem().id);
        buffer.m_130055_(this.shopItem.getBaseItem().itemStack);
        buffer.writeInt((int)((float)this.getBaseShopItem().buy * this.shopItem.getBuyMultiplier() * this.variation));
        buffer.writeInt((int)((float)this.getBaseShopItem().sell * this.variation));
    }

    public ItemStack getItemStack() {
        return this.shopItem.getItemStack();
    }

    public BaseShopItem getBaseShopItem() {
        return this.shopItem.getBaseItem();
    }

    public boolean canSell() {
        return this.shopItem.getBaseItem().sell != -1;
    }

    public int getBuyCost() {
        return (int)Math.max(0.0f, (float)this.getBaseShopItem().buy * this.shopItem.getBuyMultiplier() * this.variation);
    }

    public int getSellCost() {
        return (int)((float)this.getBaseShopItem().sell * this.variation);
    }
}

