/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.api.SpecificationTypeAdapter;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GymNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ITrainerData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryShopkeepers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryVillagers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerData;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class ServerNPCRegistry {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(PokemonSpecification.class, new SpecificationTypeAdapter(PokemonSpecification.class)).create();
    public static String en_us = "en_us";
    public static HashMap<String, NPCRegistryData> data = new HashMap();
    private static List<Pair<ResourceLocation, String>> readNPCs = Lists.newArrayList();
    public static NPCRegistryTrainers trainers = new NPCRegistryTrainers();
    public static NPCRegistryVillagers villagers = new NPCRegistryVillagers();
    public static NPCRegistryShopkeepers shopkeepers = new NPCRegistryShopkeepers();
    private static String configJson;

    public static void clear() {
        data.clear();
    }

    public static void register(Gson gson, ResourceLocation rl, JsonElement json) {
        String[] kv;
        String path = rl.m_135815_();
        if (path.contains("_") && (kv = path.replace(".json", "").split("/")).length == 2) {
            String k = kv[0];
            String v = kv[1];
            String[] split = v.split("_");
            if (split.length > 3) {
                String[] auxArray = split;
                split = new String[3];
                int difference = auxArray.length - 3;
                for (int i = 0; i <= difference; ++i) {
                    split[0] = (String)(i > 0 ? split[0] + "_" : "") + auxArray[i];
                }
                split[1] = auxArray[auxArray.length - 2];
                split[2] = auxArray[auxArray.length - 1];
            }
            if (split.length == 3) {
                Pair extracted = Pair.of((Object)rl, (Object)json.toString());
                if (!readNPCs.contains(extracted)) {
                    readNPCs.add((Pair<ResourceLocation, String>)extracted);
                }
                String name = split[0];
                String locale = split[1] + "_" + split[2];
                NPCRegistryData data = ServerNPCRegistry.getData(locale);
                switch (k) {
                    case "gyms": {
                        ServerNPCRegistry.loadGymNPC(data, name, json);
                        break;
                    }
                    case "shopkeepers": {
                        shopkeepers.loadShopkeeper(data, name, json);
                        break;
                    }
                    case "trainers": {
                        trainers.loadTrainer(data, name, json);
                        break;
                    }
                    case "villagers": {
                        villagers.loadVillager(data, name, json);
                    }
                }
            }
        }
    }

    public static void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(configJson);
    }

    public static void encodeNPCs(FriendlyByteBuf buffer, int current, int totalPackets) {
        buffer.writeInt(readNPCs.size() / totalPackets);
        for (int i = current * (readNPCs.size() / totalPackets); i < (current + 1) * (readNPCs.size() / totalPackets); ++i) {
            Pair<ResourceLocation, String> readNPC = readNPCs.get(i);
            buffer.m_130085_((ResourceLocation)readNPC.getFirst());
            buffer.m_130070_((String)readNPC.getSecond());
        }
    }

    public static void decode(FriendlyByteBuf buffer) {
        ServerNPCRegistry.clear();
        ServerNPCRegistry.readTrainerTypes((JsonElement)GSON.fromJson(buffer.m_130277_(), JsonElement.class));
    }

    public static void decodeNPCs(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation resourceLocation = buffer.m_130281_();
            String json = buffer.m_130277_();
            JsonElement jsonElement = (JsonElement)GSON.fromJson(json, JsonElement.class);
            ServerNPCRegistry.register(GSON, resourceLocation, jsonElement);
        }
    }

    public static NPCRegistryData getData(String locale) {
        return data.computeIfAbsent(locale.toLowerCase(Locale.ROOT), s -> new NPCRegistryData(locale));
    }

    public static void readTrainerTypes(JsonElement element) {
        configJson = element.toString();
        NPCRegistryData thisData = ServerNPCRegistry.getData("en_us");
        JsonObject object = element.getAsJsonObject();
        JsonArray typesArray = object.get("types").getAsJsonArray();
        BaseTrainer._index = 0;
        for (int i = 0; i < typesArray.size(); ++i) {
            JsonObject npcType = typesArray.get(i).getAsJsonObject();
            String name = npcType.get("name").getAsString();
            BaseTrainer trainer = new BaseTrainer(name);
            JsonArray texturesArray = npcType.has("textures") ? npcType.get("textures").getAsJsonArray() : new JsonArray();
            for (int j = 0; j < texturesArray.size(); ++j) {
                trainer.addTexture(texturesArray.get(j).getAsString());
            }
            thisData.trainerTypes.add(trainer);
            if (!trainer.name.equals("Steve")) continue;
            NPCRegistryTrainers.Steve = trainer;
        }
    }

    private static void loadGymNPC(NPCRegistryData thisData, String name, JsonElement element) {
        try {
            JsonObject jsonelement1;
            int i;
            JsonArray jsonarray;
            JsonObject json = element.getAsJsonObject();
            GymNPCData data = new GymNPCData(name);
            data.type = EnumNPCType.getFromString(json.get("npctype").getAsString());
            if (json.has("winnings")) {
                data.winnings = json.get("winnings").getAsInt();
            }
            if (json.has("skins")) {
                jsonarray = json.get("skins").getAsJsonArray();
                for (i = 0; i < jsonarray.size(); ++i) {
                    jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    String skin = jsonelement1.get("filename").getAsString();
                    data.addTexture(skin);
                }
            }
            if (json.has("names")) {
                jsonarray = json.get("names").getAsJsonArray();
                for (i = 0; i < jsonarray.size(); ++i) {
                    jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    String npcname = jsonelement1.get("name").getAsString();
                    data.addName(npcname);
                }
            }
            if (json.has("chat")) {
                if (data.type == EnumNPCType.ChattingNPC) {
                    jsonarray = json.get("chat").getAsJsonArray();
                    for (i = 0; i < jsonarray.size(); ++i) {
                        jsonelement1 = jsonarray.get(i).getAsJsonObject();
                        JsonArray lines = jsonelement1.get("lines").getAsJsonArray();
                        ArrayList<String> lineList = new ArrayList<String>();
                        for (int j = 0; j < lines.size(); ++j) {
                            JsonObject object = lines.get(j).getAsJsonObject();
                            String text = object.get("text").getAsString();
                            lineList.add(text);
                        }
                        String[] lineArray = new String[lineList.size()];
                        lineArray = lineList.toArray(lineArray);
                        data.addChat(lineArray);
                    }
                } else if (data.type == EnumNPCType.Trainer) {
                    jsonarray = json.get("chat").getAsJsonArray();
                    for (i = 0; i < jsonarray.size(); ++i) {
                        jsonelement1 = jsonarray.get(i).getAsJsonObject();
                        String opening = jsonelement1.get("opening").getAsString();
                        String win = jsonelement1.get("win").getAsString();
                        String lose = jsonelement1.get("lose").getAsString();
                        data.addChat(opening, win, lose);
                    }
                }
            }
            thisData.gymnpcs.put(data.id, data);
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Error in gym " + name + "_" + thisData.locale, (Throwable)e);
        }
    }

    public static GymNPCData getGymMember(String id) {
        GymNPCData npc = null;
        npc = ServerNPCRegistry.data.get((Object)ServerNPCRegistry.en_us).gymnpcs.get(id);
        return npc;
    }

    public static String getRandomName() {
        List<TrainerData> list = null;
        while (list == null) {
            NPCRegistryData npcData = data.get(en_us);
            BaseTrainer trainer = RandomHelper.getRandomElementFromList(npcData.trainerTypes);
            list = npcData.trainers.get(trainer);
        }
        TrainerData td = (TrainerData)RandomHelper.getRandomElementFromList(list);
        return RandomHelper.getRandomElementFromList(td.names);
    }

    public static GymNPCData getTranslatedGymMemberData(String langCode, String id) {
        NPCRegistryData npcRegistryData = data.get(langCode.toLowerCase(Locale.ROOT));
        if (npcRegistryData == null) {
            return ServerNPCRegistry.data.get((Object)ServerNPCRegistry.en_us).gymnpcs.get(id);
        }
        GymNPCData npc = npcRegistryData.gymnpcs.get(id);
        if (npc == null) {
            npc = ServerNPCRegistry.data.get((Object)ServerNPCRegistry.en_us).gymnpcs.get(id);
        }
        return npc;
    }

    public static String getTranslatedGymMemberName(String langCode, String id, int index) {
        ArrayList<String> names = ServerNPCRegistry.getTranslatedGymMemberData((String)langCode.toLowerCase((Locale)Locale.ROOT), (String)id).names;
        if (index >= names.size()) {
            index = 0;
        }
        return names.get(index);
    }

    public static String[] getTranslatedGymMemberChat(String langCode, String id, int index) {
        ArrayList<String[]> chat = ServerNPCRegistry.getTranslatedGymMemberData((String)langCode.toLowerCase((Locale)Locale.ROOT), (String)id).chat;
        if (index >= chat.size()) {
            index = 0;
        }
        return chat.get(index);
    }

    public static void extractFile(String resourceName, File npcsDir, String filename) {
        File file = new File(npcsDir, filename);
        if (file.exists()) {
            return;
        }
        try {
            InputStream internal = ServerNPCRegistry.class.getResourceAsStream(resourceName);
            FileOutputStream external = new FileOutputStream(file);
            IOUtils.copy((InputStream)internal, (OutputStream)external);
            internal.close();
            ((OutputStream)external).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ITrainerData getTranslatedData(String langCode, BaseTrainer baseTrainer, String id) {
        ITrainerData data = null;
        data = trainers.getTranslatedData(langCode, baseTrainer, id);
        if (data == null) {
            data = ServerNPCRegistry.getTranslatedGymMemberData(langCode, id);
        }
        return data;
    }

    public static ArrayList<GeneralNPCData> getEnglishNPCs() {
        return ServerNPCRegistry.data.get((Object)ServerNPCRegistry.en_us).npcs;
    }

    public static ArrayList<ShopkeeperData> getEnglishShopkeepers() {
        return ServerNPCRegistry.data.get((Object)ServerNPCRegistry.en_us).shopkeepers;
    }
}

