/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class NPCRegistryTrainers {
    public static BaseTrainer Steve;

    void loadTrainer(NPCRegistryData thisData, String name, JsonElement element) {
        try {
            JsonObject jsonelement1;
            JsonArray jsonarray;
            TrainerData data = new TrainerData(name);
            JsonObject json = element.getAsJsonObject();
            if (json.has("data")) {
                JsonObject object = json.get("data").getAsJsonObject();
                String trainerType = object.get("trainerType").getAsString();
                data.trainerType = this.get(trainerType);
                data.minLevel = object.get("minLevel").getAsInt();
                data.maxLevel = object.get("maxLevel").getAsInt();
                data.minPartyPokemon = object.get("minPartyPokemon").getAsInt();
                data.maxPartyPokemon = object.get("maxPartyPokemon").getAsInt();
                data.winnings = object.get("winnings").getAsInt();
            }
            if (json.has("names")) {
                jsonarray = json.get("names").getAsJsonArray();
                for (int i = 0; i < jsonarray.size(); ++i) {
                    jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    String npcname = jsonelement1.get("name").getAsString();
                    data.addName(npcname);
                }
            }
            if (json.has("pokemon")) {
                jsonarray = json.get("pokemon").getAsJsonArray();
                for (int i = 0; i < jsonarray.size(); ++i) {
                    String pokename;
                    jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    if (jsonelement1.has("ndex")) {
                        Integer pokenumber = jsonelement1.get("ndex").getAsInt();
                        if (pokenumber == null) continue;
                        PokemonBase pokemonForm = new PokemonBase(PixelmonSpecies.fromNationalDex(pokenumber));
                        String formKey = "form";
                        if (jsonelement1.has(formKey)) {
                            pokemonForm.setForm(jsonelement1.get(formKey).getAsString());
                        }
                        data.addPokemon(pokemonForm);
                        continue;
                    }
                    if (!jsonelement1.has("name") || (pokename = jsonelement1.get("name").getAsString()) == null) continue;
                    PixelmonSpecies.fromName(pokename).ifInitialized(species -> {
                        PokemonBase pokemonForm = new PokemonBase((Species)species);
                        String formKey = "form";
                        if (jsonelement1.has(formKey)) {
                            pokemonForm.setForm(jsonelement1.get(formKey).getAsString());
                        }
                        data.addPokemon(pokemonForm);
                    });
                }
            }
            if (json.has("chat")) {
                jsonarray = json.get("chat").getAsJsonArray();
                for (int i = 0; i < jsonarray.size(); ++i) {
                    jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    String opening = jsonelement1.get("opening").getAsString();
                    String win = jsonelement1.get("win").getAsString();
                    String lose = jsonelement1.get("lose").getAsString();
                    data.addChat(opening, win, lose);
                }
            }
            thisData.trainers.computeIfAbsent(data.trainerType, ___ -> Lists.newArrayList()).add(data);
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Error in trainer " + name + "_" + thisData.locale, (Throwable)e);
        }
    }

    public boolean has(String trainerName) {
        NPCRegistryData trainerData = ServerNPCRegistry.data.get(ServerNPCRegistry.en_us);
        if (trainerData != null) {
            for (BaseTrainer trainer : ServerNPCRegistry.data.get((Object)ServerNPCRegistry.en_us).trainerTypes) {
                if (!trainer.name.equalsIgnoreCase(trainerName)) continue;
                return true;
            }
        }
        return false;
    }

    public BaseTrainer get(String trainerName) {
        NPCRegistryData npcRegistryData = ServerNPCRegistry.data.get(ServerNPCRegistry.en_us);
        if (npcRegistryData != null) {
            for (BaseTrainer trainer : npcRegistryData.trainerTypes) {
                if (!trainer.name.equalsIgnoreCase(trainerName)) continue;
                return trainer;
            }
        }
        return null;
    }

    public BaseTrainer getById(int id) {
        NPCRegistryData englishData = ServerNPCRegistry.data.get(ServerNPCRegistry.en_us);
        if (englishData != null) {
            for (BaseTrainer trainer : englishData.trainerTypes) {
                if (trainer.id != id) continue;
                return trainer;
            }
        }
        return Steve;
    }

    public BaseTrainer getRandomBase() {
        return this.getById(RandomHelper.getRandomNumberBetween(0, BaseTrainer._index - 1));
    }

    public TrainerData getRandomData(BaseTrainer trainer) {
        if (trainer == null) {
            return null;
        }
        List<TrainerData> list = ServerNPCRegistry.data.get((Object)ServerNPCRegistry.en_us).trainers.get(trainer);
        if (list == null) {
            return null;
        }
        TrainerData td = RandomHelper.getRandomElementFromCollection(list);
        return td;
    }

    public TrainerData getRandomData(String name) {
        BaseTrainer trainer = this.get(name);
        return this.getRandomData(trainer);
    }

    public BaseTrainer getRandomBaseWithData() {
        TrainerData data = null;
        BaseTrainer t = null;
        while (data == null) {
            t = this.getRandomBase();
            data = this.getRandomData(t.name);
        }
        return t;
    }

    public static BaseTrainer getByName(String name) {
        NPCRegistryData data = ServerNPCRegistry.data.get(ServerNPCRegistry.en_us);
        if (data != null) {
            for (BaseTrainer trainer : data.trainerTypes) {
                if (!trainer.name.equalsIgnoreCase(name)) continue;
                return trainer;
            }
        }
        return Steve;
    }

    public TrainerData getTranslatedData(String langCode, BaseTrainer baseTrainer, String id) {
        String lowerLangCode = langCode.toLowerCase(Locale.ROOT);
        TrainerData trainer = this.findTrainerData(lowerLangCode, baseTrainer, id);
        if (trainer != null) {
            return trainer;
        }
        return this.findTrainerData(ServerNPCRegistry.en_us, baseTrainer, id);
    }

    private TrainerData findTrainerData(String langCode, BaseTrainer baseTrainer, String id) {
        List<TrainerData> trainerData;
        NPCRegistryData npcData = ServerNPCRegistry.data.get(langCode);
        if (npcData != null && (trainerData = npcData.trainers.get(baseTrainer)) != null) {
            for (TrainerData trainer : trainerData) {
                if (!trainer.id.equals(id)) continue;
                return trainer;
            }
        }
        return null;
    }

    public String getTranslatedRandomName(String langCode, BaseTrainer baseTrainer, String id) {
        try {
            ArrayList<String> names = this.getTranslatedData((String)langCode.toLowerCase((Locale)Locale.ROOT), (BaseTrainer)baseTrainer, (String)id).names;
            return RandomHelper.getRandomElementFromList(names);
        }
        catch (NullPointerException e) {
            return "Steve";
        }
    }

    public ArrayList<BaseTrainer> getTypes() {
        return ServerNPCRegistry.data == null || ServerNPCRegistry.data.get(ServerNPCRegistry.en_us) == null ? new ArrayList<BaseTrainer>() : ServerNPCRegistry.data.get((Object)ServerNPCRegistry.en_us).trainerTypes;
    }
}

