/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperChat;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperData;
import com.pixelmonmod.pixelmon.enums.EnumShopKeeperType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class NPCRegistryShopkeepers {
    public static HashMap<String, BaseShopItem> shopItems = new HashMap();

    void loadShopkeeper(NPCRegistryData thisData, String name, JsonElement element) {
        try {
            JsonArray jsonarray;
            ShopkeeperData data = new ShopkeeperData(name);
            JsonObject json = element.getAsJsonObject();
            if (json.has("data")) {
                JsonObject object = json.get("data").getAsJsonObject();
                object.get("type").getAsString();
                data.type = EnumShopKeeperType.getFromString(object.get("type").getAsString());
                if (object.has("biomes")) {
                    JsonArray biomearray = object.get("biomes").getAsJsonArray();
                    for (int i = 0; i < biomearray.size(); ++i) {
                        data.addBiome(biomearray.get(i).getAsString());
                    }
                }
            }
            if (json.has("textures")) {
                jsonarray = json.get("textures").getAsJsonArray();
                for (int i = 0; i < jsonarray.size(); ++i) {
                    JsonObject jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    String skin = jsonelement1.get("name").getAsString();
                    data.addTexture(skin);
                }
            }
            if (json.has("names")) {
                jsonarray = json.get("names").getAsJsonArray();
                for (int i = 0; i < jsonarray.size(); ++i) {
                    JsonObject jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    String npcname = jsonelement1.get("name").getAsString();
                    data.addName(npcname);
                }
            }
            if (json.has("chat")) {
                jsonarray = json.get("chat").getAsJsonArray();
                for (int i = 0; i < jsonarray.size(); ++i) {
                    JsonObject jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    String hello = jsonelement1.get("hello").getAsString();
                    String goodbye = jsonelement1.get("goodbye").getAsString();
                    data.addChat(hello, goodbye);
                }
            }
            if (json.has("items")) {
                jsonarray = json.get("items").getAsJsonArray();
                for (int i = 0; i < jsonarray.size(); ++i) {
                    JsonObject jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    String itemName = jsonelement1.get("name").getAsString();
                    float multi = 1.0f;
                    if (jsonelement1.has("multi")) {
                        multi = jsonelement1.get("multi").getAsFloat();
                    }
                    float rarity = 1.0f;
                    if (jsonelement1.has("rarity")) {
                        rarity = jsonelement1.get("rarity").getAsFloat();
                    }
                    boolean canPriceVary = true;
                    if (jsonelement1.has("variation")) {
                        canPriceVary = jsonelement1.get("variation").getAsBoolean();
                    }
                    if (!shopItems.containsKey(itemName)) {
                        Pixelmon.LOGGER.info("Item mismatch: no item found for " + itemName + " in " + name + "_" + thisData.locale + ".json");
                        continue;
                    }
                    ShopItem item = new ShopItem(shopItems.get(itemName), multi, rarity, canPriceVary);
                    data.addItem(item);
                }
            }
            thisData.shopkeepers.add(data);
            if (data.type == EnumShopKeeperType.Spawn) {
                thisData.shopkeeperSpawns.add(data);
            }
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Error in shopkeeper " + name + "_" + thisData.locale, (Throwable)e);
        }
    }

    public void registerShopItems(JsonElement element) {
        Pixelmon.LOGGER.info("Registering shop items.");
        JsonObject json = element.getAsJsonObject();
        if (json.has("items")) {
            JsonArray jsonarray = json.get("items").getAsJsonArray();
            for (int i = 0; i < jsonarray.size(); ++i) {
                JsonObject itemElement = jsonarray.get(i).getAsJsonObject();
                String name = itemElement.get("name").getAsString();
                String id = null;
                id = itemElement.has("id") ? itemElement.get("id").getAsString() : name;
                int buy = -1;
                if (itemElement.has("buy")) {
                    buy = itemElement.get("buy").getAsInt();
                }
                int sell = -1;
                if (itemElement.has("sell")) {
                    sell = itemElement.get("sell").getAsInt();
                }
                String nbtData = null;
                if (itemElement.has("nbtData")) {
                    nbtData = itemElement.get("nbtData").isJsonPrimitive() ? itemElement.get("nbtData").getAsString() : itemElement.get("nbtData").getAsJsonObject().toString();
                }
                Item item = null;
                ResourceLocation loc = ResourceLocationHelper.of(name);
                item = (Item)ForgeRegistries.ITEMS.getValue(loc);
                if (item == null) {
                    Pixelmon.LOGGER.info("Item not found: " + name + " in shopItems.json");
                    continue;
                }
                ItemStack itemStack = new ItemStack((ItemLike)item, 1, new CompoundTag());
                if (nbtData != null) {
                    try {
                        itemStack.m_41751_(TagParser.m_129359_((String)nbtData));
                    }
                    catch (Exception e) {
                        Pixelmon.LOGGER.error("Failed to parse item NBT: " + nbtData);
                    }
                }
                BaseShopItem baseItem = new BaseShopItem(id, itemStack, buy, sell);
                shopItems.put(id, baseItem);
            }
        }
    }

    public ShopkeeperData getRandom() {
        ShopkeeperData sk = null;
        NPCRegistryData data = ServerNPCRegistry.data.get(ServerNPCRegistry.en_us);
        if (data == null) {
            return null;
        }
        while (sk == null) {
            sk = RandomHelper.getRandomElementFromList(data.shopkeepers);
        }
        return sk;
    }

    public ShopkeeperData getById(String id) {
        for (ShopkeeperData sk : ServerNPCRegistry.getEnglishShopkeepers()) {
            if (!sk.id.equalsIgnoreCase(id)) continue;
            return sk;
        }
        return null;
    }

    public ShopkeeperData getRandom(EnumShopKeeperType type) {
        ShopkeeperData sk = null;
        NPCRegistryData npcData = ServerNPCRegistry.data.get(ServerNPCRegistry.en_us);
        if (npcData == null) {
            return null;
        }
        boolean hasType = false;
        for (ShopkeeperData shopkeeperData : npcData.shopkeepers) {
            if (shopkeeperData == null || shopkeeperData.type != type) continue;
            hasType = true;
            break;
        }
        if (!hasType) {
            return null;
        }
        while (sk == null || sk.type != type) {
            sk = RandomHelper.getRandomElementFromList(npcData.shopkeepers);
        }
        return sk;
    }

    @Nullable
    public ShopkeeperData getTranslatedData(String langCode, String id) {
        NPCRegistryData npcData = ServerNPCRegistry.data.get(langCode);
        if (npcData != null) {
            for (ShopkeeperData npc : npcData.shopkeepers) {
                if (!npc.id.equals(id)) continue;
                return npc;
            }
        }
        for (ShopkeeperData npc : ServerNPCRegistry.getEnglishShopkeepers()) {
            if (!npc.id.equals(id)) continue;
            return npc;
        }
        return null;
    }

    public ShopkeeperChat getTranslatedChat(String langCode, String npcIndex, int index) {
        List chat;
        ShopkeeperData translatedData = this.getTranslatedData(langCode.toLowerCase(Locale.ROOT), npcIndex);
        List<Object> list = chat = translatedData != null ? translatedData.chat : Collections.emptyList();
        if (index >= chat.size()) {
            index = 0;
        }
        return (ShopkeeperChat)chat.get(index);
    }

    public String getJsonName(String npcIndex) {
        for (ShopkeeperData npc : ServerNPCRegistry.getEnglishShopkeepers()) {
            if (!npc.id.equals(npcIndex)) continue;
            return npc.id;
        }
        return "";
    }

    public ShopkeeperData getNext(String npcIndex) {
        ArrayList<ShopkeeperData> shopkeepers = ServerNPCRegistry.getEnglishShopkeepers();
        int numShopkeepers = shopkeepers.size();
        for (int i = 0; i < numShopkeepers; ++i) {
            ShopkeeperData npc = (ShopkeeperData)shopkeepers.get(i);
            if (!npc.id.equals(npcIndex)) continue;
            if (i < numShopkeepers - 1) {
                return (ShopkeeperData)shopkeepers.get(i + 1);
            }
            return (ShopkeeperData)shopkeepers.get(0);
        }
        return (ShopkeeperData)shopkeepers.get(0);
    }

    public ShopItem getItem(String npcIndex, String itemID) {
        ShopkeeperData shopkeeper = this.getById(npcIndex);
        return shopkeeper == null ? null : shopkeeper.getItem(itemID);
    }

    public BaseShopItem getItem(String name) {
        BaseShopItem item;
        if (name == null) {
            return null;
        }
        if (name.startsWith("item.")) {
            name = name.replace("item.", "");
        }
        if ((item = shopItems.get(name)) == null && PixelmonConfigProxy.getGeneral().getDebug().isVerbose()) {
            Pixelmon.LOGGER.info("Missing item requested: " + name);
        }
        return shopItems.get(name);
    }

    public BaseShopItem getItem(ItemStack itemStack) {
        for (BaseShopItem shopItem : shopItems.values()) {
            if (!ItemStack.m_150942_((ItemStack)shopItem.itemStack, (ItemStack)itemStack)) continue;
            return shopItem;
        }
        return null;
    }

    public String getTranslatedName(String langCode, String npcIndex, int nameIndex) {
        ArrayList names;
        ShopkeeperData translatedData = this.getTranslatedData(langCode.toLowerCase(Locale.ROOT), npcIndex);
        ArrayList arrayList = names = translatedData != null ? translatedData.names : new ArrayList();
        if (nameIndex >= names.size()) {
            nameIndex = 0;
        }
        if (names.size() == 0) {
            return "";
        }
        return (String)names.get(nameIndex);
    }

    public boolean hasRoaming() {
        NPCRegistryData data = ServerNPCRegistry.data.get(ServerNPCRegistry.en_us);
        return data == null ? false : !data.shopkeeperSpawns.isEmpty();
    }

    public ShopkeeperData getRandomSpawning(String biomeID) {
        ArrayList<ShopkeeperData> keepers = new ArrayList<ShopkeeperData>();
        for (ShopkeeperData data : ServerNPCRegistry.data.get((Object)ServerNPCRegistry.en_us).shopkeeperSpawns) {
            if (!data.biomes.contains(biomeID)) continue;
            keepers.add(data);
        }
        ShopkeeperData sk = null;
        if (!keepers.isEmpty()) {
            while (sk == null) {
                sk = (ShopkeeperData)RandomHelper.getRandomElementFromList(keepers);
            }
        }
        return sk;
    }

    public String[] getRoamingBiomes() {
        ArrayList<String> biomeNames = new ArrayList<String>();
        for (ShopkeeperData data : ServerNPCRegistry.data.get((Object)ServerNPCRegistry.en_us).shopkeeperSpawns) {
            for (String biome : data.biomes) {
                if (biomeNames.contains(biome)) continue;
                biomeNames.add(biome);
            }
        }
        return biomeNames.toArray(new String[biomeNames.size()]);
    }
}

