/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.drops.PokemonDropInformation;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.raids.WeightedItemStacks;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHoldsItemsEntity;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalRecords;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import com.pixelmonmod.pixelmon.items.heldItems.BlankTechnicalMachineItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class DropItemRegistry {
    public static ArrayList<ItemStack> tier1 = new ArrayList();
    public static ArrayList<ItemStack> tier2 = new ArrayList();
    public static ArrayList<ItemStack> tier3 = new ArrayList();
    public static ArrayList<ItemStack> ultraSpace = new ArrayList();
    public static Map<Species, Set<PokemonDropInformation>> pokemonDrops = new HashMap<Species, Set<PokemonDropInformation>>();
    public static HashMap<Integer, HashMap<Element, WeightedItemStacks>> raidDrops = new HashMap();

    public static void clearDrops() {
        tier1.clear();
        tier2.clear();
        tier3.clear();
        ultraSpace.clear();
        pokemonDrops.clear();
        raidDrops.clear();
    }

    public static void registerDropItems(ResourceLocation rl, JsonElement json) {
        String path = rl.toString();
        if (path.contains("pokechestdrops")) {
            JsonObject jObj = json.getAsJsonObject();
            DropItemRegistry.registerTierDrops(jObj, "tier1", tier1);
            DropItemRegistry.registerTierDrops(jObj, "tier2", tier2);
            DropItemRegistry.registerTierDrops(jObj, "tier3", tier3);
            DropItemRegistry.registerTierDrops(jObj, "ultraSpace", ultraSpace);
        } else if (path.contains("pokedrops")) {
            DropItemRegistry.registerPokemonDrops(json.getAsJsonArray());
        } else if (path.contains("raiddrops")) {
            DropItemRegistry.registerRaidDrops(json.getAsJsonObject());
        } else if (path.contains("blankimprintrate")) {
            DropItemRegistry.registerBlankImprintRates(json.getAsJsonObject());
        }
    }

    private static void registerBlankImprintRates(JsonObject jsonObject) {
        int rate;
        BlankTechnicalMachineItem.maxImprintCount.clear();
        for (Gen8TechnicalMachines gen8TechnicalMachines : Gen8TechnicalMachines.values()) {
            rate = jsonObject.getAsJsonObject(gen8TechnicalMachines.prefix()).get(gen8TechnicalMachines.getAttackName()).getAsInt();
            BlankTechnicalMachineItem.maxImprintCount.put(gen8TechnicalMachines, rate);
        }
        for (Enum enum_ : Gen8TechnicalRecords.values()) {
            rate = jsonObject.getAsJsonObject(enum_.prefix()).get(enum_.getAttackName()).getAsInt();
            BlankTechnicalMachineItem.maxImprintCount.put((ITechnicalMove)((Object)enum_), rate);
        }
    }

    private static void registerPokemonDrops(JsonArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject pokemonDropObject = jsonArray.get(i).getAsJsonObject();
            PokemonDropInformation drop = new PokemonDropInformation(pokemonDropObject);
            Optional<RegistryValue> value = drop.getPokemonSpec().getValue(SpeciesRequirement.class);
            value.ifPresent(speciesRegistryValue -> pokemonDrops.merge((Species)speciesRegistryValue.getValueUnsafe(), Sets.newHashSet((Object[])new PokemonDropInformation[]{drop}), (oldSet, newSet) -> {
                oldSet.add(drop);
                return oldSet;
            }));
            if (!value.isPresent()) {
                Pixelmon.LOGGER.error("Potentially invalid specification (missing species): " + drop.getPokemonSpec().toString());
            }
            if (!drop.getDrops().isEmpty()) continue;
            Pixelmon.LOGGER.error("Potentially invalid items in drops JSON for " + drop.getPokemonSpec().toString());
            Pixelmon.LOGGER.error(pokemonDropObject.toString());
        }
    }

    private static void registerRaidDrops(JsonObject jsonObject) {
        for (int i = 1; i <= 5; ++i) {
            HashMap<Element, WeightedItemStacks> items = new HashMap<Element, WeightedItemStacks>();
            for (Element type : Element.values()) {
                items.put(type, WeightedItemStacks.create());
            }
            items.put(null, WeightedItemStacks.create());
            DropItemRegistry.registerRaidDropMap(jsonObject, String.valueOf(i), items);
            raidDrops.put(i, items);
        }
    }

    private static void registerRaidDropMap(JsonObject jsonObject, String key, HashMap<Element, WeightedItemStacks> map) {
        if (jsonObject.has(key)) {
            JsonObject outer = jsonObject.get(key).getAsJsonObject();
            HashSet<Element> types = new HashSet<Element>(Arrays.asList(Element.values()));
            types.add(null);
            for (Element type : types) {
                WeightedItemStacks stacks = map.get(type);
                if (!outer.has(type == null ? "Any" : type.getName())) continue;
                JsonArray inner = outer.get(type == null ? "Any" : type.getName()).getAsJsonArray();
                for (int i = 0; i < inner.size(); ++i) {
                    JsonObject itemWithWeight = inner.get(i).getAsJsonObject();
                    if (!itemWithWeight.has("item") || !itemWithWeight.has("weight")) continue;
                    String itemString = itemWithWeight.get("item").getAsString();
                    int itemWeight = itemWithWeight.get("weight").getAsInt();
                    ItemStack itemStack = DropItemRegistry.parseItem(itemString);
                    if (itemStack == null) continue;
                    stacks.add(itemWeight, itemStack);
                }
            }
        }
    }

    private static void registerTierDrops(JsonObject json, String tierName, List<ItemStack> tierList) {
        if (json.has(tierName)) {
            JsonArray jsonArray = json.get(tierName).getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement jsonElement = jsonArray.get(i);
                String itemName = "";
                itemName = jsonElement.isJsonPrimitive() ? jsonArray.get(i).getAsString() : jsonArray.get(i).getAsJsonObject().get("type").getAsString();
                ResourceLocation loc = ResourceLocationHelper.of(itemName);
                if (loc == null) {
                    Pixelmon.LOGGER.error("Resource location of item: " + itemName + " was null!");
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
                ItemStack stack = new ItemStack((ItemLike)item);
                if (item == null) {
                    Pixelmon.LOGGER.error("Item not found: " + itemName + " in pokechestdrops.json.");
                    continue;
                }
                if (!jsonElement.isJsonPrimitive() && jsonArray.get(i).getAsJsonObject().has("nbt")) {
                    try {
                        stack.m_41751_(TagParser.m_129359_((String)jsonArray.get(i).getAsJsonObject().get("nbt").toString()));
                    }
                    catch (CommandSyntaxException e) {
                        Pixelmon.LOGGER.error("Item not found: " + itemName + " in pokechestdrops.json.");
                        continue;
                    }
                }
                tierList.add(stack);
            }
        }
    }

    public static ItemStack getTier1Drop() {
        return RandomHelper.getRandomElementFromCollection(tier1);
    }

    public static ItemStack getTier2Drop() {
        return RandomHelper.getRandomElementFromCollection(tier2);
    }

    public static ItemStack getTier3Drop() {
        return RandomHelper.getRandomElementFromCollection(tier3);
    }

    public static ItemStack getUltraSpaceDrop() {
        return RandomHelper.getRandomElementFromCollection(ultraSpace);
    }

    public static List<ItemStack> getDropsForPokemon(AbstractHoldsItemsEntity pixelmon) {
        ArrayList drops = Lists.newArrayList();
        for (PokemonDropInformation dropInfo : pokemonDrops.getOrDefault(pixelmon.getSpecies(), Collections.emptySet())) {
            drops.addAll(dropInfo.getDrops(pixelmon));
        }
        return drops;
    }

    public static ItemStack parseItem(String name) {
        ResourceLocation location;
        Item item;
        String[] splits = ((String)name).split(":");
        if (splits.length > 2) {
            name = splits[0] + ":" + splits[1];
        }
        if ((item = (Item)ForgeRegistries.ITEMS.getValue(location = ResourceLocationHelper.of((String)name))) == null) {
            return null;
        }
        return new ItemStack((ItemLike)item, 1, new CompoundTag());
    }
}

