/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.events.npc.NPCTutorEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BaseStatsLearnType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.LoadTutorDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SelectPokemonResponsePacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCTutorType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;

public class NPCTutor
extends NPCEntity {
    public static final DataSync<NPCTutor, EnumNPCTutorType> SYNC_TUTOR_TYPE = new DataSync<NPCTutor, EnumNPCTutorType>(NPCTutor.class, PixelmonDataSerializers.NPC_TUTOR_TYPE, (npcTutor, type) -> {
        npcTutor.tutorType = type;
    });
    public static ArrayList<ImmutableAttack> allTutorMoves = new ArrayList();
    public static ArrayList<ImmutableAttack> allTransferMoves = new ArrayList();
    public final List<LearnableMove> moveList = Lists.newArrayList();
    public EnumSet<BaseStatsLearnType> learnTypes = EnumSet.noneOf(BaseStatsLearnType.class);
    private EnumNPCTutorType tutorType;

    public NPCTutor(EntityType<NPCTutor> type, Level world) {
        super(type, world);
    }

    public NPCTutor(Level world) {
        this((EntityType<NPCTutor>)((EntityType)EntityRegistration.NPC_TUTOR.get()), world);
        this.init("Tutor");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(SYNC_TUTOR_TYPE, EnumNPCTutorType.TUTOR);
    }

    @Override
    public void init(String name) {
        if (name.equals("Tutor")) {
            BaseTrainer trainer = ServerNPCRegistry.trainers.getRandomBase();
            name = trainer.name;
            this.setBaseTrainer(trainer);
            if (trainer.textures.size() > 1) {
                this.setTextureIndex(RandomHelper.getRandom().nextInt(trainer.textures.size()));
            }
        }
        super.init(name);
        this.npcLocation = SpawnLocationType.LAND_NPC;
        if (this.moveList.isEmpty()) {
            this.randomiseMoveList();
        }
        if (this.learnTypes.isEmpty()) {
            if (this.getTutorType() == EnumNPCTutorType.TUTOR) {
                this.learnTypes.addAll(Arrays.asList(BaseStatsLearnType.GEN8_DEFAULT));
                this.learnTypes.remove((Object)BaseStatsLearnType.TRANSFER_MOVES);
            } else {
                this.learnTypes.add(BaseStatsLearnType.TRANSFER_MOVES);
            }
        }
        if (this.getAIMode() != EnumTrainerAI.StandStill) {
            this.setAIMode(EnumTrainerAI.Wander);
        }
        this.initAI();
    }

    @Override
    public String getDisplayText() {
        if (this.getTutorType() == EnumNPCTutorType.TRANSFER) {
            return I18n.m_118938_((String)"pixelmon.npc.transfername", (Object[])new Object[0]);
        }
        return I18n.m_118938_((String)"pixelmon.npc.tutorname", (Object[])new Object[0]);
    }

    public void m_5997_(double par1, double par3, double par5) {
        if (this.m_6094_()) {
            super.m_5997_(par1, par3, par5);
        }
    }

    @Override
    public boolean m_6094_() {
        return this.getAIMode() != EnumTrainerAI.StandStill;
    }

    @Override
    public boolean m_6785_(double p_213397_1_) {
        return this.getAIMode() == EnumTrainerAI.Wander;
    }

    public void setTutorType(EnumNPCTutorType type) {
        SYNC_TUTOR_TYPE.set((Entity)this, (Object)type);
        this.learnTypes.clear();
        if (this.getTutorType() == EnumNPCTutorType.TUTOR) {
            this.learnTypes.addAll(Arrays.asList(BaseStatsLearnType.GEN8_DEFAULT));
            this.learnTypes.remove((Object)BaseStatsLearnType.TRANSFER_MOVES);
        } else {
            this.learnTypes.add(BaseStatsLearnType.TRANSFER_MOVES);
        }
        this.randomiseMoveList();
    }

    public EnumNPCTutorType getTutorType() {
        return this.tutorType;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("TutorType", this.getTutorType().ordinal());
        if (this.moveList.isEmpty()) {
            nbt.m_128405_("numAttacks", 0);
            return;
        }
        nbt.m_128405_("numAttacks", this.moveList.size());
        for (int i = 0; i < this.moveList.size(); ++i) {
            LearnableMove learnableMove = this.moveList.get(i);
            nbt.m_128359_("attack" + i, learnableMove.attack().getAttackName());
            nbt.m_128405_("attack" + i + "costNum", learnableMove.costs().size());
            List<ItemStack> costs = learnableMove.costs();
            for (int j = 0; j < costs.size(); ++j) {
                ItemStack current = costs.get(j);
                nbt.m_128405_("attack" + i + "cost" + j, Item.m_41393_((Item)current.m_41720_()));
                nbt.m_128405_("attack" + i + "cost" + j + "Num", current.m_41613_());
                if (current.m_41773_() == 0) continue;
                nbt.m_128405_("attack" + i + "cost" + j + "Damage", current.m_41773_());
            }
        }
        if (!this.isDefaultLearnList()) {
            ListTag list = new ListTag();
            for (BaseStatsLearnType type : this.learnTypes) {
                list.add((Object)StringTag.m_129297_((String)type.name()));
            }
            nbt.m_128365_("learnTypes", (Tag)list);
        }
    }

    @Override
    public void initAI() {
        this.f_21345_.f_25345_.clear();
        switch (this.getAIMode()) {
            case StandStill: {
                this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
                this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, PixelmonEntity.class, 6.0f));
                break;
            }
            case Wander: {
                this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, Attributes.f_22279_.m_22082_()));
                break;
            }
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("TutorType")) {
            this.setTutorType(EnumNPCTutorType.values()[nbt.m_128451_("TutorType")]);
        } else {
            this.setTutorType(EnumNPCTutorType.random());
        }
        int numAttacks = nbt.m_128451_("numAttacks");
        if (numAttacks > 0) {
            this.moveList.clear();
        }
        for (int i = 0; i < numAttacks; ++i) {
            Optional<ImmutableAttack> optional = AttackRegistry.getAttackBase(nbt.m_128461_("attack" + i));
            if (!optional.isPresent()) continue;
            int numCosts = nbt.m_128451_("attack" + i + "costNum");
            ArrayList<ItemStack> cost = new ArrayList<ItemStack>(numCosts);
            for (int j = 0; j < numCosts; ++j) {
                ItemStack current = new ItemStack((ItemLike)Item.m_41445_((int)nbt.m_128451_("attack" + i + "cost" + j)), nbt.m_128451_("attack" + i + "cost" + j + "Num"));
                if (nbt.m_128441_("attack" + i + "cost" + j + "Damage") && nbt.m_128451_("attack" + i + "cost" + j + "Damage") != 0) {
                    current.m_41721_(nbt.m_128451_("attack" + i + "cost" + j + "Damage"));
                }
                cost.add(current);
            }
            this.moveList.add(new LearnableMove(optional.get(), cost, true));
        }
        if (nbt.m_128425_("learnTypes", 9)) {
            this.learnTypes.clear();
            for (Tag base : nbt.m_128437_("learnTypes", 8)) {
                StringTag string = (StringTag)base;
                try {
                    BaseStatsLearnType type = BaseStatsLearnType.valueOf(string.m_7916_());
                    this.learnTypes.add(type);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public InteractionResult m_7111_(Player player, Vec3 vector, InteractionHand hand) {
        if (player instanceof ServerPlayer && hand == InteractionHand.MAIN_HAND) {
            if (this.moveList.isEmpty()) {
                this.init("");
            }
            ItemStack itemStack = player.m_21120_(hand);
            NetworkHelper.sendPacket(new LoadTutorDataPacket(this.moveList), (ServerPlayer)player);
            if (player.m_7500_() && itemStack.m_41720_() instanceof NPCEditorItem) {
                this.setAIMode(EnumTrainerAI.StandStill);
                this.initAI();
                NetworkHelper.sendPacket(new LoadTutorDataPacket(this.moveList, this.learnTypes), (ServerPlayer)player);
                OpenScreenPacket.open(player, EnumGuiScreen.TutorEditor, this.m_19879_());
            } else {
                OpenScreenPacket.open(player, EnumGuiScreen.PickPokemon, this.getTutorType() == EnumNPCTutorType.TUTOR ? SelectPokemonResponsePacket.Mode.Tutor.ordinal() : SelectPokemonResponsePacket.Mode.Transfer_Tutor.ordinal(), this.m_19879_());
            }
        } else {
            this.f_21345_.f_25345_.clear();
        }
        return super.m_7111_(player, vector, hand);
    }

    public void handlePickedPokemon(ServerPlayer player, Pokemon pokemon) {
        ArrayList learnableMoveList = Lists.newArrayList();
        for (LearnableMove learnableMove : this.moveList) {
            learnableMoveList.add(new LearnableMove(learnableMove, this.canLearn(player, pokemon, learnableMove.attack())));
        }
        NPCTutorEvent.CollectLearnableMoves.Pre pre = new NPCTutorEvent.CollectLearnableMoves.Pre((Player)player, this, pokemon, learnableMoveList);
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return;
        }
        NetworkHelper.sendPacket(new LoadTutorDataPacket(pre.getLearnableMoves()), player);
        OpenScreenPacket.open((Player)player, EnumGuiScreen.Tutor, pokemon.getPosition().order, this.m_19879_());
        Pixelmon.EVENT_BUS.post((Event)new NPCTutorEvent.CollectLearnableMoves.Post((Player)player, this, pokemon, pre.getLearnableMoves()));
    }

    public boolean canLearn(ServerPlayer player, Pokemon pokemon, ImmutableAttack attack) {
        return pokemon.getForm().getMoves().canLearn(pokemon.getForm(), attack, this.learnTypes.toArray(new BaseStatsLearnType[0]));
    }

    private static Attack getRandomAttack(EnumNPCTutorType type) {
        return new Attack(CollectionHelper.getRandomElement(type == EnumNPCTutorType.TUTOR ? allTutorMoves : allTransferMoves));
    }

    private static ItemStack getRandomCost() {
        Item[] randomItems = new Item[]{Items.f_42416_, Items.f_42417_, Items.f_42415_, Items.f_42616_, Items.f_151049_, PixelmonItems.aluminium_ingot, PixelmonItems.ruby, PixelmonItems.crystal, PixelmonItems.sapphire, PixelmonItems.silicon};
        int randomItem = RandomHelper.getRandomNumberBetween(0, randomItems.length - 1);
        return new ItemStack((ItemLike)randomItems[randomItem], RandomHelper.getRandomNumberBetween(1, 16));
    }

    public static void encode(FriendlyByteBuf buf, ArrayList<Attack> attackList, ArrayList<ArrayList<ItemStack>> costs) {
        if (attackList != null) {
            buf.writeInt(attackList.size());
            for (int i = 0; i < attackList.size(); ++i) {
                buf.m_130070_(attackList.get(i).getMove().getAttackName());
                buf.writeInt(costs.get(i).size());
                for (int j = 0; j < costs.get(i).size(); ++j) {
                    ItemStack current = costs.get(i).get(j);
                    buf.writeInt(Item.m_41393_((Item)current.m_41720_()));
                    buf.writeInt(current.m_41613_());
                    buf.writeInt(current.m_41773_());
                }
            }
        } else {
            buf.writeInt(0);
        }
    }

    public static void decode(FriendlyByteBuf buf, ArrayList<Attack> attackList, ArrayList<ArrayList<ItemStack>> costs) {
        int numAttacks = buf.readInt();
        for (int i = 0; i < numAttacks; ++i) {
            attackList.add(new Attack(buf.m_130277_()));
            int numCosts = buf.readInt();
            ArrayList<ItemStack> cost = new ArrayList<ItemStack>(numCosts);
            for (int j = 0; j < numCosts; ++j) {
                ItemStack current = new ItemStack((ItemLike)Item.m_41445_((int)buf.readInt()), buf.readInt());
                current.m_41721_(buf.readInt());
                cost.add(current);
            }
            costs.add(cost);
        }
    }

    private boolean isDefaultLearnList() {
        EnumSet<BaseStatsLearnType> defaults = EnumSet.noneOf(BaseStatsLearnType.class);
        if (this.getTutorType() == EnumNPCTutorType.TUTOR) {
            defaults.addAll(Arrays.asList(BaseStatsLearnType.GEN8_DEFAULT));
            defaults.remove((Object)BaseStatsLearnType.TRANSFER_MOVES);
        } else {
            defaults.add(BaseStatsLearnType.TRANSFER_MOVES);
        }
        return this.learnTypes.containsAll(defaults);
    }

    public void randomiseMoveList() {
        this.moveList.clear();
        HashSet moveSet = Sets.newHashSet();
        ArrayList<ImmutableAttack> attackPool = this.getTutorType() == EnumNPCTutorType.TUTOR ? allTutorMoves : allTransferMoves;
        for (int i = 0; i < Math.min(PixelmonConfigProxy.getGeneral().getMovesPerTutor(), attackPool.size()); ++i) {
            ImmutableAttack random;
            while (!moveSet.add(random = CollectionHelper.getRandomElement(attackPool))) {
            }
        }
        for (ImmutableAttack base : moveSet) {
            this.moveList.add(new LearnableMove(base, Collections.singletonList(NPCTutor.getRandomCost()), true));
        }
    }

    public static class LearnableMove
    extends AbstractPixelmonPacket {
        private ImmutableAttack attack;
        private List<ItemStack> costs;
        private boolean learnable;

        public LearnableMove() {
            super(PacketDirection.PLAY_CLIENT, true);
        }

        public LearnableMove(ImmutableAttack attack, List<ItemStack> costs, boolean learnable) {
            this();
            this.attack = attack;
            this.costs = Lists.newArrayList();
            for (ItemStack cost : costs) {
                this.costs.add(cost.m_41777_());
            }
            this.learnable = learnable;
        }

        public LearnableMove(LearnableMove source, boolean learnable) {
            this();
            this.attack = source.attack;
            this.costs = Lists.newArrayList();
            for (ItemStack cost : source.costs) {
                this.costs.add(cost.m_41777_());
            }
            this.learnable = learnable;
        }

        public ImmutableAttack attack() {
            return this.attack;
        }

        public List<ItemStack> costs() {
            return this.costs;
        }

        public boolean learnable() {
            return this.learnable;
        }

        @Override
        public void decode(FriendlyByteBuf buf) {
            this.attack = AttackRegistry.getAttackBase(buf.m_130277_()).orElse(null);
            int count = buf.readInt();
            this.costs = Lists.newArrayList();
            for (int i = 0; i < count; ++i) {
                this.costs.add(buf.m_130267_());
            }
            this.learnable = buf.readBoolean();
        }

        @Override
        protected void handlePacket(CustomPayloadEvent.Context context) {
        }

        @Override
        public void encode(FriendlyByteBuf buf) {
            buf.m_130070_(this.attack.getAttackName());
            buf.writeInt(this.costs.size());
            for (ItemStack stack : this.costs) {
                buf.m_130055_(stack);
            }
            buf.writeBoolean(this.learnable);
        }

        public void readFromNBT(CompoundTag compound) {
            this.attack = AttackRegistry.getAttackBase(compound.m_128461_("move")).orElse(null);
            this.costs = Lists.newArrayList();
            ListTag list = compound.m_128437_("costs", 10);
            for (Tag base : list) {
                CompoundTag cost = (CompoundTag)base;
                this.costs.add(ItemStack.m_41712_((CompoundTag)cost));
            }
            this.learnable = compound.m_128471_("learnable");
        }

        public CompoundTag writeToNBT(CompoundTag compound) {
            compound.m_128359_("move", this.attack == null ? "" : this.attack.getAttackName());
            ListTag list = new ListTag();
            for (ItemStack cost : this.costs) {
                list.add((Object)cost.m_41739_(new CompoundTag()));
            }
            compound.m_128365_("costs", (Tag)list);
            compound.m_128379_("learnable", this.learnable);
            return compound;
        }
    }
}

