/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.ai.ExecuteActionGoal;
import com.pixelmonmod.pixelmon.ai.MoveTowardsTargetGoal;
import com.pixelmonmod.pixelmon.ai.TargetNearestGoal;
import com.pixelmonmod.pixelmon.ai.TargetNearestGoalInFieldOfView;
import com.pixelmonmod.pixelmon.ai.TrainerInBattleGoal;
import com.pixelmonmod.pixelmon.api.battles.BattleAIMode;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.events.BeatTrainerEvent;
import com.pixelmonmod.pixelmon.api.events.LostToTrainerEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.HiddenPower;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ITrainerData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerChat;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerData;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import com.pixelmonmod.pixelmon.tools.Quadstate;
import com.pixelmonmod.pixelmon.world.generation.gyms.MovesetDefinition;
import com.pixelmonmod.pixelmon.world.generation.gyms.PokemonDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.ArrayUtils;

public class NPCTrainer
extends NPCEntity {
    private static final DataSync<NPCTrainer, EnumEncounterMode> SYNC_ENCOUNTER_MODE = new DataSync<NPCTrainer, EnumEncounterMode>(NPCTrainer.class, PixelmonDataSerializers.ENCOUNTER_MODE, (npcTrainer, o) -> {
        npcTrainer.encounterMode = o;
    });
    private static final DataSync<NPCTrainer, EnumMegaItemsUnlocked> SYNC_MEGA_ITEM = new DataSync<NPCTrainer, EnumMegaItemsUnlocked>(NPCTrainer.class, PixelmonDataSerializers.MEGA_ITEM, (npcTrainer, enumMegaItemsUnlocked) -> {
        npcTrainer.megaItem = enumMegaItemsUnlocked;
    });
    private static final DataSync<NPCTrainer, EnumOldGenMode> SYNC_OLD_GEN = new DataSync<NPCTrainer, EnumOldGenMode>(NPCTrainer.class, PixelmonDataSerializers.OLD_GEN_MODE, (npcTrainer, enumOldGenMode) -> {
        npcTrainer.oldGenMode = enumOldGenMode;
    });
    private static final DataSync<NPCTrainer, BossTier> SYNC_BOSS_MODE = new DataSync<NPCTrainer, BossTier>(NPCTrainer.class, PixelmonDataSerializers.BOSS_MODE, (npcTrainer, bossTier) -> {
        npcTrainer.bossTier = bossTier;
    });
    private static final DataSync<NPCTrainer, Integer> SYNC_TRAINER_LEVEL = new DataSync<NPCTrainer, Integer>(NPCTrainer.class, EntityDataSerializers.f_135028_, (npcTrainer, integer) -> {
        npcTrainer.trainerLevel = integer;
    });
    private static final DataSync<NPCTrainer, BattleAIMode> SYNC_BATTLE_AI = new DataSync<NPCTrainer, BattleAIMode>(NPCTrainer.class, PixelmonDataSerializers.BATTLE_AI_MODE, (npcTrainer, battleAIMode) -> {
        npcTrainer.battleAIMode = battleAIMode;
    });
    private static final DataSync<NPCTrainer, Integer> SYNC_ENGAGE_DISTANCE = new DataSync<NPCTrainer, Integer>(NPCTrainer.class, EntityDataSerializers.f_135028_, (npcTrainer, integer) -> {
        npcTrainer.engageDistance = integer;
    });
    private TrainerPartyStorage party = new TrainerPartyStorage(this);
    public boolean usingDefaultName = true;
    public boolean usingDefaultGreeting = true;
    public boolean usingDefaultWin = true;
    public boolean usingDefaultLose = true;
    public String greeting = "";
    public String winMessage = "";
    public String loseMessage = "";
    public int winMoney;
    public int pokemonLevel;
    private String trainerId = "";
    ItemStack[] winnings = new ItemStack[0];
    private boolean startRotationSet = false;
    private float startRotationYaw;
    public boolean isGymLeader = false;
    public transient boolean canEngage = true;
    public HashMap<UUID, Long> playerEncounters = new HashMap();
    public ArrayList<String> winCommands = new ArrayList();
    public ArrayList<String> loseCommands = new ArrayList();
    public ArrayList<String> forfeitCommands = new ArrayList();
    public ArrayList<String> preBattleCommands = new ArrayList();
    public BattleRules battleRules = new BattleRules();
    private EnumEncounterMode encounterMode;
    private EnumMegaItemsUnlocked megaItem;
    private EnumOldGenMode oldGenMode;
    private BossTier bossTier;
    private BattleAIMode battleAIMode;
    private int trainerLevel;
    private int engageDistance;
    public BattleController battleController;

    public NPCTrainer(EntityType<NPCTrainer> type, Level par1World) {
        super(type, par1World);
    }

    public NPCTrainer(Level world) {
        this((EntityType<NPCTrainer>)((EntityType)EntityRegistration.NPC_TRAINER.get()), world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(SYNC_ENCOUNTER_MODE, EnumEncounterMode.Once);
        this.define(SYNC_BOSS_MODE, BossTierRegistry.NOT_BOSS);
        this.define(SYNC_TRAINER_LEVEL, 0);
        this.define(SYNC_BATTLE_AI, BattleAIMode.DEFAULT);
        this.define(SYNC_MEGA_ITEM, EnumMegaItemsUnlocked.None);
        this.define(SYNC_OLD_GEN, EnumOldGenMode.World);
        this.define(SYNC_ENGAGE_DISTANCE, 10);
    }

    public void init(BaseTrainer trainer) {
        super.init(trainer.name);
        this.party = new TrainerPartyStorage(this);
        TrainerData info = ServerNPCRegistry.trainers.getRandomData(trainer);
        if (info == null) {
            BaseTrainer b = ServerNPCRegistry.trainers.getRandomBaseWithData();
            info = ServerNPCRegistry.trainers.getRandomData(b.name);
        }
        this.chatIndex = info.getRandomChat();
        if (this.usingDefaultName) {
            this.setName("" + info.getRandomName());
        }
        this.trainerId = info.id;
        this.winMoney = info.winnings;
        this.pokemonLevel = info.getRandomLevel();
        if (this.pokemonLevel == 0) {
            this.pokemonLevel = 1;
        }
        SYNC_TRAINER_LEVEL.set((Entity)this, (Object)this.pokemonLevel);
        this.setBaseTrainer(info.trainerType);
        if (info.trainerType.textures.size() > 1) {
            this.setTextureIndex(RandomHelper.getRandom().nextInt(info.trainerType.textures.size()));
        }
        this.loadPokemon(info.getRandomParty());
    }

    public String getName(String langCode) {
        if (this.usingDefaultName) {
            try {
                int index = Integer.parseInt(this.m_7755_().getString());
                ITrainerData translatedData = this.getTranslatedData(langCode);
                if (translatedData == null) {
                    return this.m_7755_().getString();
                }
                return translatedData.getName(index);
            }
            catch (NumberFormatException e) {
                return this.m_7755_().getString();
            }
        }
        return this.m_7755_().getString();
    }

    public void clearGreetings() {
        this.usingDefaultGreeting = false;
        this.usingDefaultWin = false;
        this.usingDefaultLose = false;
        this.greeting = null;
        this.winMessage = null;
        this.loseMessage = null;
    }

    public String getGreeting(String langCode) {
        if (this.usingDefaultGreeting) {
            return this.getChat((String)langCode).opening;
        }
        return this.greeting;
    }

    public String getWinMessage(String langCode) {
        if (this.usingDefaultWin) {
            return this.getChat((String)langCode).win;
        }
        return this.winMessage;
    }

    public String getLoseMessage(String langCode) {
        if (this.usingDefaultLose) {
            return this.getChat((String)langCode).lose;
        }
        return this.loseMessage;
    }

    private ITrainerData getTranslatedData(String langCode) {
        return ServerNPCRegistry.getTranslatedData(langCode, this.getBaseTrainer(), this.trainerId);
    }

    public TrainerChat getChat(String langCode) {
        ITrainerData data = this.getTranslatedData(langCode);
        if (data == null) {
            return new TrainerChat("", "", "");
        }
        return data.getChat(this.chatIndex);
    }

    public int getWinMoney() {
        return this.winMoney;
    }

    public void setEncounterMode(EnumEncounterMode mode) {
        SYNC_ENCOUNTER_MODE.set((Entity)this, (Object)mode);
        this.playerEncounters.clear();
    }

    public void setMegaItem(EnumMegaItemsUnlocked megaItem) {
        SYNC_MEGA_ITEM.set((Entity)this, (Object)megaItem);
    }

    public void setOldGenMode(EnumOldGenMode mode) {
        SYNC_OLD_GEN.set((Entity)this, (Object)mode);
    }

    public EnumEncounterMode getEncounterMode() {
        return this.encounterMode;
    }

    public EnumMegaItemsUnlocked getMegaItem() {
        return this.megaItem;
    }

    public EnumOldGenMode getOldGen() {
        return this.oldGenMode;
    }

    public void setEngageDistance(int engageDistance) {
        SYNC_ENGAGE_DISTANCE.set((Entity)this, (Object)engageDistance);
    }

    public int getEngageDistance() {
        return this.engageDistance;
    }

    public void setTrainerType(BaseTrainer model, Player player) {
        this.init(model);
        this.setTextureIndex(0);
        this.setBaseTrainer(model);
        ServerPlayer playerMP = (ServerPlayer)player;
        NetworkHelper.sendPacket(new ClearTrainerPokemonPacket(), playerMP);
        for (Pokemon pokemon : this.party.getTeam()) {
            NetworkHelper.sendPacket(new StoreTrainerPokemonPacket(pokemon), playerMP);
        }
        String loc = playerMP.getLanguage();
        this.setName(ServerNPCRegistry.trainers.getTranslatedRandomName(loc, model, this.trainerId));
        SetTrainerData p = new SetTrainerData(this, loc);
        NetworkHelper.sendPacket(new SetNPCEditDataPacket(p), playerMP);
    }

    public void m_6119_() {
        if (this.m_21523_()) {
            this.m_21455_(true, true);
        }
    }

    public void m_5997_(double par1, double par3, double par5) {
        if (this.m_6094_()) {
            super.m_5997_(par1, par3, par5);
        }
    }

    public boolean m_6087_() {
        return true;
    }

    @Override
    public boolean m_6094_() {
        EnumTrainerAI ai = this.getAIMode();
        return ai != EnumTrainerAI.StandStill && ai != EnumTrainerAI.StillAndEngage && ai != EnumTrainerAI.StillMoveAndEngage;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.startRotationSet && (this.getAIMode() == EnumTrainerAI.StillAndEngage || this.getAIMode() == EnumTrainerAI.StillMoveAndEngage)) {
            this.f_19857_ = this.startRotationYaw;
            this.f_20885_ = this.startRotationYaw;
        }
    }

    @Override
    protected void checkForRarityDespawn() {
        if (this.battleController != null) {
            return;
        }
        super.checkForRarityDespawn();
    }

    public PixelmonEntity releasePokemon(UUID newPokemonUUID) {
        return this.party.find(newPokemonUUID).getOrSpawnPixelmon((Entity)this);
    }

    public void loadPokemon(ArrayList<Pokemon> pokemonList) {
        for (int i = 0; i < 6; ++i) {
            this.party.set(i, null);
        }
        if (pokemonList == null || pokemonList.isEmpty()) {
            this.party.add(PokemonSpecificationProxy.create(PixelmonSpecies.STARLY.getValueUnsafe().getName(), "lvl:5").get().create());
        } else {
            for (Pokemon pokemon : pokemonList) {
                pokemon.setLevel(Math.max(1, RandomHelper.getRandomNumberBetween(this.pokemonLevel - 1, this.pokemonLevel + 1)));
                this.party.add(pokemon);
            }
        }
    }

    private void initializePokemon(PokemonDefinition definition, int level, boolean isDouble) {
        BaseShopItem item;
        MovesetDefinition moves = RandomHelper.getRandomElementFromList(definition.getMovesets());
        if (level < moves.minLevel || level < definition.getMinLevel() || level > definition.getMaxLevel()) {
            return;
        }
        if (moves.doubleOnly && !isDouble) {
            return;
        }
        Pokemon pokemon = PokemonFactory.create(PokemonSpecificationProxy.create(definition.getPokemon().getName(), "form:" + moves.form, "lvl:" + Math.max(1, Math.min(PixelmonServerConfig.maxLevel, RandomHelper.getRandomNumberBetween(level - 1, level + 1)))).get());
        if (this.isGymLeader) {
            pokemon.getEVs().setStat(BattleStatsType.ATTACK, moves.evAtk);
            pokemon.getEVs().setStat(BattleStatsType.DEFENSE, moves.evDef);
            pokemon.getEVs().setStat(BattleStatsType.HP, moves.evHP);
            pokemon.getEVs().setStat(BattleStatsType.SPECIAL_ATTACK, moves.evSpAtk);
            pokemon.getEVs().setStat(BattleStatsType.SPECIAL_DEFENSE, moves.evSpDef);
            pokemon.getEVs().setStat(BattleStatsType.SPEED, moves.evSpeed);
            pokemon.getEVs().setStat(BattleStatsType.ATTACK, moves.ivAtk);
            pokemon.getEVs().setStat(BattleStatsType.DEFENSE, moves.ivDef);
            pokemon.getEVs().setStat(BattleStatsType.HP, moves.ivHP);
            pokemon.getEVs().setStat(BattleStatsType.SPECIAL_ATTACK, moves.ivSpAtk);
            pokemon.getEVs().setStat(BattleStatsType.SPECIAL_DEFENSE, moves.ivSpDef);
            pokemon.getEVs().setStat(BattleStatsType.SPEED, moves.ivSpeed);
            if (moves.nature != null && moves.nature.length > 0) {
                pokemon.setNature(RandomHelper.getRandomElementFromArray(moves.nature));
            }
        }
        pokemon.setHealth(pokemon.getMaxHealth());
        if (moves.ability != null && moves.ability.length > 0) {
            pokemon.setAbility(RandomHelper.getRandomElementFromArray(moves.ability));
        } else {
            ArrayList<Ability> randomAbilities = new ArrayList<Ability>();
            for (Ability ability : pokemon.getForm().getAbilities().getAll()) {
                if (ability == null) continue;
                randomAbilities.add(ability);
            }
            if (!randomAbilities.isEmpty()) {
                pokemon.setAbility((Ability)RandomHelper.getRandomElementFromList(randomAbilities));
            }
        }
        if (moves.heldItem != null && moves.heldItem.length > 0 && (item = ServerNPCRegistry.shopkeepers.getItem(RandomHelper.getRandomElementFromArray(moves.heldItem))) != null) {
            item.getItem().m_41764_(1);
            pokemon.setHeldItem(item.getItem().m_41777_());
        }
        pokemon.setFriendship(255);
        Moveset moveset = pokemon.getMoveset();
        moveset.clear();
        this.addGymTrainerMove(moves.move1, pokemon, moves.ivsDefined);
        this.addGymTrainerMove(moves.move2, pokemon, moves.ivsDefined);
        this.addGymTrainerMove(moves.move3, pokemon, moves.ivsDefined);
        this.addGymTrainerMove(moves.move4, pokemon, moves.ivsDefined);
        this.party.add(pokemon);
        int pos = ((StoragePosition)this.party.find((UUID)pokemon.getUUID()).getStorageAndPosition().m_14419_()).order;
        if (moves.lead && pos != 0) {
            this.party.swap(pos, 0);
        }
        this.calculateGen();
    }

    private void addGymTrainerMove(String[] possibleMoves, Pokemon pokemon, boolean ivsDefined) {
        if (possibleMoves != null && possibleMoves.length > 0) {
            Attack attack;
            Moveset moveset = pokemon.getMoveset();
            int randomIndex = RandomHelper.getRandom().nextInt(possibleMoves.length);
            String selectedMove = possibleMoves[randomIndex];
            Element hiddenPowerType = null;
            if (selectedMove.contains("Hidden Power")) {
                if (!ivsDefined) {
                    hiddenPowerType = Element.parseType(selectedMove.replace("Hidden Power ", ""));
                }
                selectedMove = "Hidden Power";
            }
            if ((attack = new Attack(selectedMove)) != null && !moveset.contains(attack)) {
                moveset.add(attack);
                if (hiddenPowerType != null) {
                    pokemon.getIVs().copyIVs(HiddenPower.getOptimalIVs(hiddenPowerType));
                }
            } else {
                String[] reducedPossible = (String[])ArrayUtils.remove((Object[])possibleMoves, (int)randomIndex);
                this.addGymTrainerMove(reducedPossible, pokemon, ivsDefined);
            }
        }
    }

    public void startBattle(BattleParticipant battleParticipant) {
        this.calculateGen();
        if (battleParticipant instanceof PlayerParticipant) {
            PlayerParticipant player = (PlayerParticipant)battleParticipant;
            EnumEncounterMode encounterMode = this.getEncounterMode();
            if (encounterMode == EnumEncounterMode.OncePerMCDay) {
                this.playerEncounters.put(player.player.m_20148_(), this.f_19853_.m_46467_());
            } else if (encounterMode == EnumEncounterMode.OncePerDay) {
                this.playerEncounters.put(player.player.m_20148_(), System.currentTimeMillis());
            }
        }
        this.healAllPokemon();
    }

    public Quadstate calculateGen() {
        return this.party.isOldGen((ResourceKey<Level>)this.f_19853_.m_46472_());
    }

    public void loseBattle(ArrayList<BattleParticipant> opponents) {
        String langCode;
        if (opponents.get(0) instanceof PlayerParticipant && this.getLoseMessage(langCode = ((ServerPlayer)opponents.get(0).getEntity()).getLanguage()) != null) {
            ChatHandler.sendBattleMessage(opponents, this.getLoseMessage(langCode), new Object[0]);
        }
        if (opponents.size() == 1 && opponents.get(0) instanceof PlayerParticipant) {
            ServerPlayer player = (ServerPlayer)opponents.get(0).getEntity();
            Pixelmon.EVENT_BUS.post((Event)new BeatTrainerEvent(player, this));
            if (this.getEncounterMode() == EnumEncounterMode.Once) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.m_6089_();
            } else {
                this.healAllPokemon();
                if (this.getEncounterMode() == EnumEncounterMode.OncePerPlayer) {
                    this.playerEncounters.put(player.m_20148_(), this.f_19853_.m_46467_());
                }
            }
            if (player.f_19853_.m_46003_(player.m_20148_()) == null) {
                return;
            }
            if (this.winMoney > 0) {
                int calculatedWinMoney = this.winMoney * this.party.getAverageLevel();
                if (!this.m_6785_(0.0)) {
                    calculatedWinMoney = this.winMoney;
                }
                PlayerParticipant playerParticipant = (PlayerParticipant)opponents.get(0);
                calculatedWinMoney *= playerParticipant.getPrizeMoneyMultiplier();
                BankAccount account = BankAccountProxy.getBankAccountNow(playerParticipant.player);
                if (account != null) {
                    account.add(calculatedWinMoney);
                    if (playerParticipant.bc == null) {
                        ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.GREEN, "pixelmon.entitytrainer.winnings", "" + calculatedWinMoney, this.getName(player.getLanguage()));
                    } else {
                        ChatHandler.sendBattleMessage((Entity)playerParticipant.getEntity(), "pixelmon.entitytrainer.winnings", "" + calculatedWinMoney, this.getName(player.getLanguage()));
                    }
                }
            }
            if (this.winnings.length > 0) {
                ArrayList<DroppedItem> drops = new ArrayList<DroppedItem>();
                int id = 0;
                for (ItemStack item : this.winnings) {
                    if (item.m_41613_() == 0) {
                        item.m_41764_(1);
                    }
                    drops.add(new DroppedItem(item.m_41777_(), id++));
                }
                DropItemQueryList.register(this, drops, player);
            }
            if (this.getBaseTrainer() != null && this.getBaseTrainer().name.equals("Fisherman")) {
                int number = RandomHelper.getRandomNumberBetween(1, 100);
                int number2 = RandomHelper.getRandomNumberBetween(1, 1000);
                if (number == 43) {
                    DropItemHelper.giveItemStack(player, new ItemStack((ItemLike)PixelmonItems.good_rod), false);
                    ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.GREEN, "pixelmon.entitytrainer.goodrod", new Object[0]);
                } else if (number2 == 564) {
                    DropItemHelper.giveItemStack(player, new ItemStack((ItemLike)PixelmonItems.super_rod), false);
                    ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.GREEN, "pixelmon.entitytrainer.superrod", new Object[0]);
                }
            }
        }
    }

    public void winBattle(ArrayList<BattleParticipant> opponents) {
        String langCode;
        if (opponents.get(0) instanceof PlayerParticipant && this.getWinMessage(langCode = ((ServerPlayer)opponents.get(0).getEntity()).getLanguage()) != null) {
            ChatHandler.sendBattleMessage(opponents, this.getWinMessage(langCode), new Object[0]);
        }
        if (opponents.size() == 1 && opponents.get(0) instanceof PlayerParticipant) {
            ServerPlayer player = (ServerPlayer)opponents.get(0).getEntity();
            Pixelmon.EVENT_BUS.post((Event)new LostToTrainerEvent(player, this));
        }
    }

    public void healAllPokemon() {
        this.party.getTeam().forEach(Pokemon::heal);
    }

    public void restoreAllFriendship() {
        this.party.getTeam().forEach(pokemon -> pokemon.setFriendship(255));
    }

    public UUID getNextPokemonUUID() {
        Pokemon pokemon = this.party.findOne(p -> !p.isEgg() && !p.getPixelmonEntity().isPresent());
        return pokemon == null ? null : pokemon.getUUID();
    }

    public int getTrainerLevel() {
        return this.trainerLevel;
    }

    @Override
    public boolean interactWithNPC(Player player, InteractionHand hand) {
        Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, EnumNPCType.Trainer, player));
        return false;
    }

    public InteractionResult m_21499_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            if (!stack.m_41619_() && stack.m_41720_() instanceof NPCEditorItem) {
                ServerPlayer playerMP = (ServerPlayer)player;
                if (!NPCEditorItem.checkPermission((Player)playerMP)) {
                    return InteractionResult.FAIL;
                }
                this.m_21530_();
                this.f_21345_.m_262460_(goal -> true);
                this.party.sendCacheToPlayer(playerMP);
                String loc = playerMP.getLanguage();
                SetTrainerData p = new SetTrainerData(this, loc);
                NetworkHelper.sendPacket(new SetNPCEditDataPacket(p), playerMP);
                OpenScreenPacket.open(player, EnumGuiScreen.TrainerEditor, this.getNPCID());
            }
        } else {
            this.f_21345_.m_262460_(goal -> true);
        }
        return super.m_21499_(player, hand);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        CompoundTag pokemonNbt = new CompoundTag();
        this.party.writeToNBT(pokemonNbt);
        nbt.m_128365_("pokeStore", (Tag)pokemonNbt);
        nbt.m_128359_("BossTier", this.getBossTier().getID());
        if (this.greeting != null) {
            nbt.m_128359_("Greeting", this.greeting);
        }
        if (this.winMessage != null) {
            nbt.m_128359_("WinMessage", this.winMessage);
        }
        if (this.loseMessage != null) {
            nbt.m_128359_("LoseMessage", this.loseMessage);
        }
        CompoundTag tmpWinnings = new CompoundTag();
        for (int i = 0; i < this.winnings.length; ++i) {
            CompoundTag itemTag = new CompoundTag();
            if (this.winnings[i] == null) continue;
            this.winnings[i].m_41739_(itemTag);
            tmpWinnings.m_128365_("item" + i, (Tag)itemTag);
        }
        nbt.m_128405_("NPCLevel", this.pokemonLevel);
        nbt.m_128405_("WinMoney", this.winMoney);
        nbt.m_128365_("WinningsTag", (Tag)tmpWinnings);
        EnumEncounterMode mode = this.getEncounterMode();
        nbt.m_128376_("EncMode", (short)mode.ordinal());
        nbt.m_128405_("EngageDistance", this.getEngageDistance());
        if (mode != EnumEncounterMode.Once && mode != EnumEncounterMode.Unlimited) {
            ListTag list = new ListTag();
            for (Map.Entry<UUID, Long> entry : this.playerEncounters.entrySet()) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128362_("UUID", entry.getKey());
                if (mode != EnumEncounterMode.OncePerPlayer) {
                    compoundTag.m_128356_("time", entry.getValue().longValue());
                }
                list.add((Object)compoundTag);
            }
            nbt.m_128365_("Encounters", (Tag)list);
        }
        nbt.m_128376_("BattleAIMode", (short)this.getBattleAIMode().ordinal());
        nbt.m_128379_("DefaultName", this.usingDefaultName);
        nbt.m_128379_("DefaultWin", this.usingDefaultWin);
        nbt.m_128379_("DefaultLose", this.usingDefaultLose);
        nbt.m_128379_("DefaultGreet", this.usingDefaultGreeting);
        nbt.m_128359_("TrainerIndex", this.trainerId);
        nbt.m_128405_("ChatIndex", this.chatIndex);
        nbt.m_128405_("hasMegaItem", this.getMegaItem().ordinal());
        if (this.getOldGen() != null) {
            nbt.m_128405_("oldGen", this.getOldGen().ordinal());
        }
        if (this.getAIMode() == EnumTrainerAI.StillAndEngage || this.getAIMode() == EnumTrainerAI.StillMoveAndEngage) {
            nbt.m_128350_("TrainerRotation", this.startRotationYaw);
        }
        if (nbt.m_128441_("EngageDistance")) {
            this.setEngageDistance(nbt.m_128451_("EngageDistance"));
        }
        nbt.m_128379_("GymLeader", this.isGymLeader);
        this.battleRules.writeToNBT(nbt);
        CompoundTag commandsNbt = nbt.m_128469_("Commands");
        ListTag winList = new ListTag();
        for (String string : this.winCommands) {
            winList.add((Object)StringTag.m_129297_((String)string));
        }
        commandsNbt.m_128365_("winCommands", (Tag)winList);
        ListTag listTag = new ListTag();
        for (String string : this.loseCommands) {
            listTag.add((Object)StringTag.m_129297_((String)string));
        }
        commandsNbt.m_128365_("loseCommands", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (String forfeitCommand : this.forfeitCommands) {
            listTag2.add((Object)StringTag.m_129297_((String)forfeitCommand));
        }
        commandsNbt.m_128365_("forfeitCommands", (Tag)listTag2);
        ListTag listTag3 = new ListTag();
        for (String preBattleCommand : this.preBattleCommands) {
            listTag3.add((Object)StringTag.m_129297_((String)preBattleCommand));
        }
        commandsNbt.m_128365_("preBattleCommands", (Tag)listTag3);
        nbt.m_128365_("Commands", (Tag)commandsNbt);
    }

    public boolean canStartBattle(Player opponent, boolean printMessages) {
        if (opponent == null) {
            return true;
        }
        if (!this.canEngage) {
            return false;
        }
        if (this.battleController != null) {
            if (printMessages) {
                ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.inbattle", new Object[0]);
            }
            return false;
        }
        Long lastEncounter = this.playerEncounters.get(opponent.m_20148_());
        if (lastEncounter != null) {
            EnumEncounterMode mode = this.getEncounterMode();
            if (mode == EnumEncounterMode.OncePerDay) {
                long oldTime;
                long oldDay;
                long curTime = System.currentTimeMillis();
                long curDay = curTime / 86400000L;
                if (curDay <= (oldDay = (oldTime = lastEncounter.longValue()) / 86400000L)) {
                    if (printMessages) {
                        ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.onceday", new Object[0]);
                    }
                    return false;
                }
            } else if (mode == EnumEncounterMode.OncePerMCDay) {
                long oldTime;
                long oldDay;
                long curTime = this.f_19853_.m_46467_();
                long curDay = curTime / 24000L;
                if (curDay <= (oldDay = (oldTime = lastEncounter.longValue()) / 24000L)) {
                    if (printMessages) {
                        ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.oncemcday", new Object[0]);
                    }
                    return false;
                }
            } else if (mode == EnumEncounterMode.OncePerPlayer) {
                if (printMessages) {
                    ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.onceplayer", new Object[0]);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_("DefaultName")) {
            this.usingDefaultName = nbt.m_128471_("DefaultName");
            this.usingDefaultWin = nbt.m_128471_("DefaultWin");
            this.usingDefaultLose = nbt.m_128471_("DefaultLose");
            this.usingDefaultGreeting = nbt.m_128471_("DefaultGreet");
            this.trainerId = nbt.m_128461_("TrainerIndex");
            this.chatIndex = nbt.m_128451_("ChatIndex");
        }
        super.m_7378_(nbt);
        if (nbt.m_128441_("BossTier")) {
            this.setBossTier(BossTierRegistry.getBossTierOrNotBoss(nbt.m_128461_("BossTier")));
        }
        this.party.readFromNBT(nbt.m_128469_("pokeStore")).join();
        if (nbt.m_128441_("Greeting")) {
            this.greeting = nbt.m_128461_("Greeting");
            this.winMessage = nbt.m_128461_("WinMessage");
            this.loseMessage = nbt.m_128461_("LoseMessage");
        }
        if (nbt.m_128441_("hasMegaItem")) {
            this.setMegaItem(EnumMegaItemsUnlocked.values()[nbt.m_128451_("hasMegaItem")]);
        }
        if (nbt.m_128441_("oldGen")) {
            this.setOldGenMode(EnumOldGenMode.values()[nbt.m_128451_("oldGen")]);
        }
        if (nbt.m_128441_("WinningsTag")) {
            CompoundTag tag = nbt.m_128469_("WinningsTag");
            this.winnings = new ItemStack[tag.m_128431_().size()];
            int index = 0;
            for (String key : tag.m_128431_()) {
                this.winnings[index++] = ItemStack.m_41712_((CompoundTag)tag.m_128469_(key));
            }
        } else if (nbt.m_128441_("Winnings")) {
            int[] testArray = nbt.m_128465_("Winnings");
            ArrayList<Item> array = new ArrayList<Item>();
            for (int aTestArray : testArray) {
                array.add(Item.m_41445_((int)aTestArray));
            }
            this.winnings = new ItemStack[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                this.winnings[i] = new ItemStack((ItemLike)array.get(i));
            }
        }
        if (nbt.m_128441_("TrainerRotation")) {
            this.setStartRotationYaw(nbt.m_128457_("TrainerRotation"));
        }
        if (nbt.m_128441_("EncMode")) {
            EnumEncounterMode mode = EnumEncounterMode.getFromIndex(nbt.m_128448_("EncMode"));
            this.setEncounterMode(mode);
            this.playerEncounters.clear();
            if (mode != EnumEncounterMode.Once && mode != EnumEncounterMode.Unlimited && nbt.m_128441_("numEncounters")) {
                int numEncounters = nbt.m_128451_("numEncounters");
                for (int i = 0; i < numEncounters; ++i) {
                    String uuid = nbt.m_128461_("encPl" + i);
                    long time = 0L;
                    if (mode != EnumEncounterMode.OncePerPlayer) {
                        long oldDay;
                        long curDay;
                        time = nbt.m_128454_("encTi" + i);
                        if (mode == EnumEncounterMode.OncePerDay) {
                            curDay = System.currentTimeMillis() / 86400000L;
                            if (curDay > (oldDay = time / 86400000L)) continue;
                            this.playerEncounters.put(UUID.fromString(uuid), time);
                            continue;
                        }
                        if (mode != EnumEncounterMode.OncePerMCDay || (curDay = this.f_19853_.m_46467_() / 24000L) > (oldDay = time / 24000L)) continue;
                        this.playerEncounters.put(UUID.fromString(uuid), time);
                        continue;
                    }
                    this.playerEncounters.put(UUID.fromString(uuid), 0L);
                }
            }
            if (mode != EnumEncounterMode.Once && mode != EnumEncounterMode.Unlimited && nbt.m_128441_("Encounters")) {
                ListTag list = nbt.m_128437_("Encounters", 10);
                for (int i = 0; i < list.size(); ++i) {
                    long oldDay;
                    long curDay;
                    long time;
                    CompoundTag compound = list.m_128728_(i);
                    UUID uuid = compound.m_128342_("UUID");
                    long l = time = mode != EnumEncounterMode.OncePerPlayer ? compound.m_128454_("time") : 0L;
                    if (mode == EnumEncounterMode.OncePerDay) {
                        curDay = System.currentTimeMillis() / 86400000L;
                        if (curDay > (oldDay = time / 86400000L)) continue;
                        this.playerEncounters.put(uuid, time);
                        continue;
                    }
                    if (mode == EnumEncounterMode.OncePerMCDay) {
                        curDay = this.f_19853_.m_46467_() / 24000L;
                        if (curDay > (oldDay = time / 24000L)) continue;
                        this.playerEncounters.put(uuid, time);
                        continue;
                    }
                    this.playerEncounters.put(uuid, 0L);
                }
            }
        } else {
            this.setEncounterMode(EnumEncounterMode.Once);
        }
        if (nbt.m_128441_("BattleAIMode")) {
            this.setBattleAIMode(BattleAIMode.getFromIndex(nbt.m_128448_("BattleAIMode")));
        }
        if (nbt.m_128441_("NPCLevel")) {
            this.pokemonLevel = nbt.m_128451_("NPCLevel");
            SYNC_TRAINER_LEVEL.set((Entity)this, (Object)this.pokemonLevel);
            this.updateTrainerLevel();
        }
        if (nbt.m_128441_("Commands")) {
            CompoundTag cmdNbt = nbt.m_128469_("Commands");
            if (cmdNbt.m_128441_("winCommands")) {
                ListTag wins = cmdNbt.m_128437_("winCommands", 8);
                for (int i = 0; i < wins.size(); ++i) {
                    this.winCommands.add(wins.m_128778_(i));
                }
            }
            if (cmdNbt.m_128441_("loseCommands")) {
                ListTag loss = cmdNbt.m_128437_("loseCommands", 8);
                for (int i = 0; i < loss.size(); ++i) {
                    this.loseCommands.add(loss.m_128778_(i));
                }
            }
            if (cmdNbt.m_128441_("forfeitCommands")) {
                ListTag forfeit = cmdNbt.m_128437_("forfeitCommands", 8);
                for (int i = 0; i < forfeit.size(); ++i) {
                    this.forfeitCommands.add(forfeit.m_128778_(i));
                }
            }
            if (cmdNbt.m_128441_("preBattleCommands")) {
                ListTag preBattle = cmdNbt.m_128437_("preBattleCommands", 8);
                for (int i = 0; i < preBattle.size(); ++i) {
                    this.preBattleCommands.add(preBattle.m_128778_(i));
                }
            }
        }
        if (nbt.m_128441_("WinMoney")) {
            this.winMoney = nbt.m_128451_("WinMoney");
        }
        if (nbt.m_128441_("GymLeader")) {
            this.isGymLeader = nbt.m_128471_("GymLeader");
        }
        this.battleRules.readFromNBT(nbt);
        if (nbt.m_128441_("BattleType")) {
            this.battleRules.set(BattleRuleRegistry.BATTLE_TYPE, (Object)BattleType.values()[nbt.m_128448_("BattleType")]);
            nbt.m_128473_("BattleType");
        }
        this.updateTrainerLevel();
    }

    public void randomisePokemon(Player player) {
        ArrayList<Pokemon> randomParty;
        BaseTrainer base = this.getBaseTrainer();
        if (base.name.equals("Steve")) {
            int partySize = RandomHelper.getRandomNumberBetween(1, 6);
            randomParty = new ArrayList(partySize);
            for (int i = 0; i < partySize; ++i) {
                randomParty.add(PokemonSpecificationProxy.create(PixelmonSpecies.getRandomSpecies().getName()).get().create());
            }
            this.pokemonLevel = RandomHelper.getRandomNumberBetween(2, 99);
        } else {
            TrainerData data = ServerNPCRegistry.trainers.getRandomData(base);
            if (data == null) {
                Pixelmon.LOGGER.error(base.name + " has no trainer data set.");
                return;
            }
            randomParty = data.getRandomParty();
        }
        this.loadPokemon(randomParty);
        this.updateTrainerLevel();
        NetworkHelper.sendPacket(new ClearTrainerPokemonPacket(), (ServerPlayer)player);
        for (Pokemon pokemon : this.party.getTeam()) {
            NetworkHelper.sendPacket(new StoreTrainerPokemonPacket(pokemon), (ServerPlayer)player);
        }
    }

    @Override
    public BossTier getBossTier() {
        if (this.bossTier == null) {
            return BossTierRegistry.NOT_BOSS;
        }
        return this.bossTier;
    }

    public void setBossTier(BossTier tier) {
        if (tier == null) {
            tier = BossTierRegistry.NOT_BOSS;
        }
        SYNC_BOSS_MODE.set((Entity)this, (Object)tier);
    }

    public BattleAIMode getBattleAIMode() {
        return this.battleAIMode;
    }

    public void setBattleAIMode(BattleAIMode mode) {
        if (mode != null) {
            SYNC_BATTLE_AI.set((Entity)this, (Object)mode);
        }
    }

    public BattleType getBattleType() {
        return this.battleRules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE);
    }

    public void updateTrainerLevel() {
        int lvlTotal = 0;
        int count = 0;
        for (Pokemon pokemon : this.party.getTeam()) {
            lvlTotal += pokemon.getPokemonLevel();
            ++count;
        }
        if (count < 1) {
            count = 1;
        }
        SYNC_TRAINER_LEVEL.set((Entity)this, (Object)(lvlTotal / count));
    }

    @Override
    public void initDefaultAI() {
        this.m_21573_().m_7008_(true);
    }

    @Override
    public void initAI() {
        switch (this.getAIMode()) {
            case StandStill: {
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.f_21345_.m_262460_(goal -> true);
                this.f_21345_.m_25352_(1, (Goal)new TrainerInBattleGoal(this));
                this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
                this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, PixelmonEntity.class, 6.0f));
                break;
            }
            case Wander: {
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.f_21345_.m_262460_(goal -> true);
                this.f_21345_.m_25352_(1, (Goal)new TrainerInBattleGoal(this));
                this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, Attributes.f_22279_.m_22082_()));
                break;
            }
            case StillAndEngage: {
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.f_21345_.m_262460_(goal -> true);
                this.f_21345_.m_25352_(1, (Goal)new TrainerInBattleGoal(this));
                this.f_21345_.m_25352_(2, (Goal)new TargetNearestGoalInFieldOfView((Mob)this, (float)this.getEngageDistance(), true));
                this.f_21345_.m_25352_(4, (Goal)new ExecuteActionGoal((Mob)this));
                break;
            }
            case StillMoveAndEngage: {
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.f_21345_.m_262460_(goal -> true);
                this.f_21345_.m_25352_(1, (Goal)new TrainerInBattleGoal(this));
                this.f_21345_.m_25352_(2, (Goal)new TargetNearestGoalInFieldOfView((Mob)this, (float)this.getEngageDistance(), true));
                this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((Mob)this, 1.01));
                this.f_21345_.m_25352_(4, (Goal)new ExecuteActionGoal((Mob)this));
                break;
            }
            case WanderAndEngage: {
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.f_21345_.m_262460_(goal -> true);
                this.f_21345_.m_25352_(1, (Goal)new TrainerInBattleGoal(this));
                this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, this.m_21051_(Attributes.f_22279_).m_22135_()));
                this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
                this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, PixelmonEntity.class, 6.0f));
                this.f_21345_.m_25352_(5, (Goal)new ExecuteActionGoal((Mob)this));
                this.f_21345_.m_25352_(6, (Goal)new MoveTowardsTargetGoal((Mob)this, 1.01));
                this.f_21345_.m_25352_(7, (Goal)new TargetNearestGoal((Mob)this, (float)this.getEngageDistance(), true));
            }
        }
    }

    public void update(SetTrainerData p) {
        if (!p.greeting.equals("")) {
            this.greeting = p.greeting;
            this.usingDefaultGreeting = false;
        }
        if (!p.lose.equals("")) {
            this.loseMessage = p.lose;
            this.usingDefaultLose = false;
        }
        if (!p.win.equals("")) {
            this.winMessage = p.win;
            this.usingDefaultWin = false;
        }
        this.winMoney = p.winMoney;
        if (p.rules != null) {
            this.battleRules = p.rules;
        }
        if (p.name != null && !p.name.isEmpty()) {
            this.setName(p.name);
        }
    }

    public void setStartRotationYaw(float f) {
        this.startRotationSet = true;
        this.startRotationYaw = f;
        this.f_19857_ = f;
        this.f_20885_ = f;
    }

    @Override
    public String getDisplayText() {
        Object s = "boss";
        if (this.getBossTier() != null && this.getBossTier().isNotBoss()) {
            s = "" + this.getTrainerLevel();
        }
        return s;
    }

    @Override
    public String getSubTitleText() {
        return I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]);
    }

    public void setBattleController(BattleController battleController) {
        this.battleController = battleController;
    }

    public BattleController getBattleController() {
        return this.battleController;
    }

    public TrainerPartyStorage getPokemonStorage() {
        return this.party;
    }

    public Mob getEntity() {
        return this;
    }

    public void setAttackTargetPix(LivingEntity entity) {
        this.m_6710_(entity);
    }

    public void updateDrops(ItemStack[] drops) {
        this.winnings = drops;
    }

    public ItemStack[] getWinnings() {
        return this.winnings;
    }

    public void setPokemonLevel(int pokemonLevel) {
        this.pokemonLevel = pokemonLevel;
        SYNC_TRAINER_LEVEL.set((Entity)this, (Object)pokemonLevel);
        BaseTrainer base = this.getBaseTrainer();
        TrainerData data = ServerNPCRegistry.trainers.getRandomData(base);
        this.loadPokemon(data.getRandomParty());
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }
}

