/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.trading.NPCTrades;
import com.pixelmonmod.pixelmon.api.trading.PossibleTradeList;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class NPCTrader
extends NPCEntity {
    public TradePair tradePair = null;

    public NPCTrader(EntityType<NPCTrader> type, Level par1World) {
        super(type, par1World);
        this.setName(Component.m_237115_((String)"pixelmon.npc.tradername").getString());
        this.init("Youngster");
    }

    public NPCTrader(Level world) {
        this((EntityType<NPCTrader>)((EntityType)EntityRegistration.NPC_TRADER.get()), world);
    }

    public void m_6119_() {
        if (this.m_21523_()) {
            this.m_21455_(true, true);
        }
    }

    @Override
    public void init(String name) {
        super.init(name);
        if (this.trainer == null) {
            BaseTrainer trainer = ServerNPCRegistry.trainers.getRandomBase();
            this.setBaseTrainer(trainer);
            if (trainer.textures.size() > 1) {
                SYNC_TEXTURE_INDEX.set((Entity)this, (Object)RandomHelper.getRandom().nextInt(trainer.textures.size()));
            }
        }
        if (!this.hasTrade()) {
            this.setNewTrade();
        }
        if (this.getNickName().equalsIgnoreCase("")) {
            this.setNickName(ServerNPCRegistry.getRandomName());
        }
    }

    public void setNewTrade() {
        this.tradePair = PossibleTradeList.getRandomTrade();
    }

    @Override
    public void unloadEntity() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        this.m_6089_();
    }

    public InteractionResult m_21499_(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            this.updateTradePair();
            ItemStack stack = player.m_21120_(hand);
            int id = this.getNPCID();
            if (stack != null && stack.m_41720_() == PixelmonItems.trainer_editor) {
                this.setAIMode(EnumTrainerAI.StandStill);
                this.initAI();
                NPCTrades.updateClientTradeData((ServerPlayer)player, this.tradePair);
                OpenScreenPacket.open(player, EnumGuiScreen.NPCTrade, id);
            } else {
                NPCTrades.showTrade((ServerPlayer)player, this.tradePair, id);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean hasTrade() {
        return this.tradePair != null;
    }

    public void updateTradePair() {
        if (!this.hasTrade()) {
            this.setNewTrade();
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.updateTradePair();
        nbt.m_128365_("Offer", (Tag)this.tradePair.offer.write(new CompoundTag()));
        nbt.m_128365_("Exchange", (Tag)this.tradePair.exchange.write(new CompoundTag()));
        if (this.tradePair.description != null) {
            nbt.m_128359_("TradeDescription", this.tradePair.description);
        }
        nbt.m_128376_("ModelIndex", (short)this.getBaseTrainer().id);
        if (this.getBaseTrainer().textures.size() > 1) {
            nbt.m_128405_("TextureIndex", this.getTextureIndex());
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("ModelIndex")) {
            SYNC_MODEL.set((Entity)this, (Object)ServerNPCRegistry.trainers.getById(nbt.m_128448_("ModelIndex")));
            if (this.getBaseTrainer().textures.size() > 1) {
                SYNC_TEXTURE_INDEX.set((Entity)this, (Object)nbt.m_128451_("TextureIndex"));
            }
        }
        this.tradePair = new TradePair(PokemonSpecificationProxy.create("species:random").get(), PokemonSpecificationProxy.create("species:random").get());
        if (nbt.m_128441_("Exchange")) {
            PokemonSpecification requestedSpec = nbt.m_128423_("Exchange") instanceof CompoundTag ? PokemonSpecificationProxy.fromNbt(nbt.m_128469_("Exchange")).get() : PokemonSpecificationProxy.create(nbt.m_128461_("Exchange")).get();
            this.tradePair.exchange = requestedSpec;
        } else {
            this.tradePair.exchange = PokemonSpecificationProxy.create("species:random").get();
        }
        if (nbt.m_128441_("Offer")) {
            PokemonSpecification offeredSpec = nbt.m_128423_("Offer") instanceof CompoundTag ? PokemonSpecificationProxy.fromNbt(nbt.m_128469_("Offer")).get() : PokemonSpecificationProxy.create(nbt.m_128461_("Offer")).get();
            this.tradePair.offer = offeredSpec;
        } else {
            this.tradePair.offer = PokemonSpecificationProxy.create("random").get();
        }
        if (nbt.m_128441_("TradeDescription")) {
            this.tradePair.description = nbt.m_128461_("TradeDescription");
        }
    }

    public void updateTrade(PokemonSpecification offer, PokemonSpecification exchange, @Nullable String description) {
        this.tradePair = new TradePair(offer, exchange, description);
    }

    @Override
    public String getDisplayText() {
        return I18n.m_118938_((String)"pixelmon.npc.tradername", (Object[])new Object[0]);
    }

    @Override
    public void initAI() {
        this.f_21345_.f_25345_.clear();
        switch (this.getAIMode()) {
            case StandStill: {
                this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
                this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, PixelmonEntity.class, 6.0f));
                break;
            }
            case Wander: {
                this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, Attributes.f_22279_.m_22082_()));
                break;
            }
        }
    }

    @Override
    public boolean m_6094_() {
        return this.getAIMode() != EnumTrainerAI.StandStill;
    }

    @Override
    public boolean m_6785_(double p_213397_1_) {
        return this.getAIMode() == EnumTrainerAI.Wander;
    }
}

