/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetShopkeeperClientPacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.IndexedNPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperChat;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperData;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;

public class NPCShopkeeper
extends IndexedNPCEntity {
    private long lastUpdatedTime = 0L;
    private ArrayList<ShopItemWithVariation> itemList;
    ArrayList<UUID> playerList = new ArrayList();

    public NPCShopkeeper(EntityType<NPCShopkeeper> type, Level world) {
        super((EntityType<? extends IndexedNPCEntity>)type, world);
    }

    public NPCShopkeeper(Level world) {
        this((EntityType<NPCShopkeeper>)((EntityType)EntityRegistration.NPC_SHOPKEEPER.get()), world);
    }

    public void init(ShopkeeperData data) {
        this.npcIndex = data.id;
        this.nameIndex = data.getRandomNameIndex();
        this.chatIndex = data.getRandomChatIndex();
        this.setCustomSteveTexture(data.getRandomTexture());
    }

    @Override
    public void init(String name) {
        super.init(name);
        if (this.getCustomSteveTexture().equals("")) {
            this.setCustomSteveTexture("npcchat1.png");
        }
    }

    @Override
    public boolean m_6094_() {
        return false;
    }

    public void initRandom(String biomeID) {
        ShopkeeperData data = ServerNPCRegistry.shopkeepers.getRandomSpawning(biomeID);
        if (data == null) {
            this.m_6089_();
        } else {
            this.init(data);
        }
        this.npcLocation = SpawnLocationType.LAND_NPC;
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/" + this.getCustomSteveTexture();
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.initDefaultAI();
        if (nbt.m_128441_("ShopItems")) {
            ListTag list = nbt.m_128437_("ShopItems", 10);
            this.itemList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                ShopItemWithVariation item = ShopItemWithVariation.getFromNBT(this.npcIndex, list.m_128728_(i));
                if (item == null) continue;
                this.getItemList().add(item);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag list = new ListTag();
        if (this.getItemList() != null) {
            for (ShopItemWithVariation item : this.getItemList()) {
                item.writeToNBT(list);
            }
            nbt.m_128365_("ShopItems", (Tag)list);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean interactWithNPC(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!(player instanceof ServerPlayer)) {
            this.f_21345_.f_25345_.clear();
            return true;
        }
        ServerPlayer playerMP = (ServerPlayer)player;
        if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, EnumNPCType.Shopkeeper, (Player)playerMP))) {
            return false;
        }
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof NPCEditorItem) {
            if (!NPCEditorItem.checkPermission((Player)playerMP)) {
                return false;
            }
            String loc = playerMP.getLanguage();
            NetworkHelper.sendPacket(new SetShopkeeperClientPacket(loc), playerMP);
            NetworkHelper.sendPacket(new SetNPCEditDataPacket(ServerNPCRegistry.shopkeepers.getJsonName(this.npcIndex), this.getShopkeeperName(loc), this.getCustomSteveTexture()), playerMP);
            OpenScreenPacket.open(player, EnumGuiScreen.ShopkeeperEditor, this.getNPCID());
            return true;
        }
        if (this.getItemList() == null || this.getItemList().isEmpty()) {
            this.loadItems();
        }
        this.sendItemsToPlayer(player);
        OpenScreenPacket.open(player, EnumGuiScreen.Shopkeeper, this.getNPCID());
        return true;
    }

    public void sendItemsToPlayer(Player player) {
        ArrayList<ShopItemWithVariation> sellList = this.getSellList(player);
        String loc = ((ServerPlayer)player).getLanguage();
        this.playerList.add(player.m_20148_());
        NetworkHelper.sendPacket(new SetNPCDataPacket(this.getShopkeeperName(loc), this.getShopkeeperChat(loc), this.getItemList(), sellList), (ServerPlayer)player);
    }

    public ArrayList<ShopItemWithVariation> getSellList(Player player) {
        ArrayList<ShopItemWithVariation> sellList = new ArrayList<ShopItemWithVariation>();
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            BaseShopItem baseItem;
            ItemStack item = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (item == null) continue;
            ShopItemWithVariation shopItem = null;
            shopItem = this.getExistingItem(item);
            if (shopItem == null && (baseItem = ServerNPCRegistry.shopkeepers.getItem(item)) != null) {
                shopItem = new ShopItemWithVariation(new ShopItem(baseItem, 1.0f, 1.0f, false), 1.0f);
            }
            if (shopItem == null || !shopItem.canSell() || this.alreadyListed(sellList, shopItem)) continue;
            sellList.add(shopItem);
        }
        return sellList;
    }

    private boolean alreadyListed(ArrayList<ShopItemWithVariation> sellList, ShopItemWithVariation shopItem) {
        for (ShopItemWithVariation item : sellList) {
            if (item.getItemStack() != shopItem.getItemStack()) continue;
            return true;
        }
        return false;
    }

    private ShopItemWithVariation getExistingItem(ItemStack item) {
        for (ShopItemWithVariation si : this.getItemList()) {
            if (!ItemStack.m_41728_((ItemStack)si.getItemStack(), (ItemStack)item)) continue;
            return si;
        }
        return null;
    }

    private boolean isItemStackEqual(ItemStack a, ItemStack b) {
        if (a.m_41720_() != b.m_41720_()) {
            return false;
        }
        if (a.m_41773_() != b.m_41773_()) {
            return false;
        }
        if (a.m_41783_() == null && b.m_41783_() != null || b.m_41783_() == null && a.m_41783_() != null) {
            return false;
        }
        return false;
    }

    private ShopkeeperChat getShopkeeperChat(String langCode) {
        int index = this.chatIndex;
        return ServerNPCRegistry.shopkeepers.getTranslatedChat(langCode, this.npcIndex, index);
    }

    public String getShopkeeperName(String langCode) {
        return ServerNPCRegistry.shopkeepers.getTranslatedName(langCode, this.npcIndex, this.nameIndex);
    }

    public void loadItems() {
        this.lastUpdatedTime = this.f_19853_.m_46467_();
        ShopkeeperData skd = ServerNPCRegistry.shopkeepers.getById(this.npcIndex);
        this.itemList = skd != null ? skd.getItemList() : new ArrayList();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.playerList.size() > 0) {
            for (int i = 0; i < this.playerList.size(); ++i) {
                Player player = this.f_19853_.m_46003_(this.playerList.get(i));
                if (player != null) continue;
                this.playerList.remove(i);
                --i;
            }
        }
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46467_() > this.lastUpdatedTime + 24000L && this.playerList.size() == 0) {
            this.loadItems();
        }
    }

    public ArrayList<ShopItemWithVariation> getItemList() {
        return this.itemList;
    }

    public void cycleJson(ServerPlayer p, String newJSON) {
        ShopkeeperData id = ServerNPCRegistry.shopkeepers.getById(newJSON);
        if (id == null) {
            return;
        }
        this.init(id);
        String loc = p.getLanguage();
        NetworkHelper.sendPacket(new SetNPCEditDataPacket(ServerNPCRegistry.shopkeepers.getJsonName(this.npcIndex), this.getShopkeeperName(loc), this.getCustomSteveTexture()), p);
    }

    public void cycleName(ServerPlayer p, int nameIndex) {
        this.nameIndex = nameIndex;
        String loc = p.getLanguage();
        NetworkHelper.sendPacket(new SetNPCEditDataPacket(ServerNPCRegistry.shopkeepers.getJsonName(this.npcIndex), this.getShopkeeperName(loc), this.getCustomSteveTexture()), p);
    }

    @Override
    public String getDisplayText() {
        return I18n.m_118938_((String)"gui.shopkeeper", (Object[])new Object[0]);
    }

    @Override
    public String getSubTitleText() {
        return null;
    }
}

