/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.InteractNPCPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;

public class NPCRelearner
extends NPCEntity {
    public static final DataSync<NPCRelearner, ItemStack> SYNC_COST = new DataSync<NPCRelearner, ItemStack>(NPCRelearner.class, EntityDataSerializers.f_135033_, (npcEntity, s) -> {
        npcEntity.cost = s;
    });
    private ItemStack cost;

    public NPCRelearner(EntityType<NPCRelearner> type, Level world) {
        super(type, world);
    }

    public NPCRelearner(Level world) {
        this((EntityType<NPCRelearner>)((EntityType)EntityRegistration.NPC_RELEARNER.get()), world);
        this.init(Component.m_237115_((String)"pixelmon.npc.relearnername").getString());
    }

    @Override
    protected void m_8097_() {
        this.define(SYNC_COST, ItemStack.f_41583_);
        super.m_8097_();
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/npcchat1.png";
    }

    @Override
    public String getDisplayText() {
        return I18n.m_118938_((String)"pixelmon.npc.relearnername", (Object[])new Object[0]);
    }

    public void m_5997_(double par1, double par3, double par5) {
    }

    public ItemStack getCost() {
        ItemStack cost = this.cost;
        if (cost.m_41619_() || cost.m_41720_() instanceof NPCEditorItem || cost.m_41720_() == Items.f_41852_) {
            return ItemStack.f_41583_;
        }
        return cost;
    }

    public void setCost(ItemStack item) {
        SYNC_COST.set((Entity)this, (Object)item);
    }

    @Override
    public boolean interactWithNPC(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, EnumNPCType.Relearner, player))) {
                return false;
            }
            ItemStack cost = this.getCost();
            ItemStack itemstack = player.m_21120_(hand);
            if (player.m_7500_()) {
                if (!itemstack.m_41619_()) {
                    if (itemstack.m_41720_() instanceof NPCEditorItem) {
                        this.openRelearnerGui(player);
                    } else if (cost.m_41619_() || cost.m_41720_() != itemstack.m_41720_() || cost.m_41773_() != itemstack.m_41773_()) {
                        cost = player.m_6144_() ? new ItemStack((ItemLike)itemstack.m_41720_(), 1, itemstack.serializeNBT()) : itemstack.m_41777_();
                        this.setCost(cost);
                        ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnersetitem", cost.m_41786_(), cost.m_41613_());
                    } else if (cost.m_41613_() != cost.m_41741_()) {
                        cost.m_41769_(1);
                        this.setCost(cost);
                        ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnersetitem", cost.m_41786_(), cost.m_41613_());
                    } else {
                        ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnerfull", new Object[0]);
                    }
                } else if (!cost.m_41619_()) {
                    cost.m_41774_(1);
                    if (cost.m_41613_() <= 0) {
                        cost = ItemStack.f_41583_;
                        ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnernoitem", new Object[0]);
                        this.setCost(cost);
                    } else {
                        this.setCost(cost);
                        ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnersetitem", cost.m_41786_(), cost.m_41613_());
                    }
                } else {
                    this.openRelearnerGui(player);
                }
            } else if (this.checkCost(itemstack)) {
                this.openRelearnerGui(player);
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.npc.relearnercost", cost.m_41786_(), cost.m_41613_());
            }
        } else {
            this.f_21345_.m_25386_().forEach(arg_0 -> ((GoalSelector)this.f_21345_).m_25363_(arg_0));
        }
        return true;
    }

    public boolean checkCost(ItemStack hand) {
        ItemStack cost = this.getCost();
        if (cost.m_41619_()) {
            return true;
        }
        return ItemStack.m_41656_((ItemStack)cost, (ItemStack)hand) && hand.m_41613_() >= cost.m_41613_() && (!cost.m_41782_() || cost.m_41783_().equals((Object)hand.m_41783_()));
    }

    public void openRelearnerGui(Player player) {
        NetworkHelper.sendPacket(new InteractNPCPacket(this.getNPCID(), EnumNPCType.Relearner), (ServerPlayer)player);
        OpenScreenPacket.open(player, EnumGuiScreen.ChooseRelearnMove, new int[0]);
    }

    public static List<ImmutableAttack> getRelearnableMoves(Pokemon pokemon) {
        ArrayList<ImmutableAttack> attackList = new ArrayList<ImmutableAttack>(pokemon.getRelearnableMoves());
        List<ImmutableAttack> levelUpList = pokemon.getForm().getMoves().getMovesUpToLevel(pokemon.getPokemonLevel());
        for (int i = levelUpList.size() - 1; i >= 0; --i) {
            ImmutableAttack move = levelUpList.get(i);
            if (attackList.contains(move)) continue;
            attackList.add(move);
        }
        for (Attack attack : pokemon.getMoveset()) {
            if (attack == null) continue;
            attackList.remove(attack.getActualMove());
        }
        return attackList;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ItemStack cost = this.getCost();
        if (!cost.m_41619_()) {
            CompoundTag stack = cost.serializeNBT();
            nbt.m_128365_("RelearnerCostStack", (Tag)stack);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("RelearnerCostStack")) {
            this.setCost(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("RelearnerCostStack")));
        } else if (nbt.m_128441_("Cost")) {
            ItemStack cost = new ItemStack((ItemLike)Item.m_41445_((int)nbt.m_128451_("Cost")), nbt.m_128451_("costNum"));
            cost.m_41721_(nbt.m_128451_("CostDamage"));
            this.setCost(cost);
        }
    }

    @Override
    public void initAI() {
        this.f_21345_.m_262460_(goal -> true);
        switch (this.getAIMode()) {
            case StandStill: {
                this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
                this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, PixelmonEntity.class, 6.0f));
                break;
            }
            case Wander: {
                this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, Attributes.f_22279_.m_22082_()));
                break;
            }
        }
    }

    @Override
    public boolean m_6094_() {
        return this.getAIMode() != EnumTrainerAI.StandStill;
    }

    @Override
    public boolean m_6785_(double p_213397_1_) {
        return this.getAIMode() == EnumTrainerAI.Wander;
    }
}

