/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetChattingNPCTexturesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditDataPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;

public class NPCQuestGiver
extends NPCChatting {
    public NPCQuestGiver(EntityType<NPCQuestGiver> type, Level world) {
        super((EntityType<? extends NPCChatting>)type, world);
        this.npcType = EnumNPCType.QuestGiver;
    }

    public NPCQuestGiver(Level world) {
        this((EntityType<NPCQuestGiver>)((EntityType)EntityRegistration.NPC_QUEST_GIVER.get()), world);
    }

    @Override
    public boolean interactWithNPC(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)player;
            if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, this.npcType, (Player)playerMP))) {
                return false;
            }
            String loc = playerMP.getLanguage();
            if (!itemstack.m_41619_() && itemstack.m_41720_() instanceof NPCEditorItem) {
                if (!NPCEditorItem.checkPermission((Player)playerMP)) {
                    return false;
                }
                NetworkHelper.sendPacket(new SetNPCEditDataPacket(this.getName(loc), this.getChat(loc), this.npcType), playerMP);
                NetworkHelper.sendPacket(new SetChattingNPCTexturesPacket(), playerMP);
                OpenScreenPacket.open(player, EnumGuiScreen.NPCQuestGiverEditor, this.getNPCID());
            } else if (!this.getChat(loc).isEmpty()) {
                NPCChatEvent event = new NPCChatEvent(this, player, this.getChat(loc));
                if (Pixelmon.EVENT_BUS.post((Event)event)) {
                    return false;
                }
                NetworkHelper.sendPacket(new SetNPCDataPacket(this.getName(loc), event.getChat(), this.npcType), (ServerPlayer)player);
                OpenScreenPacket.open(player, EnumGuiScreen.NPCQuestGiver, this.getNPCID());
            }
        } else {
            this.f_21345_.m_25386_().forEach(arg_0 -> ((GoalSelector)this.f_21345_).m_25363_(arg_0));
        }
        return true;
    }
}

