/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCDataPacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.FishingRodItem;
import java.util.ArrayList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;

public class NPCFisherman
extends NPCChatting {
    public NPCFisherman(EntityType<NPCFisherman> type, Level world) {
        super((EntityType<? extends NPCChatting>)type, world);
    }

    public NPCFisherman(Level world) {
        this((EntityType<NPCFisherman>)((EntityType)EntityRegistration.NPC_FISHERMAN.get()), world);
        this.npcLocation = SpawnLocationType.LAND_VILLAGER;
    }

    @Override
    public String getDisplayText() {
        return I18n.m_118938_((String)"pixelmon.npc.fishermanname", (Object[])new Object[0]);
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/oldfisherman.png";
    }

    @Override
    public boolean interactWithNPC(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)player;
            if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, EnumNPCType.OldFisherman, (Player)playerMP))) {
                return false;
            }
            String loc = playerMP.getLanguage();
            ArrayList<String> chat = new ArrayList<String>();
            if (!itemstack.m_41619_() && itemstack.m_41720_() instanceof FishingRodItem) {
                chat.add("gui.oldfisherman.assess");
                if (!itemstack.m_41782_()) {
                    itemstack.m_41751_(new CompoundTag());
                }
                if (itemstack.m_41720_() != PixelmonItems.oas_rod) {
                    if (!itemstack.m_41783_().m_128441_("rodQuality")) {
                        int quality = this.getRodQuality();
                        itemstack.m_41783_().m_128405_("rodQuality", quality);
                        chat.add("gui.oldfisherman.rod.quality" + quality);
                    } else {
                        chat.add("gui.oldfisherman.alreadychecked");
                    }
                } else {
                    chat.add("gui.oldfisherman.rod.oas");
                }
            } else {
                boolean hasLog = false;
                for (ItemStack stack1 : playerMP.m_150109_().f_35974_) {
                    if (stack1.m_41720_() != PixelmonItems.fishing_log) continue;
                    hasLog = true;
                    break;
                }
                if (playerMP.m_150109_().f_35976_.get(0) != null && ((ItemStack)playerMP.m_150109_().f_35976_.get(0)).m_41720_() == PixelmonItems.fishing_log) {
                    hasLog = true;
                }
                ItemStack log = new ItemStack((ItemLike)PixelmonItems.fishing_log);
                for (Pokemon pokemon : StorageProxy.getPartyNow(playerMP).getAll()) {
                    if (!hasLog && pokemon != null && pokemon.getSpecies().is(PixelmonSpecies.MAGIKARP) && pokemon.getPalette() != pokemon.getSpecies().getFirstPaletteProperties()) {
                        playerMP.m_36356_(log);
                        chat.add("gui.oldfisherman.givekarplog");
                        break;
                    }
                    if (!hasLog && pokemon != null && pokemon.getSpecies().is(PixelmonSpecies.SHELLOS) && pokemon.getPalette() != pokemon.getSpecies().getFirstPaletteProperties()) {
                        playerMP.m_36356_(log);
                        chat.add("gui.oldfisherman.giveshelloslog");
                        break;
                    }
                    if (hasLog || pokemon == null || !pokemon.getSpecies().is(PixelmonSpecies.CLOBBOPUS) || pokemon.getPalette() == pokemon.getSpecies().getFirstPaletteProperties()) continue;
                    playerMP.m_36356_(log);
                    chat.add("gui.oldfisherman.givecloblog");
                    break;
                }
                if (chat.isEmpty()) {
                    chat.add("gui.oldfisherman.general");
                    chat.add("gui.oldfisherman.general2");
                }
            }
            NPCChatEvent event = new NPCChatEvent(this, player, chat);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            NetworkHelper.sendPacket(new SetNPCDataPacket(this.getName(loc), event.getChat()), (ServerPlayer)player);
            OpenScreenPacket.open(player, EnumGuiScreen.NPCChat, this.getNPCID());
        } else {
            this.f_21345_.m_25386_().forEach(arg_0 -> ((GoalSelector)this.f_21345_).m_25363_(arg_0));
        }
        return true;
    }

    @Override
    public String getName(String langCode) {
        return "Old Fisherman";
    }

    public int getRodQuality() {
        double percent = RandomHelper.getRandom().nextDouble();
        if (percent <= 0.3856) {
            return 0;
        }
        if (percent <= 0.5785) {
            return 1;
        }
        if (percent <= 0.7079) {
            return 2;
        }
        if (percent <= 0.8044) {
            return 3;
        }
        if (percent <= 0.8815) {
            return 4;
        }
        if (percent <= 0.9449) {
            return 5;
        }
        return 6;
    }

    @Override
    public void m_5997_(double par1, double par3, double par5) {
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.initDefaultAI();
    }
}

