/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.platform.NativeImage;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.ai.HarvestFarmLandGoal;
import com.pixelmonmod.pixelmon.ai.WanderGoal;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.util.ThreadPool;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.joml.Vector3f;

public abstract class NPCEntity
extends PathfinderMob
implements Npc {
    public static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f SMALLER = new Vector3f(0.85f, 0.8f, 0.85f);
    private static final ThreadPool TEXTURE_LOADER = ThreadPool.createNewThreadPool("Texture Loader", 1);
    public static final int TICKSPERSECOND = 20;
    public static int intMinTicksToDespawn = 600;
    public static int intMaxTicksToDespawn = 1200;
    public static final DataSync<NPCEntity, String> SYNC_NAME = new DataSync<NPCEntity, String>(NPCEntity.class, EntityDataSerializers.f_135030_, (npcEntity, s) -> {
        npcEntity.name = s;
    });
    public static final DataSync<NPCEntity, String> SYNC_NICKNAME = new DataSync<NPCEntity, String>(NPCEntity.class, EntityDataSerializers.f_135030_, (npcEntity, s) -> {
        npcEntity.nickName = s;
    });
    public static final DataSync<NPCEntity, BaseTrainer> SYNC_MODEL = new DataSync<NPCEntity, BaseTrainer>(NPCEntity.class, PixelmonDataSerializers.BASE_TRAINER, (npcEntity, baseTrainer) -> {
        npcEntity.trainer = baseTrainer;
    });
    public static final DataSync<NPCEntity, Integer> SYNC_TEXTURE_INDEX = new DataSync<NPCEntity, Integer>(NPCEntity.class, EntityDataSerializers.f_135028_, (npcEntity, integer) -> {
        npcEntity.textureIndex = integer;
    });
    public static final DataSync<NPCEntity, String> SYNC_CUSTOM_STEVE_TEXTURE = new DataSync<NPCEntity, String>(NPCEntity.class, EntityDataSerializers.f_135030_, (npcEntity, s) -> {
        npcEntity.customSteveTexture = s;
    });
    public static final DataSync<NPCEntity, Integer> SYNC_PROFESSION = new DataSync<NPCEntity, Integer>(NPCEntity.class, EntityDataSerializers.f_135028_, (npcEntity, integer) -> {
        npcEntity.profession = integer;
    });
    private static final DataSync<NPCEntity, EnumTrainerAI> SYNC_NPC_AI = new DataSync<NPCEntity, EnumTrainerAI>(NPCEntity.class, PixelmonDataSerializers.TRAINER_AI, (npcEntity, enumTrainerAI) -> {
        npcEntity.trainerAI = enumTrainerAI;
        if (npcEntity.m_21573_() != null && npcEntity.f_21345_ != null) {
            npcEntity.initAI();
        }
    });
    private String name;
    private String nickName;
    private int npcID;
    protected BaseTrainer trainer;
    private int textureIndex;
    private String customSteveTexture;
    private int profession;
    private EnumTrainerAI trainerAI;
    public SpawnLocationType npcLocation;
    public int despawnCounter = -1;
    private SimpleContainer npcInventory;
    protected int chatIndex;
    public ArrayList<String> interactCommands = new ArrayList();
    protected EntityDataSyncManager dataSyncManager;
    private int randomTickDivider;

    public NPCEntity(EntityType<? extends NPCEntity> type, Level world) {
        super(type, world);
        this.npcInventory = new SimpleContainer(8);
        this.initAI();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(SYNC_NAME, "");
        this.define(SYNC_NICKNAME, "");
        this.define(SYNC_MODEL, NPCRegistryTrainers.Steve);
        this.define(SYNC_TEXTURE_INDEX, 0);
        this.define(SYNC_CUSTOM_STEVE_TEXTURE, "youngster1");
        this.define(SYNC_PROFESSION, -1);
        this.define(SYNC_NPC_AI, EnumTrainerAI.Wander);
    }

    protected <A> void define(DataSync<?, A> sync, A value) {
        if (this.dataSyncManager == null) {
            this.dataSyncManager = new EntityDataSyncManager();
        }
        this.dataSyncManager.define((Entity)this, sync, value);
    }

    public void init(String name) {
        this.setName(name);
        this.m_21153_(100.0f);
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        SYNC_NICKNAME.set((Entity)this, (Object)nickName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.getTextureIndex() == -1) {
            return "pixelmon:textures/steve/" + this.getCustomSteveTexture().toLowerCase(Locale.ROOT) + ".png";
        }
        BaseTrainer t = this.getBaseTrainer();
        if (t == null) {
            return "pixelmon:textures/steve/" + this.getCustomSteveTexture().toLowerCase(Locale.ROOT) + ".png";
        }
        if ((t == NPCRegistryTrainers.Steve || t.name.equals("Steve")) && !t.textures.isEmpty()) {
            String textureName = t.textures.get(this.getTextureIndex());
            if (textureName.equals("Custom_PN") && this.getCustomSteveTexture().contains(";")) {
                String id = this.getCustomSteveTexture().split(";")[1];
                ResourceLocation rl = ResourceLocationHelper.of("playerskins", id);
                if (Minecraft.m_91087_().m_91097_().m_174786_(rl, null) == null) {
                    try {
                        NativeImage image = NativeImage.m_85058_((InputStream)new URL("http://textures.minecraft.net/texture/" + id).openStream());
                        if (image.m_85084_() < 64) {
                            int y;
                            int x;
                            NativeImage resized = new NativeImage(image.m_84982_(), image.m_84982_(), false);
                            for (x = 0; x < image.m_84982_(); ++x) {
                                for (y = 0; y < image.m_85084_(); ++y) {
                                    resized.m_84988_(x, y, image.m_84985_(x, y));
                                }
                            }
                            for (x = 32; x < resized.m_84982_(); ++x) {
                                for (y = 0; y < 16; ++y) {
                                    int rgb = resized.m_84985_(x, y);
                                    if (rgb != -16777216) continue;
                                    resized.m_84988_(x, y, 0);
                                }
                            }
                            for (x = 0; x < 16; ++x) {
                                for (y = 16; y < 32; ++y) {
                                    resized.m_84988_(x + 16, y + 32, resized.m_84985_(x, y));
                                }
                            }
                            for (x = 40; x < 56; ++x) {
                                for (y = 16; y < 32; ++y) {
                                    resized.m_84988_(x - 8, y + 32, resized.m_84985_(x, y));
                                }
                            }
                            image = resized;
                        }
                        Minecraft.m_91087_().m_91097_().m_118495_(rl, (AbstractTexture)new DynamicTexture(image));
                        return rl.toString();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return DefaultPlayerSkin.m_294143_((UUID)this.m_20148_()).toString();
                    }
                }
                return rl.toString();
            }
            if (textureName.equals("Custom_RP") && this.getCustomSteveTexture().equals("")) {
                return DefaultPlayerSkin.m_294143_((UUID)this.m_20148_()).toString();
            }
            if (textureName.equals("Steve")) {
                return DefaultPlayerSkin.m_294143_((UUID)this.m_20148_()).toString();
            }
        }
        if (!t.textures.isEmpty() && this.getTextureIndex() > -1) {
            if (this.getTextureIndex() >= t.textures.size()) {
                this.setTextureIndex(t.textures.size() - 1);
            }
            if (t.textures.get(this.getTextureIndex()).equals("Custom_RP")) {
                return "pixelmon:textures/steve/" + this.getCustomSteveTexture() + ".png";
            }
            return "pixelmon:textures/steve/" + t.textures.get(this.getTextureIndex()) + ".png";
        }
        if (this.getTextureIndex() == -1) {
            return "pixelmon:textures/steve/" + this.getCustomSteveTexture().toLowerCase(Locale.ROOT) + ".png";
        }
        if (t != NPCRegistryTrainers.Steve && !t.name.equals("Steve")) {
            return "pixelmon:textures/steve/" + t.name.toLowerCase(Locale.ROOT) + ".png";
        }
        return "pixelmon:textures/steve/" + this.getCustomSteveTexture().toLowerCase(Locale.ROOT) + ".png";
    }

    public String getCustomSteveTexture() {
        if (this.customSteveTexture == null || this.customSteveTexture.isEmpty()) {
            return "baker.png";
        }
        return this.customSteveTexture;
    }

    public void setCustomSteveTexture(String tex) {
        BaseTrainer trainer = this.getBaseTrainer();
        if (this.getTextureIndex() < 0 || trainer.textures.size() <= this.getTextureIndex()) {
            SYNC_CUSTOM_STEVE_TEXTURE.set((Entity)this, (Object)tex);
            return;
        }
        String textureName = trainer.textures.get(this.getTextureIndex());
        if (textureName == null || !textureName.equals("Custom_PN")) {
            SYNC_CUSTOM_STEVE_TEXTURE.set((Entity)this, (Object)tex);
            return;
        }
        TEXTURE_LOADER.submit(() -> {
            try {
                String texture = this.getBase64Texture(tex);
                this.m_20194_().m_18709_(() -> SYNC_CUSTOM_STEVE_TEXTURE.set((Entity)this, (Object)(tex + ";" + texture)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private String getBase64Texture(String name) throws IOException {
        String base64;
        if (name == null || name.trim().isEmpty()) {
            return "dc1c77ce8e54925ab58125446ec53b0cdd3d0ca3db273eb908d5482787ef4016";
        }
        Optional profileOptional = ServerLifecycleHooks.getCurrentServer().m_129927_().m_10996_(name);
        if (!profileOptional.isPresent()) {
            return "dc1c77ce8e54925ab58125446ec53b0cdd3d0ca3db273eb908d5482787ef4016";
        }
        GameProfile profile = (GameProfile)profileOptional.get();
        if (!profile.getProperties().isEmpty()) {
            base64 = ((Property)profile.getProperties().get((Object)"textures").iterator().next()).value();
        } else {
            InputStream is = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + profile.getId().toString().replace("-", "")).openConnection().getInputStream();
            base64 = new JsonParser().parse((Reader)new InputStreamReader(is)).getAsJsonObject().getAsJsonArray("properties").get(0).getAsJsonObject().get("value").getAsString();
        }
        return new JsonParser().parse((Reader)new InputStreamReader(new ByteArrayInputStream(Base64.getDecoder().decode(base64)))).getAsJsonObject().getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString().replace("http://textures.minecraft.net/texture/", "");
    }

    public boolean m_6785_(double p_213397_1_) {
        return !this.m_21532_() && !this.m_8023_();
    }

    public Component m_7755_() {
        return Component.m_237113_((String)this.name);
    }

    public void setName(String name) {
        SYNC_NAME.set((Entity)this, (Object)name);
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (p_21016_.m_19390_()) {
            return super.m_6469_(p_21016_, p_21017_);
        }
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_20223_(CompoundTag p_70039_1_) {
        return this.shouldSave() && super.m_20223_(p_70039_1_);
    }

    public boolean shouldSave() {
        return this.m_6084_() && (this.m_21532_() || PixelmonConfigProxy.getStorage().isWriteEntitiesToWorld() || super.m_8023_());
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Name", this.m_7755_().getString());
        if (this.npcLocation == null || this.npcLocation == SpawnLocationType.LAND) {
            this.npcLocation = SpawnLocationType.LAND_VILLAGER;
        }
        nbt.m_128405_("trainerLocation", this.npcLocation.ordinal());
        nbt.m_128359_("BaseTrainer", this.getBaseTrainer().name);
        if (this.getBaseTrainer() == NPCRegistryTrainers.Steve || this.getBaseTrainer().textures.size() > 1) {
            nbt.m_128405_("TextureIndex", this.getTextureIndex());
        }
        nbt.m_128359_("CustomSteveTexture", this.getCustomSteveTexture());
        nbt.m_128376_("Profession", (short)this.getProfession());
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.npcInventory.m_6643_(); ++i) {
            ItemStack itemstack = this.npcInventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            nbttaglist.add((Object)itemstack.serializeNBT());
        }
        nbt.m_128365_("Inventory", (Tag)nbttaglist);
        nbt.m_128376_("AIMode", (short)this.getAIMode().ordinal());
        CompoundTag commandsNbt = new CompoundTag();
        ListTag interactList = new ListTag();
        for (String interactCommand : this.interactCommands) {
            interactList.add((Object)StringTag.m_129297_((String)interactCommand));
        }
        commandsNbt.m_128365_("interactCommands", (Tag)interactList);
        nbt.m_128365_("Commands", (Tag)commandsNbt);
    }

    public void m_7378_(CompoundTag nbt) {
        CompoundTag cmdNbt;
        super.m_7378_(nbt);
        this.setName(nbt.m_128461_("Name"));
        if (nbt.m_128441_("trainerLocation")) {
            this.npcLocation = SpawnLocationType.getFromIndex(nbt.m_128451_("trainerLocation"));
            if (this.npcLocation == null) {
                this.npcLocation = SpawnLocationType.LAND_VILLAGER;
            }
        } else {
            this.npcLocation = SpawnLocationType.LAND;
        }
        this.init(this.m_7755_().getString());
        BaseTrainer trainer = null;
        if (nbt.m_128441_("ModelIndex")) {
            trainer = ServerNPCRegistry.trainers.getById(nbt.m_128451_("ModelIndex"));
        } else if (nbt.m_128441_("BaseTrainer")) {
            trainer = NPCRegistryTrainers.getByName(nbt.m_128461_("BaseTrainer"));
        }
        if (trainer != null) {
            this.setBaseTrainer(trainer);
            if (this.getBaseTrainer().textures.size() > 1) {
                this.setTextureIndex(nbt.m_128451_("TextureIndex"));
            }
        }
        if (nbt.m_128461_("CustomSteveTexture").contains(";")) {
            SYNC_CUSTOM_STEVE_TEXTURE.set((Entity)this, (Object)nbt.m_128461_("CustomSteveTexture"));
        } else {
            this.setCustomSteveTexture(nbt.m_128461_("CustomSteveTexture"));
        }
        this.setProfession(nbt.m_128448_("Profession"));
        ListTag nbttaglist = nbt.m_128437_("Inventory", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)nbttaglist.m_128728_(i));
            if (itemstack.m_41619_()) continue;
            this.npcInventory.m_19173_(itemstack);
        }
        if (this.getProfession() == 0) {
            this.initVilagerAI();
            this.f_21345_.m_25352_(6, (Goal)new HarvestFarmLandGoal(this, 0.6));
        }
        if (nbt.m_128441_("IsPersistent") && nbt.m_128471_("IsPersistent")) {
            this.m_21530_();
        }
        if (nbt.m_128441_("AIMode")) {
            this.setAIMode(EnumTrainerAI.getFromOrdinal(nbt.m_128448_("AIMode")));
            this.initAI();
        }
        if (nbt.m_128441_("Commands") && (cmdNbt = nbt.m_128469_("Commands")).m_128441_("interactCommands")) {
            ListTag wins = cmdNbt.m_128437_("interactCommands", 8);
            for (int i = 0; i < wins.size(); ++i) {
                this.interactCommands.add(wins.m_128778_(i));
            }
        }
    }

    public void initAI() {
        this.initDefaultAI();
    }

    public boolean m_5545_(LevelAccessor p_21686_, MobSpawnType p_21687_) {
        int var3;
        int var2;
        int var1 = Mth.m_14107_((double)this.m_20185_());
        Block block = this.f_19853_.m_8055_(new BlockPos(var1, (var2 = Mth.m_14107_((double)this.m_20191_().f_82289_)) - 1, var3 = Mth.m_14107_((double)this.m_20189_()))).m_60734_();
        return block == Blocks.f_50034_ || block == Blocks.f_49992_;
    }

    public InteractionResult m_7111_(Player player, Vec3 p_19981_, InteractionHand hand) {
        return this.interactWithNPC(player, hand) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean interactWithNPC(Player player, InteractionHand hand) {
        return false;
    }

    public int m_5792_() {
        return 1;
    }

    public int getNPCID() {
        return this.m_19879_();
    }

    public abstract String getDisplayText();

    public String getSubTitleText() {
        return null;
    }

    public BossTier getBossTier() {
        return BossTierRegistry.NOT_BOSS;
    }

    public BaseTrainer getBaseTrainer() {
        return this.trainer;
    }

    public void setBaseTrainer(BaseTrainer trainer) {
        SYNC_MODEL.set((Entity)this, (Object)trainer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean bindTexture() {
        block19: {
            String textureName;
            block20: {
                block21: {
                    if (this.getTextureIndex() == -1) {
                        return false;
                    }
                    BaseTrainer t = this.getBaseTrainer();
                    if (t != NPCRegistryTrainers.Steve && !t.name.equals("Steve")) break block19;
                    textureName = t.textures.get(this.getTextureIndex());
                    if (textureName.equals("Custom_PN") && this.getCustomSteveTexture().contains(";")) {
                        String id = this.getCustomSteveTexture().split(";")[1];
                        ResourceLocation rl = ResourceLocationHelper.of("playerskins", id);
                        if (Minecraft.m_91087_().m_91097_().m_118506_(rl) == null) {
                            try {
                                NativeImage image = NativeImage.m_85058_((InputStream)new URL("http://textures.minecraft.net/texture/" + id).openStream());
                                if (image.m_85084_() < 64) {
                                    int y;
                                    int x;
                                    NativeImage resized = new NativeImage(image.m_84982_(), image.m_84982_(), false);
                                    for (x = 0; x < image.m_84982_(); ++x) {
                                        for (y = 0; y < image.m_85084_(); ++y) {
                                            resized.m_84988_(x, y, image.m_84985_(x, y));
                                        }
                                    }
                                    for (x = 32; x < resized.m_84982_(); ++x) {
                                        for (y = 0; y < 16; ++y) {
                                            int rgb = resized.m_84985_(x, y);
                                            if (rgb != -16777216) continue;
                                            resized.m_84988_(x, y, 0);
                                        }
                                    }
                                    for (x = 0; x < 16; ++x) {
                                        for (y = 16; y < 32; ++y) {
                                            resized.m_84988_(x + 16, y + 32, resized.m_84985_(x, y));
                                        }
                                    }
                                    for (x = 40; x < 56; ++x) {
                                        for (y = 16; y < 32; ++y) {
                                            resized.m_84988_(x - 8, y + 32, resized.m_84985_(x, y));
                                        }
                                    }
                                    image = resized;
                                }
                                Minecraft.m_91087_().m_91097_().m_118495_(rl, (AbstractTexture)new DynamicTexture(image));
                                ScreenHelper.bindTexture(rl);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                ScreenHelper.bindTexture(DefaultPlayerSkin.m_294143_((UUID)this.m_20148_()).f_290339_());
                            }
                        } else {
                            ScreenHelper.bindTexture(rl);
                        }
                        return true;
                    }
                    if (!textureName.equals("Custom_RP")) break block20;
                    if (this.getCustomSteveTexture().equals("")) break block21;
                    if (CommonProxy.resourceLocationExists(ResourceLocationHelper.of(this.getTexture()))) break block20;
                }
                ScreenHelper.bindTexture(DefaultPlayerSkin.m_294143_((UUID)this.m_20148_()).f_290339_());
                return true;
            }
            if (textureName.equals("Steve")) {
                ScreenHelper.bindTexture(DefaultPlayerSkin.m_294143_((UUID)this.m_20148_()).f_290339_());
                return true;
            }
        }
        return false;
    }

    public Vector3f getModelScale() {
        BaseTrainer base = this.getBaseTrainer();
        if (base != null && (base.name.equals("Youngster") || base.name.equals("Lass") || base.name.equals("PreschoolerGirl"))) {
            return SMALLER;
        }
        return ONE;
    }

    public static <T extends NPCEntity> Optional<T> locateNPCClient(Level world, int id, Class<T> type) {
        Entity entityByID = world.m_6815_(id);
        if (!type.isInstance(entityByID)) {
            return Optional.empty();
        }
        return Optional.of((NPCEntity)entityByID);
    }

    public static <T extends NPCEntity> Optional<T> locateNPCServer(Level world, int id, Class<T> type) {
        Entity entityByID = world.m_6815_(id);
        if (!type.isInstance(entityByID)) {
            return Optional.empty();
        }
        return Optional.of((NPCEntity)entityByID);
    }

    public static <T extends NPCEntity> Optional<T> locateNPCServer(Level world, String name, Class<T> type, String langCode) {
        Iterable entities = ((ServerLevel)world).m_142646_().m_142273_();
        for (Entity entity : entities) {
            String npcName;
            if (!type.isInstance(entity) || !name.equals(npcName = type == NPCTrainer.class ? ((NPCTrainer)entity).getName(langCode) : ((NPCEntity)entity).m_7755_().getString())) continue;
            return Optional.of((NPCEntity)entity);
        }
        return Optional.empty();
    }

    public void unloadEntity() {
        this.m_142687_(Entity.RemovalReason.UNLOADED_TO_CHUNK);
        this.m_6089_();
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public void setTextureIndex(int index) {
        SYNC_TEXTURE_INDEX.set((Entity)this, (Object)index);
    }

    public void m_8119_() {
        if (this.m_6785_(0.0) && !this.f_19853_.f_46443_) {
            this.checkForRarityDespawn();
        }
        try {
            super.m_8119_();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected void checkForRarityDespawn() {
        if (this.despawnCounter > 0) {
            --this.despawnCounter;
        } else if (this.despawnCounter == 0) {
            if (!this.playersNearby()) {
                this.m_6089_();
            }
        } else {
            this.despawnCounter = (int)(Math.random() * (double)(intMaxTicksToDespawn - intMinTicksToDespawn) + (double)intMinTicksToDespawn);
        }
    }

    protected boolean playersNearby() {
        for (int i = 0; i < this.f_19853_.m_6907_().size(); ++i) {
            double distancez;
            double distancey;
            Player player = (Player)this.f_19853_.m_6907_().get(i);
            double distancex = player.m_20185_() - this.m_20185_();
            double distancesquared = distancex * distancex + (distancey = player.m_20186_() - this.m_20186_()) * distancey + (distancez = player.m_20189_() - this.m_20189_()) * distancez;
            if (!(distancesquared < (double)(PixelmonConfigProxy.getSpawning().getDespawnRadius() * PixelmonConfigProxy.getSpawning().getDespawnRadius()))) continue;
            return true;
        }
        return false;
    }

    public void setProfession(int professionId) {
        SYNC_PROFESSION.set((Entity)this, (Object)professionId);
    }

    public int getProfession() {
        return this.profession;
    }

    public void initDefaultAI() {
        this.m_21573_().m_7008_(true);
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public void initWanderingAI() {
        this.m_21573_().m_7008_(true);
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new WanderGoal(this));
    }

    public void initVilagerAI() {
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21573_().m_7008_(true);
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, (double)0.8f, (double)0.6f));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(7, (Goal)new WanderGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.m_21553_(true);
    }

    public boolean isFarmItemInInventory() {
        for (int i = 0; i < this.npcInventory.m_6643_(); ++i) {
            ItemStack itemstack = this.npcInventory.m_8020_(i);
            if (itemstack == null || itemstack.m_41720_() != Items.f_42404_ && itemstack.m_41720_() != Items.f_42620_ && itemstack.m_41720_() != Items.f_42619_) continue;
            return true;
        }
        return false;
    }

    public boolean hasItemToPlant() {
        boolean flag;
        boolean bl = flag = this.getProfession() == 0;
        return flag ? !this.hasEnoughItems(5) : !this.hasEnoughItems(1);
    }

    private boolean hasEnoughItems(int multiplier) {
        boolean flag = this.getProfession() == 0;
        for (int j = 0; j < this.npcInventory.m_6643_(); ++j) {
            ItemStack itemstack = this.npcInventory.m_8020_(j);
            if (itemstack == null) continue;
            if (itemstack.m_41720_() == Items.f_42406_ && itemstack.m_41613_() >= 3 * multiplier || itemstack.m_41720_() == Items.f_42620_ && itemstack.m_41613_() >= 12 * multiplier || itemstack.m_41720_() == Items.f_42619_ && itemstack.m_41613_() >= 12 * multiplier) {
                return true;
            }
            if (!flag || itemstack.m_41720_() != Items.f_42405_ || itemstack.m_41613_() < 9 * multiplier) continue;
            return true;
        }
        return false;
    }

    public Container getNPCInventory() {
        return this.npcInventory;
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        Item item = itemstack.m_41720_();
        if (this.canVillagerPickupItem(item)) {
            ItemStack itemstack1 = this.npcInventory.m_19173_(itemstack);
            if (itemstack1 == null) {
                itemEntity.m_142687_(Entity.RemovalReason.KILLED);
            } else {
                itemstack.m_41764_(itemstack1.m_41613_());
            }
        }
    }

    private boolean canVillagerPickupItem(Item itemIn) {
        return itemIn == Items.f_42406_ || itemIn == Items.f_42620_ || itemIn == Items.f_42619_ || itemIn == Items.f_42405_ || itemIn == Items.f_42404_;
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public EnumTrainerAI getAIMode() {
        if (this.trainerAI == null) {
            SYNC_NPC_AI.set((Entity)this, (Object)EnumTrainerAI.Wander);
        }
        return this.trainerAI;
    }

    public void setAIMode(EnumTrainerAI mode) {
        SYNC_NPC_AI.set((Entity)this, (Object)mode);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }
}

