/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.NativeImage;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetChattingNPCTexturesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditDataPacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.IndexedNPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GymNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.entity.TCGTrades;
import com.pixelmonmod.tcg.item.AdminPendantItem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.eventbus.api.Event;

public class NPCChatting
extends IndexedNPCEntity
implements Merchant {
    private ArrayList<String> chatPages = new ArrayList();
    boolean usingDefaultName = true;
    boolean usingDefaultChat = true;
    protected EnumNPCType npcType;
    private Player tradingPlayer;
    protected MerchantOffers offers;
    private final SimpleContainer inventory = new SimpleContainer(8);

    public NPCChatting(EntityType<? extends NPCChatting> type, Level world) {
        super((EntityType<? extends IndexedNPCEntity>)type, world);
        this.npcType = EnumNPCType.ChattingNPC;
    }

    public NPCChatting(Level world) {
        this((EntityType<? extends NPCChatting>)((EntityType)EntityRegistration.NPC_CHATTING.get()), world);
    }

    public void init(GeneralNPCData data) {
        this.npcIndex = data.id;
        this.nameIndex = data.getRandomNameIndex();
        this.chatIndex = data.getRandomChatIndex();
        this.npcLocation = SpawnLocationType.LAND_VILLAGER;
    }

    public void init(GymNPCData data) {
        this.npcIndex = "_gym_" + data.id;
        this.nameIndex = data.getRandomNameIndex();
        this.chatIndex = data.getRandomChatIndex();
        this.npcLocation = SpawnLocationType.LAND_VILLAGER;
    }

    @Override
    public void init(String name) {
        super.init(name);
        this.setCustomSteveTexture("npcchat1.png");
    }

    @Override
    public boolean m_6094_() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.getCustomSteveTexture().contains(";")) {
            String id = this.getCustomSteveTexture().split(";")[1];
            ResourceLocation rl = ResourceLocationHelper.of("playerskins", id);
            if (Minecraft.m_91087_().m_91097_().m_118506_(rl) == null) {
                try {
                    NativeImage image = NativeImage.m_85058_((InputStream)new URL("http://textures.minecraft.net/texture/" + id).openStream());
                    if (image.m_85084_() < 64) {
                        int y;
                        int x;
                        NativeImage resized = new NativeImage(image.m_84982_(), image.m_84982_(), false);
                        for (x = 0; x < image.m_84982_(); ++x) {
                            for (y = 0; y < image.m_85084_(); ++y) {
                                resized.m_84988_(x, y, image.m_84985_(x, y));
                            }
                        }
                        for (x = 32; x < resized.m_84982_(); ++x) {
                            for (y = 0; y < 16; ++y) {
                                int rgb = resized.m_84985_(x, y);
                                if (rgb != -16777216) continue;
                                resized.m_84988_(x, y, 0);
                            }
                        }
                        for (x = 0; x < 16; ++x) {
                            for (y = 16; y < 32; ++y) {
                                resized.m_84988_(x + 16, y + 32, resized.m_84985_(x, y));
                            }
                        }
                        for (x = 40; x < 56; ++x) {
                            for (y = 16; y < 32; ++y) {
                                resized.m_84988_(x - 8, y + 32, resized.m_84985_(x, y));
                            }
                        }
                        image = resized;
                    }
                    Minecraft.m_91087_().m_91097_().m_118495_(rl, (AbstractTexture)new DynamicTexture(image));
                    return rl.toString();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return DefaultPlayerSkin.m_294143_((UUID)this.m_20148_()).f_290339_().toString();
                }
            }
            return rl.toString();
        }
        return "pixelmon:textures/steve/" + this.getCustomSteveTexture();
    }

    @Override
    public String getDisplayText() {
        return "";
    }

    @Override
    public void m_5997_(double par1, double par3, double par5) {
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("DefaultName", this.usingDefaultName);
        nbt.m_128379_("DefaultGreet", this.usingDefaultChat);
        nbt.m_128405_("chatNum", this.chatPages.size());
        int i = 0;
        for (String page : this.chatPages) {
            nbt.m_128359_("chat" + i, page);
            ++i;
        }
        MerchantOffers merchantoffers = this.m_6616_();
        if (!merchantoffers.isEmpty()) {
            nbt.m_128365_("Offers", (Tag)merchantoffers.m_45388_());
        }
        nbt.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.usingDefaultName = nbt.m_128471_("DefaultName");
        this.usingDefaultChat = nbt.m_128471_("DefaultGreet");
        int numPages = nbt.m_128451_("chatNum");
        for (int i = 0; i < numPages; ++i) {
            this.chatPages.add(nbt.m_128461_("chat" + i));
        }
        if (this.getProfession() != 0) {
            this.initDefaultAI();
        }
        if (nbt.m_128425_("Offers", 10)) {
            this.offers = new MerchantOffers(nbt.m_128469_("Offers"));
        }
        this.inventory.m_7797_(nbt.m_128437_("Inventory", 10));
    }

    @Override
    public boolean interactWithNPC(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)player;
            if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, this.npcType, (Player)playerMP))) {
                return false;
            }
            String loc = playerMP.getLanguage();
            if (!itemstack.m_41619_() && itemstack.m_41720_() instanceof NPCEditorItem) {
                if (!NPCEditorItem.checkPermission((Player)playerMP)) {
                    return false;
                }
                NetworkHelper.sendPacket(new SetNPCEditDataPacket(this.getName(loc), this.getChat(loc), this.npcType), playerMP);
                NetworkHelper.sendPacket(new SetChattingNPCTexturesPacket(), playerMP);
                OpenScreenPacket.open(player, EnumGuiScreen.NPCChatEditor, this.getNPCID());
            } else if (!itemstack.m_41619_() && itemstack.m_41720_() instanceof AdminPendantItem) {
                if (!NPCEditorItem.checkPermission((Player)playerMP)) {
                    return false;
                }
                this.getPersistentData().m_128379_("TCGTrader", !this.getPersistentData().m_128471_("TCGTrader"));
            } else if (!this.startTradingWith(player) && !this.getChat(loc).isEmpty()) {
                NPCChatEvent event = new NPCChatEvent(this, player, this.getChat(loc));
                if (Pixelmon.EVENT_BUS.post((Event)event)) {
                    return false;
                }
                NetworkHelper.sendPacket(new SetNPCDataPacket(this.getName(loc), event.getChat(), this.npcType), (ServerPlayer)player);
                OpenScreenPacket.open(player, EnumGuiScreen.NPCChat, this.getNPCID());
            }
        } else {
            this.f_21345_.m_25386_().forEach(arg_0 -> ((GoalSelector)this.f_21345_).m_25363_(arg_0));
        }
        return true;
    }

    @Override
    public ArrayList<String> getChat(String langCode) {
        if (this.usingDefaultChat) {
            int index = this.chatIndex;
            if (this.npcIndex.startsWith("_gym_")) {
                return new ArrayList<String>(Arrays.asList(ServerNPCRegistry.getTranslatedGymMemberChat(langCode, this.npcIndex.substring(5), index)));
            }
            return new ArrayList<String>(Arrays.asList(ServerNPCRegistry.villagers.getTranslatedChat(langCode, this.npcIndex, index)));
        }
        return this.chatPages;
    }

    @Override
    public String getName(String langCode) {
        if (this.usingDefaultName) {
            int index = this.nameIndex;
            if (this.npcIndex.startsWith("_gym_")) {
                return ServerNPCRegistry.getTranslatedGymMemberName(langCode, this.npcIndex.substring(5), index);
            }
            return ServerNPCRegistry.villagers.getTranslatedName(langCode, this.npcIndex, index);
        }
        return this.m_7755_().getString();
    }

    public void setChat(ArrayList<String> pages) {
        this.chatPages = pages;
        this.usingDefaultChat = false;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.usingDefaultName = false;
    }

    public void cycleTexture(ServerPlayer p, ClientNPCData newData) {
        GeneralNPCData data = ServerNPCRegistry.villagers.getData(newData.getID());
        if (data == null) {
            return;
        }
        this.init(data);
        this.setTextureIndex(0);
        this.setCustomSteveTexture(newData.getTexture());
        NetworkHelper.sendPacket(new SetNPCEditDataPacket(this.getName(p.getLanguage()), this.getChat(p.getLanguage()), this.npcType), p);
    }

    public double m_21133_(Attribute attribute) {
        if (attribute.m_22087_().equalsIgnoreCase("attribute.name.generic.movement_speed")) {
            return 0.5;
        }
        return super.m_21133_(attribute);
    }

    public int m_7809_() {
        return 0;
    }

    public void m_7189_(@Nullable Player p_70932_1_) {
        this.tradingPlayer = p_70932_1_;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
        }
        return this.offers;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6255_(@Nullable MerchantOffers p_213703_1_) {
    }

    public void m_6621_(int p_213702_1_) {
    }

    public void m_6996_(MerchantOffer p_213704_1_) {
        p_213704_1_.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.rewardTradeXp(p_213704_1_);
    }

    protected void rewardTradeXp(MerchantOffer p_213713_1_) {
        if (p_213713_1_.m_45383_()) {
            int i = 3 + RandomHelper.getRandom().nextInt(4);
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    public boolean m_7826_() {
        return false;
    }

    public void m_7713_(ItemStack p_110297_1_) {
        if (!this.f_19853_.f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.m_5496_(this.getTradeUpdatedSound(!p_110297_1_.m_41619_()), this.m_6121_(), this.m_6100_());
            if (this.m_6616_().size() < TCGConfigProxy.getConfig().getMaxTradesPerTrader()) {
                this.updateTrades();
            }
        }
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12509_;
    }

    public boolean m_183595_() {
        return false;
    }

    protected SoundEvent getTradeUpdatedSound(boolean p_213721_1_) {
        return p_213721_1_ ? SoundEvents.f_12509_ : SoundEvents.f_12507_;
    }

    public void playCelebrateSound() {
        this.m_5496_(SoundEvents.f_12504_, this.m_6121_(), this.m_6100_());
    }

    @Nullable
    public Entity changeDimension(ServerLevel p_241206_1_, ITeleporter teleporter) {
        this.stopTrading();
        return super.changeDimension(p_241206_1_, teleporter);
    }

    protected void stopTrading() {
        this.m_7189_(null);
    }

    public void m_6667_(DamageSource p_70645_1_) {
        super.m_6667_(p_70645_1_);
        this.stopTrading();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addParticlesAroundSelf(ParticleOptions p_213718_1_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = RandomHelper.getRandom().nextGaussian() * 0.02;
            double d1 = RandomHelper.getRandom().nextGaussian() * 0.02;
            double d2 = RandomHelper.getRandom().nextGaussian() * 0.02;
            this.f_19853_.m_7106_(p_213718_1_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    protected void updateTrades() {
        VillagerTrades.ItemListing[] trades;
        if (this.getPersistentData().m_128471_("TCGTrader") && (trades = (VillagerTrades.ItemListing[])TCGTrades.TCG_TRADER_TRADES.get(1)) != null) {
            int i;
            VillagerTrades.ItemListing trade;
            MerchantOffer merchantoffer;
            MerchantOffers merchantoffers = this.m_6616_();
            if (this.m_6616_().size() != 0 && this.m_6616_().size() < TCGConfigProxy.getConfig().getMaxTradesPerTrader()) {
                this.addOffersFromItemListings(merchantoffers, trades, 1);
            }
            if (this.m_6616_().size() == 0) {
                this.addOffersFromItemListings(merchantoffers, trades, 3);
            }
            if ((merchantoffer = (trade = trades[i = RandomHelper.getRandom().nextInt(trades.length)]).m_213663_((Entity)this, this.f_19796_)) != null) {
                merchantoffers.add((Object)merchantoffer);
            }
        }
    }

    protected void addOffersFromItemListings(MerchantOffers p_213717_1_, VillagerTrades.ItemListing[] p_213717_2_, int amountOfItemsToAdd) {
        if (amountOfItemsToAdd <= 0) {
            Pixelmon.LOGGER.warn("You tried to add 0 items to offer, this is an invalid amount");
            return;
        }
        HashSet set = Sets.newHashSet();
        if (p_213717_2_.length > amountOfItemsToAdd) {
            while (set.size() < amountOfItemsToAdd - 1) {
                set.add(RandomHelper.getRandom().nextInt(p_213717_2_.length));
            }
        } else {
            for (int i = 0; i < p_213717_2_.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ItemListing villagertrades$itrade = p_213717_2_[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.m_213663_((Entity)this, this.f_19796_);
            if (merchantoffer == null) continue;
            p_213717_1_.add((Object)merchantoffer);
        }
    }

    public boolean startTradingWith(Player player) {
        if (this.m_6616_().isEmpty()) {
            this.updateTrades();
        }
        if (!this.getPersistentData().m_128471_("TCGTrader") || this.m_6616_().isEmpty() || !this.m_6084_() || this.isTrading()) {
            return false;
        }
        if (!this.f_19853_.f_46443_) {
            this.m_7189_(player);
            this.m_45301_(player, this.m_5446_(), 1);
        }
        return true;
    }

    public Level getLevel() {
        return this.f_19853_;
    }
}

