/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;

public abstract class IndexedNPCEntity
extends NPCEntity {
    protected int nameIndex;
    protected int chatIndex;
    protected String npcIndex = "NPC";

    public IndexedNPCEntity(EntityType<? extends IndexedNPCEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("TrainerIndex", this.npcIndex);
        nbt.m_128405_("ChatIndex", this.chatIndex);
        nbt.m_128405_("NameIndex", this.nameIndex);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.npcIndex = nbt.m_128461_("TrainerIndex");
        this.chatIndex = nbt.m_128451_("ChatIndex");
        this.nameIndex = nbt.m_128451_("NameIndex");
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/" + this.getCustomSteveTexture();
    }

    @Override
    public String getDisplayText() {
        return "";
    }

    public void m_5997_(double par1, double par3, double par5) {
    }

    @Override
    public boolean interactWithNPC(Player player, InteractionHand hand) {
        return false;
    }

    public ArrayList<String> getChat(String langCode) {
        int index = this.chatIndex;
        return new ArrayList<String>(Arrays.asList(ServerNPCRegistry.villagers.getTranslatedChat(langCode, this.npcIndex, index)));
    }

    public String getName(String langCode) {
        int index = this.nameIndex;
        return ServerNPCRegistry.villagers.getTranslatedName(langCode, this.npcIndex, index);
    }

    public boolean shouldRiderSit() {
        return super.shouldRiderSit();
    }

    public ItemStack getPickedResult(HitResult target) {
        return super.getPickedResult(target);
    }

    public boolean canRiderInteract() {
        return super.canRiderInteract();
    }

    public boolean isMultipartEntity() {
        return super.isMultipartEntity();
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return super.getParts();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }
}

