/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.custom;

import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public class PixelmonPaintingEntity
extends HangingEntity {
    public static final DataSync<PixelmonPaintingEntity, ItemStack> SYNC_ITEM_STACK = new DataSync<PixelmonPaintingEntity, ItemStack>(PixelmonPaintingEntity.class, EntityDataSerializers.f_135033_, (pixelmonPaintingEntity, itemStack) -> {
        pixelmonPaintingEntity.item = itemStack;
    });
    private ItemStack item;
    protected EntityDataSyncManager dataSyncManager;

    public PixelmonPaintingEntity(EntityType<PixelmonPaintingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public PixelmonPaintingEntity(Level world) {
        this((EntityType<PixelmonPaintingEntity>)((EntityType)EntityRegistration.PAINTING.get()), world);
    }

    public PixelmonPaintingEntity(Level worldIn, BlockPos pos, Direction facing) {
        super((EntityType)EntityRegistration.PAINTING.get(), worldIn, pos);
        this.m_6022_(facing);
    }

    protected void m_8097_() {
        this.dataSyncManager = new EntityDataSyncManager();
        this.dataSyncManager.define((Entity)this, SYNC_ITEM_STACK, ItemStack.f_41583_);
    }

    public void m_7378_(CompoundTag compound) {
        CompoundTag nbt2 = compound.m_128469_("Item");
        if (!nbt2.m_128456_()) {
            this.setDisplayedItemWithUpdate(ItemStack.m_41712_((CompoundTag)nbt2), false);
        }
    }

    public void m_7380_(CompoundTag compound) {
        if (this.getDisplayedItem() != null) {
            compound.m_128365_("Item", (Tag)this.getDisplayedItem().m_41739_(new CompoundTag()));
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.f_19853_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (this.getDisplayedItem() == null && !stack.m_41619_() && stack.m_41720_() == PixelmonItems.pixelmon_sprite) {
            this.setDisplayedItem(stack);
            stack.m_41774_(1);
            if (!player.m_7500_() && stack.m_41613_() <= 0) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5553_(Entity brokenEntity) {
        this.dropItemOrSelf(brokenEntity, true);
    }

    public void dropItemOrSelf(Entity p_146065_1_, boolean p_146065_2_) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46136_)) {
            Player entityplayer;
            ItemStack itemstack = this.getDisplayedItem();
            if (p_146065_1_ instanceof Player && (entityplayer = (Player)p_146065_1_).m_7500_()) {
                return;
            }
            if (p_146065_2_) {
                this.m_5552_(new ItemStack((ItemLike)PixelmonItems.item_frame), 0.0f);
            }
            if (itemstack != null) {
                itemstack = itemstack.m_41777_();
                this.m_5552_(itemstack, 0.0f);
            }
        }
    }

    public void m_7087_() {
        if (this.f_19853_.f_46443_) {
            this.f_31699_ = Direction.m_122364_((double)this.f_19857_);
        }
        if (this.f_31699_ != null) {
            double x = (double)this.f_31698_.m_123341_() + 0.5;
            double y = (double)this.f_31698_.m_123342_() + 0.5;
            double z = (double)this.f_31698_.m_123343_() + 0.5;
            super.m_20343_(x, y, z);
            if (this.f_31699_ == Direction.NORTH) {
                this.m_20011_(new AABB(x - 1.5, y - 1.5, z + 0.3, x + 0.5, y + 0.5, z + 0.5));
            } else if (this.f_31699_ == Direction.SOUTH) {
                this.m_20011_(new AABB(x - 0.5, y - 1.5, z - 0.3, x + 1.5, y + 0.5, z - 0.5));
            } else if (this.f_31699_ == Direction.EAST) {
                this.m_20011_(new AABB(x - 0.3, y - 1.5, z - 1.5, x - 0.5, y + 0.5, z + 0.5));
            } else {
                this.m_20011_(new AABB(x + 0.3, y - 1.5, z - 0.5, x + 0.5, y + 0.5, z + 1.5));
            }
        }
    }

    public int m_7076_() {
        return 32;
    }

    public int m_7068_() {
        return 32;
    }

    public boolean m_7088_() {
        return true;
    }

    private void setDisplayedItemWithUpdate(ItemStack stack, boolean p_174864_2_) {
        if (stack != null) {
            stack = stack.m_41777_();
            stack.m_41764_(1);
        }
        SYNC_ITEM_STACK.set((Entity)this, (Object)stack);
        if (p_174864_2_ && this.f_31698_ != null) {
            this.f_19853_.m_46717_(this.f_31698_, Blocks.f_50016_);
        }
    }

    public void setDisplayedItem(ItemStack stack) {
        this.setDisplayedItemWithUpdate(stack, true);
    }

    public ItemStack getDisplayedItem() {
        return this.item != ItemStack.f_41583_ ? this.item : null;
    }

    public void m_7084_() {
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }
}

