/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.custom;

import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.init.registry.PixelmonWoodType;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PixelmonBoatEntity
extends Boat {
    public static final DataSync<PixelmonBoatEntity, WoodType> WOOD_TYPE_DATA_SYNC = new DataSync<PixelmonBoatEntity, WoodType>(PixelmonBoatEntity.class, PixelmonDataSerializers.WOOD_TYPE, (pixelmonBoatEntity, woodType1) -> {
        pixelmonBoatEntity.woodType = woodType1;
    });
    protected WoodType woodType;
    protected EntityDataSyncManager dataSyncManager;

    public PixelmonBoatEntity(EntityType<? extends Boat> p_i50129_1_, Level p_i50129_2_) {
        super(p_i50129_1_, p_i50129_2_);
        this.f_19850_ = true;
    }

    public PixelmonBoatEntity(Level level, double x, double y, double z) {
        super((EntityType)EntityRegistration.BOAT.get(), level);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19790_ = x;
        this.f_19791_ = y;
        this.f_19792_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(WOOD_TYPE_DATA_SYNC, PixelmonWoodType.BLUE_BERRY_WOOD);
    }

    protected <A> void define(DataSync<?, A> sync, A value) {
        if (this.dataSyncManager == null) {
            this.dataSyncManager = new EntityDataSyncManager();
        }
        this.dataSyncManager.define((Entity)this, sync, value);
    }

    public Item m_38369_() {
        if (this.getWoodType() == PixelmonWoodType.BLUE_BERRY_WOOD) {
            return PixelmonItems.blue_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.GREEN_BERRY_WOOD) {
            return PixelmonItems.green_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.PINK_BERRY_WOOD) {
            return PixelmonItems.pink_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.PURPLE_BERRY_WOOD) {
            return PixelmonItems.purple_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.RED_BERRY_WOOD) {
            return PixelmonItems.red_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.YELLOW_BERRY_WOOD) {
            return PixelmonItems.yellow_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.ULTRA_ELM_WOOD) {
            return PixelmonItems.ultra_elm_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.ULTRA_GINGKO_WOOD) {
            return PixelmonItems.ultra_gingko_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.ULTRA_JUNGLE_WOOD) {
            return PixelmonItems.ultra_jungle_boat;
        }
        return null;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public void setWoodType(WoodType woodType) {
        WOOD_TYPE_DATA_SYNC.set((Entity)this, (Object)woodType);
    }

    public ItemStack getPickedResult(HitResult target) {
        return super.getPickedResult(target);
    }

    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("BoatType", this.woodType.f_61839_());
    }

    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        String type = nbt.m_128461_("BoatType");
        this.setWoodType((WoodType)RandomHelper.getRandomElementFromCollection(WoodType.m_61843_().filter(woodType1 -> woodType1.f_61839_().equalsIgnoreCase(type)).collect(Collectors.toList())));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }
}

