/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.bikes;

import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.enums.EnumBike;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BikeEntity
extends AbstractHorse {
    private static final DataSync<BikeEntity, EnumBike> SYNC_TYPE = new DataSync<BikeEntity, EnumBike>(BikeEntity.class, PixelmonDataSerializers.BIKE_TYPE, (bikeEntity, enumBike) -> {
        bikeEntity.bikeType = enumBike;
    });
    private static final DataSync<BikeEntity, DyeColor> SYNC_COLOR = new DataSync<BikeEntity, DyeColor>(BikeEntity.class, PixelmonDataSerializers.DYE_COLOR, (bikeEntity, dyeColor) -> {
        bikeEntity.color = dyeColor;
    });
    public boolean jumping = false;
    private int acceleratingTicks = 0;
    private boolean pushing = false;
    private float outOfControlTicks;
    public float moveStrafing;
    public float moveVertical;
    public float moveForward;
    public float randomYawVelocity;
    public IncrementingVariable inc;
    private EnumBike bikeType;
    private DyeColor color;
    protected EntityDataSyncManager dataSyncManager;
    private static int neededAccelerationTicks = 15;

    public BikeEntity(Level world) {
        this((EntityType<BikeEntity>)((EntityType)EntityRegistration.BIKE.get()), world);
    }

    public BikeEntity(EntityType<BikeEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.0f);
        this.f_19850_ = true;
    }

    protected void m_8097_() {
        this.dataSyncManager = new EntityDataSyncManager();
        super.m_8097_();
        this.dataSyncManager.define((Entity)this, SYNC_TYPE, EnumBike.Mach);
        this.dataSyncManager.define((Entity)this, SYNC_COLOR, EnumBike.Mach.defaultColor);
    }

    public boolean m_21525_() {
        return true;
    }

    public void m_213583_(Player p_218808_) {
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return this.m_7515_();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return this.m_7515_();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return this.m_7515_();
    }

    protected void m_7486_() {
    }

    @Nullable
    protected SoundEvent m_7871_() {
        return this.m_7515_();
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
    }

    protected void m_5877_(SoundType p_190680_1_) {
    }

    public Component m_7755_() {
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        return this.getBikeType().getTranslatedName();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }

    protected float m_293694_(EntityDimensions p_299002_, float p_297393_) {
        return 0.7f;
    }

    public boolean m_30614_() {
        return true;
    }

    public boolean m_6254_() {
        return true;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void travel(float strafe, float up, float forward) {
        LivingEntity rider = this.m_6688_();
        if (rider != null) {
            strafe = rider.f_20900_ / 3.0f;
            forward = rider.f_20902_;
            boolean bl = this.pushing = rider.f_20902_ > 0.0f;
            if (this.pushing && this.acceleratingTicks < 0) {
                this.acceleratingTicks = 1;
            } else if (this.pushing) {
                this.acceleratingTicks = Math.min(this.acceleratingTicks + 1, neededAccelerationTicks);
            }
        } else {
            this.pushing = false;
        }
        this.f_19857_ -= strafe * 10.0f;
        this.f_19857_ = (this.f_19857_ + 180.0f) % 360.0f - 180.0f;
        strafe = 0.0f;
        this.moveEntityRidden(strafe, forward);
        double var9 = this.m_20185_() - this.f_19854_;
        double var12 = this.m_20189_() - this.f_19856_;
        float var11 = Mth.m_14116_((float)((float)(var9 * var9 + var12 * var12))) * 4.0f;
        if (var11 > 1.0f) {
            var11 = 1.0f;
        }
    }

    private void moveEntityRidden(float strafe, float forward) {
        float f4 = Math.signum(forward) * Mth.m_14036_((float)(1.0f * (float)this.acceleratingTicks / (float)neededAccelerationTicks * this.getRideSpeed()), (float)0.0f, (float)this.getRideSpeed());
        if (this.getAcceleration() == 1.0f) {
            f4 = this.getRideSpeed();
        } else if (forward < 0.0f) {
            if (this.acceleratingTicks > 2) {
                this.acceleratingTicks -= 2;
            } else {
                f4 = 0.25f * this.getRideSpeed();
                this.acceleratingTicks = 0;
                this.pushing = false;
            }
        }
        if (this.m_20069_()) {
            double d0 = this.m_20186_();
            Vec3 moveInWater = new Vec3(0.0, (double)forward, 0.05);
            this.m_19920_(strafe, moveInWater);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20334_(this.m_20184_().f_82479_ * (double)0.8f, this.m_20184_().f_82480_ * (double)0.8f, this.m_20184_().f_82481_ * (double)0.8f);
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - 0.019, this.m_20184_().f_82481_);
            if (this.f_19862_ && this.m_20229_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + (double)0.6f - this.m_20186_() + d0, this.m_20184_().f_82481_)) {
                this.m_20334_(this.m_20184_().f_82479_, 0.3f, this.m_20184_().f_82481_);
            }
        } else if (this.m_20077_()) {
            double d0 = this.m_20186_();
            Vec3 moveInLava = new Vec3(0.0, (double)forward, (double)0.02f);
            this.m_19920_(strafe, moveInLava);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20334_(this.m_20184_().f_82479_ * 0.6, this.m_20184_().f_82480_ * 0.6, this.m_20184_().f_82481_ * 0.6);
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - 0.02, this.m_20184_().f_82481_);
            if (this.f_19862_ && this.m_20229_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + (double)0.6f - this.m_20186_() + d0, this.m_20184_().f_82481_)) {
                this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
            }
        } else {
            float f2 = 0.5f;
            float f3 = 0.16277136f / (f2 * f2 * f2);
            Vec3 tempVector = new Vec3(0.0, (double)forward, (double)(f4 *= f3 * 2.8f));
            this.m_19920_(strafe, tempVector);
            f2 = 0.3f;
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.f_19853_.f_46443_ && (!this.f_19853_.m_46805_(new BlockPos((int)this.m_20185_(), 0, (int)this.m_20189_())) || this.f_19853_ instanceof ServerLevel && !((ServerLevel)this.f_19853_).m_7726_().m_5563_(this.m_146902_().f_45578_, this.m_146902_().f_45579_))) {
                if (this.m_20186_() > (double)this.m_9236_().m_6042_().f_156647_()) {
                    this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - 0.1, this.m_20184_().f_82481_);
                } else {
                    this.m_20334_(this.m_20184_().f_82479_, 0.0, this.m_20184_().f_82481_);
                }
            } else {
                this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - 0.08, this.m_20184_().f_82481_);
            }
            this.m_20334_(this.m_20184_().f_82479_ * (double)f2, this.m_20184_().f_82480_ * (double)0.98f, this.m_20184_().f_82481_ * (double)f2);
        }
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource p_149501_) {
        if (this.m_6688_() instanceof ServerPlayer) {
            if (this.getBikeType() == EnumBike.Mach) {
                this.m_6688_().m_142535_(fallDistance / 1.5f, 1.0f, p_149501_);
            } else {
                this.m_6688_().m_142535_(fallDistance / 6.0f, damageMultiplier, p_149501_);
            }
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7340_(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction p_19958_) {
        if (this.m_20363_(passenger)) {
            float offset = -0.1f;
            Vec3 vec3d = new Vec3((double)offset, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            p_19958_.m_20372_(passenger, this.m_20185_() + vec3d.f_82479_, this.m_20186_() + (double)this.m_293694_(this.m_6972_(this.m_20089_()), 0.0f) + (double)passenger.m_6049_((Entity)this), this.m_20189_() + vec3d.f_82481_);
            this.applyYawToEntity(passenger);
        }
    }

    protected void applyYawToEntity(Entity entity) {
        entity.m_5618_(this.f_19857_);
        float f = Mth.m_14177_((float)(entity.f_19857_ - this.f_19857_));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += f1 - f;
        entity.f_19857_ += f1 - f;
        entity.m_5616_(entity.f_19857_);
    }

    public InteractionResult m_7111_(Player player, Vec3 angle, InteractionHand hand) {
        if (player.m_6144_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_) {
            ItemStack held = player.m_21120_(hand);
            if (held.m_41720_() instanceof DyeItem) {
                this.setColor(DyeColor.getColor((ItemStack)held));
                return InteractionResult.SUCCESS;
            }
            if (!this.m_20160_() && player.m_20329_((Entity)this)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_) {
            if (this.m_6673_(source)) {
                return false;
            }
            if (this.m_6084_() && !source.m_19390_()) {
                ItemStack stack = new ItemStack((ItemLike)this.getBikeType().getItem(), 1);
                if (this.getColor() != this.getBikeType().defaultColor) {
                    stack.m_41751_(new CompoundTag());
                    this.m_7380_(stack.m_41783_());
                }
                ItemEntity drop = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
                drop.m_32045_(stack);
                drop.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.f_19853_.m_7967_((Entity)drop);
            }
            this.m_6089_();
        }
        return true;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        if (this.m_20363_((Entity)passenger)) {
            return super.m_7688_(passenger);
        }
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public AABB getCollisionBoundingBox() {
        return this.m_6094_() ? this.m_20191_() : null;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_7378_(CompoundTag compound) {
        this.setType(EnumBike.values()[compound.m_128445_("type")]);
        if (compound.m_128441_("color")) {
            this.setColor(DyeColor.values()[compound.m_128445_("color")]);
        } else {
            this.setColor(this.getBikeType().defaultColor);
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128344_("type", (byte)this.bikeType.ordinal());
        compound.m_128344_("color", (byte)this.color.ordinal());
    }

    public EnumBike getBikeType() {
        return this.bikeType;
    }

    public void setType(EnumBike type) {
        SYNC_TYPE.set((Entity)this, (Object)type);
        SYNC_COLOR.set((Entity)this, (Object)type.defaultColor);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor type) {
        SYNC_COLOR.set((Entity)this, (Object)type);
    }

    protected void jump() {
        double motionY = 0.52f * (this.getBikeType() == EnumBike.Acro ? 1.2f : 1.0f) * (this.m_20069_() ? 0.3f : 1.0f);
        this.m_20334_(this.m_20184_().f_82479_, motionY, this.m_20184_().f_82481_);
        if (this.m_20142_()) {
            float f = this.f_19857_ * ((float)Math.PI / 180);
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - (double)(Mth.m_14031_((float)f) * 0.2f), this.m_20184_().f_82481_ + (double)(Mth.m_14089_((float)f) * 0.2f));
        }
        this.f_19812_ = true;
    }

    private float getAcceleration() {
        return this.getBikeType() == EnumBike.Mach ? 0.1f : 0.9f;
    }

    private float getRideSpeed() {
        return 0.11f * (this.getBikeType() == EnumBike.Mach ? 1.3f : 1.0f);
    }

    private boolean shouldAnimate() {
        return this.m_6688_() != null && Math.abs(this.f_19854_ - this.m_20185_()) + Math.abs(this.f_19856_ - this.m_20189_()) > 0.001;
    }
}

